do $$
begin


IF NOT EXISTS (select 1 from pg_trigger where not tgisinternal and tgrelid = 'public.tb_user'::regclass) THEN
    CREATE OR REPLACE FUNCTION public.delete_login()
      RETURNS trigger AS
    $BODY$
    begin
        DELETE FROM public.tb_user_login where user_id = OLD.user_id;
        RETURN OLD;
    end
    $BODY$
      LANGUAGE plpgsql VOLATILE
      COST 100;
    ALTER FUNCTION public.delete_login()
      OWNER TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_login() TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_login() TO public;



    CREATE TRIGGER delete_login
      BEFORE DELETE
      ON public.tb_user
      FOR EACH ROW
      EXECUTE PROCEDURE public.delete_login();
END IF;

end
$$;


do $$
begin


IF NOT EXISTS (select 1 from pg_trigger where not tgisinternal and tgrelid = 'public.product'::regclass and tgname='delete_invoiceline') THEN
    CREATE OR REPLACE FUNCTION public.delete_invoiceline()
      RETURNS trigger AS
    $BODY$
    begin
	UPDATE public.invoiceline SET product_id = 0 where product_id = OLD.product_id;
        RETURN OLD;
    end
    $BODY$
      LANGUAGE plpgsql VOLATILE
      COST 100;
    ALTER FUNCTION public.delete_invoiceline()
      OWNER TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_invoiceline() TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_invoiceline() TO public;



    CREATE TRIGGER delete_invoiceline
      BEFORE DELETE
      ON public.product
      FOR EACH ROW
      EXECUTE PROCEDURE public.delete_invoiceline();
END IF;

end
$$;