DROP TABLE IF EXISTS #syncLogTable#;
DROP TABLE IF EXISTS #syncSchedulerTable#;
DROP TABLE IF EXISTS #syncTableTable#;
DROP TABLE IF EXISTS #syncNodeTable#;
DROP TABLE IF EXISTS #syncNodeModelTable#;

CREATE TABLE #syncLogTable#
(
  id serial NOT NULL,
  type character varying(32),
  app_package character varying(32),
  class_name character varying(48),
  thread_id bigint,
  message character varying(500),
  "timestamp" timestamp without time zone,
  CONSTRAINT #syncLogTable#_pk PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE #syncLogTable#
  OWNER TO postgres;

CREATE TABLE #syncNodeModelTable#
(
  id smallint NOT NULL,
  name character varying(60),
  image character varying(100),
  CONSTRAINT #syncNodeModelTable#_pk PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE #syncNodeModelTable#
  OWNER TO postgres;

CREATE TABLE #syncNodeTable#
(
  id serial NOT NULL,
  ip_address character varying(16),
  number character varying(32) DEFAULT NULL,
  name character varying(32),
  description character varying(60),
  status smallint,
  model_id smallint NOT NULL,
  last_sync timestamp without time zone,
  last_verification timestamp without time zone,
  last_sales_merge timestamp without time zone,
  db_port character(4),
  db_name character varying(60),
  db_user character varying(32),
  db_pass character varying(32),
  lot character varying(10),
  maceth character varying(32),
  macwifi character varying(32),
  CONSTRAINT #syncNodeTable#_primary_key PRIMARY KEY (id),
  CONSTRAINT #syncNodeTable#_number_uq UNIQUE (number),
  CONSTRAINT #syncNodeModelTable#_fk_1 FOREIGN KEY (model_id)
      REFERENCES #syncNodeModelTable# (id) MATCH SIMPLE
      ON UPDATE NO ACTION
      ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE #syncNodeTable#
  OWNER TO postgres;

CREATE TABLE #syncSchedulerTable#
(
  id smallint NOT NULL,
  type smallint NOT NULL DEFAULT 0,
  "interval" integer NOT NULL DEFAULT 10,
  enabled smallint NOT NULL DEFAULT 1,
  "time" time without time zone,
  time_unit smallint,
  last_run_finished bigint,
  last_run_started bigint,
  CONSTRAINT #syncSchedulerTable#_pk PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE #syncSchedulerTable#
  OWNER TO postgres;
GRANT ALL ON TABLE #syncSchedulerTable# TO public;
GRANT ALL ON TABLE #syncSchedulerTable# TO postgres;
GRANT ALL ON TABLE #syncSchedulerTable# TO admin;
GRANT ALL ON TABLE #syncSchedulerTable# TO read;


CREATE TABLE #syncTableTable#
(
  id SERIAL NOT NULL,
  "order" integer NOT NULL,
  name character varying(60) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  primary_key character varying(32),
  process_type smallint NOT NULL DEFAULT 0,
  query_diff character varying,
  CONSTRAINT #syncTableTable#_pk PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE #syncTableTable#
  OWNER TO postgres;

DROP TABLE IF EXISTS advertising;
DROP TABLE IF EXISTS barcode_format;
DROP TABLE IF EXISTS bpartner;
DROP TABLE IF EXISTS bpartner_location;
DROP TABLE IF EXISTS city;
DROP TABLE IF EXISTS country;
DROP TABLE IF EXISTS currency;
DROP TABLE IF EXISTS department;
DROP TABLE IF EXISTS image;
DROP TABLE IF EXISTS ingredient;
DROP TABLE IF EXISTS label_format;
DROP TABLE IF EXISTS labels;
DROP TABLE IF EXISTS location;
DROP TABLE IF EXISTS main_group;
DROP TABLE IF EXISTS nut_info_el_instance;
DROP TABLE IF EXISTS nut_info_element;
DROP TABLE IF EXISTS nut_info_set;
DROP TABLE IF EXISTS preservation_info;
DROP TABLE IF EXISTS pricelist;
DROP TABLE IF EXISTS pricelist_version;
DROP TABLE IF EXISTS product;
DROP TABLE IF EXISTS productprice;
DROP TABLE IF EXISTS profile;
DROP TABLE IF EXISTS region;
DROP TABLE IF EXISTS shortcut;
DROP TABLE IF EXISTS shortcut_page;
DROP TABLE IF EXISTS tb_user;
DROP TABLE IF EXISTS warehouse;
DROP TABLE IF EXISTS locator;
DROP TABLE IF EXISTS invoiceline;
DROP TABLE IF EXISTS tax;
DROP TABLE IF EXISTS taxcategory;
DROP TABLE IF EXISTS public.access;
DROP TABLE IF EXISTS public.role;





CREATE TABLE advertising
(
  advertising_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  advertising character varying(255),
  isproductmsgonly character(1) NOT NULL DEFAULT 'N'::bpchar,
  isdefault character(1) NOT NULL DEFAULT 'N'::bpchar,
  ismedia character(1) NOT NULL DEFAULT 'N'::bpchar,
  media_url character varying(2000), -- Path y nombre del archivo de vídeo
  image_id character varying(32),
  profile_id character varying(32) DEFAULT '@'::character varying
)
WITH (
  OIDS=FALSE
);
ALTER TABLE advertising
  OWNER TO systel;
GRANT ALL ON TABLE advertising TO admin;
GRANT ALL ON TABLE advertising TO read;
GRANT ALL ON TABLE advertising TO systel;
GRANT ALL ON TABLE advertising TO public;
COMMENT ON COLUMN advertising.media_url IS 'Path y nombre del archivo de vídeo';


-- Index: fki_advertising_profile_id

-- DROP INDEX fki_advertising_profile_id;

CREATE INDEX fki_advertising_profile_id
  ON advertising
  USING btree
  (profile_id COLLATE pg_catalog."default");


CREATE TABLE barcode_format
(
  barcodetype character varying(32) NOT NULL,
  producttype character(1) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  field_a character varying(50) NOT NULL,
  cantidad_a character varying(2) NOT NULL DEFAULT 0,
  value_a character varying(30),
  field_b character varying(50),
  cantidad_b character varying(2),
  value_b character varying(30),
  field_c character varying(50),
  cantidad_c character varying(2),
  value_c character varying(30),
  field_d character varying(50),
  cantidad_d character varying(2),
  value_d character varying(30)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE barcode_format
  OWNER TO systel;
GRANT ALL ON TABLE barcode_format TO admin;
GRANT ALL ON TABLE barcode_format TO read;
GRANT ALL ON TABLE barcode_format TO systel;
GRANT ALL ON TABLE barcode_format TO public;


CREATE TABLE bpartner
(
  bpartner_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone DEFAULT now(),
  updatedby character varying(32),
  name character varying(60) NOT NULL,
  name2 character varying(60),
  description character varying(255),
  issummary character(1) NOT NULL DEFAULT 'N'::bpchar, -- Una forma de agrupar campos para ver u ocultar la información adicional
  iscustomer character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Es un cliente, es decir, una persona u organización que compra los productos o servicios de la Empresa
  isemployee character(1) NOT NULL DEFAULT 'N'::bpchar, -- Es empleado?
  issalesrep character(1) NOT NULL DEFAULT 'N'::bpchar, -- Es representante de ventas? Persona u organización que vende sus productos
  ispacker character(1) NOT NULL DEFAULT 'N'::bpchar, -- Es envasador? Persona u organización que realiza el packaging de sus productos. (Requerido por normativas de envasado fuera de la vista del cliente en Europa y Chile)
  isdistributor character(1) NOT NULL DEFAULT 'N'::bpchar, -- Es distribuidor? (Requerido por normativas en varios países)
  isimporter character(1) NOT NULL DEFAULT 'N'::bpchar,
  isexporter character(1) NOT NULL DEFAULT 'N'::bpchar,
  isvendor character(1) NOT NULL DEFAULT 'N'::bpchar,
  iscutting_hall character(1) NOT NULL DEFAULT 'N'::bpchar, -- Fraccionador
  isslaughter_house character(1) NOT NULL DEFAULT 'N'::bpchar, -- Matadero
  issupplier character(1) NOT NULL DEFAULT 'N'::bpchar,
  referenceno character varying(40), -- Campo que puede ser utilizado como referencia a algún dato del ERP.
  duns character(11), -- Número DUNS. Es un sistema numérico de identificación de empresas del mundo, que es hoy en día el único estándar internacional y es aceptado por decenas de gobiernos y organismos internacionales, tales como los Estados Unidos o la ONU. Similar a nuestro CUIT pero Internacional
  taxid character varying(20), -- Identificador del impuesto que será aplicado al tercero por defecto. Recordar que los impuestos pueden ser compuestos, es decir, que puede haber una especie de "árbol de impuestos".
  istaxexempt character(1) DEFAULT 'N'::bpchar, -- Es Exento?
  rating character(1), -- Un campo del tipo caracter para especificar la evaluación del cliente. En Europa existe un uso corriente sobre una especie de ranking de clientes. Por ejemplo, las balanzas Dibal poseen esta característica.
  salesvolume numeric(10,0), -- Volumen total de ventas
  naics character(6), -- NAICS (North American Industry Classification System) o su sucesor SIC (Standard Industrial Classification). Son códigos que se utilizan principalmente en Canada, Mexico y Estados Unidos para clasificar una empresa (ver http://www.osha.gov/oshstats/sicser.html). En Brasil este campo puede utilizarse para almacenar el SISP (rotulagem carnes)
  firstsale timestamp without time zone, -- Timestamp de la primera venta a este tercero.
  paymentrule character varying(60),
  creditlimit numeric(20, 6) DEFAULT 0, -- Límite de crédito
  creditused numeric(20, 6) DEFAULT 0, -- Saldo actual de compras a Cta Cte
  paymentterm_id character varying(32), -- Forma de pago por defecto para este tercero
  pricelist_id character varying(32), -- Lista de precio por defecto para este tercero
  isdiscountprinted character(1) DEFAULT 'Y'::bpchar, -- Establece si los descuentos deben ser impresos en la factura
  salesrep_id character varying(32), -- Vendedor asignado a este cliente
  bpartner_parent_id character varying(32), -- Campo que puede ser utilizado para generar una estructura de árbol de dos niveles. Por ejemplo, podría generarse un registro A que represente a una organización y otros registros que representen las sucursales de esa organización, estos últimos deberán tener este campo asignado al registro A. De esta manera quedarán vinculados en una estructura parent-child.
  upc character varying(30), -- Código de barras del tercero. Puede ser empleado en caso que se encuentre un lector de código de barras a la balanza, cada tercero podría tener una tarjeta de identificación con su correspondiente código de barras, permitiendo así agilizar la selección del mismo. Como terceros pueden cargarse Vendedores, Proveedores, Usuarios, Clientes, etc, con lo cuál la identificación, por ejemplo, de un vendedor también podría realizarse de esta manera.
  fiscalcode character varying(16), -- Código de identificación fiscal. Por ejemplo, en Argentina el CUIT
  isofiscalcode character varying(5), -- Código ISO del Número de Inscripción para impuestos de valor agregado (VATIN). Cada país posee su propio sistema de identificación fiscal. LA norma ISO ISO 3166-1 alpha-2, define un código de identificación para cada país, con este código el software será capaz de discernir qué código de identificación deberá emplearse y, por lo tanto, cuáles serán las validaciones correspondientes para ese código.
  image_id character varying(32), -- Imagen del tercero. Puede ser utilizada en diversos y numerosos usos. Por ejemplo, la normativa de Brasil establece que cuando se trate de alimentos que fueron envasados fuera de la vista del cliente, el ticket debe reunir ciertos requisitos, si además se tratase de carnes debe incluirse una imagen relativa al proveedor que contiene un formato específico con información sobre el mismo. Mediante el uso de esta función es posible asignarle al proveedor, fraccionador, matadero, etc, una imagen que reúna los requisitos necesarios para cumplir con la normativa vigente.
  print_field character varying(2000) -- campo de impresión de datos
)
WITH (
  OIDS=FALSE
);
ALTER TABLE bpartner
  OWNER TO systel;
GRANT ALL ON TABLE bpartner TO admin;
GRANT ALL ON TABLE bpartner TO read;
GRANT ALL ON TABLE bpartner TO systel;
GRANT ALL ON TABLE bpartner TO public;
COMMENT ON COLUMN bpartner.issummary IS 'Una forma de agrupar campos para ver u ocultar la información adicional';
COMMENT ON COLUMN bpartner.iscustomer IS 'Es un cliente, es decir, una persona u organización que compra los productos o servicios de la Empresa';
COMMENT ON COLUMN bpartner.isemployee IS 'Es empleado?';
COMMENT ON COLUMN bpartner.issalesrep IS 'Es representante de ventas? Persona u organización que vende sus productos';
COMMENT ON COLUMN bpartner.ispacker IS 'Es envasador? Persona u organización que realiza el packaging de sus productos. (Requerido por normativas de envasado fuera de la vista del cliente en Europa y Chile)';
COMMENT ON COLUMN bpartner.isdistributor IS 'Es distribuidor? (Requerido por normativas en varios países)';
COMMENT ON COLUMN bpartner.iscutting_hall IS 'Fraccionador';
COMMENT ON COLUMN bpartner.isslaughter_house IS 'Matadero';
COMMENT ON COLUMN bpartner.referenceno IS 'Campo que puede ser utilizado como referencia a algún dato del ERP.';
COMMENT ON COLUMN bpartner.duns IS 'Número DUNS. Es un sistema numérico de identificación de empresas del mundo, que es hoy en día el único estándar internacional y es aceptado por decenas de gobiernos y organismos internacionales, tales como los Estados Unidos o la ONU. Similar a nuestro CUIT pero Internacional';
COMMENT ON COLUMN bpartner.taxid IS 'Identificador del impuesto que será aplicado al tercero por defecto. Recordar que los impuestos pueden ser compuestos, es decir, que puede haber una especie de "árbol de impuestos".';
COMMENT ON COLUMN bpartner.istaxexempt IS 'Es Exento?';
COMMENT ON COLUMN bpartner.rating IS 'Un campo del tipo caracter para especificar la evaluación del cliente. En Europa existe un uso corriente sobre una especie de ranking de clientes. Por ejemplo, las balanzas Dibal poseen esta característica.';
COMMENT ON COLUMN bpartner.salesvolume IS 'Volumen total de ventas';
COMMENT ON COLUMN bpartner.naics IS 'NAICS (North American Industry Classification System) o su sucesor SIC (Standard Industrial Classification). Son códigos que se utilizan principalmente en Canada, Mexico y Estados Unidos para clasificar una empresa (ver http://www.osha.gov/oshstats/sicser.html). En Brasil este campo puede utilizarse para almacenar el SISP (rotulagem carnes)';
COMMENT ON COLUMN bpartner.firstsale IS 'Timestamp de la primera venta a este tercero.';
COMMENT ON COLUMN bpartner.creditlimit IS 'Límite de crédito';
COMMENT ON COLUMN bpartner.creditused IS 'Saldo actual de compras a Cta Cte';
COMMENT ON COLUMN bpartner.paymentterm_id IS 'Forma de pago por defecto para este tercero';
COMMENT ON COLUMN bpartner.pricelist_id IS 'Lista de precio por defecto para este tercero';
COMMENT ON COLUMN bpartner.isdiscountprinted IS 'Establece si los descuentos deben ser impresos en la factura';
COMMENT ON COLUMN bpartner.salesrep_id IS 'Vendedor asignado a este cliente';
COMMENT ON COLUMN bpartner.bpartner_parent_id IS 'Campo que puede ser utilizado para generar una estructura de árbol de dos niveles. Por ejemplo, podría generarse un registro A que represente a una organización y otros registros que representen las sucursales de esa organización, estos últimos deberán tener este campo asignado al registro A. De esta manera quedarán vinculados en una estructura parent-child.';
COMMENT ON COLUMN bpartner.upc IS 'Código de barras del tercero. Puede ser empleado en caso que se encuentre un lector de código de barras a la balanza, cada tercero podría tener una tarjeta de identificación con su correspondiente código de barras, permitiendo así agilizar la selección del mismo. Como terceros pueden cargarse Vendedores, Proveedores, Usuarios, Clientes, etc, con lo cuál la identificación, por ejemplo, de un vendedor también podría realizarse de esta manera.';
COMMENT ON COLUMN bpartner.fiscalcode IS 'Código de identificación fiscal. Por ejemplo, en Argentina el CUIT';
COMMENT ON COLUMN bpartner.isofiscalcode IS 'Código ISO del Número de Inscripción para impuestos de valor agregado (VATIN). Cada país posee su propio sistema de identificación fiscal. LA norma ISO ISO 3166-1 alpha-2, define un código de identificación para cada país, con este código el software será capaz de discernir qué código de identificación deberá emplearse y, por lo tanto, cuáles serán las validaciones correspondientes para ese código. ';
COMMENT ON COLUMN bpartner.image_id IS 'Imagen del tercero. Puede ser utilizada en diversos y numerosos usos. Por ejemplo, la normativa de Brasil establece que cuando se trate de alimentos que fueron envasados fuera de la vista del cliente, el ticket debe reunir ciertos requisitos, si además se tratase de carnes debe incluirse una imagen relativa al proveedor que contiene un formato específico con información sobre el mismo. Mediante el uso de esta función es posible asignarle al proveedor, fraccionador, matadero, etc, una imagen que reúna los requisitos necesarios para cumplir con la normativa vigente.';
COMMENT ON COLUMN bpartner.print_field IS 'campo de impresión de datos';


-- Index: bpartner_idsalesrep

-- DROP INDEX bpartner_idsalesrep;

CREATE INDEX bpartner_idsalesrep
  ON bpartner
  USING btree
  (bpartner_id COLLATE pg_catalog."default", issalesrep COLLATE pg_catalog."default");

-- Index: bpartner_name

-- DROP INDEX bpartner_name;

CREATE INDEX bpartner_name
  ON bpartner
  USING btree
  (name COLLATE pg_catalog."default");

-- Index: fki_bpartner_image_fkey

-- DROP INDEX fki_bpartner_image_fkey;

CREATE INDEX fki_bpartner_image_fkey
  ON bpartner
  USING btree
  (image_id COLLATE pg_catalog."default");


CREATE TABLE bpartner_location
(
  bpartner_location_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  isbillto character(1) NOT NULL DEFAULT 'Y'::bpchar,
  isshipto character(1) NOT NULL DEFAULT 'Y'::bpchar,
  ispayfrom character(1) NOT NULL DEFAULT 'Y'::bpchar,
  isremitto character(1) NOT NULL DEFAULT 'Y'::bpchar,
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  bpartner_id character varying(32) NOT NULL,
  istaxlocation character(1) NOT NULL DEFAULT 'N'::bpchar,
  upc character varying(30),
  address1 character varying(60),
  address2 character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  city_id character varying(32),
  region_id character varying(32),
  country_id character varying(32)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE bpartner_location
  OWNER TO systel;
GRANT ALL ON TABLE bpartner_location TO admin;
GRANT ALL ON TABLE bpartner_location TO read;
GRANT ALL ON TABLE bpartner_location TO systel;
GRANT ALL ON TABLE bpartner_location TO public;

-- Index: bplocation_bpartner

-- DROP INDEX bplocation_bpartner;

CREATE INDEX bplocation_bpartner
  ON bpartner_location
  USING btree
  (bpartner_id COLLATE pg_catalog."default");

-- Index: bplocation_updated

-- DROP INDEX bplocation_updated;

CREATE INDEX bplocation_updated
  ON bpartner_location
  USING btree
  (updated);

-- Index: fki_bpartner_location_city_fkey

-- DROP INDEX fki_bpartner_location_city_fkey;

CREATE INDEX fki_bpartner_location_city_fkey
  ON bpartner_location
  USING btree
  (city_id COLLATE pg_catalog."default");

-- Index: fki_bpartner_location_country_fkey

-- DROP INDEX fki_bpartner_location_country_fkey;

CREATE INDEX fki_bpartner_location_country_fkey
  ON bpartner_location
  USING btree
  (country_id COLLATE pg_catalog."default");

-- Index: fki_bpartner_location_region_fkey

-- DROP INDEX fki_bpartner_location_region_fkey;

CREATE INDEX fki_bpartner_location_region_fkey
  ON bpartner_location
  USING btree
  (region_id COLLATE pg_catalog."default");


CREATE TABLE city
(
  city_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  locode character varying(10),
  coordinates character varying(15),
  postal character varying(10),
  areacode character varying(10),
  country_id character varying(32),
  region_id character varying(32)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE city
  OWNER TO systel;
GRANT ALL ON TABLE city TO admin;
GRANT ALL ON TABLE city TO read;
GRANT ALL ON TABLE city TO systel;
GRANT ALL ON TABLE city TO public;


CREATE TABLE country
(
  country_id character varying(32) NOT NULL DEFAULT '',
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL, -- --OBTG:NVARCHAR--
  description character varying(255), -- --OBTG:NVARCHAR--
  countrycode character(3) NOT NULL,
  hasregion character(1) NOT NULL DEFAULT 'N'::bpchar,
  regionname character varying(60),
  expressionphone character varying(20),
  displaysequence character varying(20) NOT NULL DEFAULT '@C@, @R@ @P@'::character varying, -- Se utiliza para establecer cómo será mostrada la dirección. Los siguientes campos pueden ser utilizados: @C@=City @P@=Postal @A@=PostalAdd @R@=Region
  expressionpostal character varying(20),
  haspostal_add character(1) NOT NULL DEFAULT 'N'::bpchar,
  expressionpostal_add character varying(20),
  isdefault character(1) DEFAULT 'N'::bpchar,
  ad_language character varying(6),
  currency_id character varying(32),
  ibannodigits numeric,
  ibancountry character varying(2)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE country
  OWNER TO systel;
GRANT ALL ON TABLE country TO admin;
GRANT ALL ON TABLE country TO read;
GRANT ALL ON TABLE country TO systel;
GRANT ALL ON TABLE country TO public;
COMMENT ON COLUMN country.name IS '--OBTG:NVARCHAR--';
COMMENT ON COLUMN country.description IS '--OBTG:NVARCHAR--';
COMMENT ON COLUMN country.displaysequence IS 'Se utiliza para establecer cómo será mostrada la dirección. Los siguientes campos pueden ser utilizados: @C@=City @P@=Postal @A@=PostalAdd @R@=Region';


CREATE TABLE currency
(
  currency_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  iso_code character(3) NOT NULL,
  cursymbol character varying(10),
  description character varying(255),
  stdprecision integer NOT NULL,
  costingprecision integer NOT NULL,
  priceprecision integer NOT NULL DEFAULT 0,
  issymbolrightside character(1) DEFAULT 'N'::bpchar
)
WITH (
  OIDS=FALSE
);
ALTER TABLE currency
  OWNER TO systel;
GRANT ALL ON TABLE currency TO admin;
GRANT ALL ON TABLE currency TO read;
GRANT ALL ON TABLE currency TO systel;
GRANT ALL ON TABLE currency TO public;


CREATE TABLE department
(
  department_id bigint NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(56) NOT NULL,
  tax_id character varying(32),
  warehouse_id character varying(32) -- Almacén por defecto para el descuento de stock
)
WITH (
  OIDS=FALSE
);
ALTER TABLE department
  OWNER TO systel;
GRANT ALL ON TABLE department TO admin;
GRANT ALL ON TABLE department TO read;
GRANT ALL ON TABLE department TO systel;
GRANT ALL ON TABLE department TO public;
COMMENT ON COLUMN department.warehouse_id IS 'Almacén por defecto para el descuento de stock';


-- Index: fki_department_warehouse_fkey

-- DROP INDEX fki_department_warehouse_fkey;

CREATE INDEX fki_department_warehouse_fkey
  ON department
  USING btree
  (warehouse_id COLLATE pg_catalog."default");


CREATE TABLE image
(
  image_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  imageurl character varying(120),
  binarydata bytea,
  width numeric(10,0),
  height numeric(10,0),
  isproducticon character(1) NOT NULL DEFAULT 'Y'::bpchar,
  isproductimage character(1) NOT NULL DEFAULT 'N'::bpchar,
  issupplierimage character(1) NOT NULL DEFAULT 'N'::bpchar,
  isrsiimage character(1) NOT NULL DEFAULT 'N'::bpchar, -- En EEUU si el producto fue irradiado, lleva una imagen especial
  mimetype character varying(255),
  isadvertisingimage character(1) NOT NULL DEFAULT 'N'::bpchar,
  iscompanyimage character(1) NOT NULL DEFAULT 'N'::bpchar,
  ispreserveimage character(1) NOT NULL DEFAULT 'N'::bpchar
 )
WITH (
  OIDS=FALSE
);
ALTER TABLE image
  OWNER TO systel;
GRANT ALL ON TABLE image TO admin;
GRANT ALL ON TABLE image TO read;
GRANT ALL ON TABLE image TO systel;
GRANT ALL ON TABLE image TO public;
COMMENT ON COLUMN image.isrsiimage IS 'En EEUU si el producto fue irradiado, lleva una imagen especial';


-- Index: fki_advertising_image_id

-- DROP INDEX fki_advertising_image_id;

CREATE INDEX fki_advertising_image_id
  ON image
  USING btree
  (image_id COLLATE pg_catalog."default");


CREATE TABLE ingredient
(
  ingredient_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  ingredients text NOT NULL,
  isdefault character(1) DEFAULT 'N'::bpchar
)
WITH (
  OIDS=FALSE
);
ALTER TABLE ingredient
  OWNER TO systel;
GRANT ALL ON TABLE ingredient TO admin;
GRANT ALL ON TABLE ingredient TO read;
GRANT ALL ON TABLE ingredient TO systel;
GRANT ALL ON TABLE ingredient TO public;


CREATE TABLE label_format
(
  label_format_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  template character varying NOT NULL,
  type integer NOT NULL
)
WITH (
  OIDS=FALSE
);
ALTER TABLE label_format
  OWNER TO systel;
GRANT ALL ON TABLE label_format TO admin;
GRANT ALL ON TABLE label_format TO read;
GRANT ALL ON TABLE label_format TO systel;
GRANT ALL ON TABLE label_format TO public;


CREATE TABLE labels
(
  labels_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  label_format_w_di character varying(32) NOT NULL,
  label_format_w_pp character varying(32) NOT NULL,
  label_format_u_di character varying(32) NOT NULL,
  label_format_u_pp character varying(32) NOT NULL,
  label_format_w_co character varying(32) NOT NULL,
  label_format_w_es character varying(32) NOT NULL
)
WITH (
  OIDS=FALSE
);
ALTER TABLE labels
  OWNER TO systel;
GRANT ALL ON TABLE labels TO admin;
GRANT ALL ON TABLE labels TO read;
GRANT ALL ON TABLE labels TO systel;
GRANT ALL ON TABLE labels TO public;

-- Index: fki_labels_label_format_u_di_fkey

-- DROP INDEX fki_labels_label_format_u_di_fkey;

CREATE INDEX fki_labels_label_format_u_di_fkey
  ON labels
  USING btree
  (label_format_u_di COLLATE pg_catalog."default");

-- Index: fki_labels_label_format_u_pp_fkey

-- DROP INDEX fki_labels_label_format_u_pp_fkey;

CREATE INDEX fki_labels_label_format_u_pp_fkey
  ON labels
  USING btree
  (label_format_u_pp COLLATE pg_catalog."default");

-- Index: fki_labels_label_format_w_co_fkey

-- DROP INDEX fki_labels_label_format_w_co_fkey;

CREATE INDEX fki_labels_label_format_w_co_fkey
  ON labels
  USING btree
  (label_format_w_co COLLATE pg_catalog."default");

-- Index: fki_labels_label_format_w_di_fkey

-- DROP INDEX fki_labels_label_format_w_di_fkey;

CREATE INDEX fki_labels_label_format_w_di_fkey
  ON labels
  USING btree
  (label_format_w_di COLLATE pg_catalog."default");

-- Index: fki_labels_label_format_w_es_fkey

-- DROP INDEX fki_labels_label_format_w_es_fkey;

CREATE INDEX fki_labels_label_format_w_es_fkey
  ON labels
  USING btree
  (label_format_w_es COLLATE pg_catalog."default");

-- Index: fki_labels_label_format_w_pp_fkey

-- DROP INDEX fki_labels_label_format_w_pp_fkey;

CREATE INDEX fki_labels_label_format_w_pp_fkey
  ON labels
  USING btree
  (label_format_w_pp COLLATE pg_catalog."default");


CREATE TABLE location
(
  location_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  address1 character varying(60),
  address2 character varying(60),
  city character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  country_id character varying(32) NOT NULL,
  region_id character varying(32),
  city_id character varying(32),
  regionname character varying(40)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE location
  OWNER TO systel;
GRANT ALL ON TABLE location TO admin;
GRANT ALL ON TABLE location TO read;
GRANT ALL ON TABLE location TO systel;
GRANT ALL ON TABLE location TO public;

CREATE TABLE main_group
(
  group_id bigint NOT NULL,
  department_id bigint,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(56) NOT NULL,
  tax_id character varying(32)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE main_group
  OWNER TO systel;
GRANT ALL ON TABLE main_group TO admin;
GRANT ALL ON TABLE main_group TO read;
GRANT ALL ON TABLE main_group TO systel;
GRANT ALL ON TABLE main_group TO public;

-- Index: fki_main_group_department_fkey

-- DROP INDEX fki_main_group_department_fkey;

CREATE INDEX fki_main_group_department_fkey
  ON main_group
  USING btree
  (department_id);


CREATE TABLE nut_info_el_instance
(
  nut_info_el_instance_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  nut_info_set_id character varying(32) NOT NULL,
  product_id bigint NOT NULL,
  value character varying(255) NOT NULL, -- Texto de la celda
  hasjoinedrows character(1) NOT NULL DEFAULT 'N'::bpchar, -- Utilice este campo para que la celda utilice más de una fila. La fila origen o inicial se establece por el valor del campo "pos_row", la celda final se establece por el valor del campo "pos_rowto"
  pos_row numeric(2,0) NOT NULL,
  pos_rowto numeric(2,0),
  hasjoinedcolumns character(1) NOT NULL DEFAULT 'N'::bpchar, -- Utilice este campo para que la celda utilice más de una columna. La columna origen o inicial se establece por el valor del campo "pos_column", la columna final se establece por el valor del campo "pos_columnto"
  pos_column numeric(2,0) NOT NULL,
  pos_columnto numeric(2,0),
  alignment integer NOT NULL -- Alineación del texto de la celda:...
)
WITH (
  OIDS=FALSE
);
ALTER TABLE nut_info_el_instance
  OWNER TO systel;
GRANT ALL ON TABLE nut_info_el_instance TO admin;
GRANT ALL ON TABLE nut_info_el_instance TO read;
GRANT ALL ON TABLE nut_info_el_instance TO systel;
GRANT ALL ON TABLE nut_info_el_instance TO public;
COMMENT ON COLUMN nut_info_el_instance.value IS 'Texto de la celda';
COMMENT ON COLUMN nut_info_el_instance.hasjoinedrows IS 'Utilice este campo para que la celda utilice más de una fila. La fila origen o inicial se establece por el valor del campo "pos_row", la celda final se establece por el valor del campo "pos_rowto"';
COMMENT ON COLUMN nut_info_el_instance.hasjoinedcolumns IS 'Utilice este campo para que la celda utilice más de una columna. La columna origen o inicial se establece por el valor del campo "pos_column", la columna final se establece por el valor del campo "pos_columnto"';
COMMENT ON COLUMN nut_info_el_instance.alignment IS 'Alineación del texto de la celda: 0. Izquierda 1. Centro 2. Derecha 3. Justificado 4. Distribuido';


-- Index: fki_nut_info_el_instance_nut_info_set_fkey

-- DROP INDEX fki_nut_info_el_instance_nut_info_set_fkey;

CREATE INDEX fki_nut_info_el_instance_nut_info_set_fkey
  ON nut_info_el_instance
  USING btree
  (nut_info_set_id COLLATE pg_catalog."default");

-- Index: fki_nut_info_instance_product_fkey

-- DROP INDEX fki_nut_info_instance_product_fkey;

CREATE INDEX fki_nut_info_instance_product_fkey
  ON nut_info_el_instance
  USING btree
  (product_id);


CREATE TABLE nut_info_element
(
  nut_info_element_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  nut_info_set_id character varying(32) NOT NULL,
  value character varying(255) NOT NULL,
  hasjoinedrows character varying(1) NOT NULL DEFAULT 'N'::bpchar, -- Utilice este campo para que la celda utilice más de una fila. La fila origen o inicial se establece por el valor del campo "pos_row", la celda final se establece por el valor del campo "pos_rowto"
  pos_row numeric(2,0) NOT NULL,
  pos_rowto numeric(2,0),
  hasjoinedcolumns character varying(1) NOT NULL DEFAULT 'N'::bpchar, -- Utilice este campo para que la celda utilice más de una columna. La columna origen o inicial se establece por el valor del campo "pos_column", la columna final se establece por el valor del campo "pos_columnto"
  pos_column numeric(2,0) NOT NULL,
  pos_columnto numeric(2,0),
  alignment integer NOT NULL, -- Alineación del texto de la celda:...
  vd numeric NOT NULL DEFAULT 0,
  uom character varying(20)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE nut_info_element
  OWNER TO systel;
GRANT ALL ON TABLE nut_info_element TO admin;
GRANT ALL ON TABLE nut_info_element TO read;
GRANT ALL ON TABLE nut_info_element TO systel;
GRANT ALL ON TABLE nut_info_element TO public;
COMMENT ON COLUMN nut_info_element.hasjoinedrows IS 'Utilice este campo para que la celda utilice más de una fila. La fila origen o inicial se establece por el valor del campo "pos_row", la celda final se establece por el valor del campo "pos_rowto"';
COMMENT ON COLUMN nut_info_element.hasjoinedcolumns IS 'Utilice este campo para que la celda utilice más de una columna. La columna origen o inicial se establece por el valor del campo "pos_column", la columna final se establece por el valor del campo "pos_columnto"';
COMMENT ON COLUMN nut_info_element.alignment IS 'Alineación del texto de la celda: 0. Izquierda 1. Centro 2. Derecha 3. Justificado 4. Distribuido';


-- Index: fki_nut_info_element_nut_info_set

-- DROP INDEX fki_nut_info_element_nut_info_set;

CREATE INDEX fki_nut_info_element_nut_info_set
  ON nut_info_element
  USING btree
  (nut_info_set_id COLLATE pg_catalog."default");


CREATE TABLE nut_info_set
(
  nut_info_set_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  nut_info_name character varying(60) NOT NULL,
  description character varying(255),
  columns_qty numeric(2,0),
  rows_qty numeric(2,0)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE nut_info_set
  OWNER TO systel;
GRANT ALL ON TABLE nut_info_set TO admin;
GRANT ALL ON TABLE nut_info_set TO read;
GRANT ALL ON TABLE nut_info_set TO systel;
GRANT ALL ON TABLE nut_info_set TO public;


CREATE TABLE preservation_info
(
  preservation_info_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  info text NOT NULL,
  isdefault character(1) DEFAULT 'N'::bpchar,
  image_id character varying(32)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE preservation_info
  OWNER TO systel;
GRANT ALL ON TABLE preservation_info TO admin;
GRANT ALL ON TABLE preservation_info TO read;
GRANT ALL ON TABLE preservation_info TO systel;
GRANT ALL ON TABLE preservation_info TO public;


CREATE TABLE pricelist
(
  pricelist_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  description character varying(255),
  basepricelist_id character varying(32),
  istaxincluded character(1) NOT NULL DEFAULT 'N'::bpchar,
  issopricelist character(1) NOT NULL DEFAULT 'Y'::bpchar,
  isdefault character(1) NOT NULL DEFAULT 'N'::bpchar,
  currency_id character varying(32) NOT NULL,
  enforcepricelimit character(1) NOT NULL DEFAULT 'N'::bpchar,
  costbased character(1) NOT NULL DEFAULT 'N'::bpchar,
  CONSTRAINT pricelist_key PRIMARY KEY (pricelist_id),
  CONSTRAINT pricelist_basepricelist_fkey FOREIGN KEY (basepricelist_id)
      REFERENCES pricelist (pricelist_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT pricelist_name UNIQUE (name),
  CONSTRAINT pricelist_enforcepriceli_chk CHECK (enforcepricelimit = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT pricelist_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT pricelist_issopricelist_chk CHECK (issopricelist = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT pricelist_istaxincluded_chk CHECK (istaxincluded = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE pricelist
  OWNER TO systel;
GRANT ALL ON TABLE pricelist TO admin;
GRANT ALL ON TABLE pricelist TO read;
GRANT ALL ON TABLE pricelist TO systel;
GRANT ALL ON TABLE pricelist TO public;


CREATE TABLE pricelist_version
(
  pricelist_version_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  description character varying(255),
  pricelist_id character varying(32) NOT NULL,
  validfrom timestamp without time zone NOT NULL,
  proccreate character(1),
  pricelist_version_base_id character varying(32),
  pricelist_version_generate character(1) NOT NULL DEFAULT 'N'::bpchar,
  validto timestamp without time zone NOT NULL DEFAULT now(),
  isdefault character(1) NOT NULL DEFAULT 'N'::bpchar
)
WITH (
  OIDS=FALSE
);
ALTER TABLE pricelist_version
  OWNER TO systel;
GRANT ALL ON TABLE pricelist_version TO admin;
GRANT ALL ON TABLE pricelist_version TO read;
GRANT ALL ON TABLE pricelist_version TO systel;
GRANT ALL ON TABLE pricelist_version TO public;


CREATE TABLE product
(
  product_id bigint NOT NULL, -- Código de balanza
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  erp_code character varying(25), -- Código alfanumérico del Sistema de Gestión Empresarial
  name character varying(56) NOT NULL, -- Nombre
  description character varying(255), -- Descripción. Este campo debería ser truncado a dos líneas de 56 caracteres para mantener compatiblidad con equipos Toledo Brasil y Filizola
  department_id bigint NOT NULL DEFAULT 0,
  group_id bigint NOT NULL DEFAULT 0,
  label_format_w character varying(32), -- Formato de impresión para venta por peso
  label_format_u character varying(32), -- Formato de impresión para venta por unidad
  barcode_item_code_flag character(1) NOT NULL DEFAULT 'N'::bpchar, -- Si este campo es verdadero ('Y'), durante la generación del código de barras se utilizará como número el valor establecido en el campo "barcode_item_code" en vez del número del product.
  barcode_item_code numeric(20,0) DEFAULT 0, -- Número del product que será impreso en el código de barras. Se emplea cuando se desea utilizar un número distinto al del product en el código de barras.
  print_primary_barcode character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Si el valor de este campo es verdadero ('Y'), imprime el código de barras primario
  primary_barcode_type integer, -- Tipo de código de barras. Ver listado de códigos de barras soportados (supported_barcode_list.ods)
  primary_barcode_flag_data character varying(255), -- Cadena de configuración del código de barras primario. Aquí se define qué datos serán utilizados para generar el código de barras.
  print_secondary_barcode character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Si el valor de este campo es verdadero (''Y''), imprime el código de barras secundario
  secondary_barcode_type integer, -- Tipo de código de barras. Ver listado de códigos de barras soportados (supported_barcode_list.ods)
  secondary_barcode_flag_data character varying(255), -- Cadena de configuración del código de barras secundario. Aquí se define qué datos serán utilizados para generar el código de barras.
  sell_by_date_time integer NOT NULL DEFAULT 0, -- Dependiendo del valor de este campo, en el ticket o etiqueta se imprime:...
  sell_by_date_source integer NOT NULL DEFAULT 0, -- Determina la fecha que se utilizará como base para el cálculo de la fecha de venta que será impresa. Dependiendo del valor de este campo será:...
  sell_by_date numeric(2,0) NOT NULL DEFAULT 0, -- Ver descripción del campo "sell_by_date_source"
  sell_time_source integer NOT NULL DEFAULT 0, -- Determina la hora que será impresa:...
  sell_time time without time zone, -- Ver comentario del campo "sell_time_source"
  print_packed_date character(1) NOT NULL DEFAULT 'N'::bpchar, -- Establece si debe imprimirse la fecha de empaque del producto.
  packed_date_source integer NOT NULL DEFAULT 0, -- Base de cálculo para la fecha de empaque:...
  packed_date numeric(2,0) NOT NULL DEFAULT 0, -- Ver comentario del campo "packed_date_source"
  packed_date_format character varying(10) DEFAULT 'dd-mm-YYYY'::character varying, -- Formato de la fecha de empaque. Puede incluir fecha y hora.
  print_used_by_date character(1) NOT NULL DEFAULT 'N'::bpchar, -- Si este campo es verdader ('Y'), imprime la fecha de vencimiento.
  used_by_date_source integer NOT NULL DEFAULT 0, -- Determina la base de cálculo para la fecha de vencimiento:...
  used_by_date numeric(3,0) NOT NULL DEFAULT 0, -- 0 <= x <= 999. Ver comentario del campo "used_by_date_source"
  unit_price_selection integer NOT NULL DEFAULT 0, -- Determina si será posible modificar el precio durante la venta:...
  tare numeric(20, 6) NOT NULL DEFAULT 0,
  perc_tare numeric(20, 6) NOT NULL DEFAULT 0, -- Tara proporcional o tara porcentual para productos congelados
  quantity numeric(10,0) NOT NULL DEFAULT 1, -- Cantidad en productos no pesables. Puede ser utilizado por ejemplo, para vender UNA torta de 3,200 kg. En ese caso este campo deberá contener el valor 3200 y "quantity_uom" deberá ser "kg".
  upc character varying(30), -- Utilice este campo para ingresar el código de barras del producto
  uom_id character varying(32),
  discount_schema_id character varying(32), -- Descuento
  isstocked character(1) NOT NULL DEFAULT 'N'::bpchar, -- Determina si este producto afecta stock
  isirradiated character(1) NOT NULL DEFAULT 'N'::bpchar,
  isbom character(1) NOT NULL DEFAULT 'N'::bpchar,
  stock_min numeric(20, 6),
  stock_max numeric(20, 6),
  versionno character varying(20),
  discontinued character(1) DEFAULT 'N'::bpchar,
  discontinuedby timestamp without time zone,
  tax_id character varying(32),
  attribute integer NOT NULL DEFAULT 1, -- 0. Pesable...
  advertising_id character varying(32),
  sto_temp_limit1 numeric(20, 6), -- Temperatura límite de almacenamiento
  sto_temp_limit2 numeric(20, 6), -- Temperatura límite de almacenamiento
  ingredients character varying(2000),
  ingredients_id character varying(32),
  preservation_info character varying(2000),
  preservation_info_id character varying(32),
  coupled_product bigint, -- Si se vincula el producto con otro mediante este campo, los totales de venta serán almacenados en el producto al que hace referencia "coupled_product". Uno de los posibles usos de esta función es generar un producto temporal, por ejemplo por una promoción u oferta, almacenar los totales de ventas en un producto relacionado, para luego eliminar este producto. De esta manera los totales de venta no se pierden.
  pack_indicator numeric(1,0), -- Si existe, será utilizado como packaging indicator durante la generación del código de barras UPC/ITF 14
  extra_field1 character varying(2000), -- Campo de propósito general
  extra_field2 character varying(2000), -- Campo de propósito general
  image_id character varying(32), -- Imagen del PLU que será utilizada en la impresión. No confundir con el icono de un acceso directo.
  icon_id character varying(32), -- Icono que se utilizará por defecto si se crea un acceso directo a este producto.
  lot character varying(20),
  born_country character varying(32), -- País de nacimiento del animal
  fatten_country character varying(32), -- País de engorde
  origin_country character varying(32), -- Páis de procedencia del producto
  manufacturer_id character varying(32), -- Fabricante
  packer_id character varying(32), -- Envasador
  distributor_id character varying(32), -- Distribuidor
  importer_id character varying(32), -- Importador
  exporter_id character varying(32), -- Exportador
  vendor_id character varying(32), -- Vendedor
  cutting_hall_id character varying(32), -- Fraccionador (trazabilidad de carnes)
  slaughter_house_id character varying(32), -- Matadero (trazabilidad de carnes)
  supplier_id character varying(32), -- Proveedor (trazabilidad de carnes y otros)
  nut_info_set_id character varying(32),
  print_fix_primary_barcode character(1) NOT NULL DEFAULT 'N'::bpchar, -- Si el valor de este campo es verdadero ('Y'), imprime el código de barras primario fijo
  print_fix_secondary_barcode character(1) NOT NULL DEFAULT 'N'::bpchar -- Si el valor de este campo es verdadero ('Y'), imprime el código de barras secundario fijo
)
WITH (
  OIDS=FALSE
);
ALTER TABLE product
  OWNER TO systel;
GRANT ALL ON TABLE product TO admin;
GRANT ALL ON TABLE product TO read;
GRANT ALL ON TABLE product TO systel;
GRANT ALL ON TABLE product TO public;
COMMENT ON COLUMN product.product_id IS 'Código de balanza';
COMMENT ON COLUMN product.erp_code IS 'Código alfanumérico del Sistema de Gestión Empresarial';
COMMENT ON COLUMN product.name IS 'Nombre';
COMMENT ON COLUMN product.description IS 'Descripción. Este campo debería ser truncado a dos líneas de 56 caracteres para mantener compatiblidad con equipos Toledo Brasil y Filizola';
COMMENT ON COLUMN product.label_format_w IS 'Formato de impresión para venta por peso';
COMMENT ON COLUMN product.label_format_u IS 'Formato de impresión para venta por unidad';
COMMENT ON COLUMN product.barcode_item_code_flag IS 'Si este campo es verdadero (''Y''), durante la generación del código de barras se utilizará como número el valor establecido en el campo "barcode_item_code" en vez del número del product.';
COMMENT ON COLUMN product.barcode_item_code IS 'Número del product que será impreso en el código de barras. Se emplea cuando se desea utilizar un número distinto al del product en el código de barras.';
COMMENT ON COLUMN product.print_primary_barcode IS 'Si el valor de este campo es verdadero (''Y''), imprime el código de barras primario';
COMMENT ON COLUMN product.primary_barcode_type IS 'Tipo de código de barras. Ver listado de códigos de barras soportados (supported_barcode_list.ods)';
COMMENT ON COLUMN product.primary_barcode_flag_data IS 'Cadena de configuración del código de barras primario. Aquí se define qué datos serán utilizados para generar el código de barras.';
COMMENT ON COLUMN product.print_secondary_barcode IS 'Si el valor de este campo es verdadero (''''Y''''), imprime el código de barras secundario';
COMMENT ON COLUMN product.secondary_barcode_type IS 'Tipo de código de barras. Ver listado de códigos de barras soportados (supported_barcode_list.ods)';
COMMENT ON COLUMN product.secondary_barcode_flag_data IS 'Cadena de configuración del código de barras secundario. Aquí se define qué datos serán utilizados para generar el código de barras.';
COMMENT ON COLUMN product.sell_by_date_time IS 'Dependiendo del valor de este campo, en el ticket o etiqueta se imprime: 0. Fecha y hora (default) 1. Fecha 2. Hora';
COMMENT ON COLUMN product.sell_by_date_source IS 'Determina la fecha que se utilizará como base para el cálculo de la fecha de venta que será impresa. Dependiendo del valor de este campo será:0. fecha de venta = current_date + x_días (sell_by_date) 1. fecha de venta = packed_date + x_días (sell_by_date)';
COMMENT ON COLUMN product.sell_by_date IS 'Ver descripción del campo "sell_by_date_source"';
COMMENT ON COLUMN product.sell_time_source IS 'Determina la hora que será impresa: 0. current_time 1. valor del campo sell_time';
COMMENT ON COLUMN product.sell_time IS 'Ver comentario del campo "sell_time_source"';
COMMENT ON COLUMN product.print_packed_date IS 'Establece si debe imprimirse la fecha de empaque del producto.';
COMMENT ON COLUMN product.packed_date_source IS 'Base de cálculo para la fecha de empaque: 0. fecha empaque = current date + x_días (packed_date) 1. fecha empaque = manual (en modo pre-empaque, el operador deberá establecer la fecha por teclado) La fecha de empaque resultante debe ser menor o igual a la fecha de venta (sell_by_date).';
COMMENT ON COLUMN product.packed_date IS 'Ver comentario del campo "packed_date_source"';
COMMENT ON COLUMN product.packed_date_format IS 'Formato de la fecha de empaque. Puede incluir fecha y hora.';
COMMENT ON COLUMN product.print_used_by_date IS 'Si este campo es verdader (''Y''), imprime la fecha de vencimiento.';
COMMENT ON COLUMN product.used_by_date_source IS 'Determina la base de cálculo para la fecha de vencimiento: 0. fecha venc. = current_date + x_días (used_by_date) 1. fecha venc. = packed_date + x_días (used_by_date) 2. manual (deberá ingresarla el operador al momento de la venta)';
COMMENT ON COLUMN product.used_by_date IS '0 <= x <= 999. Ver comentario del campo "used_by_date_source"';
COMMENT ON COLUMN product.unit_price_selection IS 'Determina si será posible modificar el precio durante la venta: 0. NO CHANGE - No se permite la modificación de precio manual 1. OVERRIDE - Permite modificar el precio del product de forma temporal 2. CHANGE - Permite modificar el precio de forma permanente';
COMMENT ON COLUMN product.perc_tare IS 'Tara proporcional o tara porcentual para productos congelados';
COMMENT ON COLUMN product.quantity IS 'Cantidad en productos no pesables. Puede ser utilizado por ejemplo, para vender UNA torta de 3,200 kg. En ese caso este campo deberá contener el valor 3200 y "quantity_uom" deberá ser "kg".';
COMMENT ON COLUMN product.upc IS 'Utilice este campo para ingresar el código de barras del producto';
COMMENT ON COLUMN product.discount_schema_id IS 'Descuento';
COMMENT ON COLUMN product.isstocked IS 'Determina si este producto afecta stock';
COMMENT ON COLUMN product.attribute IS '0. Pesable 1. No pesable (unitario) 2. Congelado 3. Escurrido';
COMMENT ON COLUMN product.sto_temp_limit1 IS 'Temperatura límite de almacenamiento';
COMMENT ON COLUMN product.sto_temp_limit2 IS 'Temperatura límite de almacenamiento';
COMMENT ON COLUMN product.coupled_product IS 'Si se vincula el producto con otro mediante este campo, los totales de venta serán almacenados en el producto al que hace referencia "coupled_product". Uno de los posibles usos de esta función es generar un producto temporal, por ejemplo por una promoción u oferta, almacenar los totales de ventas en un producto relacionado, para luego eliminar este producto. De esta manera los totales de venta no se pierden.';
COMMENT ON COLUMN product.pack_indicator IS 'Si existe, será utilizado como packaging indicator durante la generación del código de barras UPC/ITF 14 ';
COMMENT ON COLUMN product.extra_field1 IS 'Campo de propósito general';
COMMENT ON COLUMN product.extra_field2 IS 'Campo de propósito general';
COMMENT ON COLUMN product.image_id IS 'Imagen del PLU que será utilizada en la impresión. No confundir con el icono de un acceso directo.';
COMMENT ON COLUMN product.icon_id IS 'Icono que se utilizará por defecto si se crea un acceso directo a este producto.';
COMMENT ON COLUMN product.born_country IS 'País de nacimiento del animal';
COMMENT ON COLUMN product.fatten_country IS 'País de engorde';
COMMENT ON COLUMN product.origin_country IS 'Páis de procedencia del producto';
COMMENT ON COLUMN product.manufacturer_id IS 'Fabricante';
COMMENT ON COLUMN product.packer_id IS 'Envasador';
COMMENT ON COLUMN product.distributor_id IS 'Distribuidor';
COMMENT ON COLUMN product.importer_id IS 'Importador';
COMMENT ON COLUMN product.exporter_id IS 'Exportador';
COMMENT ON COLUMN product.vendor_id IS 'Vendedor';
COMMENT ON COLUMN product.cutting_hall_id IS 'Fraccionador (trazabilidad de carnes)';
COMMENT ON COLUMN product.slaughter_house_id IS 'Matadero (trazabilidad de carnes)';
COMMENT ON COLUMN product.supplier_id IS 'Proveedor (trazabilidad de carnes y otros)';
COMMENT ON COLUMN product.print_fix_primary_barcode IS 'Si el valor de este campo es verdadero (''Y''), imprime el código de barras primario fijo';
COMMENT ON COLUMN product.print_fix_secondary_barcode IS 'Si el valor de este campo es verdadero (''Y''), imprime el código de barras secundario fijo';


-- Index: fki_product_born_country_fkey

-- DROP INDEX fki_product_born_country_fkey;

CREATE INDEX fki_product_born_country_fkey
  ON product
  USING btree
  (born_country COLLATE pg_catalog."default");

-- Index: fki_product_coupled_product

-- DROP INDEX fki_product_coupled_product;

CREATE INDEX fki_product_coupled_product
  ON product
  USING btree
  (coupled_product);

-- Index: fki_product_cuttinghall_fkey

-- DROP INDEX fki_product_cuttinghall_fkey;

CREATE INDEX fki_product_cuttinghall_fkey
  ON product
  USING btree
  (cutting_hall_id COLLATE pg_catalog."default");

-- Index: fki_product_department

-- DROP INDEX fki_product_department;

CREATE INDEX fki_product_department
  ON product
  USING btree
  (department_id);

-- Index: fki_product_department_pkey

-- DROP INDEX fki_product_department_pkey;

CREATE INDEX fki_product_department_pkey
  ON product
  USING btree
  (department_id);

-- Index: fki_product_discount_fkey

-- DROP INDEX fki_product_discount_fkey;

CREATE INDEX fki_product_discount_fkey
  ON product
  USING btree
  (discount_schema_id COLLATE pg_catalog."default");

-- Index: fki_product_discount_schema_fkey

-- DROP INDEX fki_product_discount_schema_fkey;

CREATE INDEX fki_product_discount_schema_fkey
  ON product
  USING btree
  (discount_schema_id COLLATE pg_catalog."default");

-- Index: fki_product_fatten_country_fkey

-- DROP INDEX fki_product_fatten_country_fkey;

CREATE INDEX fki_product_fatten_country_fkey
  ON product
  USING btree
  (fatten_country COLLATE pg_catalog."default");

-- Index: fki_product_group

-- DROP INDEX fki_product_group;

CREATE INDEX fki_product_group
  ON product
  USING btree
  (group_id);

-- Index: fki_product_icon_fkey

-- DROP INDEX fki_product_icon_fkey;

CREATE INDEX fki_product_icon_fkey
  ON product
  USING btree
  (icon_id COLLATE pg_catalog."default");

-- Index: fki_product_image_fkey

-- DROP INDEX fki_product_image_fkey;

CREATE INDEX fki_product_image_fkey
  ON product
  USING btree
  (image_id COLLATE pg_catalog."default");

-- Index: fki_product_ingredient_fkey

-- DROP INDEX fki_product_ingredient_fkey;

CREATE INDEX fki_product_ingredient_fkey
  ON product
  USING btree
  (ingredients_id COLLATE pg_catalog."default");

-- Index: fki_product_label_format_u_fkey

-- DROP INDEX fki_product_label_format_u_fkey;

CREATE INDEX fki_product_label_format_u_fkey
  ON product
  USING btree
  (label_format_u COLLATE pg_catalog."default");

-- Index: fki_product_label_format_w_fkey

-- DROP INDEX fki_product_label_format_w_fkey;

CREATE INDEX fki_product_label_format_w_fkey
  ON product
  USING btree
  (label_format_w COLLATE pg_catalog."default");

-- Index: fki_product_maingroup_pkey

-- DROP INDEX fki_product_maingroup_pkey;

CREATE INDEX fki_product_maingroup_pkey
  ON product
  USING btree
  (group_id);

-- Index: fki_product_message_fkey

-- DROP INDEX fki_product_message_fkey;

CREATE INDEX fki_product_message_fkey
  ON product
  USING btree
  (advertising_id COLLATE pg_catalog."default");

-- Index: fki_product_nut_info_set

-- DROP INDEX fki_product_nut_info_set;

CREATE INDEX fki_product_nut_info_set
  ON product
  USING btree
  (nut_info_set_id COLLATE pg_catalog."default");

-- Index: fki_product_origin_country_fkey

-- DROP INDEX fki_product_origin_country_fkey;

CREATE INDEX fki_product_origin_country_fkey
  ON product
  USING btree
  (origin_country COLLATE pg_catalog."default");

-- Index: fki_product_preservation_info_fkey

-- DROP INDEX fki_product_preservation_info_fkey;

CREATE INDEX fki_product_preservation_info_fkey
  ON product
  USING btree
  (preservation_info_id COLLATE pg_catalog."default");

-- Index: fki_product_quantity_uom_fkey

-- DROP INDEX fki_product_quantity_uom_fkey;

CREATE INDEX fki_product_quantity_uom_fkey
  ON product
  USING btree
  (uom_id COLLATE pg_catalog."default");

-- Index: fki_product_slaughterhouse_fkey

-- DROP INDEX fki_product_slaughterhouse_fkey;

CREATE INDEX fki_product_slaughterhouse_fkey
  ON product
  USING btree
  (slaughter_house_id COLLATE pg_catalog."default");

-- Index: fki_product_taxno_fkey

-- DROP INDEX fki_product_taxno_fkey;

CREATE INDEX fki_product_taxno_fkey
  ON product
  USING btree
  (tax_id COLLATE pg_catalog."default");

-- Index: fki_product_uom_fkey

-- DROP INDEX fki_product_uom_fkey;

CREATE INDEX fki_product_uom_fkey
  ON product
  USING btree
  (uom_id COLLATE pg_catalog."default");

-- Index: idx_product_id

-- DROP INDEX idx_product_id;

CREATE UNIQUE INDEX idx_product_id
  ON product
  USING btree
  (product_id);


CREATE TABLE productprice
(
  productprice_id character varying(32) NOT NULL,
  pricelist_version_id character varying(32) NOT NULL,
  product_id bigint NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  pricelist numeric(20, 6) NOT NULL DEFAULT 0,
  pricestd numeric(20, 6) NOT NULL DEFAULT 0,
  pricelimit numeric(20, 6) NOT NULL DEFAULT 0,
  cost numeric(20, 6) NOT NULL DEFAULT 0
)
WITH (
  OIDS=FALSE
);
ALTER TABLE productprice
  OWNER TO systel;
GRANT ALL ON TABLE productprice TO admin;
GRANT ALL ON TABLE productprice TO read;
GRANT ALL ON TABLE productprice TO systel;
GRANT ALL ON TABLE productprice TO public;

-- Index: fki_productprice_product_fkey

-- DROP INDEX fki_productprice_product_fkey;

CREATE INDEX fki_productprice_product_fkey
  ON productprice
  USING btree
  (product_id);


CREATE TABLE profile
(
  profile_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(32) NOT NULL
)
WITH (
  OIDS=FALSE
);
ALTER TABLE profile
  OWNER TO systel;
GRANT ALL ON TABLE profile TO admin;
GRANT ALL ON TABLE profile TO read;
GRANT ALL ON TABLE profile TO systel;
GRANT ALL ON TABLE profile TO public;

CREATE TABLE region
(
  region_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  description character varying(255),
  country_id character varying(32) NOT NULL,
  isdefault character(1) DEFAULT 'N'::bpchar,
  value character(5)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE region
  OWNER TO systel;
GRANT ALL ON TABLE region TO admin;
GRANT ALL ON TABLE region TO read;
GRANT ALL ON TABLE region TO systel;
GRANT ALL ON TABLE region TO public;


CREATE TABLE shortcut
(
  shortcut_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  shortcut_page_id character varying(32) NOT NULL,
  product_id bigint NOT NULL,
  name character varying(60) NOT NULL,
  "row" integer NOT NULL,
  col integer NOT NULL,
  profile_id character varying(32) DEFAULT '@'::character varying
)
WITH (
  OIDS=FALSE
);
ALTER TABLE shortcut
  OWNER TO systel;
GRANT ALL ON TABLE shortcut TO admin;
GRANT ALL ON TABLE shortcut TO read;
GRANT ALL ON TABLE shortcut TO systel;
GRANT ALL ON TABLE shortcut TO public;

-- Index: fki_shortcut_product_fkey

-- DROP INDEX fki_shortcut_product_fkey;

CREATE INDEX fki_shortcut_product_fkey
  ON shortcut
  USING btree
  (product_id);

-- Index: fki_shortcut_profile_id

-- DROP INDEX fki_shortcut_profile_id;

CREATE INDEX fki_shortcut_profile_id
  ON shortcut
  USING btree
  (profile_id COLLATE pg_catalog."default");

-- Index: fki_shortcut_shortcutpage_fkey

-- DROP INDEX fki_shortcut_shortcutpage_fkey;

CREATE INDEX fki_shortcut_shortcutpage_fkey
  ON shortcut
  USING btree
  (shortcut_page_id COLLATE pg_catalog."default");


CREATE TABLE shortcut_page
(
  shortcutpage_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60) NOT NULL,
  pos integer NOT NULL,
  rows integer NOT NULL,
  cols integer NOT NULL,
  isdefault character(1) NOT NULL DEFAULT 'N'::bpchar,
  profile_id character varying(32) DEFAULT '@'::character varying,
  icon_id character varying(32)
  )
WITH (
  OIDS=FALSE
);
ALTER TABLE shortcut_page
  OWNER TO systel;
GRANT ALL ON TABLE shortcut_page TO admin;
GRANT ALL ON TABLE shortcut_page TO read;
GRANT ALL ON TABLE shortcut_page TO systel;
GRANT ALL ON TABLE shortcut_page TO public;

-- Index: fki_shortcut_page_profile_id

-- DROP INDEX fki_shortcut_page_profile_id;

CREATE INDEX fki_shortcut_page_profile_id
  ON shortcut_page
  USING btree
  (profile_id COLLATE pg_catalog."default");

 CREATE TABLE public.role
(
  role_id character varying(32) NOT NULL, -- Identificador unico de registro de roles.
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Describe si el registro se encuentra activo.
  created timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora en que el registro fue creado.
  createdby character varying(32) NOT NULL, -- Describe al usuario que creo el registro de rol.
  updated timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora de la Ãºltima actualizaciÃ³n del registro.
  name character varying(60) NOT NULL, -- Nombre del rol.
  updatedby character varying(32) NOT NULL, -- Describe al usuario que actualizÃ³ por Ãºltima vez el registro.
  description character varying(255), -- DescripciÃ³n del rol creado.
  userlevel character varying(60) NOT NULL DEFAULT '  O'::character varying, -- Nivel de usuario.
  tree_menu_id character varying(32), -- Identificador dentro del Ã¡rbol establecido.
  ismanual character(1) DEFAULT 'N'::bpchar, -- No se encuentra en uso.
  processing character(1), -- No se encuentra en uso.
  is_client_admin character(1) NOT NULL, -- Define si es un rol con permisos de administrador.
  isadvanced character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Describe si el rol posee permisos avanzados.
  CONSTRAINT role_key PRIMARY KEY (role_id),
  CONSTRAINT role_name_un UNIQUE (name),
  CONSTRAINT role_adv_check CHECK (isadvanced = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT role_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT role_isclientadmin_check CHECK (is_client_admin = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.role
  OWNER TO systel;
GRANT ALL ON TABLE public.role TO systel;
GRANT ALL ON TABLE public.role TO admin;
GRANT ALL ON TABLE public.role TO read;
GRANT ALL ON TABLE public.role TO public;
COMMENT ON COLUMN public.role.role_id IS 'Identificador unico de registro de roles.';
COMMENT ON COLUMN public.role.isactive IS 'Describe si el registro se encuentra activo.';
COMMENT ON COLUMN public.role.created IS 'Fecha y hora en que el registro fue creado.';
COMMENT ON COLUMN public.role.createdby IS 'Describe al usuario que creo el registro de rol.';
COMMENT ON COLUMN public.role.updated IS 'Fecha y hora de la Ãºltima actualizaciÃ³n del registro.';
COMMENT ON COLUMN public.role.name IS 'Nombre del rol.';
COMMENT ON COLUMN public.role.updatedby IS 'Describe al usuario que actualizÃ³ por Ãºltima vez el registro.';
COMMENT ON COLUMN public.role.description IS 'DescripciÃ³n del rol creado.';
COMMENT ON COLUMN public.role.userlevel IS 'Nivel de usuario.';
COMMENT ON COLUMN public.role.tree_menu_id IS 'Identificador dentro del Ã¡rbol establecido.';
COMMENT ON COLUMN public.role.ismanual IS 'No se encuentra en uso.';
COMMENT ON COLUMN public.role.processing IS 'No se encuentra en uso.';
COMMENT ON COLUMN public.role.is_client_admin IS 'Define si es un rol con permisos de administrador.';
COMMENT ON COLUMN public.role.isadvanced IS 'Describe si el rol posee permisos avanzados.';


CREATE TABLE tb_user
(
  user_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  name character varying(60),
  description character varying(255),
  password character varying(40),
  email character varying(255),
  supervisor_id character varying(32),
  bpartner_id character varying(32),
  processing character(1),
  emailb_user character varying(40),
  emailb_userpw character varying(40),
  bpartner_location_id character varying(32),
  title character varying(40),
  comments character varying(2000),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  lastcontact timestamp without time zone,
  lastresult character varying(255),
  birthday timestamp without time zone,
  firstname character varying(60),
  lastname character varying(60),
  username character varying(60),
  upc character varying(500), -- Utilice este campo para ingresar el código de barras de la tarjeta de identificación del contacto (cliente, proveedor, vendedor, usuario, etc)
  default_language character varying(6),
  default_role_id character varying(32),
  default_warehouse_id character varying(32),
  islocked character(1) NOT NULL DEFAULT 'N'::bpchar,
  image_id character varying(32),
  CONSTRAINT user_default_role FOREIGN KEY (default_role_id) REFERENCES public."role"(role_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE tb_user
  OWNER TO systel;
GRANT ALL ON TABLE tb_user TO admin;
GRANT ALL ON TABLE tb_user TO read;
GRANT ALL ON TABLE tb_user TO systel;
GRANT ALL ON TABLE tb_user TO public;
COMMENT ON COLUMN tb_user.upc IS 'Utilice este campo para ingresar el código de barras de la tarjeta de identificación del contacto (cliente, proveedor, vendedor, usuario, etc)';


-- Index: b_user_email

-- DROP INDEX b_user_email;

CREATE INDEX b_user_email
  ON tb_user
  USING btree
  (email COLLATE pg_catalog."default");

-- Index: b_user_partner

-- DROP INDEX b_user_partner;

CREATE INDEX b_user_partner
  ON tb_user
  USING btree
  (bpartner_id COLLATE pg_catalog."default");


CREATE TABLE warehouse
(
  warehouse_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  value character varying(40) NOT NULL,
  name character varying(60) NOT NULL,
  description character varying(255),
  location_id character varying(32) NOT NULL,
  separator character(1) NOT NULL,
  isshipper character(1) DEFAULT 'N'::bpchar,
  shippercode character varying(20),
  fromdocumentno numeric(10,0),
  todocumentno numeric(10,0),
  returnlocator_id character varying(32)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE warehouse
  OWNER TO systel;
GRANT ALL ON TABLE warehouse TO admin;
GRANT ALL ON TABLE warehouse TO read;
GRANT ALL ON TABLE warehouse TO systel;
GRANT ALL ON TABLE warehouse TO public;
COMMENT ON TABLE warehouse
  IS 'Almacén';


CREATE TABLE locator
(
  locator_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  value character varying(40) NOT NULL,
  warehouse_id character varying(32) NOT NULL,
  priorityno numeric(10,0) NOT NULL,
  isdefault character(1) NOT NULL DEFAULT 'N'::bpchar,
  x character varying(60),
  y character varying(60),
  z character varying(60),
  CONSTRAINT locator_key PRIMARY KEY (locator_id),
  CONSTRAINT location_where UNIQUE (warehouse_id, x, y, z),
  CONSTRAINT locator_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE locator
  OWNER TO systel;
GRANT ALL ON TABLE locator TO admin;
GRANT ALL ON TABLE locator TO read;
GRANT ALL ON TABLE locator TO systel;
GRANT ALL ON TABLE locator TO public;


CREATE TABLE invoice
(
  invoice_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  documentno character varying(30) NOT NULL,
  processing character(1),
  processed character(1) NOT NULL DEFAULT 'N'::bpchar,
  posted character varying(60) NOT NULL DEFAULT 'N'::character varying,
  doctype_id character varying(32) NOT NULL,
  isprinted character(1) NOT NULL DEFAULT 'N'::bpchar,
  salesrep_id character varying(32),
  dateinvoiced timestamp without time zone NOT NULL,
  dateprinted timestamp without time zone,
  bpartner_id character varying(32) NOT NULL,
  bpartner_location_id character varying(32) NOT NULL,
  currency_id character varying(32) NOT NULL,
  totallines integer NOT NULL DEFAULT 0,
  grandtotal double precision NOT NULL DEFAULT 0,
  pricelist_id character varying(32) NOT NULL,
  istaxincluded character(1) DEFAULT 'N'::bpchar,
  oac character varying(100),
  change double precision NOT NULL DEFAULT 0,
  cash double precision NOT NULL DEFAULT 0,
  CONSTRAINT invoice_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT invoice_isprinted_check CHECK (isprinted = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT invoice_istaxincluded_check CHECK (istaxincluded = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT invoice_processed_check CHECK (processed = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE invoice
  OWNER TO postgres;
GRANT ALL ON TABLE invoice TO public;
GRANT ALL ON TABLE invoice TO postgres;
GRANT ALL ON TABLE invoice TO admin;
GRANT ALL ON TABLE invoice TO read;


CREATE TABLE invoiceline
(
  invoiceline_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  invoice_id character varying(32) NOT NULL,
  line numeric(10,0) NOT NULL,
  product_id bigint,
  qtyinvoiced double precision NOT NULL DEFAULT 0,
  pricelist double precision NOT NULL DEFAULT 0,
  priceactual double precision NOT NULL DEFAULT 0,
  linenetamt double precision NOT NULL DEFAULT 0,
  uom_id character varying(32),
  tax_id character varying(32),
  tax_base double precision,
  taxamt double precision,
  discount_id character varying(32),
  discount_base double precision,
  discountamt double precision,
  tare double precision NOT NULL DEFAULT 0,
  tare_water double precision NOT NULL DEFAULT 0,
  scale_number character varying(3) NOT NULL DEFAULT 0,
  lot character varying(20),
  expiration_date date,
  packing_date date,
  CONSTRAINT invoiceline_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE invoiceline
  OWNER TO postgres;
GRANT ALL ON TABLE invoiceline TO public;
GRANT ALL ON TABLE invoiceline TO postgres;
GRANT ALL ON TABLE invoiceline TO admin;
GRANT ALL ON TABLE invoiceline TO read;

CREATE TABLE public.discount_schema
(
  discount_id character varying(32) NOT NULL, -- Identificación única del registro.
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Define si el registro está en activo.
  created timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora de creación del registro.
  createdby character varying(32) NOT NULL, -- Define si el registro está en activo.
  updated timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora de la última actualización.
  updatedby character varying(32) NOT NULL, -- Identificación del usuario que actualizó por última vez el registro.
  name character varying(120) NOT NULL, -- Nombre del esquema de descuentos.
  description character varying(255), -- Descripción del esquema de descuentos.
  type integer NOT NULL, -- Tipo de descuento: 0. Reservado 1. Descuento sobre precio unitario (pu = pu orig - monto del descuento) 2. Descuento porcentual sobre precio unitario (pu = pu orig * %descuento) 3. Descuento sobre precio total (ptotal = ptotal orig - monto del descuento) 4. Descuento porcentual sobre precio total (ptotal = ptotal orig * %descuento)
  mode integer NOT NULL, -- Establece el modo de aplicación del descuento: 0. Date - El inicio y fin de la aplicación del descuento será aplicado de acuerdo a la fechas establecidas. 1. Time - El inicio y fin de la aplicación del descuento será aplicado de acuerdo a el rango horario establecido. 2. Datetime - El descuento deberá ser aplicado entre la fecha y hora establecida.
  start_date date NOT NULL DEFAULT ('now'::text)::date, -- Fecha de inicio de la aplicación del descuento
  start_time time without time zone NOT NULL DEFAULT ('now'::text)::time with time zone, -- Hora de inicio de la aplicación del descuento.
  end_date date, -- Fecha en la cual se dejará de aplicarse el descuento.
  end_time time without time zone, -- Hora en la cual dejará de aplicarse el descuento.
  dow_sunday character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Determina si este descuento se aplicará los Domingos
  dow_monday character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Determina si este descuento se aplicará los Lunes.
  dow_tuesday character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Determina si este descuento se aplicará los Martes.
  dow_wednesday character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Determina si este descuento se aplicará los Miércoles.
  dow_thursday character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Determina si este descuento se aplicará los Jueves.
  dow_friday character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Determina si este descuento se aplicará los Viernes.
  dow_saturday character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Determina si este descuento se aplicará los Sábados.
  CONSTRAINT discount_schema_pkey PRIMARY KEY (discount_id),
  CONSTRAINT discount_schema_dow_friday_check CHECK (dow_friday = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT discount_schema_dow_monday_check CHECK (dow_monday = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT discount_schema_dow_saturday_check CHECK (dow_saturday = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT discount_schema_dow_sunday_check CHECK (dow_sunday = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT discount_schema_dow_thursday_check CHECK (dow_thursday = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT discount_schema_dow_tuesday_check CHECK (dow_tuesday = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT discount_schema_dow_wednesday_check CHECK (dow_wednesday = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT discount_schema_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.discount_schema
  OWNER TO systel;
GRANT ALL ON TABLE public.discount_schema TO systel;
GRANT ALL ON TABLE public.discount_schema TO admin;
GRANT ALL ON TABLE public.discount_schema TO read;
GRANT ALL ON TABLE public.discount_schema TO public;
COMMENT ON COLUMN public.discount_schema.discount_id IS 'Identificación única del registro.';
COMMENT ON COLUMN public.discount_schema.isactive IS 'Define si el registro está en activo.';
COMMENT ON COLUMN public.discount_schema.created IS 'Fecha y hora de creación del registro.';
COMMENT ON COLUMN public.discount_schema.createdby IS 'Define si el registro está en activo.';
COMMENT ON COLUMN public.discount_schema.updated IS 'Fecha y hora de la última actualización.';
COMMENT ON COLUMN public.discount_schema.updatedby IS 'Identificación del usuario que actualizó por última vez el registro.';
COMMENT ON COLUMN public.discount_schema.name IS 'Nombre del esquema de descuentos.';
COMMENT ON COLUMN public.discount_schema.description IS 'Descripción del esquema de descuentos.';
COMMENT ON COLUMN public.discount_schema.type IS 'Tipo de descuento: 0. Reservado 1. Descuento sobre precio unitario (pu = pu orig - monto del descuento) 2. Descuento porcentual sobre precio unitario (pu = pu orig * %descuento) 3. Descuento sobre precio total (ptotal = ptotal orig - monto del descuento) 4. Descuento porcentual sobre precio total (ptotal = ptotal orig * %descuento)';
COMMENT ON COLUMN public.discount_schema.mode IS 'Establece el modo de aplicación del descuento: 0. Date - El inicio y fin de la aplicación del descuento será aplicado de acuerdo a la fechas establecidas. 1. Time - El inicio y fin de la aplicación del descuento será aplicado de acuerdo a el rango horario establecido. 2. Datetime - El descuento deberá ser aplicado entre la fecha y hora establecida.';
COMMENT ON COLUMN public.discount_schema.start_date IS 'Fecha de inicio de la aplicación del descuento';
COMMENT ON COLUMN public.discount_schema.start_time IS 'Hora de inicio de la aplicación del descuento.';
COMMENT ON COLUMN public.discount_schema.end_date IS 'Fecha en la cual se dejará de aplicarse el descuento.';
COMMENT ON COLUMN public.discount_schema.end_time IS 'Hora en la cual dejará de aplicarse el descuento.';
COMMENT ON COLUMN public.discount_schema.dow_sunday IS 'Determina si este descuento se aplicará los Domingos';
COMMENT ON COLUMN public.discount_schema.dow_monday IS 'Determina si este descuento se aplicará los Lunes.';
COMMENT ON COLUMN public.discount_schema.dow_tuesday IS 'Determina si este descuento se aplicará los Martes.';
COMMENT ON COLUMN public.discount_schema.dow_wednesday IS 'Determina si este descuento se aplicará los Miércoles.';
COMMENT ON COLUMN public.discount_schema.dow_thursday IS 'Determina si este descuento se aplicará los Jueves.';
COMMENT ON COLUMN public.discount_schema.dow_friday IS 'Determina si este descuento se aplicará los Viernes.';
COMMENT ON COLUMN public.discount_schema.dow_saturday IS 'Determina si este descuento se aplicará los Sábados.';


CREATE TABLE IF NOT EXISTS public.discount_schema_line
(
  discount_schema_line_id character varying(32) NOT NULL, -- Identificador único del registro.
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Define si el registro está en activo.
  created timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora de creación del registro.
  createdby character varying(32) NOT NULL, -- Identificación de usuario que creó el registro.
  updated timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora de la última actualización.
  updatedby character varying(32) NOT NULL, -- Identificación del usuario que actualizó por última vez el registro.
  discount_schema_id character varying(32) NOT NULL, -- Identificación del enlace a la tabla DISCOUNT_SHEMA.
  source integer NOT NULL DEFAULT 0, -- Determina sobre qué valor se basan los límites de aplicación del descuento: 0. Cantidad, en productos no pesables
  limit_minamt numeric(20, 6) NOT NULL DEFAULT 0, -- Ver comentario del campo limit_margin
  limit_maxamt numeric(20, 6) NOT NULL DEFAULT 0, -- Ver comentario del campo limit_margin.
  limit_fixed numeric(20, 6) DEFAULT 0, -- Límite para la aplicación de este rate de descuento. El descuento será aplicado si el valor de peso, cantidad o importe total es igual o mayor al límite establecido.
  limit_margin numeric(20, 6) NOT NULL DEFAULT 0, -- Establece la tolerancia porcentual del límite de aplicación de un descuento. Si en vez de una tolerancia porcentual se desea utilizar un valor mínimo y máximo prefijado, se deberán utilizar los campos limit_minamt y limit_maxamt respectivamente.
  rate numeric(20, 6) NOT NULL, -- Establece el porcentaje o el monto del descuento (depende de la configuración del descuento, ver discount_schema).
  CONSTRAINT discount_schema_line_pkey PRIMARY KEY (discount_schema_line_id),
  CONSTRAINT discount_schema_line_fkey FOREIGN KEY (discount_schema_id)
      REFERENCES public.discount_schema (discount_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT discount_schema_line_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS public.discount_schema_line
    OWNER to systel;

GRANT ALL ON TABLE public.discount_schema_line TO PUBLIC;

GRANT ALL ON TABLE public.discount_schema_line TO systel;

GRANT ALL ON TABLE public.discount_schema_line TO read;

GRANT ALL ON TABLE public.discount_schema_line TO admin;

COMMENT ON COLUMN public.discount_schema_line.discount_schema_line_id
    IS 'Identificador único del registro.';

COMMENT ON COLUMN public.discount_schema_line.isactive
    IS 'Define si el registro está en activo.';

COMMENT ON COLUMN public.discount_schema_line.created
    IS 'Fecha y hora de creación del registro.';

COMMENT ON COLUMN public.discount_schema_line.createdby
    IS 'Identificación de usuario que creó el registro.';

COMMENT ON COLUMN public.discount_schema_line.updated
    IS 'Fecha y hora de la última actualización.';

COMMENT ON COLUMN public.discount_schema_line.updatedby
    IS 'Identificación del usuario que actualizó por última vez el registro.';

COMMENT ON COLUMN public.discount_schema_line.discount_schema_id
    IS 'Identificación del enlace a la tabla DISCOUNT_SHEMA.';

COMMENT ON COLUMN public.discount_schema_line.source
    IS 'Determina sobre qué valor se basan los límites de aplicación del descuento: 0. Cantidad, en productos no pesables';

COMMENT ON COLUMN public.discount_schema_line.limit_minamt
    IS 'Ver comentario del campo limit_margin';

COMMENT ON COLUMN public.discount_schema_line.limit_maxamt
    IS 'Ver comentario del campo limit_margin.';

COMMENT ON COLUMN public.discount_schema_line.limit_fixed
    IS 'Límite para la aplicación de este rate de descuento. El descuento será aplicado si el valor de peso, cantidad o importe total es igual o mayor al límite establecido.';

COMMENT ON COLUMN public.discount_schema_line.limit_margin
    IS 'Establece la tolerancia porcentual del límite de aplicación de un descuento. Si en vez de una tolerancia porcentual se desea utilizar un valor mínimo y máximo prefijado, se deberán utilizar los campos limit_minamt y limit_maxamt respectivamente.';

COMMENT ON COLUMN public.discount_schema_line.rate
    IS 'Establece el porcentaje o el monto del descuento (depende de la configuración del descuento, ver discount_schema).';
-- Index: fki_discount_schema_line_fkey

-- DROP INDEX IF EXISTS public.fki_discount_schema_line_fkey;

CREATE INDEX fki_discount_schema_line_fkey
    ON public.discount_schema_line USING btree
    (discount_schema_id COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default;

CREATE TABLE public.taxcategory
(
  taxcategory_id character varying(32) NOT NULL, -- No está en uso.
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar, -- No está en uso.
  created timestamp without time zone NOT NULL DEFAULT now(), -- No está en uso.
  createdby character varying(32) NOT NULL, -- No está en uso.
  updated timestamp without time zone NOT NULL DEFAULT now(), -- No está en uso.
  updatedby character varying(32) NOT NULL, -- No está en uso.
  name character varying(60) NOT NULL, -- No está en uso.
  description character varying(255), -- No está en uso.
  isdefault character(1) NOT NULL DEFAULT 'N'::bpchar, -- No está en uso.
  CONSTRAINT taxcategory_key PRIMARY KEY (taxcategory_id),
  CONSTRAINT taxcategory_name UNIQUE (name),
  CONSTRAINT taxcategory_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.taxcategory
  OWNER TO systel;
GRANT ALL ON TABLE public.taxcategory TO systel;
GRANT ALL ON TABLE public.taxcategory TO admin;
GRANT ALL ON TABLE public.taxcategory TO read;
GRANT ALL ON TABLE public.taxcategory TO public;
COMMENT ON COLUMN public.taxcategory.taxcategory_id IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.isactive IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.created IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.createdby IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.updated IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.updatedby IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.name IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.description IS 'No está en uso.';
COMMENT ON COLUMN public.taxcategory.isdefault IS 'No está en uso.';



CREATE TABLE public.tax
(
  tax_id character varying(32) NOT NULL, -- No está en uso.
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar, -- No está en uso.
  created timestamp without time zone NOT NULL DEFAULT now(), -- No está en uso.
  createdby character varying(32) NOT NULL, -- No está en uso.
  updated timestamp without time zone NOT NULL DEFAULT now(), -- No está en uso.
  updatedby character varying(32) NOT NULL, -- No está en uso.
  name character varying(60) NOT NULL, -- No está en uso.
  description character varying(255), -- No está en uso.
  taxindicator character varying(5), -- No está en uso.
  validfrom timestamp without time zone NOT NULL, -- No está en uso.
  issummary character(1) NOT NULL DEFAULT 'N'::bpchar, -- No está en uso.
  rate numeric(20,6) NOT NULL, -- No está en uso.
  parent_tax_id character varying(32), -- No está en uso.
  taxcategory_id character varying(32) NOT NULL, -- No está en uso.
  isdefault character(1) NOT NULL DEFAULT 'N'::bpchar, -- No está en uso.
  istaxexempt character(1) NOT NULL DEFAULT 'N'::bpchar, -- No está en uso.
  sopotype character varying(60) NOT NULL DEFAULT 'B'::character varying, -- No está en uso.
  cascade character(1) DEFAULT 'N'::bpchar, -- No está en uso.
  bp_taxcategory_id character varying(32), -- No está en uso.
  line numeric, -- No está en uso.
  iswithholdingtax character(1), -- No está en uso.
  isnotaxable character(1) DEFAULT 'N'::bpchar, -- No está en uso.
  deducpercent numeric(20,6), -- No está en uso.
  originalrate numeric(20,6), -- No está en uso.
  istaxundeductable character(1) DEFAULT 'N'::bpchar, -- No está en uso.
  istaxdeductable character(1) DEFAULT 'N'::bpchar, -- No está en uso.
  isnovat character(1) DEFAULT 'N'::bpchar, -- No está en uso.
  baseamount character varying(60) NOT NULL DEFAULT 'LNA'::character varying, -- No está en uso.
  taxbase_id character varying(32), -- No está en uso.
  doctaxamount character varying(60) NOT NULL DEFAULT 'D'::character varying, -- No está en uso.
  CONSTRAINT tax_pkey PRIMARY KEY (tax_id),
  CONSTRAINT tax_parent_tax FOREIGN KEY (parent_tax_id)
      REFERENCES public.tax (tax_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT tax_taxbase FOREIGN KEY (taxbase_id)
      REFERENCES public.tax (tax_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT tax_taxcategory FOREIGN KEY (taxcategory_id)
      REFERENCES public.taxcategory (taxcategory_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT tax_name1 UNIQUE (name, parent_tax_id),
  CONSTRAINT tax_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT tax_istaxdeductable CHECK (istaxdeductable = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.tax
  OWNER TO systel;
GRANT ALL ON TABLE public.tax TO systel;
GRANT ALL ON TABLE public.tax TO admin;
GRANT ALL ON TABLE public.tax TO read;
GRANT ALL ON TABLE public.tax TO public;
COMMENT ON COLUMN public.tax.tax_id IS 'No está en uso.';
COMMENT ON COLUMN public.tax.isactive IS 'No está en uso.';
COMMENT ON COLUMN public.tax.created IS 'No está en uso.';
COMMENT ON COLUMN public.tax.createdby IS 'No está en uso.';
COMMENT ON COLUMN public.tax.updated IS 'No está en uso.';
COMMENT ON COLUMN public.tax.updatedby IS 'No está en uso.';
COMMENT ON COLUMN public.tax.name IS 'No está en uso.';
COMMENT ON COLUMN public.tax.description IS 'No está en uso.';
COMMENT ON COLUMN public.tax.taxindicator IS 'No está en uso.';
COMMENT ON COLUMN public.tax.validfrom IS 'No está en uso.';
COMMENT ON COLUMN public.tax.issummary IS 'No está en uso.';
COMMENT ON COLUMN public.tax.rate IS 'No está en uso.';
COMMENT ON COLUMN public.tax.parent_tax_id IS 'No está en uso.';
COMMENT ON COLUMN public.tax.taxcategory_id IS 'No está en uso.';
COMMENT ON COLUMN public.tax.isdefault IS 'No está en uso.';
COMMENT ON COLUMN public.tax.istaxexempt IS 'No está en uso.';
COMMENT ON COLUMN public.tax.sopotype IS 'No está en uso.';
COMMENT ON COLUMN public.tax.cascade IS 'No está en uso.';
COMMENT ON COLUMN public.tax.bp_taxcategory_id IS 'No está en uso.';
COMMENT ON COLUMN public.tax.line IS 'No está en uso.';
COMMENT ON COLUMN public.tax.iswithholdingtax IS 'No está en uso.';
COMMENT ON COLUMN public.tax.isnotaxable IS 'No está en uso.';
COMMENT ON COLUMN public.tax.deducpercent IS 'No está en uso.';
COMMENT ON COLUMN public.tax.originalrate IS 'No está en uso.';
COMMENT ON COLUMN public.tax.istaxundeductable IS 'No está en uso.';
COMMENT ON COLUMN public.tax.istaxdeductable IS 'No está en uso.';
COMMENT ON COLUMN public.tax.isnovat IS 'No está en uso.';
COMMENT ON COLUMN public.tax.baseamount IS 'No está en uso.';
COMMENT ON COLUMN public.tax.taxbase_id IS 'No está en uso.';
COMMENT ON COLUMN public.tax.doctaxamount IS 'No está en uso.';

CREATE TABLE public.access
(
  access_id character varying(32) NOT NULL,
  role_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  config character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_gral character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_profile character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_format_print character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_codebar character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_calibration character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_overweight character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_backup character(1) NOT NULL DEFAULT 'N'::bpchar,
  product character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_products character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_fast_load character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_shortcut character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_department character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_group character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_ingridient character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_conservation character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_tax character(1) NOT NULL DEFAULT 'N'::bpchar,
  importer character(1) NOT NULL DEFAULT 'N'::bpchar,
  prices character(1) NOT NULL DEFAULT 'N'::bpchar,
  prices_list character(1) NOT NULL DEFAULT 'N'::bpchar,
  prices_quick_update character(1) NOT NULL DEFAULT 'N'::bpchar,
  advertising character(1) NOT NULL DEFAULT 'N'::bpchar,
  users character(1) NOT NULL DEFAULT 'N'::bpchar,
  locations character(1) NOT NULL DEFAULT 'N'::bpchar,
  locations_currency character(1) NOT NULL DEFAULT 'N'::bpchar,
  locations_countrie character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_day character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_seller character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_plu character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_close_sales character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_cancel character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_total character(1) NOT NULL DEFAULT 'N'::bpchar,
  images character(1) NOT NULL DEFAULT 'N'::bpchar,
  roles character(1) NOT NULL DEFAULT 'N'::bpchar,
  role_name character varying(60) COLLATE pg_catalog."default",
  CONSTRAINT access_key PRIMARY KEY (access_id),
  CONSTRAINT access_role_fkey FOREIGN KEY (role_id)
      REFERENCES public.role (role_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.access
  OWNER TO systel;
GRANT ALL ON TABLE public.access TO systel;
GRANT ALL ON TABLE public.access TO admin;
GRANT ALL ON TABLE public.access TO public;
GRANT ALL ON TABLE public.access TO read;

-- Index: public.fki_access_role_id

-- DROP INDEX public.fki_access_role_id;

CREATE INDEX fki_access_role_id
  ON public.access
  USING btree
  (role_id COLLATE pg_catalog."default" varchar_ops);




-- Inserts

-- Node Models

INSERT INTO #syncNodeModelTable#
(id, name, image)
VALUES
--(0, 'node.models.cuora', 'cuora.png'),
(1, 'node.models.cuora.neo', 'cuora-neo.png'),
--(2, 'node.models.clipse', 'clipse.png'),
--(3, 'node.models.cuora.max', 'cuora-max.png'),
(4, 'node.models.verificador', 'verificador.png'),
(5, 'node.models.selfservice', 'selfservice.png'),
(6, 'node.models.modular', 'modular.png');

-- **************************************************
-- PRCOCESS TYPE 0 sincro parcial por medio de hash
-- **************************************************
-- **************************************************
-- PRCOCESS TYPE 2 sincro forzada full del server a la balanza
-- **************************************************
-- **************************************************
-- PRCOCESS TYPE 1 sincro de ventas de la balanza al server
-- **************************************************
-- **************************************************
-- PRCOCESS TYPE 3 borrado de datos que están en la balanza y no en el server (se borran de la balanza)
-- **************************************************

-- Tables
INSERT INTO #syncTableTable#
("order", name, primary_key, process_type, query_diff)
VALUES
( 10, 'barcode_format', 'barcodetype, producttype', 0,'SELECT * FROM barcode_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM barcode_format'' ) AS DATA (
  barcodetype character varying(32),
  producttype character(1),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  field_a character varying(50),
  cantidad_a character varying(2),
  value_a character varying(30),
  field_b character varying(50),
  cantidad_b character varying(2),
  value_b character varying(30),
  field_c character varying(50),
  cantidad_c character varying(2),
  value_c character varying(30),
  field_d character varying(50),
  cantidad_d character varying(2),
  value_d character varying(30)
);'),
(20, 'nut_info_set', 'nut_info_set_id', 0,'SELECT * FROM nut_info_set
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_set'' ) AS DATA (
  nut_info_set_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_name character varying(60),
  description character varying(255),
  columns_qty numeric(2,0),
  rows_qty numeric(2,0)
);'),
(30, 'nut_info_element', 'nut_info_element_id', 0,'SELECT * FROM nut_info_element
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_element'' ) AS DATA (
 nut_info_element_id character varying(32),
  isactive character(1) ,
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  value character varying(255),
  hasjoinedrows character varying(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character varying(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer,
  vd numeric,
  uom character varying(20)
);'),
(31, 'discount_schema', 'discount_id', 0,'SELECT * FROM discount_schema
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema'' ) AS DATA (
  discount_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(120),
  description character varying(255),
  type integer,
  mode integer,
  start_date date,
  start_time time without time zone,
  end_date date,
  end_time time without time zone,
  dow_sunday character(1),
  dow_monday character(1),
  dow_tuesday character(1),
  dow_wednesday character(1),
  dow_thursday character(1),
  dow_friday character(1),
  dow_saturday character(1)
);'),
(32, 'discount_schema_line', 'discount_schema_line_id', 0,'SELECT * FROM discount_schema_line
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema_line'' ) AS DATA (
  discount_schema_line_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  discount_schema_id character varying(32),
  source integer,
  limit_minamt numeric(20, 6),
  limit_maxamt numeric(20, 6),
  limit_fixed numeric(20, 6),
  limit_margin numeric(20, 6),
  rate numeric(20, 6)
);'),
(33, 'taxcategory', 'taxcategory_id', 0,'SELECT * FROM taxcategory
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM taxcategory'' ) AS DATA (
  taxcategory_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  isdefault character(1)
);'),
(34, 'tax', 'tax_id', 0,'SELECT * FROM tax
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tax'' ) AS DATA (
  tax_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  taxindicator character varying(5),
  validfrom timestamp without time zone,
  issummary character(1),
  rate numeric(20,6),
  parent_tax_id character varying(32),
  taxcategory_id character varying(32),
  isdefault character(1),
  istaxexempt character(1),
  sopotype character varying(60),
  cascade character(1),
  bp_taxcategory_id character varying(32),
  line numeric,
  iswithholdingtax character(1),
  isnotaxable character(1),
  deducpercent numeric(20,6),
  originalrate numeric(20,6),
  istaxundeductable character(1),
  istaxdeductable character(1),
  isnovat character(1),
  baseamount character varying(60),
  taxbase_id character varying(32),
  doctaxamount character varying(60)
);'),
(40, 'department', 'department_id', 0,'SELECT * FROM department
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM department'' ) AS DATA (
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32),
  warehouse_id character varying(32)
);'),
(50, 'main_group', 'group_id', 0,'SELECT * FROM main_group
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM main_group'' ) AS DATA (
  group_id bigint,
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32)
);'),
(70, 'labels', 'labels_id', 0,'SELECT * FROM labels
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM labels'' ) AS DATA (
  labels_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  label_format_w_di character varying(32),
  label_format_w_pp character varying(32),
  label_format_u_di character varying(32),
  label_format_u_pp character varying(32),
  label_format_w_co character varying(32),
  label_format_w_es character varying(32)
);'),
(60, 'label_format', 'label_format_id', 0,'SELECT * FROM label_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM label_format'' ) AS DATA (
  label_format_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  template character varying,
  type integer
);'),
(120, 'locator', 'locator_id', 0,'SELECT * FROM locator
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM locator'' ) AS DATA (
  locator_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  warehouse_id character varying(32),
  priorityno numeric(10,0),
  isdefault character(1),
  x character varying(60),
  y character varying(60),
  z character varying(60)
);'),
(140, 'warehouse', 'warehouse_id', 0,'SELECT * FROM warehouse
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM warehouse'' ) AS DATA (
  warehouse_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  name character varying(60),
  description character varying(255),
  location_id character varying(32),
  separator character(1),
  isshipper character(1),
  shippercode character varying(20),
  fromdocumentno numeric(10,0),
  todocumentno numeric(10,0),
  returnlocator_id character varying(32)
);'),
(130, 'location', 'location_id', 0,'SELECT * FROM location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM location'' ) AS DATA (
  location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  address1 character varying(60),
  address2 character varying(60),
  city character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  country_id character varying(32),
  region_id character varying(32),
  city_id character varying(32),
  regionname character varying(40)
);'),
(200, 'tb_user', 'user_id', 0,'SELECT * FROM tb_user
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tb_user'' ) AS DATA (
  user_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  password character varying(40),
  email character varying(255),
  supervisor_id character varying(32),
  bpartner_id character varying(32),
  processing character(1),
  emailb_user character varying(40),
  emailb_userpw character varying(40),
  bpartner_location_id character varying(32),
  title character varying(40),
  comments character varying(2000),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  lastcontact timestamp without time zone,
  lastresult character varying(255),
  birthday timestamp without time zone,
  firstname character varying(60),
  lastname character varying(60),
  username character varying(60),
  upc character varying(500),
  default_language character varying(6),
  default_role_id character varying(32),
  default_warehouse_id character varying(32),
  islocked character(1),
  image_id character varying(32)
);'),
(190, 'bpartner_location', 'bpartner_location_id', 0,'SELECT * FROM bpartner_location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner_location'' ) AS DATA (
   bpartner_location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  isbillto character(1),
  isshipto character(1),
  ispayfrom character(1),
  isremitto character(1),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  bpartner_id character varying(32),
  istaxlocation character(1),
  upc character varying(30),
  address1 character varying(60),
  address2 character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  city_id character varying(32),
  region_id character varying(32),
  country_id character varying(32)
);'),
(110, 'city', 'city_id', 0,'SELECT * FROM city
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM city'' ) AS DATA (
   city_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  locode character varying(10),
  coordinates character varying(15),
  postal character varying(10),
  areacode character varying(10),
  country_id character varying(32),
  region_id character varying(32)
);'),
(90, 'country', 'country_id', 0,'SELECT * FROM country
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM country'' ) AS DATA (
  country_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  countrycode character(3),
  hasregion character(1),
  regionname character varying(60),
  expressionphone character varying(20),
  displaysequence character varying(20),
  expressionpostal character varying(20),
  haspostal_add character(1),
  expressionpostal_add character varying(20),
  isdefault character(1),
  ad_language character varying(6),
  currency_id character varying(32),
  ibannodigits numeric,
  ibancountry character varying(2)
);'),
(290, 'productprice', 'productprice_id', 0,'SELECT * FROM productprice
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM productprice'' ) AS DATA (
  productprice_id character varying(32),
  pricelist_version_id character varying(32),
  product_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  pricelist numeric(20,6),
  pricestd numeric(20,6),
  pricelimit numeric(20,6),
  cost numeric(20,6)
);'),
(220, 'pricelist_version', 'pricelist_version_id', 0,'SELECT * FROM pricelist_version
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist_version'' ) AS DATA (
  pricelist_version_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  pricelist_id character varying(32),
  validfrom timestamp without time zone,
  proccreate character(1),
  pricelist_version_base_id character varying(32),
  pricelist_version_generate character(1),
  validto timestamp without time zone,
  isdefault character(1)
);'),
(280, 'nut_info_el_instance', 'nut_info_el_instance_id', 0,'SELECT * FROM nut_info_el_instance
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_el_instance'' ) AS DATA (
nut_info_el_instance_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  product_id bigint,
  value character varying(255),
  hasjoinedrows character(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer
);'),
(260, 'shortcut_page', 'shortcutpage_id', 0,'SELECT * FROM shortcut_page
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut_page'' ) AS DATA (
  shortcutpage_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  pos integer,
  rows integer,
  cols integer,
  isdefault character(1),
  profile_id character varying(32),
  icon_id character varying(32)
);'),
(270, 'shortcut', 'shortcut_id', 0,'SELECT * FROM shortcut
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut'' ) AS DATA (
  shortcut_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  shortcut_page_id character varying(32),
  product_id bigint,
  name character varying(60),
  "row" integer,
  col integer,
  profile_id character varying(32)
);'),
(250, 'product', 'product_id', 0,'SELECT * FROM product
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM product'' ) AS DATA (
    product_id bigint ,
    isactive character(1) ,
    created timestamp without time zone ,
    createdby character varying(32) ,
    updated timestamp without time zone ,
    updatedby character varying(32) ,
    erp_code character varying(25),
    name character varying(56) ,
    description character varying(255),
    department_id bigint ,
    group_id bigint ,
    label_format_w character varying(32),
    label_format_u character varying(32),
    barcode_item_code_flag character(1),
    barcode_item_code numeric(20,0) ,
    print_primary_barcode character(1) ,
    primary_barcode_type integer,
    primary_barcode_flag_data character varying(255),
    print_secondary_barcode character(1) ,
    secondary_barcode_type integer,
    secondary_barcode_flag_data character varying(255),
    sell_by_date_time integer ,
    sell_by_date_source integer ,
    sell_by_date numeric(2,0),
    sell_time_source integer,
    sell_time time without time zone,
    print_packed_date character(1),
    packed_date_source integer ,
    packed_date numeric(2,0),
    packed_date_format character varying(10),
    print_used_by_date character(1),
    used_by_date_source integer,
    used_by_date numeric(3,0) ,
    unit_price_selection integer,
    tare numeric(20,6),
    perc_tare numeric(20,6),
    quantity numeric(10,0),
    upc character varying(30),
    uom_id character varying(32),
    discount_schema_id character varying(32),
    isstocked character(1),
    isirradiated character(1),
    isbom character(1),
    stock_min numeric(20,6),
    stock_max numeric(20,6),
    versionno character varying(20),
    discontinued character(1),
    discontinuedby timestamp without time zone,
    tax_id character varying(32),
    attribute integer,
    advertising_id character varying(32),
    sto_temp_limit1 numeric(20,6),
    sto_temp_limit2 numeric(20,6),
    ingredients character varying(2000),
    ingredients_id character varying(32),
    preservation_info character varying(2000),
    preservation_info_id character varying(32),
    coupled_product bigint,
    pack_indicator numeric(1,0),
    extra_field1 character varying(2000),
    extra_field2 character varying(2000),
    image_id character varying(32),
    icon_id character varying(32),
    lot character varying(20),
    born_country character varying(32),
    fatten_country character varying(32),
    origin_country character varying(32),
    manufacturer_id character varying(32),
    packer_id character varying(32),
    distributor_id character varying(32),
    importer_id character varying(32),
    exporter_id character varying(32),
    vendor_id character varying(32),
    cutting_hall_id character varying(32),
    slaughter_house_id character varying(32),
    supplier_id character varying(32),
    nut_info_set_id character varying(32),
    print_fix_primary_barcode character(1),
    print_fix_secondary_barcode character(1)
);'),
(240, 'advertising', 'advertising_id', 0,'SELECT * FROM advertising
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM advertising'' ) AS DATA (
  advertising_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  advertising character varying(255),
  isproductmsgonly character(1),
  isdefault character(1),
  ismedia character(1),
  media_url character varying(2000),
  image_id character varying(32),
  profile_id character varying(32)
);'),
(230, 'profile', 'profile_id', 0,'SELECT * FROM profile
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM profile'' ) AS DATA (
  profile_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(32)
);'),
(160, 'ingredient', 'ingredient_id', 0,'SELECT * FROM ingredient
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM ingredient'' ) AS DATA (
  ingredient_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  ingredients text,
  isdefault character(1)
);'),
(170, 'preservation_info', 'preservation_info_id', 0,'SELECT * FROM preservation_info
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM preservation_info'' ) AS DATA (
  preservation_info_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  info text,
  isdefault character(1),
  image_id character varying(32)
);'),
(180, 'bpartner', 'bpartner_id', 0,'SELECT * FROM bpartner
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner'' ) AS DATA (
  bpartner_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  name2 character varying(60),
  description character varying(255),
  issummary character(1),
  iscustomer character(1),
  isemployee character(1),
  issalesrep character(1),
  ispacker character(1),
  isdistributor character(1),
  isimporter character(1),
  isexporter character(1),
  isvendor character(1),
  iscutting_hall character(1),
  isslaughter_house character(1),
  issupplier character(1),
  referenceno character varying(40),
  duns character(11),
  taxid character varying(20),
  istaxexempt character(1),
  rating character(1),
  salesvolume numeric(10,0),
  naics character(6),
  firstsale timestamp without time zone,
  paymentrule character varying(60),
  creditlimit numeric(20,6),
  creditused numeric(20,6),
  paymentterm_id character varying(32),
  pricelist_id character varying(32),
  isdiscountprinted character(1),
  salesrep_id character varying(32),
  bpartner_parent_id character varying(32),
  upc character varying(30),
  fiscalcode character varying(16),
  isofiscalcode character varying(5),
  image_id character varying(32),
  print_field character varying(2000)
);'),
(150, 'image', 'image_id', 0,'SELECT * FROM image
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM image'' ) AS DATA (
  image_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  imageurl character varying(120),
  binarydata bytea,
  width numeric(10,0),
  height numeric(10,0),
  isproducticon character(1),
  isproductimage character(1),
  issupplierimage character(1),
  isrsiimage character(1),
  mimetype character varying(255),
  isadvertisingimage character(1),
  iscompanyimage character(1),
  ispreserveimage character(1)
);'),
(210, 'pricelist', 'pricelist_id', 0,'SELECT * FROM pricelist
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist'' ) AS DATA (
  pricelist_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  basepricelist_id character varying(32),
  istaxincluded character(1),
  issopricelist character(1),
  isdefault character(1),
  currency_id character varying(32),
  enforcepricelimit character(1),
  costbased character(1)
);'),
(100, 'region', 'region_id', 0,'SELECT * FROM region
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM region'' ) AS DATA (
  region_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  country_id character varying(32),
  isdefault character(1),
  value character(5)
);'),
(80, 'currency', 'currency_id', 0,'SELECT * FROM currency
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM currency'' ) AS DATA (
  currency_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  iso_code character(3),
  cursymbol character varying(10),
  description character varying(255),
  stdprecision integer,
  costingprecision integer,
  priceprecision integer,
  issymbolrightside character(1)
);'),
(195, 'role', 'role_id', 0,'SELECT * FROM role
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM role'' ) AS DATA (
  role_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  name character varying(60),
  updatedby character varying(32),
  description character varying(255),
  userlevel character varying(60),
  tree_menu_id character varying(32),
  ismanual character(1),
  processing character(1),
  is_client_admin character(1),
  isadvanced character(1)
);'),
(300, 'access', 'access_id', 0,'SELECT * FROM access
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM access'' ) AS DATA (
  access_id character varying(32),
  role_id character varying(32),
  isactive character(1) ,
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  config character(1),
  config_gral character(1),
  config_profile character(1),
  config_format_print character(1),
  config_codebar character(1),
  config_calibration character(1),
  config_overweight character(1),
  config_backup character(1),
  product character(1),
  product_products character(1),
  product_fast_load character(1),
  product_shortcut character(1),
  product_department character(1),
  product_group character(1),
  product_ingridient character(1),
  product_conservation character(1),
  product_tax character(1),
  importer character(1),
  prices character(1),
  prices_list character(1),
  prices_quick_update character(1),
  advertising character(1),
  users character(1),
  locations character(1),
  locations_currency character(1),
  locations_countrie character(1),
  reports character(1),
  reports_vta_day character(1),
  reports_vta_seller character(1),
  reports_vta_plu character(1),
  reports_vta_close_sales character(1),
  reports_vta_cancel character(1),
  reports_vta_total character(1),
  images character(1),
  roles character(1),
  role_name character varying(60)
);'),
(10, 'barcode_format', 'barcodetype, producttype', 2,'SELECT * FROM barcode_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM barcode_format'' ) AS DATA (
  barcodetype character varying(32),
  producttype character(1),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  field_a character varying(50),
  cantidad_a character varying(2),
  value_a character varying(30),
  field_b character varying(50),
  cantidad_b character varying(2),
  value_b character varying(30),
  field_c character varying(50),
  cantidad_c character varying(2),
  value_c character varying(30),
  field_d character varying(50),
  cantidad_d character varying(2),
  value_d character varying(30)
);'),
(20, 'nut_info_set', 'nut_info_set_id', 2,'SELECT * FROM nut_info_set
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_set'' ) AS DATA (
  nut_info_set_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_name character varying(60),
  description character varying(255),
  columns_qty numeric(2,0),
  rows_qty numeric(2,0)
);'),
(30, 'nut_info_element', 'nut_info_element_id', 2,'SELECT * FROM nut_info_element
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_element'' ) AS DATA (
 nut_info_element_id character varying(32),
  isactive character(1) ,
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  value character varying(255),
  hasjoinedrows character varying(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character varying(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer,
  vd numeric,
  uom character varying(20)
);'),
(31, 'discount_schema', 'discount_id', 2,'SELECT * FROM discount_schema
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema'' ) AS DATA (
  discount_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(120),
  description character varying(255),
  type integer,
  mode integer,
  start_date date,
  start_time time without time zone,
  end_date date,
  end_time time without time zone,
  dow_sunday character(1),
  dow_monday character(1),
  dow_tuesday character(1),
  dow_wednesday character(1),
  dow_thursday character(1),
  dow_friday character(1),
  dow_saturday character(1)
);'),
(32, 'discount_schema_line', 'discount_schema_line_id', 2,'SELECT * FROM discount_schema_line
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema_line'' ) AS DATA (
  discount_schema_line_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  discount_schema_id character varying(32),
  source integer,
  limit_minamt numeric(20,6),
  limit_maxamt numeric(20,6),
  limit_fixed numeric(20,6),
  limit_margin numeric(20,6),
  rate numeric(20,6)
);'),
(33, 'taxcategory', 'taxcategory_id', 2,'SELECT * FROM taxcategory
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM taxcategory'' ) AS DATA (
  taxcategory_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  isdefault character(1)
);'),
(34, 'tax', 'tax_id', 2,'SELECT * FROM tax
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tax'' ) AS DATA (
  tax_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  taxindicator character varying(5),
  validfrom timestamp without time zone,
  issummary character(1),
  rate numeric(20,6),
  parent_tax_id character varying(32),
  taxcategory_id character varying(32),
  isdefault character(1),
  istaxexempt character(1),
  sopotype character varying(60),
  cascade character(1),
  bp_taxcategory_id character varying(32),
  line numeric,
  iswithholdingtax character(1),
  isnotaxable character(1),
  deducpercent numeric(20,6),
  originalrate numeric(20,6),
  istaxundeductable character(1),
  istaxdeductable character(1),
  isnovat character(1),
  baseamount character varying(60),
  taxbase_id character varying(32),
  doctaxamount character varying(60)
);'),
(40, 'department', 'department_id', 2,'SELECT * FROM department
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM department'' ) AS DATA (
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32),
  warehouse_id character varying(32)
);'),
(50, 'main_group', 'group_id', 2,'SELECT * FROM main_group
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM main_group'' ) AS DATA (
  group_id bigint,
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32)
);'),
(70, 'labels', 'labels_id', 2,'SELECT * FROM labels
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM labels'' ) AS DATA (
  labels_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  label_format_w_di character varying(32),
  label_format_w_pp character varying(32),
  label_format_u_di character varying(32),
  label_format_u_pp character varying(32),
  label_format_w_co character varying(32),
  label_format_w_es character varying(32)
);'),
(60, 'label_format', 'label_format_id', 2,'SELECT * FROM label_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM label_format'' ) AS DATA (
  label_format_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  template character varying,
  type integer
);'),
(80, 'currency', 'currency_id', 2,'SELECT * FROM currency
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM currency'' ) AS DATA (
  currency_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  iso_code character(3),
  cursymbol character varying(10),
  description character varying(255),
  stdprecision integer,
  costingprecision integer,
  priceprecision integer,
  issymbolrightside character(1)
);'),
(90, 'country', 'country_id', 2,'SELECT * FROM country
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM country'' ) AS DATA (
  country_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  countrycode character(3),
  hasregion character(1),
  regionname character varying(60),
  expressionphone character varying(20),
  displaysequence character varying(20),
  expressionpostal character varying(20),
  haspostal_add character(1),
  expressionpostal_add character varying(20),
  isdefault character(1),
  ad_language character varying(6),
  currency_id character varying(32),
  ibannodigits numeric,
  ibancountry character varying(2)
);'),
(100, 'region', 'region_id', 2,'SELECT * FROM region
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM region'' ) AS DATA (
  region_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  country_id character varying(32),
  isdefault character(1),
  value character(5)
);'),
(110, 'city', 'city_id', 2,'SELECT * FROM city
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM city'' ) AS DATA (
   city_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  locode character varying(10),
  coordinates character varying(15),
  postal character varying(10),
  areacode character varying(10),
  country_id character varying(32),
  region_id character varying(32)
);'),
(120, 'locator', 'locator_id', 2,'SELECT * FROM locator
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM locator'' ) AS DATA (
  locator_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  warehouse_id character varying(32),
  priorityno numeric(10,0),
  isdefault character(1),
  x character varying(60),
  y character varying(60),
  z character varying(60)
);
'),
(130, 'location', 'location_id', 2,'SELECT * FROM location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM location'' ) AS DATA (
  location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  address1 character varying(60),
  address2 character varying(60),
  city character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  country_id character varying(32),
  region_id character varying(32),
  city_id character varying(32),
  regionname character varying(40)
);'),
(140, 'warehouse', 'warehouse_id', 2,'SELECT * FROM warehouse
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM warehouse'' ) AS DATA (
  warehouse_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  name character varying(60),
  description character varying(255),
  location_id character varying(32),
  separator character(1),
  isshipper character(1),
  shippercode character varying(20),
  fromdocumentno numeric(10,0),
  todocumentno numeric(10,0),
  returnlocator_id character varying(32)
);'),
(150, 'image', 'image_id', 2,'SELECT * FROM image
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM image'' ) AS DATA (
  image_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  imageurl character varying(120),
  binarydata bytea,
  width numeric(10,0),
  height numeric(10,0),
  isproducticon character(1),
  isproductimage character(1),
  issupplierimage character(1),
  isrsiimage character(1),
  mimetype character varying(255),
  isadvertisingimage character(1),
  iscompanyimage character(1),
  ispreserveimage character(1)
);'),
(160, 'ingredient', 'ingredient_id', 2,'SELECT * FROM ingredient
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM ingredient'' ) AS DATA (
  ingredient_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  ingredients text,
  isdefault character(1)
);'),
(170, 'preservation_info', 'preservation_info_id', 2,'SELECT * FROM preservation_info
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM preservation_info'' ) AS DATA (
  preservation_info_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  info text,
  isdefault character(1),
  image_id character varying(32)
);'),
(180, 'bpartner', 'bpartner_id', 2,'SELECT * FROM bpartner
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner'' ) AS DATA (
  bpartner_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  name2 character varying(60),
  description character varying(255),
  issummary character(1),
  iscustomer character(1),
  isemployee character(1),
  issalesrep character(1),
  ispacker character(1),
  isdistributor character(1),
  isimporter character(1),
  isexporter character(1),
  isvendor character(1),
  iscutting_hall character(1),
  isslaughter_house character(1),
  issupplier character(1),
  referenceno character varying(40),
  duns character(11),
  taxid character varying(20),
  istaxexempt character(1),
  rating character(1),
  salesvolume numeric(10,0),
  naics character(6),
  firstsale timestamp without time zone,
  paymentrule character varying(60),
  creditlimit numeric(20,6),
  creditused numeric(20,6),
  paymentterm_id character varying(32),
  pricelist_id character varying(32),
  isdiscountprinted character(1),
  salesrep_id character varying(32),
  bpartner_parent_id character varying(32),
  upc character varying(30),
  fiscalcode character varying(16),
  isofiscalcode character varying(5),
  image_id character varying(32),
  print_field character varying(2000)
);'),
(190, 'bpartner_location', 'bpartner_location_id', 2,'SELECT * FROM bpartner_location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner_location'' ) AS DATA (
   bpartner_location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  isbillto character(1),
  isshipto character(1),
  ispayfrom character(1),
  isremitto character(1),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  bpartner_id character varying(32),
  istaxlocation character(1),
  upc character varying(30),
  address1 character varying(60),
  address2 character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  city_id character varying(32),
  region_id character varying(32),
  country_id character varying(32)
);'),
(195, 'role', 'role_id', 2,'SELECT * FROM role
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM role'' ) AS DATA (
  role_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  name character varying(60),
  updatedby character varying(32),
  description character varying(255),
  userlevel character varying(60),
  tree_menu_id character varying(32),
  ismanual character(1),
  processing character(1),
  is_client_admin character(1),
  isadvanced character(1)
);'),
(200, 'tb_user', 'user_id', 2,'SELECT * FROM tb_user
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tb_user'' ) AS DATA (
  user_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  password character varying(40),
  email character varying(255),
  supervisor_id character varying(32),
  bpartner_id character varying(32),
  processing character(1),
  emailb_user character varying(40),
  emailb_userpw character varying(40),
  bpartner_location_id character varying(32),
  title character varying(40),
  comments character varying(2000),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  lastcontact timestamp without time zone,
  lastresult character varying(255),
  birthday timestamp without time zone,
  firstname character varying(60),
  lastname character varying(60),
  username character varying(60),
  upc character varying(500),
  default_language character varying(6),
  default_role_id character varying(32),
  default_warehouse_id character varying(32),
  islocked character(1),
  image_id character varying(32)
);'),
(210, 'pricelist', 'pricelist_id', 2,'SELECT * FROM pricelist
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist'' ) AS DATA (
  pricelist_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  basepricelist_id character varying(32),
  istaxincluded character(1),
  issopricelist character(1),
  isdefault character(1),
  currency_id character varying(32),
  enforcepricelimit character(1),
  costbased character(1)
);'),
(220, 'pricelist_version', 'pricelist_version_id', 2,'SELECT * FROM pricelist_version
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist_version'' ) AS DATA (
  pricelist_version_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  pricelist_id character varying(32),
  validfrom timestamp without time zone,
  proccreate character(1),
  pricelist_version_base_id character varying(32),
  pricelist_version_generate character(1),
  validto timestamp without time zone,
  isdefault character(1)
);'),
(230, 'profile', 'profile_id', 2,'SELECT * FROM profile
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM profile'' ) AS DATA (
  profile_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(32)
);'),
(240, 'advertising', 'advertising_id', 2,'SELECT * FROM advertising
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM advertising'' ) AS DATA (
  advertising_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  advertising character varying(255),
  isproductmsgonly character(1),
  isdefault character(1),
  ismedia character(1),
  media_url character varying(2000),
  image_id character varying(32),
  profile_id character varying(32)
);'),
(250, 'product', 'product_id', 2,'SELECT * FROM product
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM product'' ) AS DATA (
    product_id bigint ,
    isactive character(1) ,
    created timestamp without time zone ,
    createdby character varying(32) ,
    updated timestamp without time zone ,
    updatedby character varying(32) ,
    erp_code character varying(25),
    name character varying(56) ,
    description character varying(255),
    department_id bigint ,
    group_id bigint ,
    label_format_w character varying(32),
    label_format_u character varying(32),
    barcode_item_code_flag character(1),
    barcode_item_code numeric(20,0) ,
    print_primary_barcode character(1) ,
    primary_barcode_type integer,
    primary_barcode_flag_data character varying(255),
    print_secondary_barcode character(1) ,
    secondary_barcode_type integer,
    secondary_barcode_flag_data character varying(255),
    sell_by_date_time integer ,
    sell_by_date_source integer ,
    sell_by_date numeric(2,0),
    sell_time_source integer,
    sell_time time without time zone,
    print_packed_date character(1),
    packed_date_source integer ,
    packed_date numeric(2,0),
    packed_date_format character varying(10),
    print_used_by_date character(1),
    used_by_date_source integer,
    used_by_date numeric(3,0) ,
    unit_price_selection integer,
    tare numeric(20,6),
    perc_tare numeric(20,6),
    quantity numeric(10,0),
    upc character varying(30),
    uom_id character varying(32),
    discount_schema_id character varying(32),
    isstocked character(1),
    isirradiated character(1),
    isbom character(1),
    stock_min numeric(20,6),
    stock_max numeric(20,6),
    versionno character varying(20),
    discontinued character(1),
    discontinuedby timestamp without time zone,
    tax_id character varying(32),
    attribute integer,
    advertising_id character varying(32),
    sto_temp_limit1 numeric(20,6),
    sto_temp_limit2 numeric(20,6),
    ingredients character varying(2000),
    ingredients_id character varying(32),
    preservation_info character varying(2000),
    preservation_info_id character varying(32),
    coupled_product bigint,
    pack_indicator numeric(1,0),
    extra_field1 character varying(2000),
    extra_field2 character varying(2000),
    image_id character varying(32),
    icon_id character varying(32),
    lot character varying(20),
    born_country character varying(32),
    fatten_country character varying(32),
    origin_country character varying(32),
    manufacturer_id character varying(32),
    packer_id character varying(32),
    distributor_id character varying(32),
    importer_id character varying(32),
    exporter_id character varying(32),
    vendor_id character varying(32),
    cutting_hall_id character varying(32),
    slaughter_house_id character varying(32),
    supplier_id character varying(32),
    nut_info_set_id character varying(32),
    print_fix_primary_barcode character(1),
    print_fix_secondary_barcode character(1)
);'),
(260, 'shortcut_page', 'shortcutpage_id', 2,'SELECT * FROM shortcut_page
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut_page'' ) AS DATA (
  shortcutpage_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  pos integer,
  rows integer,
  cols integer,
  isdefault character(1),
  profile_id character varying(32),
  icon_id character varying(32)
);
'),
(270, 'shortcut', 'shortcut_id', 2,'SELECT * FROM shortcut
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut'' ) AS DATA (
  shortcut_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  shortcut_page_id character varying(32),
  product_id bigint,
  name character varying(60),
  "row" integer,
  col integer,
  profile_id character varying(32)
);'),
(280, 'nut_info_el_instance', 'nut_info_el_instance_id', 2,'SELECT * FROM nut_info_el_instance
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_el_instance'' ) AS DATA (
nut_info_el_instance_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  product_id bigint,
  value character varying(255),
  hasjoinedrows character(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer
);'),
(290, 'productprice', 'productprice_id', 2,'SELECT * FROM productprice
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM productprice'' ) AS DATA (
  productprice_id character varying(32),
  pricelist_version_id character varying(32),
  product_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  pricelist numeric(20,6),
  pricestd numeric(20,6),
  pricelimit numeric(20,6),
  cost numeric(20,6)
);'),
(300, 'access', 'access_id', 2,'SELECT * FROM access
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM access'' ) AS DATA (
  access_id character varying(32),
  role_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  config character(1),
  config_gral character(1),
  config_profile character(1),
  config_format_print character(1),
  config_codebar character(1),
  config_calibration character(1),
  config_overweight character(1),
  config_backup character(1),
  product character(1),
  product_products character(1),
  product_fast_load character(1),
  product_shortcut character(1),
  product_department character(1),
  product_group character(1),
  product_ingridient character(1),
  product_conservation character(1),
  product_tax character(1),
  importer character(1),
  prices character(1),
  prices_list character(1),
  prices_quick_update character(1),
  advertising character(1),
  users character(1),
  locations character(1),
  locations_currency character(1),
  locations_countrie character(1),
  reports character(1),
  reports_vta_day character(1),
  reports_vta_seller character(1),
  reports_vta_plu character(1),
  reports_vta_close_sales character(1),
  reports_vta_cancel character(1),
  reports_vta_total character(1),
  images character(1),
  roles character(1),
  role_name character varying(60)
);'),


--(300, 'invoice', 'invoice_id', 2,''),
--(310, 'invoiceline', 'invoiceline_id', 2,''),

(10, 'invoice', 'invoice_id', 1,''),
(20, 'invoiceline', 'invoiceline_id', 1,''),

(10, 'nut_info_el_instance', 'nut_info_el_instance_id', 3, 'SELECT nut_info_el_instance_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT nut_info_el_instance_id FROM nut_info_el_instance'' ) AS DATA ( nut_info_el_instance_id character varying(32) ) EXCEPT SELECT nut_info_el_instance_id FROM nut_info_el_instance'),
(20, 'productprice', 'productprice_id', 3, 'SELECT productprice_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT productprice_id FROM productprice'' ) AS DATA ( productprice_id character varying(32) ) EXCEPT SELECT productprice_id FROM productprice'),
(30, 'shortcut', 'shortcut_id', 3, 'SELECT shortcut_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT shortcut_id FROM shortcut'' ) AS DATA ( shortcut_id character varying(32) ) EXCEPT SELECT shortcut_id FROM shortcut'),
(40, 'product', 'product_id', 3, 'SELECT product_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT product_id FROM product'' ) AS DATA ( product_id bigint ) EXCEPT SELECT product_id FROM product'),
(50, 'pricelist_version', 'pricelist_version_id', 3, 'SELECT pricelist_version_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT pricelist_version_id FROM pricelist_version'' ) AS DATA ( pricelist_version_id character varying(32) ) EXCEPT SELECT pricelist_version_id FROM pricelist_version'),
(60, 'advertising', 'advertising_id', 3, 'SELECT advertising_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT advertising_id FROM advertising'' ) AS DATA ( advertising_id character varying(32) ) EXCEPT SELECT advertising_id FROM advertising'),
(70, 'main_group', 'group_id', 3, 'SELECT group_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT group_id FROM main_group'' ) AS DATA ( group_id bigint ) EXCEPT SELECT group_id FROM main_group'),
(80, 'department', 'department_id', 3, 'SELECT department_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT department_id FROM department'' ) AS DATA ( department_id bigint ) EXCEPT SELECT department_id FROM department'),
(90, 'ingredient', 'ingredient_id', 3, 'SELECT ingredient_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT ingredient_id FROM ingredient'' ) AS DATA ( ingredient_id character varying(32) ) EXCEPT SELECT ingredient_id FROM ingredient'),
(100, 'preservation_info', 'preservation_info_id', 3, 'SELECT preservation_info_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT preservation_info_id FROM preservation_info'' ) AS DATA ( preservation_info_id character varying(32) ) EXCEPT SELECT preservation_info_id FROM preservation_info'),
(110, 'labels', 'labels_id', 3, 'SELECT labels_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT labels_id FROM labels'' ) AS DATA ( labels_id character varying(32) ) EXCEPT SELECT labels_id FROM labels'),
(120, 'label_format', 'label_format_id', 3, 'SELECT label_format_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT label_format_id FROM label_format'' ) AS DATA ( label_format_id character varying(32) ) EXCEPT SELECT label_format_id FROM label_format'),
(121, 'tax', 'tax_id', 3, 'SELECT tax_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT tax_id FROM tax'' ) AS DATA ( tax_id character varying(32) ) EXCEPT SELECT tax_id FROM tax'),
(122, 'taxcategory', 'taxcategory_id', 3, 'SELECT taxcategory_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT taxcategory_id FROM taxcategory'' ) AS DATA ( taxcategory_id character varying(32) ) EXCEPT SELECT taxcategory_id FROM taxcategory'),
(123, 'discount_schema_line', 'discount_schema_line_id', 3, 'SELECT discount_schema_line_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT discount_schema_line_id FROM discount_schema_line'' ) AS DATA ( discount_schema_line_id character varying(32) ) EXCEPT SELECT discount_schema_line_id FROM discount_schema_line'),
(124, 'discount_schema', 'discount_id', 3, 'SELECT discount_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT discount_id FROM discount_schema'' ) AS DATA ( discount_id character varying(32) ) EXCEPT SELECT discount_id FROM discount_schema'),
(130, 'nut_info_element', 'nut_info_element_id', 3, 'SELECT nut_info_element_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT nut_info_element_id FROM nut_info_element'' ) AS DATA ( nut_info_element_id character varying(32) ) EXCEPT SELECT nut_info_element_id FROM nut_info_element'),
(140, 'nut_info_set', 'nut_info_set_id', 3, 'SELECT nut_info_set_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT nut_info_set_id FROM nut_info_set'' ) AS DATA ( nut_info_set_id character varying(32) ) EXCEPT SELECT nut_info_set_id FROM nut_info_set'),
(150, 'locator', 'locator_id', 3, 'SELECT locator_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT locator_id FROM locator'' ) AS DATA ( locator_id character varying(32) ) EXCEPT SELECT locator_id FROM locator'),
(160, 'warehouse', 'warehouse_id', 3, 'SELECT warehouse_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT warehouse_id FROM warehouse'' ) AS DATA ( warehouse_id character varying(32) ) EXCEPT SELECT warehouse_id FROM warehouse'),
(170, 'shortcut_page', 'shortcutpage_id', 3, 'SELECT shortcutpage_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT shortcutpage_id FROM shortcut_page'' ) AS DATA ( shortcutpage_id character varying(32) ) EXCEPT SELECT shortcutpage_id FROM shortcut_page'),
(180, 'profile', 'profile_id', 3, 'SELECT profile_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT profile_id FROM profile'' ) AS DATA ( profile_id character varying(32) ) EXCEPT SELECT profile_id FROM profile'),
(190, 'location', 'location_id', 3, 'SELECT location_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT location_id FROM location'' ) AS DATA ( location_id character varying(32) ) EXCEPT SELECT location_id FROM location'),
(195, 'role', 'role_id', 3,'SELECT role_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT role_id FROM role'' ) AS DATA ( role_id character varying(32)) EXCEPT SELECT role_id FROM role'),
(200, 'tb_user', 'user_id', 3, 'SELECT user_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT user_id FROM tb_user'' ) AS DATA ( user_id character varying(32) ) EXCEPT SELECT user_id FROM tb_user'),
(210, 'bpartner_location', 'bpartner_location_id', 3, 'SELECT bpartner_location_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT bpartner_location_id FROM bpartner_location'' ) AS DATA ( bpartner_location_id character varying(32) ) EXCEPT SELECT bpartner_location_id FROM bpartner_location'),
(220, 'city', 'city_id', 3, 'SELECT city_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT city_id FROM city'' ) AS DATA ( city_id character varying(32) ) EXCEPT SELECT city_id FROM city'),
(230, 'region', 'region_id', 3, 'SELECT region_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT region_id FROM region'' ) AS DATA ( region_id character varying(32) ) EXCEPT SELECT region_id FROM region'),
(240, 'country', 'country_id', 3, 'SELECT country_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT country_id FROM country'' ) AS DATA ( country_id character varying(32) ) EXCEPT SELECT country_id FROM country'),
(250, 'currency', 'currency_id', 3, 'SELECT currency_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT currency_id FROM currency'' ) AS DATA ( currency_id character varying(32) ) EXCEPT SELECT currency_id FROM currency'),
(260, 'bpartner', 'bpartner_id', 3, 'SELECT bpartner_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT bpartner_id FROM bpartner'' ) AS DATA ( bpartner_id character varying(32) ) EXCEPT SELECT bpartner_id FROM bpartner'),
(270, 'pricelist', 'pricelist_id', 3, 'SELECT pricelist_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT pricelist_id FROM pricelist'' ) AS DATA ( pricelist_id character varying(32) ) EXCEPT SELECT pricelist_id FROM pricelist'),
(280, 'image', 'image_id', 3, 'SELECT image_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT image_id FROM image'' ) AS DATA ( image_id character varying(32) ) EXCEPT SELECT image_id FROM image'),
(290, 'barcode_format', 'barcodetype, producttype', 3, 'SELECT barcodetype, producttype FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT barcodetype, producttype FROM barcode_format'' ) AS DATA ( barcodetype character varying(32), producttype character(1))  EXCEPT SELECT barcodetype, producttype FROM barcode_format'),
(300,  'access', 'access_id', 3,'SELECT access_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT access_id FROM access'' ) AS DATA ( access_id character varying(32)) EXCEPT SELECT access_id FROM access');


-- dblink
CREATE EXTENSION dblink;
-- Scheduler

INSERT INTO #syncSchedulerTable#
(id, type, "interval", enabled, time_unit)
VALUES
(1, 0, 5, 0, 4),
(2, 1, 0, 0, 0),
(3, 1, 0, 0, 0),
(4, 1, 0, 0, 0),
(5, 1, 0, 0, 0);