CREATE OR REPLACE FUNCTION getcommaseparatedcolumns(PAR_table text) RETURNS text AS $$
DECLARE
 REC_columns record;
 VAR_query text;
BEGIN
 VAR_query := '';
 FOR REC_columns IN SELECT column_name FROM information_schema.columns WHERE table_schema = 'public' AND table_name = PAR_table LOOP
     IF VAR_query <> '' THEN
         VAR_query := VAR_query || '::TEXT,';
     END IF;

     VAR_query := VAR_query || REC_columns.column_name;
 END LOOP;

 RETURN VAR_query;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION selecttablehash(PAR_table text) RETURNS TABLE (
 hash text
) AS $$
BEGIN
 RETURN QUERY EXECUTE 'select md5(string_agg(md5,'''')) from (select md5(b.*::TEXT) from '||PAR_table||' as b order by 1) as md5';
END;
$$ LANGUAGE plpgsql;
