
do $$
begin

-- VIEW FOR VICL
CREATE OR REPLACE VIEW public.data_for_vicl
 AS
 SELECT product.primary_barcode_flag_data AS barcode,
    product.name AS nombre,
    productprice.pricelist AS precios
   FROM product,
    productprice
     JOIN pricelist_version ON productprice.pricelist_version_id::text = pricelist_version.pricelist_version_id::text
  WHERE productprice.product_id = product.product_id AND pricelist_version.isdefault = 'Y'::bpchar AND product.product_id <> 0 AND product.primary_barcode_flag_data::text <> '0'::text AND product.primary_barcode_flag_data::text <> ''::text;

ALTER TABLE public.data_for_vicl
    OWNER TO postgres;

GRANT ALL ON TABLE public.data_for_vicl TO PUBLIC;
GRANT ALL ON TABLE public.data_for_vicl TO postgres;
GRANT ALL ON TABLE public.data_for_vicl TO admin;
GRANT ALL ON TABLE public.data_for_vicl TO read;

--setup 
IF NOT EXISTS (select 1 from public.setup where id = 'delaytoprint') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Delay entre imp',0,'',2.5,'delaytoprint','Delay en segundos entre impresiones');
END IF;
IF NOT EXISTS (select 1 from public.setup where id = 'ntpserver') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Servidor NTP',0,'pool.ntp.org',0,'ntpserver','Servidor NTP para busqueda de horario');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'sepmiles') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Separador de miles',0,'.',0,'sepmiles','Separador de miles');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'sepdecimales') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Separador de decimales',0,',',0,'sepdecimales','Separador de decimales');
END IF;
-- systel_setup
IF NOT EXISTS (select 1 from systel.setup_systel where id = 'timezone') THEN
    INSERT INTO systel.setup_systel (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Time Zone',0,'America/Buenos_Aires',0,'timezone','Uso Horario');
END IF;

IF NOT EXISTS (select 1 from systel.setup_systel where id = 'roundingmode') THEN
    INSERT INTO systel.setup_systel (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Rounding Mode',0,' ',0,'roundingmode','Selección de modo de redondeo');
END IF;
-- invoiceline
IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='invoiceline' and column_name='lot')  THEN
	ALTER TABLE public.invoiceline ADD COLUMN lot character varying(20);
        COMMENT ON COLUMN public.invoiceline.lot IS 'Lote';
END IF;

IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='invoiceline' and column_name='expiration_date')  THEN
	ALTER TABLE public.invoiceline ADD COLUMN expiration_date date;
        COMMENT ON COLUMN public.invoiceline.expiration_date IS 'Fecha de vencimiento';
END IF;

IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='invoiceline' and column_name='packing_date')  THEN
	ALTER TABLE public.invoiceline ADD COLUMN packing_date date;
        COMMENT ON COLUMN public.invoiceline.packing_date IS 'Fecha de empaque';
END IF;
IF EXISTS (select 1 from public.setup where id = 'currency' and (value_string='Y' OR value_string='N')) THEN
    UPDATE public.setup SET value_int=6, value_string='2' WHERE id = 'currency';
END IF;

-- regional_config

IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='regional_config' and column_name='registra_equipo')  THEN
	ALTER TABLE systel.regional_config
	ADD COLUMN registra_equipo character(1) NOT NULL DEFAULT 'Y';
END IF;

IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='regional_config' and column_name='print_valido_factura')  THEN
	ALTER TABLE systel.regional_config
	ADD COLUMN print_valido_factura character(1) NOT NULL DEFAULT 'Y';
END IF;

IF EXISTS (select 1 from systel.regional_config where conf_regional_id = 'mexico') THEN
    UPDATE systel.regional_config SET print_valido_factura='N' WHERE conf_regional_id = 'mexico';
END IF;

IF EXISTS (select 1 from systel.regional_config where conf_regional_id = 'mexico') THEN
    UPDATE systel.regional_config SET minimo_pesable='N' WHERE conf_regional_id = 'mexico';
END IF;

IF  EXISTS (SELECT 1 FROM public.currency where currency_id= 'B9E7D20B50E24B208AD1EA8F6E757E2C') THEN
    IF  EXISTS (SELECT 1 FROM public.country where currency_id= 'B9E7D20B50E24B208AD1EA8F6E757E2C') THEN
        update public.country set currency_id = null;
    END IF;    
    DELETE FROM public.currency where currency_id= 'B9E7D20B50E24B208AD1EA8F6E757E2C';
END IF;

IF NOT EXISTS (SELECT 1 FROM public.currency where currency_id= '32') THEN
    INSERT INTO public.currency(currency_id, isactive, created, createdby, updated, updatedby, iso_code, cursymbol, description, stdprecision, costingprecision, priceprecision, issymbolrightside)
	VALUES ('32', 'Y', '2014-10-09 11:42:32.603', 'systel', '2015-12-27 03:05:27.37', 'systel', 'USD', '$', 'Moeda de Estados Unidos', 2, 2, 2, 'N');
END IF;


IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='uom' and column_name='thirdprecision')  THEN
    ALTER TABLE public.uom    
        ADD COLUMN thirdprecision numeric(20, 15);
    
    ALTER TABLE public.uom
        ALTER COLUMN stdprecision TYPE numeric(20, 15);

    ALTER TABLE public.uom
        ALTER COLUMN costingprecision TYPE numeric(20, 15);

END IF;

IF NOT EXISTS (SELECT 1 FROM public.uom where uom_id= '4') THEN
    INSERT INTO public.uom(uom_id, isactive, created, createdby, updated, updatedby, x12de355, uomsymbol, name, description, stdprecision, costingprecision, isdefault, thirdprecision)
	VALUES ('4', 'Y', '2014-07-03 12:27:24.318', 'systel', '2014-07-03 12:27:24.318', 'systel', 'oz', 'oz ', 'oz', 'oz', 0.0283495, 0.0625, 'N', 1);
END IF;

IF EXISTS (SELECT 1 FROM public.uom where uom_id= '3') THEN
    update public.uom SET stdprecision=0.453592 , costingprecision=1 , thirdprecision=16 where uom_id= '3' ;
END IF;

IF EXISTS (SELECT 1 FROM public.uom where uom_id= '2') THEN
    update public.uom SET stdprecision=1 , costingprecision=1 , thirdprecision=1 where uom_id= '2' ;
END IF;

IF EXISTS (SELECT 1 FROM public.uom where uom_id= '1') THEN
    update public.uom SET stdprecision=1 , costingprecision=2.20462 , thirdprecision=35.2739199982575 where uom_id= '1' ;
END IF;


IF NOT EXISTS (SELECT 1 FROM systel.regional_config where conf_regional_id = 'unitedstate') THEN
    INSERT INTO systel.regional_config(	conf_regional_id, cero_negativo, tara_manual, congelados, escurridos, minimo_pesable, currency_id, idioma, ini_zero_tol, sobrepeso_permitido_e, minimo_pesable_valor, despeja_bandeja, muestra_peso_secundario, registra_equipo, print_valido_factura)
	VALUES ('unitedstate', 'Y', 'N', 'Y', 'Y', 'Y', '32', 'en-US', 	1, 9, 20, 'N', 'N', 'Y', 'Y');
END IF;

IF NOT EXISTS (SELECT 1 FROM systel.regional_config where conf_regional_id = 'puertorico') THEN
    INSERT INTO systel.regional_config(	conf_regional_id, cero_negativo, tara_manual, congelados, escurridos, minimo_pesable, currency_id, idioma, ini_zero_tol, sobrepeso_permitido_e, minimo_pesable_valor, despeja_bandeja, muestra_peso_secundario, registra_equipo, print_valido_factura)
	VALUES ('puertorico', 'Y', 'N', 'Y', 'Y', 'Y', '32', 'en-US', 	1, 9, 20, 'N', 'N', 'Y', 'Y');
END IF;
IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='regional_config' and column_name='separador_decimal')  THEN
    ALTER TABLE systel.regional_config
    ADD COLUMN separador_decimal character(1) NOT NULL DEFAULT ','::bpchar;
    ALTER TABLE systel.regional_config
    ADD COLUMN uom_primaria character(1) NOT NULL DEFAULT '1'::bpchar;
    ALTER TABLE systel.regional_config
    ADD COLUMN uom_secundaria character(1) NOT NULL DEFAULT '3'::bpchar;

    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'mexico';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'arabia saudita';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'argelia';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'bahrein';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'bolivia';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'ecuador';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'egipto';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'emiratos';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'guatemala';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'honduras';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'iran';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'iraq';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'jordania';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'kuwait';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'lebanon';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'nicaragua';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'oman';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'panama';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'paraguay';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'peru';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'qatar';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'syria';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'unitedstate';
    UPDATE systel.regional_config SET separador_decimal='.' WHERE conf_regional_id = 'puertorico';


    UPDATE systel.regional_config SET uom_primaria='3' WHERE conf_regional_id = 'unitedstate';
    UPDATE systel.regional_config SET uom_secundaria='4' WHERE conf_regional_id = 'unitedstate';
    UPDATE systel.regional_config SET uom_primaria='3' WHERE conf_regional_id = 'puertorico';
    UPDATE systel.regional_config SET uom_secundaria='4' WHERE conf_regional_id = 'puertorico';
END IF;

IF EXISTS (SELECT 1 FROM systel.setup_systel where id = 'configregional' and value_string = 'brasil') THEN
    UPDATE public.product SET name='DIVERSOS' WHERE product_id = '0';

    --departamentos
    UPDATE public.department SET name='SEM DEPARTAMENTO' WHERE department_id=0;

    --departamentos grupos
    UPDATE public.main_group SET name='SEM AGRUPAR' WHERE group_id=0;
END IF;

IF EXISTS (SELECT 1 FROM public.product where product_id = 0 AND isactive = 'N' ) THEN
    UPDATE public.product SET isactive = 'Y' WHERE product_id = 0;
END IF;
--discount_schema_line
ALTER TABLE public.discount_schema_line ALTER COLUMN limit_minamt TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN limit_maxamt TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN limit_fixed TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN limit_margin TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN rate TYPE numeric(20, 6);



ALTER TABLE public.tax ALTER COLUMN rate TYPE numeric(20, 6);
ALTER TABLE public.tax ALTER COLUMN deducpercent TYPE numeric(20, 6);
ALTER TABLE public.tax ALTER COLUMN originalrate TYPE numeric(20, 6);

IF EXISTS (SELECT 1 FROM public.profile where name= 'VICL') THEN
    UPDATE public.profile SET name='PRICE POINT' WHERE name= 'VICL';
END IF;

CREATE OR REPLACE FUNCTION public.shortcut_update_name_or_active_changes()
  RETURNS trigger AS
$BODY$
BEGIN
	IF NEW.name <> OLD.name THEN
		 UPDATE shortcut set name=NEW.name WHERE product_id = NEW.product_id;
	END IF;
 
	RETURN NEW;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.shortcut_update_name_or_active_changes()
  OWNER TO postgres;
GRANT EXECUTE ON FUNCTION public.shortcut_update_name_or_active_changes() TO postgres;
GRANT EXECUTE ON FUNCTION public.shortcut_update_name_or_active_changes() TO systel;
GRANT EXECUTE ON FUNCTION public.shortcut_update_name_or_active_changes() TO public;

--tabla nutricional

--EEUU
IF NOT EXISTS (select 1 from public.nut_info_set where nut_info_set_id = '5') THEN
    INSERT INTO public.nut_info_set (nut_info_set_id,isactive,created,createdby,updated,updatedby,nut_info_name,description,columns_qty,rows_qty) VALUES
        ('5','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','Nutrition Facts HFS-800','ejemplo desc',2,16);
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'servings per container' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','servings per container','N',1,0,'Y',1,2,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Serving size' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Serving size','N',2,0,'Y',0,0,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = '(g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','(g)','N',2,0,'Y',1,2,1,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Amount per serving' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Amount per serving','N',3,0,'Y',0,2,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Calories' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Calories','N',4,0,'N',0,0,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = '%Daily Value*' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','%Daily Value*','N',5,0,'N',2,0,1,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Total Fat' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Total Fat','N',6,0,'N',0,0,0,78,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = '  Saturated Fat' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','  Saturated Fat','N',7,0,'N',0,0,0,20,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = '  Trans Fat' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','  Trans Fat','N',8,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Cholesterol' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Cholesterol','N',9,0,'N',0,0,0,300,'mg');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Sodium' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Sodium','N',10,0,'N',0,0,0,2300,'mg');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Total Carbohydrate' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Total Carbohydrate','N',11,0,'N',0,0,0,275,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = '  Dietary Fiber' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','  Dietary Fiber','N',12,0,'N',0,0,0,28,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = '  Total Sugars' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','  Total Sugars','N',13,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = '      Includes' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','      Includes','N',14,0,'N',0,0,0,50,'g Added Sugars');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '5' AND value = 'Protein' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','5','Protein','N',15,0,'N',0,0,0,50,'g');
END IF;



--mexico
IF NOT EXISTS (select 1 from public.nut_info_set where nut_info_set_id = '4') THEN
    INSERT INTO public.nut_info_set (nut_info_set_id,isactive,created,createdby,updated,updatedby,nut_info_name,description,columns_qty,rows_qty) VALUES
        ('4','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','NOM-051-SCFI-SSA1-2010','ejemplo desc',2,17);
END IF;


IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = '100 g' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','100 g','N',1,0,'N',1,0,2,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Por 100 g' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Por 100 g','N',1,0,'Y',0,0,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Contenido energético' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Contenido energético','N',3,0,'N',0,0,0,0,'kcal');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Contenido energético por envase' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Contenido energético por envase','N',4,0,'N',0,0,0,0,'kcal');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Proteinas' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Proteinas','N',5,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Grasas totales' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Grasas totales','N',6,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = '  Grasas saturadas' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','  Grasas saturadas','N',7,0,'N',0,0,0,0,'mg');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = '  Grasas Trans' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','  Grasas Trans','N',8,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Hidratos de carbono disponibles' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Hidratos de carbono disponibles','N',9,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = '  Azúcares' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','  Azúcares','N',10,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = '   Azúcares añadidos' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','   Azúcares añadidos','N',11,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Fibra dietética' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Fibra dietética','N',12,0,'N',0,0,0,0,'g');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Sódio' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Sódio','N',13,0,'N',0,0,0,0,'mg');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Informacion adicional**' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Informacion adicional**','N',14,0,'N',0,0,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Informacion adicional**' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Informacion adicional**','N',14,0,'N',0,0,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Edulcorante' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Edulcorante','N',15,0,'N',0,0,0,0,'');
END IF;
IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '4' AND value = 'Cafeina' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','4','Cafeina','N',16,0,'N',0,0,0,0,'');
END IF;

-- Argentina
IF NOT EXISTS (select 1 from public.nut_info_set where nut_info_set_id = '3') THEN
    INSERT INTO public.nut_info_set (nut_info_set_id,isactive,created,createdby,updated,updatedby,nut_info_name,description,columns_qty,rows_qty) VALUES
             ('3','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','Ley N° 27.642','ejemplo desc',3,14);

    INSERT INTO public.nut_info_element (nut_info_element_id,isactive,created,createdby,updated,updatedby,nut_info_set_id,value,hasjoinedrows,pos_row,pos_rowto,hasjoinedcolumns,pos_column,pos_columnto,alignment,vd,uom) VALUES
             ('6B4EE76BE2C640FE8235E867C0E257','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','%VD(*)','N',2,0,'N',2,0,0,0,NULL),
             ('E7D67F2583814528AB00697DC32557','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Sodio','N',12,0,'N',0,0,0,2400,'mg'),
             ('9322978CBCF64F4284003EE9675949','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Fibra alimentaria','N',11,0,'N',0,0,0,25,'g'),
             ('45BB32BC2FDA44E49EF7C77DFB6542','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','(**)','N',10,0,'N',2,0,0,0,NULL),
             ('493AB35836804235BC117F848055C7','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Grasas trans','N',10,0,'N',0,0,0,0,'g'),
             ('11E220FF5EAC43829CD4F5CD9DF21','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Grasas saturadas','N',9,0,'N',0,0,0,22,'g'),
             ('095DB8A398C04BDB82D2F3D3A53A5B','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Grasas totales','N',8,0,'N',0,0,0,55,'g'),
             ('A1F6A85915A24780A255986DD16017','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Proteinas','N',7,0,'N',0,0,0,75,'g'),
             ('9FB708145EB14E22AB0D4C2B8131B9','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Carbohidratos, de los cuales:','N',4,0,'N',0,0,0,300,'g'),
             ('388A20B9FCB54933812B257984432F','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Valor Energetico','N',3,0,'N',0,0,0,2000,'kcal');
    INSERT INTO public.nut_info_element (nut_info_element_id,isactive,created,createdby,updated,updatedby,nut_info_set_id,value,hasjoinedrows,pos_row,pos_rowto,hasjoinedcolumns,pos_column,pos_columnto,alignment,vd,uom) VALUES
             ('435BEF2671DE47208477845FA398B86R','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Cantidad por porción','N',2,0,'Y',1,1,0,0,NULL),
             ('E7D67F2583814528AB00697DC32551','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Porción','N',1,0,'Y',0,2,2,0,'Porción'),
             ('E7D67F2583814528AB00697DC3255','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3',' Azucares totales','N',5,0,'N',0,0,0,0,'g'),
             ('h7D67F2583814528AB00697DC325527','Y','2022-12-21 01:41:02.475','systel','2022-12-21 01:41:02.475','systel','3','(**)','N',5,0,'N',2,0,0,0,NULL),
             ('h7D67F2583814528AB00697DC325573','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3',' Azucares añadidos','N',6,0,'N',0,0,0,0,'g'),
             ('11E220FF5EAC43829CD4F5CD9DF2','Y','2022-12-21 01:47:10.511','systel','2022-12-21 01:47:10.511','systel','3','(**)','N',6,0,'N',2,0,0,0,NULL),
             ('9FB708145EB14E22AB0D4C2B8161B95','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Edulcorante','N',13,0,'N',0,0,0,0,NULL),
             ('9FB708148EB14E22AB0D4C2B8131B9','Y','2014-03-17 10:50:00.000','systel','2014-03-17 10:50:00.000','systel','3','Cafeina','N',14,0,'N',0,0,0,0,NULL);

END IF;

------------
--Brasil
IF NOT EXISTS (select 1 from public.nut_info_set where nut_info_set_id = '2') THEN
    INSERT INTO public.nut_info_set (nut_info_set_id, isactive, created, createdby, updated, updatedby, nut_info_name, description, columns_qty, rows_qty) VALUES
        ('2','Y','2022-04-26 08:25:51.024149','systel','2022-04-26 08:25:51.024149','systel','RDC Nº 429 ANVISA','exemplo',3,13);
ELSE
    UPDATE public.nut_info_set SET nut_info_name = 'RDC Nº 429 ANVISA' WHERE nut_info_set_id = '2';
END IF;


IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Porções por embalagem:' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Porções por embalagem:','N',1,0,'Y',0,3,0,0,'Porções');
END IF;


IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '000 g' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','000 g','N',3,0,'N',1,0,2,0,'');
END IF;


IF EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '%VD') THEN
    DELETE FROM public.nut_info_element WHERE value = '%VD';
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '%VD*' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','%VD*','N',3,0,'N',2,0,2,0,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Carboidratos totais (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Carboidratos totais (g)','N',5,0,'N',0,0,0,300,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Sódio (mg)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Sódio (mg)','N',13,0,'N',0,0,0,2000,'');
END IF;

IF EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Sódio (mg)' AND vd!= 2000 ) THEN
    UPDATE public.nut_info_element SET vd=2000 WHERE value = 'Sódio (mg)' ;
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Porção:' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Porção:','N',2,0,'Y',0,1,0,0,'g');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '(Medida caseira)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','(Medida caseira)','N',2,0,'Y',2,3,0,0,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Valor energético (kcal)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Valor energético (kcal)','N',4,0,'N',0,0,0,2000,'kcal');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Proteinas (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Proteinas (g)','N',8,0,'N',0,0,0,50,'');
END IF;

IF EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Proteinas (g)'  AND vd!= 50 ) THEN
    UPDATE public.nut_info_element SET vd=50 WHERE value = 'Proteinas (g)';
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Fibra alimentar (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Fibra alimentar (g)','N',12,0,'N',0,0,0,25,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '  Gorduras saturadas (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','  Gorduras saturadas (g)','N',10,0,'N',0,0,0,20,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '  Gorduras trans (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','  Gorduras trans (g)','N',11,0,'N',0,0,0,2,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = 'Gorduras totais (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','Gorduras totais (g)','N',9,0,'N',0,0,0,65,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '   Açúcares adicionados (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','   Açúcares adicionados (g)','N',7,0,'N',0,0,0,50,'');
END IF;

IF NOT EXISTS (select 1 from public.nut_info_element where nut_info_set_id = '2' AND value = '  Açúcares totais (g)' ) THEN
    INSERT INTO public.nut_info_element (nut_info_element_id, isactive, created, createdby, updated, updatedby, nut_info_set_id, value, hasjoinedrows, pos_row, pos_rowto, hasjoinedcolumns, pos_column, pos_columnto, alignment, vd, uom) VALUES
        (get_uuid(),'Y','2014-03-17 10:50:00','systel','2014-03-17 10:50:00','systel','2','  Açúcares totais (g)','N',6,0,'N',0,0,0,0,'');
END IF;

--tabla nutricional
ALTER TABLE public.discount_schema
   ALTER COLUMN name TYPE character varying(120); 

IF NOT EXISTS (select 1 from public.setup where id = 'delaytoprint') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Delay entre imp',0,NULL,0,'delaytoprint','Delay en segundos entre impresiones');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'emaildestinatary') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('emailDestinatary',0,NULL,0,'emaildestinatary','Destinatarios de aviso de sincro desde FTP');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'emailhost') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('emailHost',0,NULL,0,'emailhost','Correo desde donde se envían los informes');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'emailpass') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('emailPass',0,NULL,0,'emailpass','Contraseña del correo de origen');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'emailport') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('emailPort',0,NULL,0,'emailport','');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'emailuser') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('emailUser',1,NULL,0,'emailuser','1=Enviar - 0=No enviar');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'filepath') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPFilePath',0,NULL,0,'filepath','Path del archivo a importar desde el servidor');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'filetype') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPFileType',0,NULL,0,'filetype','Tipo del archivo a importar desde el servidor. systel o MGV');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'mgvnutinfo') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPMGVnutinfo',0,NULL,0,'mgvnutinfo','Informacion nutricional formato MGV');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'mgvreceing') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPMGVreceing',0,NULL,0,'mgvreceing','Datos extras formato MGV');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'mgvtara') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPMGVtara',0,NULL,0,'mgvtara','Datos de tara formato MGV');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'ftphost') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPHost',0,NULL,0,'ftphost','1=SFTP - 0=FTP');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'ftpimport') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Importar desde FTP',0,NULL,0,'ftpimport','1=SI - 0=NO');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'ftppass') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPPass',0,NULL,0,'ftppass','Contraseña del servidor FTP');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'ftpport') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPPort',0,NULL,0,'ftpport','Puerto de conexión al servidor');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'ftpuser') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('FTPUser',0,NULL,0,'ftpuser','Usuario del servidor FTP');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'intervalhours') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('intervalo en horas',0,NULL,0,'intervalhours','Horas en las que se realizaran las sincros desde FTP');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'intervalminutes') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('intervalo en minutos',60,NULL,0,'intervalminutes','Tiempo en minutos entre cada sincro desde FTP');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'intervaltype') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Tipo de intervalo',0,NULL,0,'intervaltype','1=hora - 0=minuto');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'rewind') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Auto Rewind Paper', 2, NULL, 0, 'rewind', 'Si está activo el auto recolector 1 o no 2');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'compressmode') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Auto Compress Mode', 0, NULL, 0, 'compressmode', 'Si está activo el modo compresión de espacio en blanco 1 o no 0');
END IF;


IF NOT EXISTS (select 1 from public.setup where id = 'qrdatatype') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('QR Data Type', 0, NULL, 0, 'qrdatatype', 'Tipo de código de barras según BarcoeType');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'qrprint') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Imprime código QR', 0, NULL, 0, 'qrprint', '1=SI - 0=NO');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'rotateprint') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Rotar impresion', 0, NULL, 0, 'rotateprint', '1=SI - 0=NO');
END IF;
IF NOT EXISTS (select 1 from public.setup where id = 'descuento') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Permite Descuento', 0, NULL, 0, 'descuento', '1=Si - 0=NO');
END IF;

IF NOT EXISTS (select 1 from public.setup where id = 'datesyncrotype') THEN
    INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios) VALUES
        ('Modo syncronización fecha y hora', 1, '132.147.5.100,132.147.217.33', 0, 'datesyncrotype', '2=Local Server Sync 1=Internet Server Sync - 0=NO Sync');
END IF;

-- Add user Tecnico
IF NOT EXISTS (select 1 from public.role where role_id = '5') THEN
    INSERT INTO public.role (role_id, isactive, created, createdby, updated, updatedby, name, description, userlevel, is_client_admin, isadvanced) VALUES
        ('5', 'Y','2014-03-17 08:47:57.061332','systel','2014-03-17 08:47:57.061332','systel','Tecnico','Tecnico','  O','Y','Y');
END IF;

IF NOT EXISTS (select 1 from public.tb_user where user_id = 'Tecnico') THEN
    INSERT INTO public.tb_user (user_id, isactive, created, createdby, updated, updatedby, name, password,firstname,lastname,username,default_role_id,islocked,image_id) VALUES
        ('Tecnico', 'Y','2014-03-17 08:47:57.061332','systel','2014-03-17 08:47:57.061332','systel','Tecnico','81dc9bdb52d04dc20036dbd8313ed055','Tecnico','Tecnico','Tecnico','5','N','896E3DEACA8443908CF01C21D386918B');
END IF;

-- Table: systel.calibration
IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='calibration' and column_name='res_m')  THEN
    ALTER TABLE systel.calibration
      ADD COLUMN res_m numeric(10,3) NOT NULL DEFAULT 0.005;
    COMMENT ON COLUMN systel.calibration.res_m IS 'Valor de la media resolución del equipo';
END IF;



-- Table: public.taxcategory

IF NOT EXISTS (select 1 from public.taxcategory where taxcategory_id = '@') THEN
INSERT INTO public.taxcategory(taxcategory_id, isactive, created, createdby, updated, updatedby,name, description, isdefault)
    VALUES ('@','Y','2021-05-20 18:56:15.221621','systel','2021-05-20 18:56:15.221621','systel','IVA','IVA','Y');        
END IF;

-- Table: public.tax

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva4') THEN
   INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
            taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
            istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
    VALUES ('iva4','Y','2000-01-01 00:00:00.000','Supervisor','2000-01-01 18:57:00.819','Supervisor','4%','iva 4','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',4,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva6') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva6','Y','2000-01-01 00:00:00.000','Supervisor','2000-01-01 09:30:23.624','Supervisor','8%','iva 8','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',6,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva7') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva7','Y','2000-01-01 00:00:00.000','Supervisor','2000-01-01 09:30:23.624','Supervisor','7%','iva 7','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',7,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva10') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva10','Y','2000-01-01 00:00:00.000','Supervisor','2000-01-01 19:04:19.095','Supervisor','10%','iva 10','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',10,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva13') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva13','Y','2000-01-01 00:00:00.000','Supervisor','2000-01-01 19:04:19.095','Supervisor','13%','iva 13','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',13,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva16') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva16','Y','2000-01-01 18:57:08','Supervisor','2000-01-01 11:14:54','Supervisor','16%','iva 16','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',16,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva17') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva17','Y','2000-01-01 18:57:08','Supervisor','2000-01-01 11:14:54','Supervisor','17%','iva 17','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',17,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva19') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva19','Y','2000-01-01 18:57:08','Supervisor','2000-01-01 11:14:54','Supervisor','19%','iva 19','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',19,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva21') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva21','Y','2000-01-01 18:57:08','Supervisor','2000-01-01 11:14:54','Supervisor','21%','iva 21','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',21,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva22') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva22','Y','2000-01-01 18:57:08','Supervisor','2000-01-01 11:14:54','Supervisor','22%','iva 22','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',22,0,'N','N','Y','LNA',null,'D');
END IF;

IF NOT EXISTS (select 1 from public.tax where tax_id = 'iva23') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('iva23','Y','2000-01-01 00:00:00.000','Supervisor','2000-01-01 19:04:19.095','Supervisor','23%','iva 23','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',23,0,'N','N','Y','LNA',null,'D');
END IF;


IF NOT EXISTS (select 1 from public.tax where tax_id = '@') THEN
	INSERT INTO public.tax(tax_id, isactive, created, createdby, updated, updatedby, name, description, taxindicator, validfrom, issummary, rate, parent_tax_id, 
				taxcategory_id, isdefault, istaxexempt, sopotype, cascade, bp_taxcategory_id,line, iswithholdingtax, isnotaxable, deducpercent, originalrate, 
				istaxundeductable, istaxdeductable, isnovat, baseamount, taxbase_id, doctaxamount)
		VALUES ('@','Y','2000-01-01 00:00:00.000','Supervisor','2000-01-01 19:04:19.095','Supervisor','0%','iva 0','','2000-01-01 00:00:00.000','N',0,null,'@','N','N','B','N','',0,'','',0,0,'Y','N','N','LNA',null,'D');
END IF;

-- Table: systel.hashes

-- DROP TABLE systel.hashes;

CREATE TABLE IF NOT EXISTS systel.hashes
(
  table_name character varying(60) NOT NULL, -- Nombre de la tabla a la cual se le aplica el hash.
  updated timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora de la última actualización de registro.
  hash character varying(255), -- Resultado del algoritmo matemático aplicado (Hash).
  CONSTRAINT hashes_pkey PRIMARY KEY (table_name)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE systel.hashes
  OWNER TO systel;
GRANT ALL ON TABLE systel.hashes TO systel;
GRANT ALL ON TABLE systel.hashes TO admin;
GRANT SELECT, REFERENCES, TRIGGER ON TABLE systel.hashes TO read;
COMMENT ON COLUMN systel.hashes.table_name IS 'Nombre de la tabla a la cual se le aplica el hash.';
COMMENT ON COLUMN systel.hashes.updated IS 'Fecha y hora de la última actualización de registro.';
COMMENT ON COLUMN systel.hashes.hash IS 'Resultado del algoritmo matemático aplicado (Hash).';

IF NOT EXISTS (select 1 from systel.hashes where table_name='calibration') THEN
    INSERT INTO systel.hashes(table_name, updated, hash) VALUES ('calibration','2019-06-19 09:35:37.053244',null);
    INSERT INTO systel.hashes(table_name, updated, hash) VALUES ('currency','2019-06-19 09:35:37.053244',null);
    INSERT INTO systel.hashes(table_name, updated, hash) VALUES ('label_format','2019-06-19 09:35:37.053244',null);
    INSERT INTO systel.hashes(table_name, updated, hash) VALUES ('regional_config','2019-06-19 09:35:37.053244',null);
    INSERT INTO systel.hashes(table_name, updated, hash) VALUES ('setup_systel','2019-06-19 09:35:37.053244',null);
    INSERT INTO systel.hashes(table_name, updated, hash) VALUES ('uom','2019-06-19 09:35:37.053244',null);
    --COPY (SELECT 1 from systel.hashes) TO '/home/root/dbres'; 
    COPY (SELECT 1 from systel.hashes) TO '/tmp/dbres'; 
END IF;


IF NOT EXISTS (select 1 from public.product where product_id = 0) THEN
    INSERT INTO public.product(
            product_id, isactive, created, createdby, updated, updatedby, 
            erp_code, name, description, department_id, group_id, label_format_w, 
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode, 
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode, 
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time, 
            sell_by_date_source, sell_by_date, sell_time_source, sell_time, 
            print_packed_date, packed_date_source, packed_date, packed_date_format, 
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection, 
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked, 
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued, 
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1, 
            sto_temp_limit2, ingredients, ingredients_id, preservation_info, 
            preservation_info_id, coupled_product, pack_indicator, extra_field1, 
            extra_field2, image_id, icon_id, lot, born_country, fatten_country, 
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id, 
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id, 
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
            VALUES (0,'Y','2014-03-17 10:50:00','systel','2015-04-07 16:36:15.456','systel','0','VARIOS','',0,0,null,null,'N',0,'Y',0,'0','Y',null,'0',0,0,0,0,null,'N',0,0,'dd-mm-YYYY','N',0,0,1,0.000000,0.000000,1,null,'0',null,'N','N','N',null,null,null,'N',null,'@',4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'N','N');
    
    INSERT INTO public.productprice(
	productprice_id, pricelist_version_id, product_id, isactive, created, createdby, updated, updatedby, pricelist, pricestd, pricelimit, cost)
	VALUES ('6B467C01831E4D2FBAACBBA9CDDF5ED2','lst1',0,'Y','2016-02-11 21:51:15.562','systel','2020-05-18 12:22:20.084','Supervisor',1.000000,1.000000,1.000000,1.000000);


    INSERT INTO public.productprice(
	productprice_id, pricelist_version_id, product_id, isactive, created, createdby, updated, updatedby, pricelist, pricestd, pricelimit, cost)
	VALUES ('6B467C01831E4D2FBAACBBA9CDDF5ED4','lst2',0,'Y','2016-02-11 21:51:15.562','systel','2016-02-11 21:51:15.562','systel',1.000000,1.000000,1.000000,1.000000);
END IF;

ALTER TABLE systel.closing_sales
   ALTER COLUMN totalinvoice TYPE numeric(10,0);

IF ((SELECT pg_typeof(creditlimit) from public.bpartner)::TEXT<>'numeric')  THEN
	ALTER TABLE public.bpartner
	ALTER COLUMN creditlimit TYPE numeric(20,6),
	ALTER COLUMN creditused TYPE numeric(20,6);

	ALTER TABLE public.product
	ALTER COLUMN tare TYPE numeric(20,6),
	ALTER COLUMN perc_tare TYPE numeric(20,6),
	ALTER COLUMN stock_min TYPE numeric(20,6),
	ALTER COLUMN stock_max TYPE numeric(20,6),
	ALTER COLUMN sto_temp_limit1 TYPE numeric(20,6),
	ALTER COLUMN sto_temp_limit2 TYPE numeric(20,6);

	ALTER TABLE public.productprice
	ALTER COLUMN pricelist TYPE numeric(20,6),
	ALTER COLUMN pricestd TYPE numeric(20,6),
	ALTER COLUMN pricelimit TYPE numeric(20,6),
	ALTER COLUMN cost TYPE numeric(20,6);
END IF;

ALTER TABLE public.product
   ALTER COLUMN barcode_item_code TYPE numeric(20,0);

IF ((SELECT pg_typeof(peso_patron) from systel.calibration ORDER BY 1 DESC LIMIT 1)::TEXT<>'numeric')  THEN
	ALTER TABLE systel.calibration
	ALTER COLUMN peso_patron TYPE numeric(10,3);
END IF;



CREATE TABLE IF NOT EXISTS public.access
(
    access_id character varying(32) COLLATE pg_catalog."default" NOT NULL,
    role_id character varying(32) COLLATE pg_catalog."default" NOT NULL,
    isactive character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'Y'::bpchar,
    created timestamp without time zone NOT NULL DEFAULT now(),
    createdby character varying(32) COLLATE pg_catalog."default" NOT NULL,
    updated timestamp without time zone NOT NULL DEFAULT now(),
    updatedby character varying(32) COLLATE pg_catalog."default" NOT NULL,
    config character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    config_gral character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    config_profile character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    config_format_print character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    config_codebar character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    config_calibration character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    config_overweight character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    config_backup character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_products character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_fast_load character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_shortcut character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_department character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_group character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_ingridient character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_conservation character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    product_tax character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    importer character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    prices character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    prices_list character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    prices_quick_update character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    advertising character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    users character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    locations character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    locations_currency character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    locations_countrie character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    reports character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    reports_vta_day character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    reports_vta_seller character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    reports_vta_plu character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    reports_vta_close_sales character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    reports_vta_cancel character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    reports_vta_total character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    images character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    roles character(1) COLLATE pg_catalog."default" NOT NULL DEFAULT 'N'::bpchar,
    role_name character varying(60) COLLATE pg_catalog."default",
    CONSTRAINT access_key PRIMARY KEY (access_id),
    CONSTRAINT access_role_fkey FOREIGN KEY (role_id)
        REFERENCES public.role (role_id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE CASCADE
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE IF EXISTS public.access
    OWNER to systel;

GRANT ALL ON TABLE public.access TO systel;

GRANT ALL ON TABLE public.access TO admin;

GRANT ALL ON TABLE public.access TO PUBLIC;

GRANT ALL ON TABLE public.access TO read;
-- Index: fki_access_role_id

-- DROP INDEX IF EXISTS public.fki_access_role_id;

 IF NOT EXISTS (
      SELECT 1
      FROM   pg_class c
      JOIN   pg_namespace n ON n.oid = c.relnamespace
      WHERE  c.relname = 'fki_access_role_id'
      -- AND    n.nspname = 'myschema'
   ) THEN
        CREATE INDEX fki_access_role_id ON public.access USING btree
        (role_id COLLATE pg_catalog."default" varchar_ops ASC NULLS LAST)
        TABLESPACE pg_default;

        INSERT INTO public.access(access_id, role_id, isactive, created, createdby, updated, updatedby, config, config_gral, config_profile, config_format_print, config_codebar, config_calibration, config_overweight, config_backup, product, product_products, product_fast_load, product_shortcut, product_department, product_group, product_ingridient, product_conservation, product_tax, importer, prices, prices_list, prices_quick_update, advertising, users, locations, locations_currency, locations_countrie, reports, reports_vta_day, reports_vta_seller, reports_vta_plu, reports_vta_close_sales, reports_vta_cancel, reports_vta_total, images, roles)
        VALUES ('EE8054149ADC4E7FAE5682FCAF369D66', '2', 'Y', '2022-10-31 06:02:02', 'Supervisor', '2022-10-31 06:02:02', 'Supervisor', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N');

        INSERT INTO public.access(access_id, role_id, isactive, created, createdby, updated, updatedby, config, config_gral, config_profile, config_format_print, config_codebar, config_calibration, config_overweight, config_backup, product, product_products, product_fast_load, product_shortcut, product_department, product_group, product_ingridient, product_conservation, product_tax, importer, prices, prices_list, prices_quick_update, advertising, users, locations, locations_currency, locations_countrie, reports, reports_vta_day, reports_vta_seller, reports_vta_plu, reports_vta_close_sales, reports_vta_cancel, reports_vta_total, images, roles)
        VALUES ('81dc9bdb52d04dc20036dbd8313ed055', '1', 'Y', '2022-10-26 09:08:59.734228', 'Supervisor', '2022-10-26 09:08:59.734228', 'Supervisor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
 
END IF;

-- Table: public.access
IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='access' and column_name='role_name')  THEN
    ALTER TABLE public.access
    ADD COLUMN role_name character varying(60);

    ALTER TABLE public.access
    ADD CONSTRAINT role_name_fkey FOREIGN KEY (role_name) REFERENCES role (name) ON UPDATE CASCADE ON DELETE CASCADE;
END IF;
ALTER TABLE public.tb_user
    ALTER COLUMN upc TYPE character varying(500);
IF EXISTS (SELECT 1 FROM tb_user WHERE default_role_id = '1' and upc not like '%Admin%')  THEN
    update public.tb_user set upc='Admin' where default_role_id = '1' and upc not like '%Admin%';
END IF;

IF EXISTS (SELECT 1 FROM public.access WHERE role_name IS null)  THEN
        
    UPDATE public.access SET role_name = public.role.name
            FROM public.role
            WHERE public.access.role_id = public.role.role_id
            AND public.access.role_name IS NULL;
END IF;


IF NOT EXISTS (select 1 from pg_trigger where not tgisinternal and tgrelid = 'public.product'::regclass and tgname='delete_invoiceline') THEN
    CREATE OR REPLACE FUNCTION public.delete_invoiceline()
      RETURNS trigger AS
    $BODY$
    begin
	UPDATE public.invoiceline SET product_id = 0 where product_id = OLD.product_id;
        RETURN OLD;
    end
    $BODY$
      LANGUAGE plpgsql VOLATILE
      COST 100;
    ALTER FUNCTION public.delete_invoiceline()
      OWNER TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_invoiceline() TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_invoiceline() TO public;



    CREATE TRIGGER delete_invoiceline
      BEFORE DELETE
      ON public.product
      FOR EACH ROW
      EXECUTE PROCEDURE public.delete_invoiceline();
END IF;


IF NOT EXISTS (select 1 from pg_trigger where not tgisinternal and tgrelid = 'public.tb_user'::regclass and tgname='delete_login') THEN
    CREATE OR REPLACE FUNCTION public.delete_login()
      RETURNS trigger AS
    $BODY$
    begin
        DELETE FROM public.tb_user_login where user_id = OLD.user_id;
        RETURN OLD;
    end
    $BODY$
      LANGUAGE plpgsql VOLATILE
      COST 100;
    ALTER FUNCTION public.delete_login()
      OWNER TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_login() TO systel;
    GRANT EXECUTE ON FUNCTION public.delete_login() TO public;



    CREATE TRIGGER delete_login
      BEFORE DELETE
      ON public.tb_user
      FOR EACH ROW
      EXECUTE PROCEDURE public.delete_login();
END IF;


CREATE EXTENSION IF NOT EXISTS  dblink  WITH SCHEMA systel;
CREATE EXTENSION IF NOT EXISTS  pgcrypto  WITH SCHEMA systel;

CREATE OR REPLACE FUNCTION public.merge_product(
	the_product_id bigint,
	the_erp_code character varying,
	the_name character varying,
	the_attribute integer,
	the_department_id bigint,
	the_description character varying,
	the_print_used_by_date character,
	the_used_by_date numeric,
	the_uom_id character varying,
	the_tare double precision,
	the_extra_field1 character varying,
	the_extra_field2 character varying,
	the_primary_barcode_flag character varying,
	the_primary_barcode_flag_data character varying,
	the_ingredients character varying,
	the_preservation_info character varying,
	the_is_active character)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
the_is_active,
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
the_primary_barcode_flag,
0,
the_primary_barcode_flag_data,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
the_ingredients,
NULL,
the_preservation_info,
NULL,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    isactive = the_is_active,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = LOCALTIMESTAMP, 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare,
    extra_field1 = the_extra_field1,
    extra_field2 = the_extra_field2,
    nut_info_set_id='1',
    print_primary_barcode = the_primary_barcode_flag,
    primary_barcode_flag_data = the_primary_barcode_flag_data,
    ingredients = the_ingredients,
    preservation_info = the_preservation_info   
    WHERE product_id = the_product_id;
  END;
END;
$BODY$;

ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character varying, character varying, character)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character varying, character varying, character) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character varying, character varying, character) TO systel;

CREATE OR REPLACE FUNCTION public.merge_product(
	the_product_id bigint,
	the_nut_info_set_id character varying)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
BEGIN  
    UPDATE product SET nut_info_set_id = the_nut_info_set_id, 
                       updatedby = 'importacion RDC429'
    WHERE product_id = the_product_id;
END;
$BODY$;

ALTER FUNCTION public.merge_product(bigint, character varying)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying) TO systel;


CREATE OR REPLACE FUNCTION public.merge_product(
    the_product_id bigint,
    the_erp_code character varying,
    the_name character varying,
    the_attribute integer,
    the_department_id bigint,
    the_description character varying,
    the_print_used_by_date character,
    the_used_by_date numeric,
    the_uom_id character varying,
    the_tare double precision,
    the_extra_field1 character varying,
    the_extra_field2 character varying,
    the_ingredients character varying)
  RETURNS void AS
$BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
'Y',
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
'Y',
0,
0,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
the_ingredients,
NULL,
NULL,
NULL,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = LOCALTIMESTAMP, 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare,
    extra_field1 = the_extra_field1,
    extra_field2 = the_extra_field2,
    nut_info_set_id='1',
    ingredients = the_ingredients
    WHERE product_id = the_product_id;
  END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying) TO public;

--------------------------
-- FUNCTION: public.merge_product_coto(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying)

-- DROP FUNCTION IF EXISTS public.merge_product_coto(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying);

CREATE OR REPLACE FUNCTION public.merge_product_coto(
	the_product_id bigint,
	the_erp_code character varying,
	the_name character varying,
	the_attribute integer,
	the_department_id bigint,
	the_description character varying,
	the_print_used_by_date character,
	the_used_by_date numeric,
	the_uom_id character varying,
	the_tare double precision,
	the_extra_field1 character varying,
	the_extra_field2 character varying,
	the_label_id_u character varying,
	the_label_id_w character varying)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
'Y',
now(),
'importacion',
now(),
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
the_label_ID_w,
the_label_ID_u,
'N',
0,
'Y',
0,
0,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
NULL,
the_attribute,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = now(), 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare,
    extra_field1 = the_extra_field1,
    extra_field2 = the_extra_field2,
    nut_info_set_id='1',
    label_format_w = the_label_ID_w,
    label_format_u = the_label_ID_u
    WHERE product_id = the_product_id;
  END;
END;
$BODY$;

ALTER FUNCTION public.merge_product_coto(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying)
    OWNER TO systel;
------------------

------------------------------------------------------------

-- FUNCTION: public.merge_label_format(character varying, character varying, character varying, integer)

-- DROP FUNCTION IF EXISTS public.merge_label_format(character varying, character varying, character varying, integer);

CREATE OR REPLACE FUNCTION public.merge_label_format(
	the_id character varying,
	the_name character varying,
	the_template character varying,
	the_type integer)
    RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$

BEGIN
	BEGIN
      INSERT INTO label_format (
          label_format_id,  
          "name", 
          "template", 
          "type", 
          createdby, 
          updatedby)
        VALUES ( 
            the_ID,
            the_name, 
            the_template,
            the_type , 
            'importacion', 
            'importacion');
    EXCEPTION WHEN unique_violation THEN
        UPDATE label_format SET 
            "name" = the_name, 
            "template" = the_template, 
            "type" = the_type 
        WHERE label_format_id = the_ID;
    END;             
	
END;
$BODY$;

ALTER FUNCTION public.merge_label_format(character varying, character varying, character varying, integer)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_label_format(character varying, character varying, character varying, integer) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_label_format(character varying, character varying, character varying, integer) TO systel;

----------------------------------------------------------------


-- FUNCTION: public.merge_images(character varying, character, character varying, character varying, character varying, character varying, character varying, numeric, numeric, character, character, character, character, character varying, character, character, character)

-- DROP FUNCTION IF EXISTS public.merge_images(character varying, character, character varying, character varying, character varying, character varying, character varying, numeric, numeric, character, character, character, character, character varying, character, character, character);

CREATE OR REPLACE FUNCTION public.merge_images(
	the_image_id character varying,
	the_isactive character,
	the_createdby character varying,
	the_updatedby character varying,
	the_name character varying,
	the_imageurl character varying,
	the_binarydata character varying,
	the_width numeric,
	the_height numeric,
	the_isproducticon character,
	the_isproductimage character,
	the_issupplierimage character,
	the_isrsiimage character,
	the_mimetype character varying,
	the_isadvertisingimage character,
	the_iscompanyimage character,
	the_ispreserveimage character)
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
DECLARE
    the_binarydata_decode BYTEA := decode(the_binarydata, 'base64');
BEGIN

    -- Verificar si la imagen ya existe en la tabla
    IF EXISTS (SELECT 1 FROM public.image WHERE image_id = the_image_id) THEN
        -- Actualizar la imagen existente
        UPDATE public.image
        SET
            isactive = the_isactive,
           -- updated = now(),
            updatedby = the_updatedby,
            name = the_name,
            imageurl = the_imageurl,
            binarydata = the_binarydata_decode,
            width = the_width,
            height = the_height,
            isproducticon = the_isproducticon,
            isproductimage = the_isproductimage,
            issupplierimage = the_issupplierimage,
            isrsiimage = the_isrsiimage,
            mimetype = the_mimetype,
            isadvertisingimage = the_isadvertisingimage,
            iscompanyimage = the_iscompanyimage,
            ispreserveimage = the_ispreserveimage
        WHERE image_id = the_image_id;
    ELSE
        -- Insertar una nueva imagen
        INSERT INTO public.image (
            image_id,
            isactive,
            created,
            createdby,
            updated,
            updatedby,
            name,
            imageurl,
            binarydata,
            width,
            height,
            isproducticon,
            isproductimage,
            issupplierimage,
            isrsiimage,
            mimetype,
            isadvertisingimage,
            iscompanyimage,
            ispreserveimage
        ) VALUES (
            the_image_id,
            the_isactive,
            now(),
            the_createdby,
            now(),
            the_updatedby,
            the_name,
            the_imageurl,
            the_binarydata_decode,
            the_width,
            the_height,
            the_isproducticon,
            the_isproductimage,
            the_issupplierimage,
            the_isrsiimage,
            the_mimetype,
            the_isadvertisingimage,
            the_iscompanyimage,
            the_ispreserveimage
        );
    END IF;
END;
$BODY$;

ALTER FUNCTION public.merge_images(character varying, character, character varying, character varying, character varying, character varying, character varying, numeric, numeric, character, character, character, character, character varying, character, character, character)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_images(character varying, character, character varying, character varying, character varying, character varying, character varying, numeric, numeric, character, character, character, character, character varying, character, character, character) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_images(character varying, character, character varying, character varying, character varying, character varying, character varying, numeric, numeric, character, character, character, character, character varying, character, character, character) TO systel;



-- FUNCTION: public.odoo_merge_depto_prod_price(bigint, character, character varying, numeric, character varying, integer, character varying, timestamp without time zone, json[], character varying)

-- DROP FUNCTION IF EXISTS public.odoo_merge_depto_prod_price(bigint, character, character varying, numeric, character varying, integer, character varying, timestamp without time zone, json[], character varying);

CREATE OR REPLACE FUNCTION public.odoo_merge_depto_prod_price(
	the_product_id bigint,
	the_isactive character,
	the_name character varying,
	the_price numeric,
	the_barcode character varying,
	the_attribute integer,
	the_department_name character varying,
	the_updated timestamp without time zone,
	the_json_array json[],
	the_bytea_param character varying)
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
	DECLARE
	    the_department_id 	department.department_id%TYPE;
		the_uom_id uom.uom_id%TYPE;
		the_print_primary_barcode product.print_primary_barcode%TYPE;
        the_json_element JSON;
        JsEl_id_value character varying;
        JsEl_listname_value character varying;
        JsEl_price_value double precision;
        the_have_image BOOLEAN; 
BEGIN
--RAISE NOTICE 'merge_department: START';
		-- Vemos si exite el dpto o si hay que crearlo y devolvemos el id del dpto.
        the_department_id := merge_department(the_department_name);
--RAISE NOTICE 'merge_department: END';         
--RAISE NOTICE 'the_department_id: %', the_department_id;
		-- Analizar el valor the_attribute
		the_uom_id:=1;
--RAISE NOTICE 'the_attribute: %', the_attribute;   
		IF the_attribute = 1 THEN
			the_uom_id := 2;
		END IF;
--RAISE NOTICE 'the_uom: %', the_uom_id;
	-- Analizar el valor the_barcode
		--the_print_primary_barcode:='N';
--RAISE NOTICE 'the_barcode: %', the_barcode;        
		--IF the_barcode <> '' THEN
			the_print_primary_barcode := 'Y';
		--END IF;
        
        IF (SELECT the_bytea_param IS NOT NULL) THEN
            the_have_image := TRUE;
        ELSE
            the_have_image := FALSE;
        END IF;
--RAISE NOTICE 'the_primary_barcode_flag: %', the_print_primary_barcode;

--RAISE NOTICE 'merge_images: START';
BEGIN
       PERFORM merge_images(
    the_product_id::TEXT,
    'Y',
    'ODOO',
    'ODOO',
    the_name,
    null,
    the_bytea_param,
    90,
    90,
    'Y',
    'Y',
    'N',
    'N',
    null,
    'N',
    'N',
    'N'
);

       PERFORM odoo_merge_product(
        the_product_id,
        the_name,
        the_attribute,
        the_department_id,
        the_uom_id,
        the_print_primary_barcode,
        the_barcode,
        the_isactive,
        the_updated,
        the_have_image);
  END;      

--RAISE NOTICE 'odoo_merge_product: END';
--RAISE NOTICE 'merge_product_price: START';
BEGIN
    -- Ejemplo: Recorrer el array de JSON y procesar cada elemento
    FOREACH the_json_element IN ARRAY the_json_array LOOP
       -- Acceder a los valores de las propiedades en cada elemento
        JsEl_id_value := (the_json_element->>'id')::character varying;
        JsEl_listname_value := (the_json_element->>'listname')::character varying;
        JsEl_price_value := (the_json_element->>'price')::double precision;

        -- Ejemplo: Imprimir los valores de las propiedades
        --RAISE NOTICE 'ID: %, Listname: %, Price: %', JsEl_id_value, JsEl_listname_value, JsEl_price_value;

        -- Ejemplo: Realizar otras operaciones con los valores
        PERFORM merge_price_list(JsEl_id_value,  JsEl_listname_value);
		PERFORM merge_product_price(JsEl_id_value, the_product_id, JsEl_price_value);
    END LOOP;

END;
--RAISE NOTICE 'merge_product_price: END';

END;
$BODY$;

ALTER FUNCTION public.odoo_merge_depto_prod_price(bigint, character, character varying, numeric, character varying, integer, character varying, timestamp without time zone, json[], character varying)
    OWNER TO systel;




-- FUNCTION: public.odoo_merge_product(bigint, character varying, integer, bigint, character varying, character varying, character varying, character, timestamp without time zone, boolean)

-- DROP FUNCTION IF EXISTS public.odoo_merge_product(bigint, character varying, integer, bigint, character varying, character varying, character varying, character, timestamp without time zone, boolean);

CREATE OR REPLACE FUNCTION public.odoo_merge_product(
	the_product_id bigint,
	the_name character varying,
	the_attribute integer,
	the_department_id bigint,
	the_uom_id character varying,
	the_print_primary_barcode character varying,
	the_primary_barcode_flag_data character varying,
	the_is_active character,
	the_updated timestamp without time zone,
	the_have_image boolean)
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
DECLARE

        the_icon_id character varying; 

BEGIN
        IF (SELECT the_have_image IS NOT NULL) THEN
            the_icon_id := the_product_id;
        ELSE
            the_icon_id := '';
        END IF;
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
the_is_active,
LOCALTIMESTAMP,
'ODOO',
the_updated,
'ODOO',
the_product_id,
the_name,
the_name,
the_department_id,
0,
NULL,
NULL,
'N',
0,
the_print_primary_barcode,
0,
the_primary_barcode_flag_data,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
'N',
0,
0,
1,
0,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
the_product_id,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_product_id, 
    name = the_name,
    isactive = the_is_active,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_name,
    updated = the_updated, 
    updatedby = 'ODOO',
    uom_id = the_uom_id,
    print_primary_barcode = the_print_primary_barcode,
    primary_barcode_flag_data = the_primary_barcode_flag_data ,
    icon_id = the_icon_id
    WHERE product_id = the_product_id;
  END;
END;
$BODY$;

ALTER FUNCTION public.odoo_merge_product(bigint, character varying, integer, bigint, character varying, character varying, character varying, character, timestamp without time zone, boolean)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.odoo_merge_product(bigint, character varying, integer, bigint, character varying, character varying, character varying, character, timestamp without time zone, boolean) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.odoo_merge_product(bigint, character varying, integer, bigint, character varying, character varying, character varying, character, timestamp without time zone, boolean) TO systel;



-- FUNCTION: public.merge_price_list(character varying, character varying)

-- DROP FUNCTION IF EXISTS public.merge_price_list(character varying, character varying);

CREATE OR REPLACE FUNCTION public.merge_price_list(
	the_pricelist_version_id character varying,
	the_pricelist_version_name character varying)
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$

BEGIN

BEGIN

IF NOT EXISTS (SELECT 1 FROM pricelist_version WHERE pricelist_version_id = the_pricelist_version_id) THEN
      INSERT INTO pricelist_version(pricelist_version_id,
            isactive, 
            created, 
            createdby, 
            updated, 
            updatedby, 
            name, 
            description, 
            pricelist_id, 
            validfrom, 
            proccreate, 
            pricelist_version_base_id, 
            pricelist_version_generate, 
            validto, 
            isdefault)
    VALUES (the_pricelist_version_id, 
	    'Y', 
	    LOCALTIMESTAMP,
	    'importacion',
	    LOCALTIMESTAMP,
	    'importacion', 
	    the_pricelist_version_name, 
	    the_pricelist_version_name, 
	    '@', 
	    LOCALTIMESTAMP, 
	    NULL, 
	    'man', 
	    'N', 
	    '2050-12-12 23:00:00',
	    'N');
END IF;
END;
   
END;

$BODY$;

ALTER FUNCTION public.merge_price_list(character varying, character varying)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_price_list(character varying, character varying) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_price_list(character varying, character varying) TO systel;

-- Function: public.odoo_disable_price_lists(json[])

-- DROP FUNCTION public.odoo_disable_price_lists(json[]);

CREATE OR REPLACE FUNCTION public.odoo_disable_price_lists(the_json_array json[])
  RETURNS void AS
$BODY$
	DECLARE
        the_json_element JSON;
        JsEl_id_value character varying;
        JsEl_name_value character varying;
       -- JsEl_default character varying;
        --s_default character varying;
BEGIN
    ALTER TABLE public.pricelist_version DISABLE TRIGGER pricelistver_update_isdefault;

    UPDATE public.pricelist_version SET isactive='N';

    -- Ejemplo: Recorrer el array de JSON y procesar cada elemento
    FOREACH the_json_element IN ARRAY the_json_array LOOP
       -- Acceder a los valores de las propiedades en cada elemento
        JsEl_id_value := (the_json_element->>'id')::character varying;
        JsEl_name_value := (the_json_element->>'name')::character varying;
        --JsEl_default := (the_json_element->>'pricelist_id')::character varying;

	--s_default := 'N';
	
	--if JsEl_id_value = JsEl_default then
	--	s_default := 'Y';
	--end if;

        -- Ejemplo: Imprimir los valores de las propiedades
        --RAISE NOTICE 'FIJO: %, PLU: %, DATO: %', JsEl_fijo_value, JsEl_plu_value, JsEl_dato_value;
        UPDATE public.pricelist_version 
        SET isactive = 'Y', 
        name = JsEl_name_value, 
        description = JsEl_name_value
        --,isactive = s_default
        WHERE pricelist_version_id = JsEl_id_value;
	
    END LOOP;

    ALTER TABLE public.pricelist_version ENABLE TRIGGER pricelistver_update_isdefault;
END;

$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.odoo_disable_price_lists(json[])
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.odoo_disable_price_lists(json[]) TO public;
GRANT EXECUTE ON FUNCTION public.odoo_disable_price_lists(json[]) TO systel;

CREATE OR REPLACE FUNCTION public.merge_setup(
    p_param character varying(50),
    p_value_int integer,
    p_value_string character varying,
    p_value_double double precision,
    p_id character varying(50),
    p_comentarios character varying
)
  RETURNS void AS
$BODY$
BEGIN
    -- Verifica si ya existe una fila con el ID especificado
    IF EXISTS(SELECT 1 FROM public.setup WHERE id = p_id) THEN
        -- Actualiza la fila existente
        UPDATE public.setup
        SET
            param = p_param,
            value_int = p_value_int,
            value_string = p_value_string,
            value_double = p_value_double,
            comentarios = p_comentarios
        WHERE
            id = p_id;
    ELSE
        -- Inserta una nueva fila
        INSERT INTO public.setup (param, value_int, value_string, value_double, id, comentarios)
        VALUES (p_param, p_value_int, p_value_string, p_value_double, p_id, p_comentarios);
    END IF;

    -- Puedes realizar más operaciones aquí si es necesario

    -- Opcionalmente, puedes retornar algún valor
    RETURN;
END;
$BODY$
LANGUAGE plpgsql;

    

ALTER FUNCTION public.merge_setup(character varying(50), integer, character varying, double precision, character varying(50), character varying)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_setup(character varying(50), integer, character varying, double precision, character varying(50), character varying) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_setup(character varying(50), integer, character varying, double precision, character varying(50), character varying) TO systel;



-- FUNCTION: public.merge_discount(bigint, double precision, double precision)

DROP FUNCTION IF EXISTS public.merge_discount(bigint, double precision, double precision);

CREATE OR REPLACE FUNCTION public.merge_discount(
    the_product_id bigint,
    the_limit_fixed numeric,
    the_rate numeric)
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
BEGIN
-- controlo que exista el PLU
IF EXISTS (SELECT 1 FROM product WHERE product_id = the_product_id) THEN
	--si no existe el esquema, lo inserto
	IF NOT EXISTS (SELECT 1 FROM discount_schema WHERE discount_id = the_product_id::text) THEN
		BEGIN
			INSERT INTO discount_schema(
				discount_id, 
				isactive, created, createdby, updated, updatedby, 
				name, 
				description, type, mode, 
				start_date, start_time, 
				end_date, end_time, 
				dow_sunday, dow_monday, dow_tuesday, dow_wednesday, dow_thursday, dow_friday, dow_saturday)
			VALUES (the_product_id::text, 
				'Y', LOCALTIMESTAMP, 'importacion', LOCALTIMESTAMP, 'importacion',
				(SELECT product_id::text || ' - ' || name as the_name FROM product WHERE product_id = the_product_id),
				'', 0, 0,
				'1970-01-01', '00:00:00',
				'2050-12-31', '23:59:59',
				'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
		END;    
  		
	-- si el esquema ya existe
	END IF;
    BEGIN
    -- borro todos los schema line que tengan más de 30 segundos de creados para ese producto
	    DELETE FROM discount_schema_line
		    WHERE discount_schema_id = the_product_id::text
            AND  (DATE_PART('day', created::timestamp - now()::timestamp) * 24 * 60 + 
               DATE_PART('hour', created::timestamp - now()::timestamp)) * 60 +
               DATE_PART('minute', created::timestamp - now()::timestamp) * 60 +
               DATE_PART('second', created::timestamp - now()::timestamp) <= -30;
    END;

	BEGIN
	INSERT INTO discount_schema_line(
		    discount_schema_line_id, 
		    isactive, created, createdby, updated, updatedby, 
		    discount_schema_id, 
		    source, limit_minamt, limit_maxamt, 
		    limit_fixed, 
		    limit_margin, 
		    rate)
	VALUES (
		   get_uuid(), 
		   'Y', LOCALTIMESTAMP, 'importador', LOCALTIMESTAMP, 'importador',
		   the_product_id::text,
		   0,0,0,
		   the_limit_fixed,
		   0,
		   the_rate);
	END;

	BEGIN
	-- update de la tabla product
		UPDATE product
		   SET discount_schema_id = the_product_id::text
		 WHERE product_id = the_product_id;
	END;  

ELSE
	RETURN;	
END IF;

END;
$BODY$;
ALTER FUNCTION public.merge_discount(bigint, numeric, numeric)
  OWNER TO systel;


-- FUNCTION: public.odoo_barcode(json[])

-- DROP FUNCTION IF EXISTS public.odoo_barcode(json[]);

CREATE OR REPLACE FUNCTION public.odoo_barcode(
	the_json_array json[])
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE  
AS $BODY$
	DECLARE
        the_json_element JSON;
        JsEl_fijo_value character varying;
        JsEl_plu_value character varying;
        JsEl_dato_value character varying;

        p_barcodetype character varying(32);
        p_producttype character(1);
        p_isactive character(1);
        p_createdby character varying(32);
        p_updatedby character varying(32);
        p_field_a character varying(50);
        p_cantidad_a character varying(2);
        p_value_a character varying(30);
        p_field_b character varying(50);
        p_cantidad_b character varying(2);
        p_value_b character varying(30);
        p_field_c character varying(50);
        p_cantidad_c character varying(2);
        p_value_c character varying(30);
        p_field_d character varying(50);
        p_cantidad_d character varying(2);
        p_value_d character varying(30);
BEGIN

    -- Ejemplo: Recorrer el array de JSON y procesar cada elemento
    FOREACH the_json_element IN ARRAY the_json_array LOOP
       -- Acceder a los valores de las propiedades en cada elemento
        JsEl_fijo_value := (the_json_element->>'fijo')::character varying;
        JsEl_plu_value := (the_json_element->>'plu')::character varying;
        JsEl_dato_value := (the_json_element->>'dato')::character varying;



        -- Ejemplo: Imprimir los valores de las propiedades
        --RAISE NOTICE 'FIJO: %, PLU: %, DATO: %', JsEl_fijo_value, JsEl_plu_value, JsEl_dato_value;


-- pesables
        IF JsEl_fijo_value = '20' THEN 
            p_barcodetype := '0'; 
            p_producttype := '0';
            p_isactive := 'Y';
            p_createdby := 'ODOO';
            p_updatedby := 'ODOO';
            --A--
            p_field_a := 'FIJO';
            p_cantidad_a := LENGTH(JsEl_fijo_value)::TEXT;
            p_value_a := JsEl_fijo_value;
            --B--
            p_field_b := '20';
            p_cantidad_b := JsEl_plu_value::TEXT;
            p_value_b := null;
            --C--
            p_field_c := '19';
            p_cantidad_c := JsEl_dato_value::TEXT;
            p_value_c := null; 
            --D--
            p_field_d := null;
            p_cantidad_d := null;
            p_value_d := null;
            
		END IF;

-- unitarios
        IF JsEl_fijo_value = '21' THEN 
            p_barcodetype := '0'; 
            p_producttype := '1';
            p_isactive := 'Y';
            p_createdby := 'ODOO';
            p_updatedby := 'ODOO';
            --A--
            p_field_a := 'FIJO';
            p_cantidad_a := LENGTH(JsEl_fijo_value)::TEXT;
            p_value_a := JsEl_fijo_value;
            --B--
            p_field_b := '20';
            p_cantidad_b := JsEl_plu_value::TEXT;
            p_value_b := null;
            --C--
            p_field_c := '15';
            p_cantidad_c := JsEl_dato_value::TEXT;
            p_value_c := null; 
            --D--
            p_field_d := null;
            p_cantidad_d := null;
            p_value_d := null;
		END IF;

-- sumatoria <= 99999,99
	IF JsEl_fijo_value = '22' THEN 
            p_barcodetype := '0'; 
            p_producttype := '4';
            p_isactive := 'Y';
            p_createdby := 'ODOO';
            p_updatedby := 'ODOO';
            --A--
            p_field_a := 'FIJO';
            p_cantidad_a := LENGTH(JsEl_fijo_value)::TEXT;
            p_value_a := JsEl_fijo_value;
            --B--
            p_field_b := '202';
            p_cantidad_b := JsEl_plu_value::TEXT;
            p_value_b := 'null';
            --C--
            p_field_c := '18';
            p_cantidad_c := JsEl_dato_value::TEXT;
            p_value_c := null; 
            --D--
            p_field_d := null;
            p_cantidad_d := null;
            p_value_d := null;
		END IF;

-- sumatoria <= 999999,9        
        IF JsEl_fijo_value = '23' THEN 
            p_barcodetype := '0'; 
            p_producttype := '8';
            p_isactive := 'Y';
            p_createdby := 'ODOO';
            p_updatedby := 'ODOO';
            --A--
            p_field_a := 'FIJO';
            p_cantidad_a := LENGTH(JsEl_fijo_value)::TEXT;
            p_value_a := JsEl_fijo_value;
            --B--
            p_field_b := '202';
            p_cantidad_b := JsEl_plu_value::TEXT;
            p_value_b := 'null';
            --C--
            p_field_c := '18';
            p_cantidad_c := JsEl_dato_value::TEXT;
            p_value_c := null; 
            --D--
            p_field_d := null;
            p_cantidad_d := null;
            p_value_d := null;
		END IF;

-- sumatoria <= 9999999
        IF JsEl_fijo_value = '24' THEN 
            p_barcodetype := '0'; 
            p_producttype := '9';
            p_isactive := 'Y';
            p_createdby := 'ODOO';
            p_updatedby := 'ODOO';
            --A--
            p_field_a := 'FIJO';
            p_cantidad_a := LENGTH(JsEl_fijo_value)::TEXT;
            p_value_a := JsEl_fijo_value;
            --B--
            p_field_b := '202';
            p_cantidad_b := JsEl_plu_value::TEXT;
            p_value_b := 'null';
            --C--
            p_field_c := '18';
            p_cantidad_c := JsEl_dato_value::TEXT;
            p_value_c := null; 
            --D--
            p_field_d := null;
            p_cantidad_d := null;
            p_value_d := null;
		END IF;


        -- Ejemplo: Realizar otras operaciones con los valores
        PERFORM merge_barcode_format(
                                        p_barcodetype,
                                        p_producttype,
                                        p_isactive,
                                        p_createdby,
                                        p_updatedby,
                                        p_field_a,
                                        p_cantidad_a,
                                        p_value_a,
                                        p_field_b,
                                        p_cantidad_b,
                                        p_value_b,
                                        p_field_c,
                                        p_cantidad_c,
                                        p_value_c,
                                        p_field_d,
                                        p_cantidad_d,
                                        p_value_d
        );
	
    END LOOP;


END;

$BODY$;

ALTER FUNCTION public.odoo_barcode(json[])
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.odoo_barcode(json[]) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.odoo_barcode(json[]) TO systel;



-- FUNCTION: public.merge_department(character varying)

-- DROP FUNCTION IF EXISTS public.merge_department(character varying);

CREATE OR REPLACE FUNCTION public.merge_barcode_format(
    p_barcodetype character varying(32),
    p_producttype character(1),
    p_isactive character(1),
    p_createdby character varying(32),
    p_updatedby character varying(32),
    p_field_a character varying(50),
    p_cantidad_a character varying(2),
    p_value_a character varying(30),
    p_field_b character varying(50),
    p_cantidad_b character varying(2),
    p_value_b character varying(30),
    p_field_c character varying(50),
    p_cantidad_c character varying(2),
    p_value_c character varying(30),
    p_field_d character varying(50),
    p_cantidad_d character varying(2),
    p_value_d character varying(30))
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
BEGIN

  -- Verifica si ya existe una fila con la combinación de barcodetype y producttype especificados
    IF EXISTS(
        SELECT 1 FROM public.barcode_format
        WHERE barcodetype = p_barcodetype AND producttype = p_producttype
    ) THEN
        -- Actualiza la fila existente
        UPDATE public.barcode_format
        SET
            isactive = p_isactive,
            createdby = p_createdby,
            updatedby = p_updatedby,
            field_a = p_field_a,
            cantidad_a = p_cantidad_a,
            value_a = p_value_a,
            field_b = p_field_b,
            cantidad_b = p_cantidad_b,
            value_b = p_value_b,
            field_c = p_field_c,
            cantidad_c = p_cantidad_c,
            value_c = p_value_c,
            field_d = p_field_d,
            cantidad_d = p_cantidad_d,
            value_d = p_value_d
        WHERE
            barcodetype = p_barcodetype AND producttype = p_producttype;
    ELSE
        -- Inserta una nueva fila
        INSERT INTO public.barcode_format (
            barcodetype,
            producttype,
            isactive,
            created,
            createdby,
            updated,
            updatedby,
            field_a,
            cantidad_a,
            value_a,
            field_b,
            cantidad_b,
            value_b,
            field_c,
            cantidad_c,
            value_c,
            field_d,
            cantidad_d,
            value_d
        )
        VALUES (
            p_barcodetype,
            p_producttype,
            p_isactive,
            now(),
            p_createdby,
            now(),
            p_updatedby,
            p_field_a,
            p_cantidad_a,
            p_value_a,
            p_field_b,
            p_cantidad_b,
            p_value_b,
            p_field_c,
            p_cantidad_c,
            p_value_c,
            p_field_d,
            p_cantidad_d,
            p_value_d
        );
    END IF;

END;

$BODY$;

ALTER FUNCTION public.merge_barcode_format(character varying(32),
     character(1),
     character(1),
     character varying(32),
     character varying(32),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30))
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_barcode_format(character varying(32),
     character(1),
     character(1),
     character varying(32),
     character varying(32),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30)) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_barcode_format(character varying(32),
     character(1),
     character(1),
     character varying(32),
     character varying(32),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30),
     character varying(50),
     character varying(2),
     character varying(30)) TO systel;
-- Function: public.delete_discount()

-- DROP FUNCTION public.delete_discount();

CREATE OR REPLACE FUNCTION public.delete_discount()
  RETURNS void AS
$BODY$
BEGIN
	-- borro todos los esquema lines de ese plu
	DELETE FROM discount_schema_line;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.delete_discount()
  OWNER TO systel;


-- Function: public.merge_nut_info(bigint, character varying, character varying, numeric, character varying)

-- DROP FUNCTION public.merge_nut_info(bigint, character varying, character varying, numeric, character varying);

CREATE OR REPLACE FUNCTION public.merge_nut_info(
	the_product_id bigint,
	the_value_desc character varying,
	the_value character varying,
    the_pos_column numeric(2,0),
	the_info_set_id character varying,
    the_alignment numeric(2,0))
  RETURNS void AS
$BODY$
BEGIN

   UPDATE nut_info_el_instance 
   SET 
       --updated=LOCALTIMESTAMP, 
       updatedby='importador', value=the_value_desc, alignment=the_alignment
   WHERE 
       product_id = the_product_id AND
       pos_row = (SELECT pos_row FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id) AND
       pos_rowto = (SELECT pos_rowto FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id) AND 
       hasjoinedcolumns = (SELECT hasjoinedcolumns FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id) AND
       pos_column = the_pos_column AND 
       pos_columnto = (SELECT pos_columnto FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id) AND 
       nut_info_set_id = the_info_set_id;
   IF FOUND THEN
     RETURN;
   END IF;
   -- Not found, try insert and check exceptions in case someone inserted
   -- the same key concurrently as we speak
   BEGIN
   INSERT INTO nut_info_el_instance(
           nut_info_el_instance_id, 
           isactive, created, createdby, updated, updatedby, 
           nut_info_set_id, product_id, value, hasjoinedrows, 
           pos_row, pos_rowto, 
           hasjoinedcolumns, 
           pos_column, pos_columnto, 
           alignment)
   VALUES (
           get_uuid(), 
           'Y', LOCALTIMESTAMP, 'importador', LOCALTIMESTAMP, 'importador', 
           the_info_set_id , the_product_id, the_value_desc, 'N',
           (SELECT pos_row FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id),
           (SELECT pos_rowto FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id), 
           (SELECT hasjoinedcolumns FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id), 
           the_pos_column, 
           (SELECT pos_columnto FROM nut_info_element WHERE value=the_value AND nut_info_set_id = the_info_set_id), 
           the_alignment
           );
                   
   END;

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

ALTER FUNCTION public.merge_nut_info(bigint, character varying, character varying, numeric, character varying, numeric)
    OWNER TO systel;


--------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------


-- Function: public.merge_nut_info(bigint, character varying, character varying, numeric)

-- DROP FUNCTION public.merge_nut_info(bigint, character varying, character varying, numeric);

CREATE OR REPLACE FUNCTION public.merge_nut_info(
    the_product_id bigint,
    the_value_desc character varying,
    the_value character varying,
    the_pos_column numeric(2,0))
  RETURNS void AS
$BODY$
BEGIN

   UPDATE nut_info_el_instance 
   SET 
       --updated=LOCALTIMESTAMP, 
       updatedby='importador', value=the_value_desc 
   WHERE 
       product_id=the_product_id AND
       pos_row = (SELECT pos_row FROM nut_info_element WHERE value=the_value) AND
       pos_rowto = (SELECT pos_rowto FROM nut_info_element WHERE value=the_value) AND 
       hasjoinedcolumns = (SELECT hasjoinedcolumns FROM nut_info_element WHERE value=the_value) AND
       pos_column = the_pos_column AND 
       pos_columnto = (SELECT pos_columnto FROM nut_info_element WHERE value=the_value) AND
       alignment = (SELECT alignment FROM nut_info_element WHERE value=the_value);
       
   IF FOUND THEN
     RETURN;
   END IF;
   -- Not found, try insert and check exceptions in case someone inserted
   -- the same key concurrently as we speak
   BEGIN
   INSERT INTO nut_info_el_instance(
           nut_info_el_instance_id, 
           isactive, created, createdby, updated, updatedby, 
           nut_info_set_id, product_id, value, hasjoinedrows, 
           pos_row, pos_rowto, 
           hasjoinedcolumns, 
           pos_column, pos_columnto, 
           alignment)
   VALUES (
           get_uuid(), 
           'Y', LOCALTIMESTAMP, 'importador', LOCALTIMESTAMP, 'importador', 
           '1', the_product_id, the_value_desc, 'N',
           (SELECT pos_row FROM nut_info_element WHERE value=the_value),
           (SELECT pos_rowto FROM nut_info_element WHERE value=the_value), 
           (SELECT hasjoinedcolumns FROM nut_info_element WHERE value=the_value), 
           the_pos_column, 
           (SELECT pos_columnto FROM nut_info_element WHERE value=the_value), 
           (SELECT alignment FROM nut_info_element WHERE value=the_value)
           );
                   
   END;

END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_nut_info(bigint, character varying, character varying, numeric)
  OWNER TO systel;

--------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------
  
CREATE OR REPLACE FUNCTION public.delete_all_plu()
RETURNS void AS
$BODY$
declare
i bigint;

begin
i=0;

if (select count(*) from invoiceline) = i then
	DELETE FROM productprice
	       WHERE product_id != 0;

	DELETE FROM nut_info_el_instance
	       WHERE product_id != 0;

	DELETE FROM product 
               WHERE product_id != 0;
else 
	raise EXCEPTION 'close sales';
end if;
  end
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.delete_all_plu()
  OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.delete_all_plu() TO public;
GRANT EXECUTE ON FUNCTION public.delete_all_plu() TO systel;

--------------------------------------------------------------
---------------------------------------------------------------

CREATE OR REPLACE FUNCTION public.delete_plu(plu_id bigint)
  RETURNS void AS
$BODY$
declare
i bigint;

begin
i=0;

if (select count(*) from invoiceline WHERE product_id = plu_id) = i then
    DELETE FROM productprice WHERE product_id = plu_id;

    DELETE FROM nut_info_el_instance WHERE product_id = plu_id;

DELETE FROM product WHERE product_id = plu_id;

else 
	raise EXCEPTION 'close sales';
end if;
  end
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.delete_plu(bigint)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.delete_plu(bigint) TO public;
GRANT EXECUTE ON FUNCTION public.delete_plu(bigint) TO systel;

  
  
  
-- Function: merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character)

-- DROP FUNCTION merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character);

CREATE OR REPLACE FUNCTION public.merge_product(
    the_product_id bigint,
    the_erp_code character varying,
    the_name character varying,
    the_attribute integer,
    the_department_id bigint,
    the_description character varying,
    the_print_used_by_date character,
    the_used_by_date numeric,
    the_uom_id character varying,
    the_tare double precision,
    the_extra_field1 character varying,
    the_extra_field2 character varying,
    the_primary_barcode_flag character varying,
    the_primary_barcode_flag_data character varying,
    the_is_active character)
  RETURNS void AS
$BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
the_is_active,
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
the_primary_barcode_flag,
0,
the_primary_barcode_flag_data,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    isactive = the_is_active,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = LOCALTIMESTAMP, 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare,
    extra_field1 = the_extra_field1,
    extra_field2 = the_extra_field2,
    nut_info_set_id='1',
    print_primary_barcode = the_primary_barcode_flag,
    primary_barcode_flag_data = the_primary_barcode_flag_data   
    WHERE product_id = the_product_id;
  END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character) TO public;


  
  
-- Function: merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying)

-- DROP FUNCTION merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying);

CREATE OR REPLACE FUNCTION public.merge_product(
    the_product_id bigint,
    the_erp_code character varying,
    the_name character varying,
    the_attribute integer,
    the_department_id bigint,
    the_description character varying,
    the_print_used_by_date character,
    the_used_by_date numeric,
    the_uom_id character varying,
    the_tare double precision,
    the_extra_field1 character varying,
    the_extra_field2 character varying)
  RETURNS void AS
$BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
'Y',
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
'Y',
0,
0,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = LOCALTIMESTAMP, 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare,
    extra_field1 = the_extra_field1,
    extra_field2 = the_extra_field2,
    nut_info_set_id='1'
    WHERE product_id = the_product_id;
  END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying) TO public;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying) TO systel;

-- Function: merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying)

-- DROP FUNCTION merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying);


CREATE OR REPLACE FUNCTION public.merge_product(
	the_product_id bigint,
	the_erp_code character varying,
	the_name character varying,
	the_attribute integer,
	the_department_id bigint,
	the_description character varying,
	the_print_used_by_date character,
	the_used_by_date numeric,
	the_uom_id character varying,
	the_tare double precision,
	the_extra_field1 character varying,
	the_extra_field2 character varying,
	the_primary_barcode_flag character varying,
	the_primary_barcode_flag_data character varying,
    the_ingredients character varying,
    the_preservation_info character varying)
  RETURNS void AS
$BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
'Y',
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
the_primary_barcode_flag,
0,
the_primary_barcode_flag_data,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
the_ingredients,
NULL,
the_preservation_info,
NULL,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = LOCALTIMESTAMP, 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare,
    extra_field1 = the_extra_field1,
    extra_field2 = the_extra_field2,
    nut_info_set_id='1',
    print_primary_barcode = the_primary_barcode_flag,
    primary_barcode_flag_data = the_primary_barcode_flag_data,
    ingredients = the_ingredients,
    preservation_info = the_preservation_info   
    WHERE product_id = the_product_id;
  END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character varying, character varying)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character varying, character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying, character varying, character varying) TO public;



-- Function: public.pricelistver_update_isdefault()

-- DROP FUNCTION public.pricelistver_update_isdefault();

CREATE OR REPLACE FUNCTION public.pricelistver_update_isdefault()
  RETURNS trigger AS
$BODY$
BEGIN
  
  IF NEW.isdefault = 'Y' THEN
      UPDATE pricelist_version set isdefault='N' WHERE pricelist_version_id != NEW.pricelist_version_id ;
  END IF;
  RETURN NEW;  
END
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.pricelistver_update_isdefault()
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.pricelistver_update_isdefault() TO postgres;
GRANT EXECUTE ON FUNCTION public.pricelistver_update_isdefault() TO systel;
GRANT EXECUTE ON FUNCTION public.pricelistver_update_isdefault() TO public;


CREATE OR REPLACE FUNCTION public.shortcut_update_name_or_active_changes()
  RETURNS trigger AS
$BODY$
BEGIN
	IF NEW.name <> OLD.name THEN
		 UPDATE shortcut set name=NEW.name WHERE product_id = NEW.product_id;
	END IF;
 
	RETURN NEW;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.shortcut_update_name_or_active_changes()
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.shortcut_update_name_or_active_changes() TO postgres;
GRANT EXECUTE ON FUNCTION public.shortcut_update_name_or_active_changes() TO systel;
GRANT EXECUTE ON FUNCTION public.shortcut_update_name_or_active_changes() TO public;



-- Function: public.selecttablehash(text)

-- DROP FUNCTION public.selecttablehash(text);

CREATE OR REPLACE FUNCTION public.selecttablehash(IN par_table text)
  RETURNS TABLE(hash text) AS
$BODY$
BEGIN
 RETURN QUERY EXECUTE 'select md5(string_agg(md5,'''')) from (select md5(b.*::TEXT) from '||PAR_table||' as b order by 1) as md5';
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION public.selecttablehash(text)
  OWNER TO sync;

-- Function: public.find_barcode_ret_prodid(text)

-- DROP FUNCTION public.find_barcode_ret_prodid(text);

CREATE OR REPLACE FUNCTION public.find_barcode_ret_prodid(barcode text)
  RETURNS bigint AS
$BODY$
begin
    return (SELECT p.product_id FROM product p where p.primary_barcode_flag_data = barcode OR p.secondary_barcode_flag_data = barcode LIMIT 1);  
end
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.find_barcode_ret_prodid(text)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.find_barcode_ret_prodid(text) TO systel;
GRANT EXECUTE ON FUNCTION public.find_barcode_ret_prodid(text) TO public;

-- Function: public.find_barcode_ret_table(text)

-- DROP FUNCTION public.find_barcode_ret_table(text);

CREATE OR REPLACE FUNCTION public.find_barcode_ret_table(IN barcode text)
  RETURNS TABLE(producto product) AS
$BODY$
begin
     RETURN QUERY SELECT p.* FROM product p where p.primary_barcode_flag_data = barcode OR p.secondary_barcode_flag_data = barcode;
end
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
ALTER FUNCTION public.find_barcode_ret_table(text)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.find_barcode_ret_table(text) TO systel;
GRANT EXECUTE ON FUNCTION public.find_barcode_ret_table(text) TO public;


-- Function: public.getcommaseparatedcolumns(text)

-- DROP FUNCTION public.getcommaseparatedcolumns(text);

CREATE OR REPLACE FUNCTION public.getcommaseparatedcolumns(par_table text)
  RETURNS text AS
$BODY$
DECLARE
 REC_columns record;
 VAR_query text;
BEGIN
 VAR_query := '';
 FOR REC_columns IN SELECT column_name FROM information_schema.columns WHERE table_schema = 'public' AND table_name = PAR_table LOOP
     IF VAR_query <> '' THEN
         VAR_query := VAR_query || '::TEXT,';
     END IF;

     VAR_query := VAR_query || REC_columns.column_name;
 END LOOP;

 RETURN VAR_query;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.getcommaseparatedcolumns(text)
  OWNER TO sync;


-- Function: public.getplu(bigint)

-- DROP FUNCTION public.getplu(bigint);

CREATE OR REPLACE FUNCTION public.getplu(IN plu_id bigint DEFAULT 1)
  RETURNS TABLE(output_prod product) AS
$BODY$
begin
 select p from public.product p where p.product_id = plu_id; 
end
$BODY$
  LANGUAGE plpgsql VOLATILE STRICT
  COST 100
  ROWS 1000;
ALTER FUNCTION public.getplu(bigint)
  OWNER TO systel;


-- Function: public.merge_department(bigint, character varying)

-- DROP FUNCTION public.merge_department(bigint, character varying);

CREATE OR REPLACE FUNCTION public.merge_department(
    the_department_id bigint,
    the_name character varying)
  RETURNS void AS
$BODY$
                            
BEGIN
  BEGIN
      INSERT INTO department(
            department_id, 
            isactive, 
            created, 
            createdby, 
            updated, 
            updatedby, 
            name, 
            tax_id, 
            warehouse_id)
    VALUES (
    the_department_id, 
    'Y', 
    LOCALTIMESTAMP,
    'importacion',
    LOCALTIMESTAMP,
    'importacion',
    the_name, 
    NULL, 
    NULL
    );
    EXCEPTION WHEN unique_violation THEN
        UPDATE department SET 
	 name = the_name, 
         --updated = LOCALTIMESTAMP, 
	 updatedby = 'importacion'
        WHERE department_id = the_department_id;
    END;
END;


$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_department(bigint, character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_department(bigint, character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_department(bigint, character varying) TO public;


-- Function: public.merge_department(character varying)

-- DROP FUNCTION public.merge_department(character varying);

CREATE OR REPLACE FUNCTION public.merge_department(the_name character varying)
  RETURNS bigint AS
$BODY$
DECLARE the_department_id bigint;                               

BEGIN

    UPDATE department SET 
	name = the_name, 
      --  updated = LOCALTIMESTAMP, 
	updatedby = 'importacion'
    WHERE name = the_name RETURNING department.department_id into the_department_id;
        --raise notice 'the_department_id %', the_department_id;


    IF FOUND THEN
      RETURN the_department_id;
    END IF;
    -- Not found, try insert and check exceptions in case someone inserted
    -- the same key concurrently as we speak
    BEGIN
    the_department_id = (select max(department_id) + 1 from department);
      INSERT INTO department(
            department_id, 
            isactive, 
            created, 
            createdby, 
            updated, 
            updatedby, 
            name, 
            tax_id, 
            warehouse_id)
    VALUES (
    the_department_id, 
    'Y', 
    LOCALTIMESTAMP,
    'importacion',
    LOCALTIMESTAMP,
    'importacion',
    the_name, 
    NULL, 
    NULL
    );
      RETURN the_department_id;
    EXCEPTION WHEN unique_violation THEN
      -- do nothing; just loop back to the UPDATE
    END;

END;


$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_department(character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_department(character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_department(character varying) TO public;


-- Function: public.merge_price_list(character varying)

-- DROP FUNCTION public.merge_price_list(character varying);

CREATE OR REPLACE FUNCTION public.merge_price_list(the_pricelist_version_id character varying)
  RETURNS void AS
$BODY$

BEGIN

BEGIN

IF NOT EXISTS (SELECT 1 FROM pricelist_version WHERE pricelist_version_id = the_pricelist_version_id) THEN
      INSERT INTO pricelist_version(pricelist_version_id,
            isactive, 
            created, 
            createdby, 
            updated, 
            updatedby, 
            name, 
            description, 
            pricelist_id, 
            validfrom, 
            proccreate, 
            pricelist_version_base_id, 
            pricelist_version_generate, 
            validto, 
            isdefault)
    VALUES (the_pricelist_version_id, 
	    'Y', 
	    LOCALTIMESTAMP,
	    'importacion',
	    LOCALTIMESTAMP,
	    'importacion', 
	    the_pricelist_version_id, 
	    the_pricelist_version_id, 
	    '@', 
	    LOCALTIMESTAMP, 
	    NULL, 
	    'man', 
	    'N', 
	    '2020-12-12 23:00:00',
	    'N');
END IF;
END;
   
END;


$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_price_list(character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_price_list(character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_price_list(character varying) TO public;


-- Function: public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision)

-- DROP FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision);

CREATE OR REPLACE FUNCTION public.merge_product(
    the_product_id bigint,
    the_erp_code character varying,
    the_name character varying,
    the_attribute integer,
    the_department_id bigint,
    the_description character varying,
    the_print_used_by_date character,
    the_used_by_date numeric,
    the_uom_id character varying,
    the_tare double precision)
  RETURNS void AS
$BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
'Y',
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
'Y',
0,
0,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = LOCALTIMESTAMP, 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare
    WHERE product_id = the_product_id;
  END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision) TO public;



-- Function: public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying)

-- DROP FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying);

CREATE OR REPLACE FUNCTION public.merge_product(
    the_product_id bigint,
    the_erp_code character varying,
    the_name character varying,
    the_attribute integer,
    the_department_id bigint,
    the_description character varying,
    the_print_used_by_date character,
    the_used_by_date numeric,
    the_uom_id character varying)
  RETURNS void AS
$BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
'Y',
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
'Y',
0,
0,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
0,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
--updated = LOCALTIMESTAMP, 
updatedby = 'importacion'



    WHERE product_id = the_product_id;
  END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying) TO public;


CREATE OR REPLACE FUNCTION public.merge_product(
	the_product_id bigint,
	the_erp_code character varying,
	the_name character varying,
	the_attribute integer,
	the_department_id bigint,
	the_description character varying,
	the_print_used_by_date character,
	the_used_by_date numeric,
	the_uom_id character varying,
	the_tare double precision,
	the_extra_field1 character varying,
	the_extra_field2 character varying,
	the_primary_barcode_flag character varying,
	the_primary_barcode_flag_data character varying)
RETURNS void
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
AS $BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
'Y',
LOCALTIMESTAMP,
'importacion',
LOCALTIMESTAMP,
'importacion',
the_erp_code,
the_name,
the_description,
the_department_id,
0,
NULL,
NULL,
'N',
0,
the_primary_barcode_flag,
0,
the_primary_barcode_flag_data,
'Y',
NULL,
0,
0,
0,
0,
0,
NULL,
'N',
0,
0,
'dd-mm-YYYY',
the_print_used_by_date,
0,
the_used_by_date,
1,
the_tare,
0,
1,
NULL,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
NULL,
the_attribute,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
NULL,
'1',
'N',
'N');            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET erp_code = the_erp_code, 
    name = the_name,
    attribute = the_attribute,
    department_id = the_department_id,
    description = the_description,
    print_used_by_date = the_print_used_by_date,
    used_by_date = the_used_by_date, 
    --updated = LOCALTIMESTAMP, 
    updatedby = 'importacion',
    uom_id = the_uom_id ,
    tare = the_tare,
    extra_field1 = the_extra_field1,
    extra_field2 = the_extra_field2,
    nut_info_set_id='1',
    print_primary_barcode = the_primary_barcode_flag,
    primary_barcode_flag_data = the_primary_barcode_flag_data   
    WHERE product_id = the_product_id;
  END;
END;
$BODY$;

ALTER FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying)
    OWNER TO systel;

GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying) TO PUBLIC;

GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character varying, character varying, integer, bigint, character varying, character, numeric, character varying, double precision, character varying, character varying, character varying, character varying) TO systel;



-- Function: public.merge_product(bigint, character, character varying, character varying, character varying, bigint, bigint, character varying, character varying, character, character, character, character varying, character, character varying, integer, integer, numeric, integer, time without time zone, integer, numeric, character, integer, numeric, numeric, numeric, character varying, character varying, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character, character)

-- DROP FUNCTION public.merge_product(bigint, character, character varying, character varying, character varying, bigint, bigint, character varying, character varying, character, character, character, character varying, character, character varying, integer, integer, numeric, integer, time without time zone, integer, numeric, character, integer, numeric, numeric, numeric, character varying, character varying, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character, character);

CREATE OR REPLACE FUNCTION public.merge_product(
    the_product_id bigint,
    the_isactive character,
    the_createdby character varying,
    the_updatedby character varying,
    the_erp_code character varying,
    the_name character varying,
    the_description character varying,
    the_department_id bigint,
    the_group_id bigint,
    the_label_format_w character varying,
    the_label_format_u character varying,
    the_barcode_item_code_flag character,
    the_barcode_item_code numeric,
    the_print_primary_barcode character,
    the_primary_barcode_flag_data character varying,
    the_print_secondary_barcode character,
    the_secondary_barcode_flag_data character varying,
    the_sell_by_date_time integer,
    the_sell_by_date_source integer,
    the_sell_by_date numeric,
    the_sell_time_source integer,
    the_sell_time time without time zone,
    the_packed_date_source integer,
    the_packed_date numeric,
    the_print_used_by_date character,
    the_used_by_date_source integer,
    the_used_by_date numeric,
    the_tare double precision,
    the_perc_tare double precision,
    the_upc character varying,
    the_uom_id character varying,
    the_attribute integer,
    the_advertising_id character varying,
    the_ingredients character varying,
    the_ingredients_id character varying,
    the_preservation_info character varying,
    the_preservation_info_id character varying,
    the_extra_field1 character varying,
    the_extra_field2 character varying,
    the_image_id character varying,
    the_icon_id character varying,
    the_lot character varying,
    the_born_country character varying,
    the_fatten_country character varying,
    the_origin_country character varying,
    the_manufacturer_id character varying,
    the_packer_id character varying,
    the_distributor_id character varying,
    the_importer_id character varying,
    the_exporter_id character varying,
    the_vendor_id character varying,
    the_cutting_hall_id character varying,
    the_slaughter_house_id character varying,
    the_supplier_id character varying,
    the_nut_info_set_id character varying,
    the_print_fix_primary_barcode character,
    the_print_fix_secondary_barcode character)
  RETURNS void AS
$BODY$
BEGIN
  BEGIN
    INSERT INTO product (product_id, isactive, created, createdby, updated, updatedby,
            erp_code, name, description, department_id, group_id, label_format_w,
            label_format_u, barcode_item_code_flag, barcode_item_code, print_primary_barcode,
            primary_barcode_type, primary_barcode_flag_data, print_secondary_barcode,
            secondary_barcode_type, secondary_barcode_flag_data, sell_by_date_time,
            sell_by_date_source, sell_by_date, sell_time_source, sell_time,
            print_packed_date, packed_date_source, packed_date, packed_date_format,
            print_used_by_date, used_by_date_source, used_by_date, unit_price_selection,
            tare, perc_tare, quantity, upc, uom_id, discount_schema_id, isstocked,
            isirradiated, isbom, stock_min, stock_max, versionno, discontinued,
            discontinuedby, tax_id, attribute, advertising_id, sto_temp_limit1,
            sto_temp_limit2, ingredients, ingredients_id, preservation_info,
            preservation_info_id, coupled_product, pack_indicator, extra_field1,
            extra_field2, image_id, icon_id, lot, born_country, fatten_country,
            origin_country, manufacturer_id, packer_id, distributor_id, importer_id,
            exporter_id, vendor_id, cutting_hall_id, slaughter_house_id,
            supplier_id, nut_info_set_id, print_fix_primary_barcode, print_fix_secondary_barcode)
VALUES(the_product_id,
the_isactive,
LOCALTIMESTAMP,
the_createdby,
LOCALTIMESTAMP,
the_updatedby,
the_erp_code,
the_name,
the_description,
the_department_id,
the_group_id,
the_label_format_w,
the_label_format_u,
the_barcode_item_code_flag,
the_barcode_item_code,
the_print_primary_barcode,
0,
the_primary_barcode_flag_data,
the_print_secondary_barcode,
NULL,
the_secondary_barcode_flag_data,
the_sell_by_date_time,
the_sell_by_date_source,
the_sell_by_date,
the_sell_time_source,
the_sell_time,
'N',
the_packed_date_source,
the_packed_date,
'dd-mm-YYYY',
the_print_used_by_date,
the_used_by_date_source,
the_used_by_date,
1,
the_tare,
the_perc_tare,
1,
the_upc,
the_uom_id,
NULL,
'N',
'N',
'N',
NULL,
NULL,
NULL,
'N',
NULL,
'@',
the_attribute,
the_advertising_id,
NULL,
NULL,
the_ingredients,
the_ingredients_id,
the_preservation_info,
the_preservation_info_id,
NULL,
NULL,
the_extra_field1,
the_extra_field2,
the_image_id,
the_icon_id,
the_lot,
the_born_country,
the_fatten_country,
the_origin_country,
the_manufacturer_id,
the_packer_id,
the_distributor_id,
the_importer_id,
the_exporter_id,
the_vendor_id,
the_cutting_hall_id,
the_slaughter_house_id,
the_supplier_id,
the_nut_info_set_id,
the_print_fix_primary_barcode,
the_print_fix_secondary_barcode);            
  EXCEPTION WHEN unique_violation THEN
    UPDATE product SET isactive = the_isactive,
	--updated = LOCALTIMESTAMP,
	updatedby = the_updatedby,
	erp_code = the_erp_code,
	name = the_name,
	description = the_description,
	department_id = the_department_id,
	group_id = the_group_id,
	label_format_w = the_label_format_w,
	label_format_u = the_label_format_u,
	barcode_item_code_flag = the_barcode_item_code_flag,
	barcode_item_code = the_barcode_item_code,
	print_primary_barcode = the_print_primary_barcode,
	primary_barcode_flag_data = the_primary_barcode_flag_data,
	print_secondary_barcode = the_print_secondary_barcode,
	secondary_barcode_flag_data = the_secondary_barcode_flag_data,
	sell_by_date_time = the_sell_by_date_time,
	sell_by_date_source = the_sell_by_date_source,
	sell_by_date = the_sell_by_date,
	sell_time_source = the_sell_time_source,
	sell_time = the_sell_time,
	packed_date_source = the_packed_date_source,
	packed_date = the_packed_date,
	print_used_by_date = the_print_used_by_date,
	used_by_date_source = the_used_by_date_source,
	used_by_date = the_used_by_date,
	tare = the_tare,
	perc_tare = the_perc_tare,
	upc = the_upc,
	uom_id = the_uom_id,
	attribute = the_attribute,
	advertising_id = the_advertising_id,
	ingredients = the_ingredients,
	ingredients_id = the_ingredients_id,
	preservation_info = the_preservation_info,
	preservation_info_id = the_preservation_info_id,
	extra_field1 = the_extra_field1,
	extra_field2 = the_extra_field2,
	image_id = the_image_id,
	icon_id = the_icon_id,
	lot = the_lot,
	born_country = the_born_country,
	fatten_country = the_fatten_country,
	origin_country = the_origin_country,
	manufacturer_id = the_manufacturer_id,
	packer_id = the_packer_id,
	distributor_id = the_distributor_id,
	importer_id = the_importer_id,
	exporter_id = the_exporter_id,
	vendor_id = the_vendor_id,
	cutting_hall_id = the_cutting_hall_id,
	slaughter_house_id = the_slaughter_house_id,
	supplier_id = the_supplier_id,
	nut_info_set_id = the_nut_info_set_id,
	print_fix_primary_barcode = the_print_fix_primary_barcode,
	print_fix_secondary_barcode = the_print_fix_secondary_barcode
    WHERE product_id = the_product_id;
  END;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product(bigint, character,  character varying, character varying, character varying, character varying, character varying, bigint, bigint, character varying, character varying, character, numeric, character, character varying, character, character varying, integer, integer, numeric, integer, time without time zone, integer, numeric, character, integer, numeric, double precision, double precision, character varying, character varying, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character, character)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character,  character varying, character varying,  character varying, character varying, character varying, bigint, bigint, character varying, character varying, character, numeric, character, character varying, character, character varying, integer, integer, numeric, integer, time without time zone, integer, numeric, character, integer, numeric, double precision, double precision, character varying, character varying, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character, character) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product(bigint, character,  character varying, character varying,  character varying, character varying, character varying, bigint, bigint, character varying, character varying, character, numeric, character, character varying, character, character varying, integer, integer, numeric, integer, time without time zone, integer, numeric, character, integer, numeric, double precision, double precision, character varying, character varying, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character, character) TO public;





-- Function: public.merge_product_price(character varying, bigint, double precision)

-- DROP FUNCTION public.merge_product_price(character varying, bigint, double precision);

CREATE OR REPLACE FUNCTION public.merge_product_price(
    the_pricelist_version_id character varying,
    the_product_id bigint,
    the_price double precision)
  RETURNS void AS
$BODY$

BEGIN


    PERFORM merge_price_list(the_pricelist_version_id);


    UPDATE productprice SET 
	pricelist = the_price, 
            pricestd = the_price, 
            pricelimit = the_price, 
            cost = the_price,
        --updated = LOCALTIMESTAMP, 
	updatedby = 'importacion'
    WHERE pricelist_version_id =  the_pricelist_version_id
            AND product_id = the_product_id;
    IF FOUND THEN
      RETURN;
    END IF;
    -- Not found, try insert and check exceptions in case someone inserted
    -- the same key concurrently as we speak
    BEGIN
    
   INSERT INTO productprice(
            productprice_id, 
            pricelist_version_id, 
            product_id, 
            isactive, 
            created, 
            createdby, 
            updated, 
            updatedby, 
            pricelist, 
            pricestd, 
            pricelimit, 
            cost)
    VALUES (
    (select get_uuid()), 
    the_pricelist_version_id, 
    the_product_id, 
    'Y', 
     LOCALTIMESTAMP,
    'importacion',
     LOCALTIMESTAMP,
    'importacion',
     the_price, 
     the_price, 
     the_price, 
     the_price);

    EXCEPTION WHEN unique_violation THEN
      -- do nothing; just loop back to the UPDATE
    END;

END;


$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product_price(character varying, bigint, double precision)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product_price(character varying, bigint, double precision) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product_price(character varying, bigint, double precision) TO public;


-- Function: public.merge_product_price(character varying, bigint, double precision)

-- DROP FUNCTION public.merge_product_price(character varying, bigint, double precision);

CREATE OR REPLACE FUNCTION public.merge_product_price(
    the_pricelist_version_id character varying,
    the_product_id bigint,
    the_price double precision,
    the_user character varying)
  RETURNS void AS
$BODY$

BEGIN


    PERFORM merge_price_list(the_pricelist_version_id);


    UPDATE productprice SET 
	pricelist = the_price, 
            pricestd = the_price, 
            pricelimit = the_price, 
            cost = the_price,
        --updated = LOCALTIMESTAMP, 
	updatedby = the_user
    WHERE pricelist_version_id =  the_pricelist_version_id
            AND product_id = the_product_id;
    IF FOUND THEN
      RETURN;
    END IF;
    -- Not found, try insert and check exceptions in case someone inserted
    -- the same key concurrently as we speak
    BEGIN
    
   INSERT INTO productprice(
            productprice_id, 
            pricelist_version_id, 
            product_id, 
            isactive, 
            created, 
            createdby, 
            updated, 
            updatedby, 
            pricelist, 
            pricestd, 
            pricelimit, 
            cost)
    VALUES (
    (select get_uuid()), 
    the_pricelist_version_id, 
    the_product_id, 
    'Y', 
     LOCALTIMESTAMP,
    the_user,
     LOCALTIMESTAMP,
    the_user,
     the_price, 
     the_price, 
     the_price, 
     the_price);

    EXCEPTION WHEN unique_violation THEN
      -- do nothing; just loop back to the UPDATE
    END;

END;


$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.merge_product_price(character varying, bigint, double precision, character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product_price(character varying, bigint, double precision, character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_product_price(character varying, bigint, double precision, character varying) TO public;


-- Function: public.valid_barcode(text)

-- DROP FUNCTION public.valid_barcode(text);

CREATE OR REPLACE FUNCTION public.valid_barcode(barcode text)
  RETURNS text AS
$BODY$
 DECLARE
   b text;
   odd int;
   even int;
   s int;
   chk int;
   res text;
 BEGIN
   IF LENGTH(barcode) < 12 THEN
      -- b = to_char(barcode, '000000000000'); 
      b = lpad(barcode, 12, '0');
   ELSE
       b = barcode;
   END IF;
   -- normalize UPC and EAN to both be 13 digits
--   IF LENGTH(barcode) = 12 THEN
--     b = '0' || barcode;
--   ELSE
    -- b = barcode;
  -- END IF;
   -- sum of odd digits times 3, plus sum of even digits

   
   even =  CAST(SUBSTR(b, 1, 1) AS int) + 
           CAST(SUBSTR(b, 3, 1) AS int) +
           CAST(SUBSTR(b, 5, 1) AS int) + 
           CAST(SUBSTR(b, 7, 1) AS int) +
           CAST(SUBSTR(b, 9, 1) AS int) + 
           CAST(SUBSTR(b, 11, 1) AS int);
           
   odd =   CAST(SUBSTR(b, 2, 1) AS int) + 
           CAST(SUBSTR(b, 4, 1) AS int) +
           CAST(SUBSTR(b, 6, 1) AS int) + 
           CAST(SUBSTR(b, 8, 1) AS int) +
           CAST(SUBSTR(b, 10, 1) AS int) + 
           CAST(SUBSTR(b, 12, 1) AS int);
   
   s = (3 * odd) + even;
   
  chk = (10 - (s % 10)) % 10;
    
   -- remainder to nearest 10 should be same as last check digit
--   IF (CAST((CEIL(CAST(s AS float8) / 10) * 10) AS int) % s) =
-- CAST(SUBSTR(b, 13, 1) AS int) THEN
--     return true;
--   ELSE
--     return false;
--   END IF;
 res = b||chk;
return res;
 END;
 $BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.valid_barcode(text)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.valid_barcode(text) TO systel;
GRANT EXECUTE ON FUNCTION public.valid_barcode(text) TO public;


-- Function: public.vendor_login(character varying, character)

-- DROP FUNCTION public.vendor_login(character varying, character);

CREATE OR REPLACE FUNCTION public.vendor_login(
    p_user_id character varying,
    p_isactive character)
  RETURNS void AS
$BODY$
begin
    UPDATE tb_user set isactive = p_isactive where user_id = p_user_id;
end
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION public.vendor_login(character varying, character)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.vendor_login(character varying, character) TO systel;
GRANT EXECUTE ON FUNCTION public.vendor_login(character varying, character) TO public;


IF EXISTS (select 1 from product where (tax_id <> '') IS NOT TRUE  )  THEN
	update public.product set tax_id = '@' where (tax_id <> '') IS NOT TRUE ;
END IF;


IF EXISTS (select 1 from public.product where attribute = 1 AND uom_id <> '2')  THEN
	update public.product set uom_id = '2' where attribute = 1;
END IF;



IF EXISTS (select 1 from systel.calibration where LOWER(unimedi) = 'kg')  THEN
	IF EXISTS (select 1 from public.product where attribute = 0 AND uom_id <> '1')  THEN
		update public.product set uom_id = '1' where attribute = 0;
	END IF;
ELSIF EXISTS (select 1 from systel.calibration where LOWER(unimedi) = 'lb')  THEN
	IF EXISTS (select 1 from public.product where attribute = 0 AND uom_id <> '3')  THEN
		update public.product set uom_id = '3' where attribute = 0;
	END IF;
--ELSE
--	update public.product set uom_id = '1' where attribute = 0;
END IF;



end
$$



