
do $$
begin

CREATE OR REPLACE FUNCTION public.merge_mgv_department(the_department_id bigint, the_name character varying)
 RETURNS void
AS $BODY$
                            
BEGIN
  BEGIN
      INSERT INTO department(
            department_id, 
            isactive, 
            created, 
            createdby, 
            updated, 
            updatedby, 
            name, 
            tax_id, 
            warehouse_id)
    VALUES (
    the_department_id, 
    'Y', 
    LOCALTIMESTAMP,
    'importacion',
    LOCALTIMESTAMP,
    'importacion',
    the_name, 
    NULL, 
    NULL
    );
    EXCEPTION WHEN unique_violation THEN

    END;
END;
$BODY$
 LANGUAGE plpgsql VOLATILE
  COST 100;
  
ALTER FUNCTION public.merge_mgv_department(bigint, character varying)
  OWNER TO systel;
GRANT EXECUTE ON FUNCTION public.merge_mgv_department(bigint, character varying) TO systel;
GRANT EXECUTE ON FUNCTION public.merge_mgv_department(bigint, character varying) TO public;


CREATE TABLE IF NOT EXISTS public.access
(
  access_id character varying(32) NOT NULL,
  role_id character varying(32) NOT NULL,
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar,
  created timestamp without time zone NOT NULL DEFAULT now(),
  createdby character varying(32) NOT NULL,
  updated timestamp without time zone NOT NULL DEFAULT now(),
  updatedby character varying(32) NOT NULL,
  config character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_gral character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_profile character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_format_print character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_codebar character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_calibration character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_overweight character(1) NOT NULL DEFAULT 'N'::bpchar,
  config_backup character(1) NOT NULL DEFAULT 'N'::bpchar,
  product character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_products character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_fast_load character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_shortcut character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_department character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_group character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_ingridient character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_conservation character(1) NOT NULL DEFAULT 'N'::bpchar,
  product_tax character(1) NOT NULL DEFAULT 'N'::bpchar,
  importer character(1) NOT NULL DEFAULT 'N'::bpchar,
  prices character(1) NOT NULL DEFAULT 'N'::bpchar,
  prices_list character(1) NOT NULL DEFAULT 'N'::bpchar,
  prices_quick_update character(1) NOT NULL DEFAULT 'N'::bpchar,
  advertising character(1) NOT NULL DEFAULT 'N'::bpchar,
  users character(1) NOT NULL DEFAULT 'N'::bpchar,
  locations character(1) NOT NULL DEFAULT 'N'::bpchar,
  locations_currency character(1) NOT NULL DEFAULT 'N'::bpchar,
  locations_countrie character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_day character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_seller character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_plu character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_close_sales character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_cancel character(1) NOT NULL DEFAULT 'N'::bpchar,
  reports_vta_total character(1) NOT NULL DEFAULT 'N'::bpchar,
  images character(1) NOT NULL DEFAULT 'N'::bpchar,
  roles character(1) NOT NULL DEFAULT 'N'::bpchar,
  role_name character varying(60),
  CONSTRAINT access_key PRIMARY KEY (access_id),
  CONSTRAINT access_role_fkey FOREIGN KEY (role_id)
      REFERENCES role (role_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT role_name_fkey FOREIGN KEY (role_name)
      REFERENCES role (name) MATCH SIMPLE
      ON UPDATE CASCADE ON DELETE CASCADE
)
WITH (
  OIDS=FALSE
);
ALTER TABLE access
  OWNER TO systel;
GRANT ALL ON TABLE access TO systel;
GRANT ALL ON TABLE access TO admin;
GRANT ALL ON TABLE access TO read;
GRANT ALL ON TABLE access TO public;

-- Index: fki_access_role_id
 DROP INDEX fki_access_role_id;

CREATE INDEX fki_access_role_id
  ON access
  USING btree
  (role_id COLLATE pg_catalog."default" varchar_ops);


ALTER TABLE public.discount_schema ALTER COLUMN name TYPE character varying(120);




ALTER TABLE public.discount_schema_line ALTER COLUMN limit_minamt TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN limit_maxamt TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN limit_fixed TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN limit_margin TYPE numeric(20, 6);
ALTER TABLE public.discount_schema_line ALTER COLUMN rate TYPE numeric(20, 6);




ALTER TABLE public.product ALTER COLUMN barcode_item_code TYPE numeric(20,0);

IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='product' and column_name='ir_id')  THEN
    ALTER TABLE public.product
    ADD COLUMN ir_id character varying(255);
END IF;  

ALTER TABLE public.product
   ALTER COLUMN ir_id TYPE character varying(255); 

IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='product' and column_name='ir_group')  THEN
    ALTER TABLE public.product
    ADD COLUMN ir_group character varying(255);
END IF; 

IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='product' and column_name='gtin_code')  THEN
    ALTER TABLE public.product
    ADD COLUMN gtin_code character varying(255);
END IF;



CREATE TABLE IF NOT EXISTS public.role
(
  role_id character varying(32) NOT NULL, -- Identificador unico de registro de roles.
  isactive character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Describe si el registro se encuentra activo.
  created timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora en que el registro fue creado.
  createdby character varying(32) NOT NULL, -- Describe al usuario que creo el registro de rol.
  updated timestamp without time zone NOT NULL DEFAULT now(), -- Fecha y hora de la última actualización del registro.
  name character varying(60) NOT NULL, -- Nombre del rol.
  updatedby character varying(32) NOT NULL, -- Describe al usuario que actualizó por última vez el registro.
  description character varying(255), -- Descripción del rol creado.
  userlevel character varying(60) NOT NULL DEFAULT '  O'::character varying, -- Nivel de usuario.
  tree_menu_id character varying(32), -- Identificador dentro del árbol establecido.
  ismanual character(1) DEFAULT 'N'::bpchar, -- No se encuentra en uso.
  processing character(1), -- No se encuentra en uso.
  is_client_admin character(1) NOT NULL, -- Define si es un rol con permisos de administrador.
  isadvanced character(1) NOT NULL DEFAULT 'Y'::bpchar, -- Describe si el rol posee permisos avanzados.
  CONSTRAINT role_key PRIMARY KEY (role_id),
  CONSTRAINT role_name_un UNIQUE (name),
  CONSTRAINT role_adv_check CHECK (isadvanced = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT role_isactive_check CHECK (isactive = ANY (ARRAY['Y'::bpchar, 'N'::bpchar])),
  CONSTRAINT role_isclientadmin_check CHECK (is_client_admin = ANY (ARRAY['Y'::bpchar, 'N'::bpchar]))
)
WITH (
  OIDS=FALSE
);
ALTER TABLE role
  OWNER TO systel;
GRANT ALL ON TABLE role TO systel;
GRANT ALL ON TABLE role TO admin;
GRANT ALL ON TABLE role TO read;
GRANT ALL ON TABLE role TO public;
COMMENT ON COLUMN role.role_id IS 'Identificador unico de registro de roles.';
COMMENT ON COLUMN role.isactive IS 'Describe si el registro se encuentra activo.';
COMMENT ON COLUMN role.created IS 'Fecha y hora en que el registro fue creado.';
COMMENT ON COLUMN role.createdby IS 'Describe al usuario que creo el registro de rol.';
COMMENT ON COLUMN role.updated IS 'Fecha y hora de la última actualización del registro.';
COMMENT ON COLUMN role.name IS 'Nombre del rol.';
COMMENT ON COLUMN role.updatedby IS 'Describe al usuario que actualizó por última vez el registro.';
COMMENT ON COLUMN role.description IS 'Descripción del rol creado.';
COMMENT ON COLUMN role.userlevel IS 'Nivel de usuario.';
COMMENT ON COLUMN role.tree_menu_id IS 'Identificador dentro del árbol establecido.';
COMMENT ON COLUMN role.ismanual IS 'No se encuentra en uso.';
COMMENT ON COLUMN role.processing IS 'No se encuentra en uso.';
COMMENT ON COLUMN role.is_client_admin IS 'Define si es un rol con permisos de administrador.';
COMMENT ON COLUMN role.isadvanced IS 'Describe si el rol posee permisos avanzados.';


IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_schema = 'public' AND table_name='systel_sync_nodes' and column_name='lot')  THEN
	ALTER TABLE public.systel_sync_nodes ADD COLUMN lot character varying(10);
	ALTER TABLE public.systel_sync_nodes ADD COLUMN maceth character varying(32);
	ALTER TABLE public.systel_sync_nodes ADD COLUMN macwifi character varying(32);
END IF;



IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_schema = 'public' AND table_name='tax' and column_name='rate')  THEN
	ALTER TABLE public.tax ALTER COLUMN rate TYPE numeric(20, 6);
	ALTER TABLE public.tax ALTER COLUMN deducpercent TYPE numeric(20, 6);
	ALTER TABLE public.tax ALTER COLUMN originalrate TYPE numeric(20, 6);
END IF;



IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_schema = 'public' AND table_name='tb_user' and column_name='upc')  THEN
	
	ALTER TABLE tb_user ALTER COLUMN upc TYPE character varying(500);

END IF;



--IF EXISTS (select 1 from public.systel_sync_node_models where id = '0') THEN
--    DELETE FROM public.systel_sync_node_models WHERE id = '0';
--END IF;

--IF EXISTS (select 1 from public.systel_sync_node_models where id = '2') THEN
--    DELETE FROM public.systel_sync_node_models WHERE id = '2';
--END IF;

--IF EXISTS (select 1 from public.systel_sync_node_models where id = '3') THEN
--    DELETE FROM public.systel_sync_node_models WHERE id = '3';
--END IF;

IF NOT EXISTS (select 1 from public.systel_sync_node_models where id = '5') THEN
    INSERT INTO public.systel_sync_node_models(id, name, image) VALUES ('5', 'node.models.selfservice', 'selfservice.png');
    INSERT INTO public.systel_sync_node_models(id, name, image) VALUES ('6', 'node.models.modular', 'modular.png');
END IF;


ALTER TABLE public.systel_sync_tables DROP CONSTRAINT systel_sync_tables_pk;


 DELETE FROM public.systel_sync_tables;



INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (1,10,'barcode_format','2023-10-18 14:35:30.009','barcodetype, producttype',0,'SELECT * FROM barcode_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM barcode_format'' ) AS DATA (
  barcodetype character varying(32),
  producttype character(1),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  field_a character varying(50),
  cantidad_a character varying(2),
  value_a character varying(30),
  field_b character varying(50),
  cantidad_b character varying(2),
  value_b character varying(30),
  field_c character varying(50),
  cantidad_c character varying(2),
  value_c character varying(30),
  field_d character varying(50),
  cantidad_d character varying(2),
  value_d character varying(30)
);'),
	 (2,20,'nut_info_set','2023-10-18 14:35:30.009','nut_info_set_id',0,'SELECT * FROM nut_info_set
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_set'' ) AS DATA (
  nut_info_set_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_name character varying(60),
  description character varying(255),
  columns_qty numeric(2,0),
  rows_qty numeric(2,0)
);'),
	 (3,30,'nut_info_element','2023-10-18 14:35:30.009','nut_info_element_id',0,'SELECT * FROM nut_info_element
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_element'' ) AS DATA (
 nut_info_element_id character varying(32),
  isactive character(1) ,
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  value character varying(255),
  hasjoinedrows character varying(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character varying(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer,
  vd numeric,
  uom character varying(20)
);'),
	 (4,31,'discount_schema','2023-10-18 14:35:30.009','discount_id',0,'SELECT * FROM discount_schema
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema'' ) AS DATA (
  discount_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(120),
  description character varying(255),
  type integer,
  mode integer,
  start_date date,
  start_time time without time zone,
  end_date date,
  end_time time without time zone,
  dow_sunday character(1),
  dow_monday character(1),
  dow_tuesday character(1),
  dow_wednesday character(1),
  dow_thursday character(1),
  dow_friday character(1),
  dow_saturday character(1)
);'),
	 (5,32,'discount_schema_line','2023-10-18 14:35:30.009','discount_schema_line_id',0,'SELECT * FROM discount_schema_line
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema_line'' ) AS DATA (
  discount_schema_line_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  discount_schema_id character varying(32),
  source integer,
  limit_minamt numeric(20, 6),
  limit_maxamt numeric(20, 6),
  limit_fixed numeric(20, 6),
  limit_margin numeric(20, 6),
  rate numeric(20, 6)
);'),
	 (6,33,'taxcategory','2023-10-18 14:35:30.009','taxcategory_id',0,'SELECT * FROM taxcategory
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM taxcategory'' ) AS DATA (
  taxcategory_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  isdefault character(1)
);'),
	 (7,34,'tax','2023-10-18 14:35:30.009','tax_id',0,'SELECT * FROM tax
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tax'' ) AS DATA (
  tax_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  taxindicator character varying(5),
  validfrom timestamp without time zone,
  issummary character(1),
  rate numeric(20,6),
  parent_tax_id character varying(32),
  taxcategory_id character varying(32),
  isdefault character(1),
  istaxexempt character(1),
  sopotype character varying(60),
  cascade character(1),
  bp_taxcategory_id character varying(32),
  line numeric,
  iswithholdingtax character(1),
  isnotaxable character(1),
  deducpercent numeric(20,6),
  originalrate numeric(20,6),
  istaxundeductable character(1),
  istaxdeductable character(1),
  isnovat character(1),
  baseamount character varying(60),
  taxbase_id character varying(32),
  doctaxamount character varying(60)
);'),
	 (8,40,'department','2023-10-18 14:35:30.009','department_id',0,'SELECT * FROM department
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM department'' ) AS DATA (
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32),
  warehouse_id character varying(32)
);'),
	 (9,50,'main_group','2023-10-18 14:35:30.009','group_id',0,'SELECT * FROM main_group
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM main_group'' ) AS DATA (
  group_id bigint,
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32)
);'),
	 (10,70,'labels','2023-10-18 14:35:30.009','labels_id',0,'SELECT * FROM labels
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM labels'' ) AS DATA (
  labels_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  label_format_w_di character varying(32),
  label_format_w_pp character varying(32),
  label_format_u_di character varying(32),
  label_format_u_pp character varying(32),
  label_format_w_co character varying(32),
  label_format_w_es character varying(32)
);');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (11,60,'label_format','2023-10-18 14:35:30.009','label_format_id',0,'SELECT * FROM label_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM label_format'' ) AS DATA (
  label_format_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  template character varying,
  type integer
);'),
	 (12,120,'locator','2023-10-18 14:35:30.009','locator_id',0,'SELECT * FROM locator
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM locator'' ) AS DATA (
  locator_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  warehouse_id character varying(32),
  priorityno numeric(10,0),
  isdefault character(1),
  x character varying(60),
  y character varying(60),
  z character varying(60)
);'),
	 (13,140,'warehouse','2023-10-18 14:35:30.009','warehouse_id',0,'SELECT * FROM warehouse
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM warehouse'' ) AS DATA (
  warehouse_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  name character varying(60),
  description character varying(255),
  location_id character varying(32),
  separator character(1),
  isshipper character(1),
  shippercode character varying(20),
  fromdocumentno numeric(10,0),
  todocumentno numeric(10,0),
  returnlocator_id character varying(32)
);'),
	 (14,130,'location','2023-10-18 14:35:30.009','location_id',0,'SELECT * FROM location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM location'' ) AS DATA (
  location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  address1 character varying(60),
  address2 character varying(60),
  city character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  country_id character varying(32),
  region_id character varying(32),
  city_id character varying(32),
  regionname character varying(40)
);'),
	 (15,200,'tb_user','2023-10-18 14:35:30.009','user_id',0,'SELECT * FROM tb_user
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tb_user'' ) AS DATA (
  user_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  password character varying(40),
  email character varying(255),
  supervisor_id character varying(32),
  bpartner_id character varying(32),
  processing character(1),
  emailb_user character varying(40),
  emailb_userpw character varying(40),
  bpartner_location_id character varying(32),
  title character varying(40),
  comments character varying(2000),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  lastcontact timestamp without time zone,
  lastresult character varying(255),
  birthday timestamp without time zone,
  firstname character varying(60),
  lastname character varying(60),
  username character varying(60),
  upc character varying(500),
  default_language character varying(6),
  default_role_id character varying(32),
  default_warehouse_id character varying(32),
  islocked character(1),
  image_id character varying(32)
);'),
	 (16,190,'bpartner_location','2023-10-18 14:35:30.009','bpartner_location_id',0,'SELECT * FROM bpartner_location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner_location'' ) AS DATA (
   bpartner_location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  isbillto character(1),
  isshipto character(1),
  ispayfrom character(1),
  isremitto character(1),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  bpartner_id character varying(32),
  istaxlocation character(1),
  upc character varying(30),
  address1 character varying(60),
  address2 character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  city_id character varying(32),
  region_id character varying(32),
  country_id character varying(32)
);'),
	 (17,110,'city','2023-10-18 14:35:30.009','city_id',0,'SELECT * FROM city
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM city'' ) AS DATA (
   city_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  locode character varying(10),
  coordinates character varying(15),
  postal character varying(10),
  areacode character varying(10),
  country_id character varying(32),
  region_id character varying(32)
);'),
	 (18,90,'country','2023-10-18 14:35:30.009','country_id',0,'SELECT * FROM country
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM country'' ) AS DATA (
  country_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  countrycode character(3),
  hasregion character(1),
  regionname character varying(60),
  expressionphone character varying(20),
  displaysequence character varying(20),
  expressionpostal character varying(20),
  haspostal_add character(1),
  expressionpostal_add character varying(20),
  isdefault character(1),
  ad_language character varying(6),
  currency_id character varying(32),
  ibannodigits numeric,
  ibancountry character varying(2)
);'),
	 (19,290,'productprice','2023-10-18 14:35:30.009','productprice_id',0,'SELECT * FROM productprice
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM productprice'' ) AS DATA (
  productprice_id character varying(32),
  pricelist_version_id character varying(32),
  product_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  pricelist numeric(20,6),
  pricestd numeric(20,6),
  pricelimit numeric(20,6),
  cost numeric(20,6)
);'),
	 (20,220,'pricelist_version','2023-10-18 14:35:30.009','pricelist_version_id',0,'SELECT * FROM pricelist_version
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist_version'' ) AS DATA (
  pricelist_version_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  pricelist_id character varying(32),
  validfrom timestamp without time zone,
  proccreate character(1),
  pricelist_version_base_id character varying(32),
  pricelist_version_generate character(1),
  validto timestamp without time zone,
  isdefault character(1)
);');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (91,150,'locator','2023-10-18 14:35:30.009','locator_id',3,'SELECT locator_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT locator_id FROM locator'' ) AS DATA ( locator_id character varying(32) ) EXCEPT SELECT locator_id FROM locator'),
	 (21,280,'nut_info_el_instance','2023-10-18 14:35:30.009','nut_info_el_instance_id',0,'SELECT * FROM nut_info_el_instance
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_el_instance'' ) AS DATA (
nut_info_el_instance_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  product_id bigint,
  value character varying(255),
  hasjoinedrows character(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer
);'),
	 (22,260,'shortcut_page','2023-10-18 14:35:30.009','shortcutpage_id',0,'SELECT * FROM shortcut_page
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut_page'' ) AS DATA (
  shortcutpage_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  pos integer,
  rows integer,
  cols integer,
  isdefault character(1),
  profile_id character varying(32),
  icon_id character varying(32)
);'),
	 (23,270,'shortcut','2023-10-18 14:35:30.009','shortcut_id',0,'SELECT * FROM shortcut
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut'' ) AS DATA (
  shortcut_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  shortcut_page_id character varying(32),
  product_id bigint,
  name character varying(60),
  "row" integer,
  col integer,
  profile_id character varying(32)
);'),
	 (24,250,'product','2023-10-18 14:35:30.009','product_id',0,'SELECT * FROM product
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM product'' ) AS DATA (
    product_id bigint ,
    isactive character(1) ,
    created timestamp without time zone ,
    createdby character varying(32) ,
    updated timestamp without time zone ,
    updatedby character varying(32) ,
    erp_code character varying(25),
    name character varying(56) ,
    description character varying(255),
    department_id bigint ,
    group_id bigint ,
    label_format_w character varying(32),
    label_format_u character varying(32),
    barcode_item_code_flag character(1),
    barcode_item_code numeric(20,0) ,
    print_primary_barcode character(1) ,
    primary_barcode_type integer,
    primary_barcode_flag_data character varying(255),
    print_secondary_barcode character(1) ,
    secondary_barcode_type integer,
    secondary_barcode_flag_data character varying(255),
    sell_by_date_time integer ,
    sell_by_date_source integer ,
    sell_by_date numeric(2,0),
    sell_time_source integer,
    sell_time time without time zone,
    print_packed_date character(1),
    packed_date_source integer ,
    packed_date numeric(2,0),
    packed_date_format character varying(10),
    print_used_by_date character(1),
    used_by_date_source integer,
    used_by_date numeric(3,0) ,
    unit_price_selection integer,
    tare numeric(20,6),
    perc_tare numeric(20,6),
    quantity numeric(10,0),
    upc character varying(30),
    uom_id character varying(32),
    discount_schema_id character varying(32),
    isstocked character(1),
    isirradiated character(1),
    isbom character(1),
    stock_min numeric(20,6),
    stock_max numeric(20,6),
    versionno character varying(200),
    discontinued character(1),
    discontinuedby timestamp without time zone,
    tax_id character varying(32),
    attribute integer,
    advertising_id character varying(32),
    sto_temp_limit1 numeric(20,6),
    sto_temp_limit2 numeric(20,6),
    ingredients character varying(2000),
    ingredients_id character varying(32),
    preservation_info character varying(2000),
    preservation_info_id character varying(32),
    coupled_product bigint,
    pack_indicator numeric(1,0),
    extra_field1 character varying(2000),
    extra_field2 character varying(2000),
    image_id character varying(32),
    icon_id character varying(32),
    lot character varying(20),
    born_country character varying(32),
    fatten_country character varying(32),
    origin_country character varying(32),
    manufacturer_id character varying(32),
    packer_id character varying(32),
    distributor_id character varying(32),
    importer_id character varying(32),
    exporter_id character varying(32),
    vendor_id character varying(32),
    cutting_hall_id character varying(32),
    slaughter_house_id character varying(32),
    supplier_id character varying(32),
    nut_info_set_id character varying(32),
    print_fix_primary_barcode character(1),
    print_fix_secondary_barcode character(1),
    ir_id character varying(255),
    ir_group character varying(255),
    gtin_code character varying(255)
);'),
	 (25,240,'advertising','2023-10-18 14:35:30.009','advertising_id',0,'SELECT * FROM advertising
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM advertising'' ) AS DATA (
  advertising_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  advertising character varying(255),
  isproductmsgonly character(1),
  isdefault character(1),
  ismedia character(1),
  media_url character varying(2000),
  image_id character varying(32),
  profile_id character varying(32)
);'),
	 (26,230,'profile','2023-10-18 14:35:30.009','profile_id',0,'SELECT * FROM profile
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM profile'' ) AS DATA (
  profile_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(32)
);'),
	 (27,160,'ingredient','2023-10-18 14:35:30.009','ingredient_id',0,'SELECT * FROM ingredient
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM ingredient'' ) AS DATA (
  ingredient_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  ingredients text,
  isdefault character(1)
);'),
	 (28,170,'preservation_info','2023-10-18 14:35:30.009','preservation_info_id',0,'SELECT * FROM preservation_info
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM preservation_info'' ) AS DATA (
  preservation_info_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  info text,
  isdefault character(1),
  image_id character varying(32)
);'),
	 (29,180,'bpartner','2023-10-18 14:35:30.009','bpartner_id',0,'SELECT * FROM bpartner
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner'' ) AS DATA (
  bpartner_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  name2 character varying(60),
  description character varying(255),
  issummary character(1),
  iscustomer character(1),
  isemployee character(1),
  issalesrep character(1),
  ispacker character(1),
  isdistributor character(1),
  isimporter character(1),
  isexporter character(1),
  isvendor character(1),
  iscutting_hall character(1),
  isslaughter_house character(1),
  issupplier character(1),
  referenceno character varying(40),
  duns character(11),
  taxid character varying(20),
  istaxexempt character(1),
  rating character(1),
  salesvolume numeric(10,0),
  naics character(6),
  firstsale timestamp without time zone,
  paymentrule character varying(60),
  creditlimit numeric(20,6),
  creditused numeric(20,6),
  paymentterm_id character varying(32),
  pricelist_id character varying(32),
  isdiscountprinted character(1),
  salesrep_id character varying(32),
  bpartner_parent_id character varying(32),
  upc character varying(30),
  fiscalcode character varying(16),
  isofiscalcode character varying(5),
  image_id character varying(32),
  print_field character varying(2000)
);');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (30,150,'image','2023-10-18 14:35:30.009','image_id',0,'SELECT * FROM image
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM image'' ) AS DATA (
  image_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  imageurl character varying(120),
  binarydata bytea,
  width numeric(10,0),
  height numeric(10,0),
  isproducticon character(1),
  isproductimage character(1),
  issupplierimage character(1),
  isrsiimage character(1),
  mimetype character varying(255),
  isadvertisingimage character(1),
  iscompanyimage character(1),
  ispreserveimage character(1)
);'),
	 (31,210,'pricelist','2023-10-18 14:35:30.009','pricelist_id',0,'SELECT * FROM pricelist
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist'' ) AS DATA (
  pricelist_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  basepricelist_id character varying(32),
  istaxincluded character(1),
  issopricelist character(1),
  isdefault character(1),
  currency_id character varying(32),
  enforcepricelimit character(1),
  costbased character(1)
);'),
	 (32,100,'region','2023-10-18 14:35:30.009','region_id',0,'SELECT * FROM region
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM region'' ) AS DATA (
  region_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  country_id character varying(32),
  isdefault character(1),
  value character(5)
);'),
	 (33,80,'currency','2023-10-18 14:35:30.009','currency_id',0,'SELECT * FROM currency
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM currency'' ) AS DATA (
  currency_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  iso_code character(3),
  cursymbol character varying(10),
  description character varying(255),
  stdprecision integer,
  costingprecision integer,
  priceprecision integer,
  issymbolrightside character(1)
);'),
	 (34,195,'role','2023-10-18 14:35:30.009','role_id',0,'SELECT * FROM role
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM role'' ) AS DATA (
  role_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  name character varying(60),
  updatedby character varying(32),
  description character varying(255),
  userlevel character varying(60),
  tree_menu_id character varying(32),
  ismanual character(1),
  processing character(1),
  is_client_admin character(1),
  isadvanced character(1)
);'),
	 (35,300,'access','2023-10-18 14:35:30.009','access_id',0,'SELECT * FROM access
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM access'' ) AS DATA (
  access_id character varying(32),
  role_id character varying(32),
  isactive character(1) ,
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  config character(1),
  config_gral character(1),
  config_profile character(1),
  config_format_print character(1),
  config_codebar character(1),
  config_calibration character(1),
  config_overweight character(1),
  config_backup character(1),
  product character(1),
  product_products character(1),
  product_fast_load character(1),
  product_shortcut character(1),
  product_department character(1),
  product_group character(1),
  product_ingridient character(1),
  product_conservation character(1),
  product_tax character(1),
  importer character(1),
  prices character(1),
  prices_list character(1),
  prices_quick_update character(1),
  advertising character(1),
  users character(1),
  locations character(1),
  locations_currency character(1),
  locations_countrie character(1),
  reports character(1),
  reports_vta_day character(1),
  reports_vta_seller character(1),
  reports_vta_plu character(1),
  reports_vta_close_sales character(1),
  reports_vta_cancel character(1),
  reports_vta_total character(1),
  images character(1),
  roles character(1),
  role_name character varying(60)
);'),
	 (36,10,'barcode_format','2023-10-18 14:35:30.009','barcodetype, producttype',2,'SELECT * FROM barcode_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM barcode_format'' ) AS DATA (
  barcodetype character varying(32),
  producttype character(1),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  field_a character varying(50),
  cantidad_a character varying(2),
  value_a character varying(30),
  field_b character varying(50),
  cantidad_b character varying(2),
  value_b character varying(30),
  field_c character varying(50),
  cantidad_c character varying(2),
  value_c character varying(30),
  field_d character varying(50),
  cantidad_d character varying(2),
  value_d character varying(30)
);'),
	 (37,20,'nut_info_set','2023-10-18 14:35:30.009','nut_info_set_id',2,'SELECT * FROM nut_info_set
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_set'' ) AS DATA (
  nut_info_set_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_name character varying(60),
  description character varying(255),
  columns_qty numeric(2,0),
  rows_qty numeric(2,0)
);'),
	 (38,30,'nut_info_element','2023-10-18 14:35:30.009','nut_info_element_id',2,'SELECT * FROM nut_info_element
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_element'' ) AS DATA (
 nut_info_element_id character varying(32),
  isactive character(1) ,
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  value character varying(255),
  hasjoinedrows character varying(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character varying(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer,
  vd numeric,
  uom character varying(20)
);'),
	 (39,31,'discount_schema','2023-10-18 14:35:30.009','discount_id',2,'SELECT * FROM discount_schema
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema'' ) AS DATA (
  discount_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(120),
  description character varying(255),
  type integer,
  mode integer,
  start_date date,
  start_time time without time zone,
  end_date date,
  end_time time without time zone,
  dow_sunday character(1),
  dow_monday character(1),
  dow_tuesday character(1),
  dow_wednesday character(1),
  dow_thursday character(1),
  dow_friday character(1),
  dow_saturday character(1)
);');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (92,160,'warehouse','2023-10-18 14:35:30.009','warehouse_id',3,'SELECT warehouse_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT warehouse_id FROM warehouse'' ) AS DATA ( warehouse_id character varying(32) ) EXCEPT SELECT warehouse_id FROM warehouse'),
	 (40,32,'discount_schema_line','2023-10-18 14:35:30.009','discount_schema_line_id',2,'SELECT * FROM discount_schema_line
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM discount_schema_line'' ) AS DATA (
  discount_schema_line_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  discount_schema_id character varying(32),
  source integer,
  limit_minamt numeric(20,6),
  limit_maxamt numeric(20,6),
  limit_fixed numeric(20,6),
  limit_margin numeric(20,6),
  rate numeric(20,6)
);'),
	 (41,33,'taxcategory','2023-10-18 14:35:30.009','taxcategory_id',2,'SELECT * FROM taxcategory
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM taxcategory'' ) AS DATA (
  taxcategory_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  isdefault character(1)
);'),
	 (42,34,'tax','2023-10-18 14:35:30.009','tax_id',2,'SELECT * FROM tax
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tax'' ) AS DATA (
  tax_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  taxindicator character varying(5),
  validfrom timestamp without time zone,
  issummary character(1),
  rate numeric(20,6),
  parent_tax_id character varying(32),
  taxcategory_id character varying(32),
  isdefault character(1),
  istaxexempt character(1),
  sopotype character varying(60),
  cascade character(1),
  bp_taxcategory_id character varying(32),
  line numeric,
  iswithholdingtax character(1),
  isnotaxable character(1),
  deducpercent numeric(20,6),
  originalrate numeric(20,6),
  istaxundeductable character(1),
  istaxdeductable character(1),
  isnovat character(1),
  baseamount character varying(60),
  taxbase_id character varying(32),
  doctaxamount character varying(60)
);'),
	 (43,40,'department','2023-10-18 14:35:30.009','department_id',2,'SELECT * FROM department
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM department'' ) AS DATA (
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32),
  warehouse_id character varying(32)
);'),
	 (44,50,'main_group','2023-10-18 14:35:30.009','group_id',2,'SELECT * FROM main_group
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM main_group'' ) AS DATA (
  group_id bigint,
  department_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(56),
  tax_id character varying(32)
);'),
	 (45,70,'labels','2023-10-18 14:35:30.009','labels_id',2,'SELECT * FROM labels
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM labels'' ) AS DATA (
  labels_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  label_format_w_di character varying(32),
  label_format_w_pp character varying(32),
  label_format_u_di character varying(32),
  label_format_u_pp character varying(32),
  label_format_w_co character varying(32),
  label_format_w_es character varying(32)
);'),
	 (46,60,'label_format','2023-10-18 14:35:30.009','label_format_id',2,'SELECT * FROM label_format
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM label_format'' ) AS DATA (
  label_format_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  template character varying,
  type integer
);'),
	 (47,80,'currency','2023-10-18 14:35:30.009','currency_id',2,'SELECT * FROM currency
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM currency'' ) AS DATA (
  currency_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  iso_code character(3),
  cursymbol character varying(10),
  description character varying(255),
  stdprecision integer,
  costingprecision integer,
  priceprecision integer,
  issymbolrightside character(1)
);'),
	 (48,90,'country','2023-10-18 14:35:30.009','country_id',2,'SELECT * FROM country
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM country'' ) AS DATA (
  country_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  countrycode character(3),
  hasregion character(1),
  regionname character varying(60),
  expressionphone character varying(20),
  displaysequence character varying(20),
  expressionpostal character varying(20),
  haspostal_add character(1),
  expressionpostal_add character varying(20),
  isdefault character(1),
  ad_language character varying(6),
  currency_id character varying(32),
  ibannodigits numeric,
  ibancountry character varying(2)
);');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (49,100,'region','2023-10-18 14:35:30.009','region_id',2,'SELECT * FROM region
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM region'' ) AS DATA (
  region_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  country_id character varying(32),
  isdefault character(1),
  value character(5)
);'),
	 (50,110,'city','2023-10-18 14:35:30.009','city_id',2,'SELECT * FROM city
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM city'' ) AS DATA (
   city_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  locode character varying(10),
  coordinates character varying(15),
  postal character varying(10),
  areacode character varying(10),
  country_id character varying(32),
  region_id character varying(32)
);'),
	 (93,170,'shortcut_page','2023-10-18 14:35:30.009','shortcutpage_id',3,'SELECT shortcutpage_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT shortcutpage_id FROM shortcut_page'' ) AS DATA ( shortcutpage_id character varying(32) ) EXCEPT SELECT shortcutpage_id FROM shortcut_page'),
	 (51,120,'locator','2023-10-18 14:35:30.009','locator_id',2,'SELECT * FROM locator
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM locator'' ) AS DATA (
  locator_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  warehouse_id character varying(32),
  priorityno numeric(10,0),
  isdefault character(1),
  x character varying(60),
  y character varying(60),
  z character varying(60)
);
'),
	 (52,130,'location','2023-10-18 14:35:30.009','location_id',2,'SELECT * FROM location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM location'' ) AS DATA (
  location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  address1 character varying(60),
  address2 character varying(60),
  city character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  country_id character varying(32),
  region_id character varying(32),
  city_id character varying(32),
  regionname character varying(40)
);'),
	 (53,140,'warehouse','2023-10-18 14:35:30.009','warehouse_id',2,'SELECT * FROM warehouse
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM warehouse'' ) AS DATA (
  warehouse_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  value character varying(40),
  name character varying(60),
  description character varying(255),
  location_id character varying(32),
  separator character(1),
  isshipper character(1),
  shippercode character varying(20),
  fromdocumentno numeric(10,0),
  todocumentno numeric(10,0),
  returnlocator_id character varying(32)
);'),
	 (54,150,'image','2023-10-18 14:35:30.009','image_id',2,'SELECT * FROM image
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM image'' ) AS DATA (
  image_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  imageurl character varying(120),
  binarydata bytea,
  width numeric(10,0),
  height numeric(10,0),
  isproducticon character(1),
  isproductimage character(1),
  issupplierimage character(1),
  isrsiimage character(1),
  mimetype character varying(255),
  isadvertisingimage character(1),
  iscompanyimage character(1),
  ispreserveimage character(1)
);'),
	 (55,160,'ingredient','2023-10-18 14:35:30.009','ingredient_id',2,'SELECT * FROM ingredient
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM ingredient'' ) AS DATA (
  ingredient_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  ingredients text,
  isdefault character(1)
);'),
	 (56,170,'preservation_info','2023-10-18 14:35:30.009','preservation_info_id',2,'SELECT * FROM preservation_info
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM preservation_info'' ) AS DATA (
  preservation_info_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  info text,
  isdefault character(1),
  image_id character varying(32)
);'),
	 (57,180,'bpartner','2023-10-18 14:35:30.009','bpartner_id',2,'SELECT * FROM bpartner
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner'' ) AS DATA (
  bpartner_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  name2 character varying(60),
  description character varying(255),
  issummary character(1),
  iscustomer character(1),
  isemployee character(1),
  issalesrep character(1),
  ispacker character(1),
  isdistributor character(1),
  isimporter character(1),
  isexporter character(1),
  isvendor character(1),
  iscutting_hall character(1),
  isslaughter_house character(1),
  issupplier character(1),
  referenceno character varying(40),
  duns character(11),
  taxid character varying(20),
  istaxexempt character(1),
  rating character(1),
  salesvolume numeric(10,0),
  naics character(6),
  firstsale timestamp without time zone,
  paymentrule character varying(60),
  creditlimit numeric(20,6),
  creditused numeric(20,6),
  paymentterm_id character varying(32),
  pricelist_id character varying(32),
  isdiscountprinted character(1),
  salesrep_id character varying(32),
  bpartner_parent_id character varying(32),
  upc character varying(30),
  fiscalcode character varying(16),
  isofiscalcode character varying(5),
  image_id character varying(32),
  print_field character varying(2000)
);');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (58,190,'bpartner_location','2023-10-18 14:35:30.009','bpartner_location_id',2,'SELECT * FROM bpartner_location
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM bpartner_location'' ) AS DATA (
   bpartner_location_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  isbillto character(1),
  isshipto character(1),
  ispayfrom character(1),
  isremitto character(1),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  bpartner_id character varying(32),
  istaxlocation character(1),
  upc character varying(30),
  address1 character varying(60),
  address2 character varying(60),
  postal character varying(10),
  postal_add character varying(10),
  city_id character varying(32),
  region_id character varying(32),
  country_id character varying(32)
);'),
	 (59,195,'role','2023-10-18 14:35:30.009','role_id',2,'SELECT * FROM role
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM role'' ) AS DATA (
  role_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  name character varying(60),
  updatedby character varying(32),
  description character varying(255),
  userlevel character varying(60),
  tree_menu_id character varying(32),
  ismanual character(1),
  processing character(1),
  is_client_admin character(1),
  isadvanced character(1)
);'),
	 (94,180,'profile','2023-10-18 14:35:30.009','profile_id',3,'SELECT profile_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT profile_id FROM profile'' ) AS DATA ( profile_id character varying(32) ) EXCEPT SELECT profile_id FROM profile'),
	 (60,200,'tb_user','2023-10-18 14:35:30.009','user_id',2,'SELECT * FROM tb_user
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM tb_user'' ) AS DATA (
  user_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  password character varying(40),
  email character varying(255),
  supervisor_id character varying(32),
  bpartner_id character varying(32),
  processing character(1),
  emailb_user character varying(40),
  emailb_userpw character varying(40),
  bpartner_location_id character varying(32),
  title character varying(40),
  comments character varying(2000),
  phone character varying(40),
  phone2 character varying(40),
  fax character varying(40),
  lastcontact timestamp without time zone,
  lastresult character varying(255),
  birthday timestamp without time zone,
  firstname character varying(60),
  lastname character varying(60),
  username character varying(60),
  upc character varying(500),
  default_language character varying(6),
  default_role_id character varying(32),
  default_warehouse_id character varying(32),
  islocked character(1),
  image_id character varying(32)
);'),
	 (61,210,'pricelist','2023-10-18 14:35:30.009','pricelist_id',2,'SELECT * FROM pricelist
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist'' ) AS DATA (
  pricelist_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  basepricelist_id character varying(32),
  istaxincluded character(1),
  issopricelist character(1),
  isdefault character(1),
  currency_id character varying(32),
  enforcepricelimit character(1),
  costbased character(1)
);'),
	 (62,220,'pricelist_version','2023-10-18 14:35:30.009','pricelist_version_id',2,'SELECT * FROM pricelist_version
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM pricelist_version'' ) AS DATA (
  pricelist_version_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  description character varying(255),
  pricelist_id character varying(32),
  validfrom timestamp without time zone,
  proccreate character(1),
  pricelist_version_base_id character varying(32),
  pricelist_version_generate character(1),
  validto timestamp without time zone,
  isdefault character(1)
);'),
	 (63,230,'profile','2023-10-18 14:35:30.009','profile_id',2,'SELECT * FROM profile
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM profile'' ) AS DATA (
  profile_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(32)
);'),
	 (64,240,'advertising','2023-10-18 14:35:30.009','advertising_id',2,'SELECT * FROM advertising
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM advertising'' ) AS DATA (
  advertising_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  advertising character varying(255),
  isproductmsgonly character(1),
  isdefault character(1),
  ismedia character(1),
  media_url character varying(2000),
  image_id character varying(32),
  profile_id character varying(32)
);'),
	 (65,250,'product','2023-10-18 14:35:30.009','product_id',2,'SELECT * FROM product
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM product'' ) AS DATA (
    product_id bigint ,
    isactive character(1) ,
    created timestamp without time zone ,
    createdby character varying(32) ,
    updated timestamp without time zone ,
    updatedby character varying(32) ,
    erp_code character varying(25),
    name character varying(56) ,
    description character varying(255),
    department_id bigint ,
    group_id bigint ,
    label_format_w character varying(32),
    label_format_u character varying(32),
    barcode_item_code_flag character(1),
    barcode_item_code numeric(20,0) ,
    print_primary_barcode character(1) ,
    primary_barcode_type integer,
    primary_barcode_flag_data character varying(255),
    print_secondary_barcode character(1) ,
    secondary_barcode_type integer,
    secondary_barcode_flag_data character varying(255),
    sell_by_date_time integer ,
    sell_by_date_source integer ,
    sell_by_date numeric(2,0),
    sell_time_source integer,
    sell_time time without time zone,
    print_packed_date character(1),
    packed_date_source integer ,
    packed_date numeric(2,0),
    packed_date_format character varying(10),
    print_used_by_date character(1),
    used_by_date_source integer,
    used_by_date numeric(3,0) ,
    unit_price_selection integer,
    tare numeric(20,6),
    perc_tare numeric(20,6),
    quantity numeric(10,0),
    upc character varying(30),
    uom_id character varying(32),
    discount_schema_id character varying(32),
    isstocked character(1),
    isirradiated character(1),
    isbom character(1),
    stock_min numeric(20,6),
    stock_max numeric(20,6),
    versionno character varying(200),
    discontinued character(1),
    discontinuedby timestamp without time zone,
    tax_id character varying(32),
    attribute integer,
    advertising_id character varying(32),
    sto_temp_limit1 numeric(20,6),
    sto_temp_limit2 numeric(20,6),
    ingredients character varying(2000),
    ingredients_id character varying(32),
    preservation_info character varying(2000),
    preservation_info_id character varying(32),
    coupled_product bigint,
    pack_indicator numeric(1,0),
    extra_field1 character varying(2000),
    extra_field2 character varying(2000),
    image_id character varying(32),
    icon_id character varying(32),
    lot character varying(20),
    born_country character varying(32),
    fatten_country character varying(32),
    origin_country character varying(32),
    manufacturer_id character varying(32),
    packer_id character varying(32),
    distributor_id character varying(32),
    importer_id character varying(32),
    exporter_id character varying(32),
    vendor_id character varying(32),
    cutting_hall_id character varying(32),
    slaughter_house_id character varying(32),
    supplier_id character varying(32),
    nut_info_set_id character varying(32),
    print_fix_primary_barcode character(1),
    print_fix_secondary_barcode character(1),
    ir_id character varying(255),
    ir_group character varying(255),
    gtin_code character varying(255)
);'),
	 (66,260,'shortcut_page','2023-10-18 14:35:30.009','shortcutpage_id',2,'SELECT * FROM shortcut_page
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut_page'' ) AS DATA (
  shortcutpage_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  name character varying(60),
  pos integer,
  rows integer,
  cols integer,
  isdefault character(1),
  profile_id character varying(32),
  icon_id character varying(32)
);
');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (67,270,'shortcut','2023-10-18 14:35:30.009','shortcut_id',2,'SELECT * FROM shortcut
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM shortcut'' ) AS DATA (
  shortcut_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  shortcut_page_id character varying(32),
  product_id bigint,
  name character varying(60),
  "row" integer,
  col integer,
  profile_id character varying(32)
);'),
	 (68,280,'nut_info_el_instance','2023-10-18 14:35:30.009','nut_info_el_instance_id',2,'SELECT * FROM nut_info_el_instance
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM nut_info_el_instance'' ) AS DATA (
nut_info_el_instance_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  nut_info_set_id character varying(32),
  product_id bigint,
  value character varying(255),
  hasjoinedrows character(1),
  pos_row numeric(2,0),
  pos_rowto numeric(2,0),
  hasjoinedcolumns character(1),
  pos_column numeric(2,0),
  pos_columnto numeric(2,0),
  alignment integer
);'),
	 (69,290,'productprice','2023-10-18 14:35:30.009','productprice_id',2,'SELECT * FROM productprice
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM productprice'' ) AS DATA (
  productprice_id character varying(32),
  pricelist_version_id character varying(32),
  product_id bigint,
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  pricelist numeric(20,6),
  pricestd numeric(20,6),
  pricelimit numeric(20,6),
  cost numeric(20,6)
);'),
	 (70,300,'access','2023-10-18 14:35:30.009','access_id',2,'SELECT * FROM access
except
SELECT * FROM
dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,
'' SELECT * FROM access'' ) AS DATA (
  access_id character varying(32),
  role_id character varying(32),
  isactive character(1),
  created timestamp without time zone,
  createdby character varying(32),
  updated timestamp without time zone,
  updatedby character varying(32),
  config character(1),
  config_gral character(1),
  config_profile character(1),
  config_format_print character(1),
  config_codebar character(1),
  config_calibration character(1),
  config_overweight character(1),
  config_backup character(1),
  product character(1),
  product_products character(1),
  product_fast_load character(1),
  product_shortcut character(1),
  product_department character(1),
  product_group character(1),
  product_ingridient character(1),
  product_conservation character(1),
  product_tax character(1),
  importer character(1),
  prices character(1),
  prices_list character(1),
  prices_quick_update character(1),
  advertising character(1),
  users character(1),
  locations character(1),
  locations_currency character(1),
  locations_countrie character(1),
  reports character(1),
  reports_vta_day character(1),
  reports_vta_seller character(1),
  reports_vta_plu character(1),
  reports_vta_close_sales character(1),
  reports_vta_cancel character(1),
  reports_vta_total character(1),
  images character(1),
  roles character(1),
  role_name character varying(60)
);'),
	 (71,10,'invoice','2023-10-18 14:35:30.009','invoice_id',1,''),
	 (72,20,'invoiceline','2023-10-18 14:35:30.009','invoiceline_id',1,''),
	 (73,10,'nut_info_el_instance','2023-10-18 14:35:30.009','nut_info_el_instance_id',3,'SELECT nut_info_el_instance_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT nut_info_el_instance_id FROM nut_info_el_instance'' ) AS DATA ( nut_info_el_instance_id character varying(32) ) EXCEPT SELECT nut_info_el_instance_id FROM nut_info_el_instance'),
	 (74,20,'productprice','2023-10-18 14:35:30.009','productprice_id',3,'SELECT productprice_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT productprice_id FROM productprice'' ) AS DATA ( productprice_id character varying(32) ) EXCEPT SELECT productprice_id FROM productprice'),
	 (75,30,'shortcut','2023-10-18 14:35:30.009','shortcut_id',3,'SELECT shortcut_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT shortcut_id FROM shortcut'' ) AS DATA ( shortcut_id character varying(32) ) EXCEPT SELECT shortcut_id FROM shortcut'),
	 (76,40,'product','2023-10-18 14:35:30.009','product_id',3,'SELECT product_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT product_id FROM product'' ) AS DATA ( product_id bigint ) EXCEPT SELECT product_id FROM product');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (77,50,'pricelist_version','2023-10-18 14:35:30.009','pricelist_version_id',3,'SELECT pricelist_version_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT pricelist_version_id FROM pricelist_version'' ) AS DATA ( pricelist_version_id character varying(32) ) EXCEPT SELECT pricelist_version_id FROM pricelist_version'),
	 (78,60,'advertising','2023-10-18 14:35:30.009','advertising_id',3,'SELECT advertising_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT advertising_id FROM advertising'' ) AS DATA ( advertising_id character varying(32) ) EXCEPT SELECT advertising_id FROM advertising'),
	 (79,70,'main_group','2023-10-18 14:35:30.009','group_id',3,'SELECT group_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT group_id FROM main_group'' ) AS DATA ( group_id bigint ) EXCEPT SELECT group_id FROM main_group'),
	 (80,80,'department','2023-10-18 14:35:30.009','department_id',3,'SELECT department_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT department_id FROM department'' ) AS DATA ( department_id bigint ) EXCEPT SELECT department_id FROM department'),
	 (81,90,'ingredient','2023-10-18 14:35:30.009','ingredient_id',3,'SELECT ingredient_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT ingredient_id FROM ingredient'' ) AS DATA ( ingredient_id character varying(32) ) EXCEPT SELECT ingredient_id FROM ingredient'),
	 (82,100,'preservation_info','2023-10-18 14:35:30.009','preservation_info_id',3,'SELECT preservation_info_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT preservation_info_id FROM preservation_info'' ) AS DATA ( preservation_info_id character varying(32) ) EXCEPT SELECT preservation_info_id FROM preservation_info'),
	 (83,110,'labels','2023-10-18 14:35:30.009','labels_id',3,'SELECT labels_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT labels_id FROM labels'' ) AS DATA ( labels_id character varying(32) ) EXCEPT SELECT labels_id FROM labels'),
	 (84,120,'label_format','2023-10-18 14:35:30.009','label_format_id',3,'SELECT label_format_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT label_format_id FROM label_format'' ) AS DATA ( label_format_id character varying(32) ) EXCEPT SELECT label_format_id FROM label_format'),
	 (85,121,'tax','2023-10-18 14:35:30.009','tax_id',3,'SELECT tax_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT tax_id FROM tax'' ) AS DATA ( tax_id character varying(32) ) EXCEPT SELECT tax_id FROM tax'),
	 (86,122,'taxcategory','2023-10-18 14:35:30.009','taxcategory_id',3,'SELECT taxcategory_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT taxcategory_id FROM taxcategory'' ) AS DATA ( taxcategory_id character varying(32) ) EXCEPT SELECT taxcategory_id FROM taxcategory');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (87,123,'discount_schema_line','2023-10-18 14:35:30.009','discount_schema_line_id',3,'SELECT discount_schema_line_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT discount_schema_line_id FROM discount_schema_line'' ) AS DATA ( discount_schema_line_id character varying(32) ) EXCEPT SELECT discount_schema_line_id FROM discount_schema_line'),
	 (88,124,'discount_schema','2023-10-18 14:35:30.009','discount_id',3,'SELECT discount_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT discount_id FROM discount_schema'' ) AS DATA ( discount_id character varying(32) ) EXCEPT SELECT discount_id FROM discount_schema'),
	 (89,130,'nut_info_element','2023-10-18 14:35:30.009','nut_info_element_id',3,'SELECT nut_info_element_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT nut_info_element_id FROM nut_info_element'' ) AS DATA ( nut_info_element_id character varying(32) ) EXCEPT SELECT nut_info_element_id FROM nut_info_element'),
	 (90,140,'nut_info_set','2023-10-18 14:35:30.009','nut_info_set_id',3,'SELECT nut_info_set_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT nut_info_set_id FROM nut_info_set'' ) AS DATA ( nut_info_set_id character varying(32) ) EXCEPT SELECT nut_info_set_id FROM nut_info_set'),
	 (95,190,'location','2023-10-18 14:35:30.009','location_id',3,'SELECT location_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT location_id FROM location'' ) AS DATA ( location_id character varying(32) ) EXCEPT SELECT location_id FROM location'),
	 (96,195,'role','2023-10-18 14:35:30.009','role_id',3,'SELECT role_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT role_id FROM role'' ) AS DATA ( role_id character varying(32)) EXCEPT SELECT role_id FROM role'),
	 (97,200,'tb_user','2023-10-18 14:35:30.009','user_id',3,'SELECT user_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT user_id FROM tb_user'' ) AS DATA ( user_id character varying(32) ) EXCEPT SELECT user_id FROM tb_user'),
	 (98,210,'bpartner_location','2023-10-18 14:35:30.009','bpartner_location_id',3,'SELECT bpartner_location_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT bpartner_location_id FROM bpartner_location'' ) AS DATA ( bpartner_location_id character varying(32) ) EXCEPT SELECT bpartner_location_id FROM bpartner_location'),
	 (99,220,'city','2023-10-18 14:35:30.009','city_id',3,'SELECT city_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT city_id FROM city'' ) AS DATA ( city_id character varying(32) ) EXCEPT SELECT city_id FROM city'),
	 (100,230,'region','2023-10-18 14:35:30.009','region_id',3,'SELECT region_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT region_id FROM region'' ) AS DATA ( region_id character varying(32) ) EXCEPT SELECT region_id FROM region');
INSERT INTO public.systel_sync_tables (id,"order","name",updated,primary_key,process_type,query_diff) VALUES
	 (101,240,'country','2023-10-18 14:35:30.009','country_id',3,'SELECT country_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT country_id FROM country'' ) AS DATA ( country_id character varying(32) ) EXCEPT SELECT country_id FROM country'),
	 (102,250,'currency','2023-10-18 14:35:30.009','currency_id',3,'SELECT currency_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT currency_id FROM currency'' ) AS DATA ( currency_id character varying(32) ) EXCEPT SELECT currency_id FROM currency'),
	 (103,260,'bpartner','2023-10-18 14:35:30.009','bpartner_id',3,'SELECT bpartner_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT bpartner_id FROM bpartner'' ) AS DATA ( bpartner_id character varying(32) ) EXCEPT SELECT bpartner_id FROM bpartner'),
	 (104,270,'pricelist','2023-10-18 14:35:30.009','pricelist_id',3,'SELECT pricelist_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT pricelist_id FROM pricelist'' ) AS DATA ( pricelist_id character varying(32) ) EXCEPT SELECT pricelist_id FROM pricelist'),
	 (105,280,'image','2023-10-18 14:35:30.009','image_id',3,'SELECT image_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT image_id FROM image'' ) AS DATA ( image_id character varying(32) ) EXCEPT SELECT image_id FROM image'),
	 (106,290,'barcode_format','2023-10-18 14:35:30.009','barcodetype, producttype',3,'SELECT barcodetype, producttype FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT barcodetype, producttype FROM barcode_format'' ) AS DATA ( barcodetype character varying(32), producttype character(1))  EXCEPT SELECT barcodetype, producttype FROM barcode_format'),
	 (107,300,'access','2023-10-18 14:35:30.009','access_id',3,'SELECT access_id FROM dblink(''hostaddr=#host# port=#port# dbname=#dbname# user=#user# password=#pass#''::text,'' SELECT access_id FROM access'' ) AS DATA ( access_id character varying(32)) EXCEPT SELECT access_id FROM access');


ALTER TABLE ONLY public.systel_sync_tables
    ADD CONSTRAINT systel_sync_tables_pk PRIMARY KEY (id);

end
$$



