/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.Serializable;
import java.util.List;
import plume.ArraysMDE;

public class LimitedSizeIntSet
implements Serializable,
Cloneable {
    static final long serialVersionUID = 20031021L;
    protected int[] values;
    int num_values;

    public LimitedSizeIntSet(int max_values) {
        assert (max_values > 0);
        this.values = new int[max_values];
        this.num_values = 0;
    }

    public void add(int elt) {
        if (this.repNulled()) {
            return;
        }
        if (this.contains(elt)) {
            return;
        }
        if (this.num_values == this.values.length) {
            this.nullRep();
            return;
        }
        this.values[this.num_values] = elt;
        ++this.num_values;
    }

    public void addAll(LimitedSizeIntSet s2) {
        boolean sameObject;
        boolean bl = sameObject = this == s2;
        if (sameObject) {
            return;
        }
        if (this.repNulled()) {
            return;
        }
        if (s2.repNulled()) {
            if (s2.size() > this.values.length) {
                this.nullRep();
                return;
            }
            throw new Error("Arg is rep-nulled, so we don't know its values and can't add them to this.");
        }
        int[] svalues = s2.values;
        for (int i = 0; i < s2.size(); ++i) {
            this.add(svalues[i]);
            if (!this.repNulled()) continue;
            return;
        }
    }

    public boolean contains(int elt) {
        if (this.repNulled()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.num_values; ++i) {
            if (this.values[i] != elt) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.num_values;
    }

    public int max_size() {
        if (this.repNulled()) {
            return this.num_values;
        }
        return this.values.length + 1;
    }

    public boolean repNulled() {
        return this.values == null;
    }

    private void nullRep() {
        if (this.repNulled()) {
            return;
        }
        this.num_values = this.values.length + 1;
        this.values = null;
    }

    public LimitedSizeIntSet clone() {
        LimitedSizeIntSet result;
        try {
            result = (LimitedSizeIntSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.values != null) {
            result.values = (int[])this.values.clone();
        }
        return result;
    }

    public static LimitedSizeIntSet merge(int max_values, List<LimitedSizeIntSet> slist) {
        LimitedSizeIntSet result = new LimitedSizeIntSet(max_values);
        for (LimitedSizeIntSet s2 : slist) {
            result.addAll(s2);
        }
        return result;
    }

    public String toString() {
        return "[size=" + this.size() + "; " + (this.repNulled() ? "null" : ArraysMDE.toString(this.values)) + "]";
    }
}

