/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Array {
    private BaseConnection connection = null;
    private int oid;
    private String fieldString = null;
    private final boolean useObjects;
    private final boolean haveMinServer82;
    private PgArrayList arrayList;
    private byte[] fieldBytes;

    private AbstractJdbc2Array(BaseConnection connection, int oid) throws SQLException {
        this.connection = connection;
        this.oid = oid;
        this.useObjects = connection.haveMinimumCompatibleVersion("8.3");
        this.haveMinServer82 = connection.haveMinimumServerVersion("8.2");
    }

    public AbstractJdbc2Array(BaseConnection connection, int oid, String fieldString) throws SQLException {
        this(connection, oid);
        this.fieldString = fieldString;
    }

    public AbstractJdbc2Array(BaseConnection connection, int oid, byte[] fieldBytes) throws SQLException {
        this(connection, oid);
        this.fieldBytes = fieldBytes;
    }

    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    public Object getArrayImpl(Map map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    public Object getArrayImpl(long index, int count, Map map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(index)), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryArray((int)index, count);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(index + (long)count), new Long(this.arrayList.size())}), PSQLState.DATA_ERROR);
        }
        return this.buildArray(this.arrayList, (int)index, count);
    }

    private Object readBinaryArray(int index, int count) throws SQLException {
        int dimensions = ByteConverter.int4(this.fieldBytes, 0);
        int elementOid = ByteConverter.int4(this.fieldBytes, 8);
        int pos = 12;
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = ByteConverter.int4(this.fieldBytes, pos);
            pos += 4;
            pos += 4;
        }
        if (dimensions == 0) {
            return Array.newInstance(this.elementOidToClass(elementOid), 0);
        }
        if (count > 0) {
            dims[0] = Math.min(count, dims[0]);
        }
        Object arr = Array.newInstance(this.elementOidToClass(elementOid), dims);
        try {
            this.storeValues((Object[])arr, elementOid, dims, pos, 0, index);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database."), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
        return arr;
    }

    private int storeValues(Object[] arr, int elementOid, int[] dims, int pos, int thisDimension, int index) throws SQLException, IOException {
        if (thisDimension == dims.length - 1) {
            int len;
            int i;
            for (i = 1; i < index; ++i) {
                len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
            for (i = 0; i < dims[thisDimension]; ++i) {
                len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                switch (elementOid) {
                    case 21: {
                        arr[i] = new Short(ByteConverter.int2(this.fieldBytes, pos));
                        break;
                    }
                    case 23: {
                        arr[i] = new Integer(ByteConverter.int4(this.fieldBytes, pos));
                        break;
                    }
                    case 20: {
                        arr[i] = new Long(ByteConverter.int8(this.fieldBytes, pos));
                        break;
                    }
                    case 700: {
                        arr[i] = new Float(ByteConverter.float4(this.fieldBytes, pos));
                        break;
                    }
                    case 701: {
                        arr[i] = new Double(ByteConverter.float8(this.fieldBytes, pos));
                        break;
                    }
                    case 25: 
                    case 1043: {
                        Encoding encoding = this.connection.getEncoding();
                        arr[i] = encoding.decode(this.fieldBytes, pos, len);
                    }
                }
                pos += len;
            }
        } else {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                pos = this.storeValues((Object[])arr[i], elementOid, dims, pos, thisDimension + 1, 0);
            }
        }
        return pos;
    }

    private ResultSet readBinaryResultSet(int index, int count) throws SQLException {
        int dimensions = ByteConverter.int4(this.fieldBytes, 0);
        int elementOid = ByteConverter.int4(this.fieldBytes, 8);
        int pos = 12;
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = ByteConverter.int4(this.fieldBytes, pos);
            pos += 4;
            pos += 4;
        }
        if (count > 0 && dimensions > 0) {
            dims[0] = Math.min(count, dims[0]);
        }
        ArrayList rows = new ArrayList();
        Field[] fields = new Field[2];
        if (dimensions > 0) {
            this.storeValues(rows, fields, elementOid, dims, pos, 0, index);
        }
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    private int storeValues(List rows, Field[] fields, int elementOid, int[] dims, int pos, int thisDimension, int index) throws SQLException {
        if (thisDimension == dims.length - 1) {
            int i;
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", elementOid);
            fields[1].setFormat(1);
            for (i = 1; i < index; ++i) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
            for (i = 0; i < dims[thisDimension]; ++i) {
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                ByteConverter.int4(rowData[0], 0, i + index);
                rows.add(rowData);
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                rowData[1] = new byte[len];
                System.arraycopy(this.fieldBytes, pos, rowData[1], 0, rowData[1].length);
                pos += len;
            }
        } else {
            int i;
            fields[0] = new Field("INDEX", 23);
            fields[0].setFormat(1);
            fields[1] = new Field("VALUE", this.oid);
            fields[1].setFormat(1);
            int nextDimension = thisDimension + 1;
            int dimensionsLeft = dims.length - nextDimension;
            for (i = 1; i < index; ++i) {
                pos = this.calcRemainingDataLength(dims, pos, elementOid, nextDimension);
            }
            for (i = 0; i < dims[thisDimension]; ++i) {
                byte[][] rowData = new byte[2][];
                rowData[0] = new byte[4];
                ByteConverter.int4(rowData[0], 0, i + index);
                rows.add(rowData);
                int dataEndPos = this.calcRemainingDataLength(dims, pos, elementOid, nextDimension);
                int dataLength = dataEndPos - pos;
                rowData[1] = new byte[12 + 8 * dimensionsLeft + dataLength];
                ByteConverter.int4(rowData[1], 0, dimensionsLeft);
                System.arraycopy(this.fieldBytes, 4, rowData[1], 4, 8);
                System.arraycopy(this.fieldBytes, 12 + nextDimension * 8, rowData[1], 12, dimensionsLeft * 8);
                System.arraycopy(this.fieldBytes, pos, rowData[1], 12 + dimensionsLeft * 8, dataLength);
                pos = dataEndPos;
            }
        }
        return pos;
    }

    private int calcRemainingDataLength(int[] dims, int pos, int elementOid, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                int len = ByteConverter.int4(this.fieldBytes, pos);
                pos += 4;
                if (len == -1) continue;
                pos += len;
            }
        } else {
            pos = this.calcRemainingDataLength(dims, elementOid, pos, thisDimension + 1);
        }
        return pos;
    }

    private Class elementOidToClass(int oid) throws SQLException {
        switch (oid) {
            case 21: {
                return Short.class;
            }
            case 23: {
                return Integer.class;
            }
            case 20: {
                return Long.class;
            }
            case 700: {
                return Float.class;
            }
            case 701: {
                return Double.class;
            }
            case 25: 
            case 1043: {
                return String.class;
            }
        }
        throw Driver.notImplemented(this.getClass(), "readBinaryArray(data,oid)");
    }

    private synchronized void buildArrayList() throws SQLException {
        if (this.arrayList != null) {
            return;
        }
        this.arrayList = new PgArrayList();
        char delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
        if (this.fieldString != null) {
            char[] chars = this.fieldString.toCharArray();
            StringBuffer buffer = null;
            boolean insideString = false;
            boolean wasInsideString = false;
            ArrayList<PgArrayList> dims = new ArrayList<PgArrayList>();
            PgArrayList curArray = this.arrayList;
            int startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            for (int i = startOffset; i < chars.length; ++i) {
                if (chars[i] == '\\') {
                    ++i;
                } else {
                    if (!insideString && chars[i] == '{') {
                        if (dims.size() == 0) {
                            dims.add(this.arrayList);
                        } else {
                            PgArrayList a = new PgArrayList();
                            PgArrayList p = (PgArrayList)dims.get(dims.size() - 1);
                            p.add(a);
                            dims.add(a);
                        }
                        curArray = (PgArrayList)dims.get(dims.size() - 1);
                        for (int t = i + 1; t < chars.length; ++t) {
                            if (Character.isWhitespace(chars[t])) continue;
                            if (chars[t] != '{') break;
                            ++curArray.dimensionsCount;
                        }
                        buffer = new StringBuffer();
                        continue;
                    }
                    if (chars[i] == '\"') {
                        insideString = !insideString;
                        wasInsideString = true;
                        continue;
                    }
                    if (!insideString && Character.isWhitespace(chars[i])) continue;
                    if (!insideString && (chars[i] == delim || chars[i] == '}') || i == chars.length - 1) {
                        String b;
                        if (chars[i] != '\"' && chars[i] != '}' && chars[i] != delim && buffer != null) {
                            buffer.append(chars[i]);
                        }
                        String string = b = buffer == null ? null : buffer.toString();
                        if (b != null && (b.length() > 0 || wasInsideString)) {
                            curArray.add(!wasInsideString && this.haveMinServer82 && b.equals("NULL") ? null : b);
                        }
                        wasInsideString = false;
                        buffer = new StringBuffer();
                        if (chars[i] != '}') continue;
                        dims.remove(dims.size() - 1);
                        if (dims.size() > 0) {
                            curArray = (PgArrayList)dims.get(dims.size() - 1);
                        }
                        buffer = null;
                        continue;
                    }
                }
                if (buffer == null) continue;
                buffer.append(chars[i]);
            }
        }
    }

    private Object buildArray(PgArrayList input, int index, int count) throws SQLException {
        int[] dimsLength;
        if (count < 0) {
            count = input.size();
        }
        Object[] ret = null;
        int dims = input.dimensionsCount;
        int[] nArray = dimsLength = dims > 1 ? new int[dims] : null;
        if (dims > 1) {
            for (int i = 0; i < dims; ++i) {
                dimsLength[i] = i == 0 ? count : 0;
            }
        }
        int length = 0;
        int type = this.connection.getTypeInfo().getSQLType(this.connection.getTypeInfo().getPGArrayElement(this.oid));
        if (type == -7) {
            boolean[] pa = null;
            Boolean[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Boolean.class : Boolean.TYPE, dimsLength) : new Boolean[count];
                ret = oa;
            } else {
                ret = pa = new boolean[count];
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Boolean(AbstractJdbc2ResultSet.toBoolean((String)o)));
                } else {
                    pa[length++] = o == null ? false : AbstractJdbc2ResultSet.toBoolean((String)o);
                }
                --count;
            }
        } else if (type == 5 || type == 4) {
            int[] pa = null;
            Integer[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Integer.class : Integer.TYPE, dimsLength) : new Integer[count];
                ret = oa;
            } else {
                pa = new int[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Integer(AbstractJdbc2ResultSet.toInt((String)o)));
                } else {
                    pa[length++] = o == null ? 0 : AbstractJdbc2ResultSet.toInt((String)o);
                }
                --count;
            }
        } else if (type == -5) {
            long[] pa = null;
            Long[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Long.class : Long.TYPE, dimsLength) : new Long[count];
                ret = oa;
            } else {
                pa = new long[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Long(AbstractJdbc2ResultSet.toLong((String)o)));
                } else {
                    pa[length++] = o == null ? 0L : AbstractJdbc2ResultSet.toLong((String)o);
                }
                --count;
            }
        } else if (type == 2) {
            BigDecimal[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(BigDecimal.class, dimsLength) : new BigDecimal[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : AbstractJdbc2ResultSet.toBigDecimal((String)v, -1));
                --count;
            }
        } else if (type == 7) {
            float[] pa = null;
            Float[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Float.class : Float.TYPE, dimsLength) : new Float[count];
                ret = oa;
            } else {
                pa = new float[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Float(AbstractJdbc2ResultSet.toFloat((String)o)));
                } else {
                    pa[length++] = o == null ? 0.0f : AbstractJdbc2ResultSet.toFloat((String)o);
                }
                --count;
            }
        } else if (type == 8) {
            double[] pa = null;
            Double[] oa = null;
            if (dims > 1 || this.useObjects) {
                oa = dims > 1 ? (Object[])Array.newInstance(this.useObjects ? Double.class : Double.TYPE, dimsLength) : new Double[count];
                ret = oa;
            } else {
                pa = new double[count];
                ret = pa;
            }
            while (count > 0) {
                Object o = input.get(index++);
                if (dims > 1 || this.useObjects) {
                    oa[length++] = o == null ? null : (dims > 1 ? this.buildArray((PgArrayList)o, 0, -1) : new Double(AbstractJdbc2ResultSet.toDouble((String)o)));
                } else {
                    pa[length++] = o == null ? 0.0 : AbstractJdbc2ResultSet.toDouble((String)o);
                }
                --count;
            }
        } else if (type == 1 || type == 12) {
            String[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(String.class, dimsLength) : new String[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : v;
                --count;
            }
        } else if (type == 91) {
            Date[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Date.class, dimsLength) : new Date[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toDate(null, (String)v));
                --count;
            }
        } else if (type == 92) {
            Time[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Time.class, dimsLength) : new Time[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toTime(null, (String)v));
                --count;
            }
        } else if (type == 93) {
            Timestamp[] oa = null;
            oa = dims > 1 ? (Object[])Array.newInstance(Timestamp.class, dimsLength) : new Timestamp[count];
            ret = oa;
            while (count > 0) {
                Object v = input.get(index++);
                oa[length++] = dims > 1 && v != null ? this.buildArray((PgArrayList)v, 0, -1) : (v == null ? null : this.connection.getTimestampUtils().toTimestamp(null, (String)v));
                --count;
            }
        } else {
            if (this.connection.getLogger().logDebug()) {
                this.connection.getLogger().debug("getArrayImpl(long,int,Map) with " + this.getBaseTypeName());
            }
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        return ret;
    }

    public int getBaseType() throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        this.buildArrayList();
        int elementOID = this.connection.getTypeInfo().getPGArrayElement(this.oid);
        return this.connection.getTypeInfo().getPGType(elementOID);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    public ResultSet getResultSetImpl(Map map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    public ResultSet getResultSetImpl(long index, int count, Map map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(index)), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            return this.readBinaryResultSet((int)index, count);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(index + (long)count), new Long(this.arrayList.size())}), PSQLState.DATA_ERROR);
        }
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        Field[] fields = new Field[2];
        if (this.arrayList.dimensionsCount <= 1) {
            int baseOid = this.connection.getTypeInfo().getPGArrayElement(this.oid);
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", baseOid);
            for (int i = 0; i < count; ++i) {
                int offset = (int)index + i;
                byte[][] t = new byte[2][0];
                String v = (String)this.arrayList.get(offset);
                t[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t[1] = v == null ? null : this.connection.encodeString(v);
                rows.add(t);
            }
        } else {
            fields[0] = new Field("INDEX", 23);
            fields[1] = new Field("VALUE", this.oid);
            for (int i = 0; i < count; ++i) {
                int offset = (int)index + i;
                byte[][] t = new byte[2][0];
                Object v = this.arrayList.get(offset);
                t[0] = this.connection.encodeString(Integer.toString(offset + 1));
                t[1] = v == null ? null : this.connection.encodeString(this.toString((PgArrayList)v));
                rows.add(t);
            }
        }
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    public String toString() {
        return this.fieldString;
    }

    private String toString(PgArrayList list) throws SQLException {
        StringBuffer b = new StringBuffer().append('{');
        char delim = this.connection.getTypeInfo().getArrayDelimiter(this.oid);
        for (int i = 0; i < list.size(); ++i) {
            Object v = list.get(i);
            if (i > 0) {
                b.append(delim);
            }
            if (v == null) {
                b.append("NULL");
                continue;
            }
            if (v instanceof PgArrayList) {
                b.append(this.toString((PgArrayList)v));
                continue;
            }
            AbstractJdbc2Array.escapeArrayElement(b, (String)v);
        }
        b.append('}');
        return b.toString();
    }

    public static void escapeArrayElement(StringBuffer b, String s2) {
        b.append('\"');
        for (int j = 0; j < s2.length(); ++j) {
            char c = s2.charAt(j);
            if (c == '\"' || c == '\\') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append('\"');
    }

    public boolean isBinary() {
        return this.fieldBytes != null;
    }

    public byte[] toBytes() {
        return this.fieldBytes;
    }

    private static class PgArrayList
    extends ArrayList {
        private static final long serialVersionUID = 2052783752654562677L;
        int dimensionsCount = 1;

        private PgArrayList() {
        }
    }
}

