/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class TypeAnnotationUtils {
    private TypeAnnotationUtils() {
        throw new AssertionError((Object)"Class TypeAnnotationUtils cannot be instantiated.");
    }

    public static boolean isTypeCompoundContained(Types types, List<Attribute.TypeCompound> list, Attribute.TypeCompound tc) {
        for (Attribute.TypeCompound rawat : list) {
            if (!TypeAnnotationUtils.contentEquals(rawat.type.tsym.name, tc.type.tsym.name) || !rawat.values.equals(tc.values) || !TypeAnnotationUtils.isSameTAPositionExceptTreePos(rawat.position, tc.position)) continue;
            return true;
        }
        return false;
    }

    private static boolean contentEquals(Name n1, Name n2) {
        ByteBuffer b1 = ByteBuffer.wrap(n1.getByteArray(), n1.getByteOffset(), n1.getByteLength());
        ByteBuffer b2 = ByteBuffer.wrap(n2.getByteArray(), n2.getByteOffset(), n2.getByteLength());
        return b1.equals(b2);
    }

    public static boolean isSameTAPosition(TypeAnnotationPosition p1, TypeAnnotationPosition p2) {
        return TypeAnnotationUtils.isSameTAPositionExceptTreePos(p1, p2) && p1.pos == p2.pos;
    }

    public static boolean isSameTAPositionExceptTreePos(TypeAnnotationPosition p1, TypeAnnotationPosition p2) {
        return p1.isValidOffset == p2.isValidOffset && p1.bound_index == p2.bound_index && p1.exception_index == p2.exception_index && p1.location.equals(p2.location) && Arrays.equals(p1.lvarIndex, p2.lvarIndex) && Arrays.equals(p1.lvarLength, p2.lvarLength) && Arrays.equals(p1.lvarOffset, p2.lvarOffset) && p1.offset == p2.offset && p1.onLambda == p2.onLambda && p1.parameter_index == p2.parameter_index && p1.type == p2.type && p1.type_index == p2.type_index;
    }

    public static Attribute.Compound createCompoundFromAnnotationMirror(ProcessingEnvironment env, AnnotationMirror am) {
        List<Pair<Symbol.MethodSymbol, Attribute>> values = List.nil();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            Attribute attribute = TypeAnnotationUtils.attributeFromAnnotationValue(env, entry.getKey(), entry.getValue());
            values = values.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)entry.getKey(), attribute));
        }
        return new Attribute.Compound((Type.ClassType)am.getAnnotationType(), values);
    }

    public static Attribute.TypeCompound createTypeCompoundFromAnnotationMirror(ProcessingEnvironment env, AnnotationMirror am, TypeAnnotationPosition tapos) {
        List<Pair<Symbol.MethodSymbol, Attribute>> values = List.nil();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            Attribute attribute = TypeAnnotationUtils.attributeFromAnnotationValue(env, entry.getKey(), entry.getValue());
            values = values.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)entry.getKey(), attribute));
        }
        return new Attribute.TypeCompound((Type.ClassType)am.getAnnotationType(), values, tapos);
    }

    public static Attribute attributeFromAnnotationValue(ProcessingEnvironment env, ExecutableElement meth, AnnotationValue av) {
        return av.accept(new AttributeCreator(env, meth), null);
    }

    private static <RET> RET call8or9(Call8or9<RET> tc) {
        try {
            boolean hasEight;
            boolean hasNine;
            try {
                hasNine = SourceVersion.valueOf("RELEASE_9") != null;
            }
            catch (IllegalArgumentException iae) {
                hasNine = false;
            }
            if (hasNine) {
                return tc.call9();
            }
            try {
                hasEight = SourceVersion.valueOf("RELEASE_8") != null;
            }
            catch (IllegalArgumentException iae) {
                hasEight = false;
            }
            if (hasEight) {
                return tc.call8();
            }
            assert (false) : "Checker Framework needs a Java 8 or 9 javac.";
            return null;
        }
        catch (Throwable t) {
            assert (false) : "Checker Framework internal error: " + t;
            t.printStackTrace();
            return null;
        }
    }

    public static TypeAnnotationPosition unknownTAPosition() {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getField("unknown").get(null);
            }
        });
    }

    public static TypeAnnotationPosition methodReturnTAPosition(final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.METHOD_RETURN);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("methodReturn", Integer.TYPE).invoke(null, pos);
            }
        });
    }

    public static TypeAnnotationPosition methodReceiverTAPosition(final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.METHOD_RECEIVER);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("methodReceiver", Integer.TYPE).invoke(null, pos);
            }
        });
    }

    public static TypeAnnotationPosition methodParameterTAPosition(final int pidx, final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.METHOD_FORMAL_PARAMETER);
                TypeAnnotationPosition.class.getField("parameter_index").set(tapos, pidx);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("methodParameter", Integer.TYPE, Integer.TYPE).invoke(null, pidx, pos);
            }
        });
    }

    public static TypeAnnotationPosition methodThrowsTAPosition(final int tidx, final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.THROWS);
                TypeAnnotationPosition.class.getField("type_index").set(tapos, tidx);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("methodThrows", List.class, JCTree.JCLambda.class, Integer.TYPE, Integer.TYPE).invoke(null, TypeAnnotationPosition.class.getField("emptyPath").get(null), null, tidx, pos);
            }
        });
    }

    public static TypeAnnotationPosition fieldTAPosition(final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.FIELD);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("field", Integer.TYPE).invoke(null, pos);
            }
        });
    }

    public static TypeAnnotationPosition classExtendsTAPosition(final int implidx, final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.CLASS_EXTENDS);
                TypeAnnotationPosition.class.getField("type_index").set(tapos, implidx);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("classExtends", Integer.TYPE, Integer.TYPE).invoke(null, implidx, pos);
            }
        });
    }

    public static TypeAnnotationPosition typeParameterTAPosition(final int tpidx, final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.CLASS_TYPE_PARAMETER);
                TypeAnnotationPosition.class.getField("parameter_index").set(tapos, tpidx);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("typeParameter", List.class, JCTree.JCLambda.class, Integer.TYPE, Integer.TYPE).invoke(null, TypeAnnotationPosition.class.getField("emptyPath").get(null), null, tpidx, pos);
            }
        });
    }

    public static TypeAnnotationPosition methodTypeParameterTAPosition(final int tpidx, final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.METHOD_TYPE_PARAMETER);
                TypeAnnotationPosition.class.getField("parameter_index").set(tapos, tpidx);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("methodTypeParameter", List.class, JCTree.JCLambda.class, Integer.TYPE, Integer.TYPE).invoke(null, TypeAnnotationPosition.class.getField("emptyPath").get(null), null, tpidx, pos);
            }
        });
    }

    public static TypeAnnotationPosition typeParameterBoundTAPosition(final int tpidx, final int bndidx, final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.CLASS_TYPE_PARAMETER_BOUND);
                TypeAnnotationPosition.class.getField("parameter_index").set(tapos, tpidx);
                TypeAnnotationPosition.class.getField("bound_index").set(tapos, bndidx);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("typeParameterBound", List.class, JCTree.JCLambda.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, TypeAnnotationPosition.class.getField("emptyPath").get(null), null, tpidx, bndidx, pos);
            }
        });
    }

    public static TypeAnnotationPosition methodTypeParameterBoundTAPosition(final int tpidx, final int bndidx, final int pos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                TypeAnnotationPosition tapos = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
                TypeAnnotationPosition.class.getField("type").set(tapos, (Object)TargetType.METHOD_TYPE_PARAMETER_BOUND);
                TypeAnnotationPosition.class.getField("parameter_index").set(tapos, tpidx);
                TypeAnnotationPosition.class.getField("bound_index").set(tapos, bndidx);
                TypeAnnotationPosition.class.getField("pos").set(tapos, pos);
                return tapos;
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("methodTypeParameterBound", List.class, JCTree.JCLambda.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, TypeAnnotationPosition.class.getField("emptyPath").get(null), null, tpidx, bndidx, pos);
            }
        });
    }

    public static TypeAnnotationPosition copyTAPosition(final TypeAnnotationPosition tapos) {
        return TypeAnnotationUtils.call8or9(new Call8or9<TypeAnnotationPosition>(){

            @Override
            public TypeAnnotationPosition call8() throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                return TypeAnnotationUtils.copyTAPosition8(tapos);
            }

            @Override
            public TypeAnnotationPosition call9() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, InvocationTargetException, NoSuchMethodException {
                return (TypeAnnotationPosition)TypeAnnotationPosition.class.getMethod("copy", TypeAnnotationPosition.class).invoke(null, tapos);
            }
        });
    }

    private static TypeAnnotationPosition copyTAPosition8(TypeAnnotationPosition tapos) throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
        TypeAnnotationPosition res = (TypeAnnotationPosition)TypeAnnotationPosition.class.newInstance();
        res.isValidOffset = tapos.isValidOffset;
        TypeAnnotationPosition.class.getField("bound_index").set(res, tapos.bound_index);
        res.exception_index = tapos.exception_index;
        res.location = List.from(tapos.location);
        if (tapos.lvarIndex != null) {
            res.lvarIndex = Arrays.copyOf(tapos.lvarIndex, tapos.lvarIndex.length);
        }
        if (tapos.lvarLength != null) {
            res.lvarLength = Arrays.copyOf(tapos.lvarLength, tapos.lvarLength.length);
        }
        if (tapos.lvarOffset != null) {
            res.lvarOffset = Arrays.copyOf(tapos.lvarOffset, tapos.lvarOffset.length);
        }
        res.offset = tapos.offset;
        TypeAnnotationPosition.class.getField("onLambda").set(res, tapos.onLambda);
        TypeAnnotationPosition.class.getField("parameter_index").set(res, tapos.parameter_index);
        TypeAnnotationPosition.class.getField("pos").set(res, tapos.pos);
        TypeAnnotationPosition.class.getField("type").set(res, (Object)tapos.type);
        TypeAnnotationPosition.class.getField("type_index").set(res, tapos.type_index);
        return res;
    }

    public static Type unannotatedType(final Type in) {
        return TypeAnnotationUtils.call8or9(new Call8or9<Type>(){

            @Override
            public Type call8() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
                return (Type)Type.class.getMethod("unannotatedType", new Class[0]).invoke((Object)in, new Object[0]);
            }

            @Override
            public Type call9() {
                return in;
            }
        });
    }

    static interface Call8or9<RET> {
        public RET call8() throws Throwable;

        public RET call9() throws Throwable;
    }

    private static class AttributeCreator
    implements AnnotationValueVisitor<Attribute, Void> {
        private final ProcessingEnvironment processingEnv;
        private final Types modelTypes;
        private final Elements elements;
        private final com.sun.tools.javac.code.Types javacTypes;
        private final ExecutableElement meth;

        public AttributeCreator(ProcessingEnvironment env, ExecutableElement meth) {
            this.processingEnv = env;
            Context context = ((JavacProcessingEnvironment)env).getContext();
            this.elements = env.getElementUtils();
            this.modelTypes = env.getTypeUtils();
            this.javacTypes = com.sun.tools.javac.code.Types.instance(context);
            this.meth = meth;
        }

        @Override
        public Attribute visit(AnnotationValue av, Void p) {
            return av.accept(this, p);
        }

        @Override
        public Attribute visit(AnnotationValue av) {
            return this.visit(av, null);
        }

        @Override
        public Attribute visitBoolean(boolean b, Void p) {
            PrimitiveType booleanType = this.modelTypes.getPrimitiveType(TypeKind.BOOLEAN);
            return new Attribute.Constant((Type)((Object)booleanType), b ? 1 : 0);
        }

        @Override
        public Attribute visitByte(byte b, Void p) {
            PrimitiveType byteType = this.modelTypes.getPrimitiveType(TypeKind.BYTE);
            return new Attribute.Constant((Type)((Object)byteType), b);
        }

        @Override
        public Attribute visitChar(char c, Void p) {
            PrimitiveType charType = this.modelTypes.getPrimitiveType(TypeKind.CHAR);
            return new Attribute.Constant((Type)((Object)charType), Character.valueOf(c));
        }

        @Override
        public Attribute visitDouble(double d, Void p) {
            PrimitiveType doubleType = this.modelTypes.getPrimitiveType(TypeKind.DOUBLE);
            return new Attribute.Constant((Type)((Object)doubleType), d);
        }

        @Override
        public Attribute visitFloat(float f, Void p) {
            PrimitiveType floatType = this.modelTypes.getPrimitiveType(TypeKind.FLOAT);
            return new Attribute.Constant((Type)((Object)floatType), Float.valueOf(f));
        }

        @Override
        public Attribute visitInt(int i, Void p) {
            PrimitiveType intType = this.modelTypes.getPrimitiveType(TypeKind.INT);
            return new Attribute.Constant((Type)((Object)intType), i);
        }

        @Override
        public Attribute visitLong(long i, Void p) {
            PrimitiveType longType = this.modelTypes.getPrimitiveType(TypeKind.LONG);
            return new Attribute.Constant((Type)((Object)longType), i);
        }

        @Override
        public Attribute visitShort(short s2, Void p) {
            PrimitiveType shortType = this.modelTypes.getPrimitiveType(TypeKind.SHORT);
            return new Attribute.Constant((Type)((Object)shortType), s2);
        }

        @Override
        public Attribute visitString(String s2, Void p) {
            TypeMirror stringType = this.elements.getTypeElement("java.lang.String").asType();
            return new Attribute.Constant((Type)stringType, s2);
        }

        @Override
        public Attribute visitType(TypeMirror t, Void p) {
            if (t instanceof Type) {
                return new Attribute.Class(this.javacTypes, (Type)t);
            }
            assert (false) : "Unexpected type of TypeMirror: " + t.getClass();
            return null;
        }

        @Override
        public Attribute visitEnumConstant(VariableElement c, Void p) {
            Symbol.VarSymbol sym;
            if (c instanceof Symbol.VarSymbol && (sym = (Symbol.VarSymbol)c).getKind() == ElementKind.ENUM_CONSTANT) {
                return new Attribute.Enum(sym.type, sym);
            }
            assert (false) : "Unexpected type of VariableElement: " + c.getClass();
            return null;
        }

        @Override
        public Attribute visitAnnotation(AnnotationMirror a, Void p) {
            return TypeAnnotationUtils.createCompoundFromAnnotationMirror(this.processingEnv, a);
        }

        @Override
        public Attribute visitArray(java.util.List<? extends AnnotationValue> vals, Void p) {
            if (!vals.isEmpty()) {
                List<Attribute> valAttrs = List.nil();
                for (AnnotationValue annotationValue : vals) {
                    valAttrs = valAttrs.append(annotationValue.accept(this, p));
                }
                ArrayType arrayType = this.modelTypes.getArrayType(((Attribute)valAttrs.get((int)0)).type);
                return new Attribute.Array((Type)((Object)arrayType), valAttrs);
            }
            return new Attribute.Array((Type)this.meth.getReturnType(), List.nil());
        }

        @Override
        public Attribute visitUnknown(AnnotationValue av, Void p) {
            assert (false) : "Unexpected type of AnnotationValue: " + av.getClass();
            return null;
        }
    }
}

