/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.HashMap;
import java.util.Map;

public class TreePathCacher
extends TreeScanner<TreePath, Tree> {
    private final Map<Tree, TreePath> foundPaths = new HashMap<Tree, TreePath>();
    private TreePath path;

    public boolean isCached(Tree target) {
        return this.foundPaths.containsKey(target);
    }

    public TreePath getPath(CompilationUnitTree root, Tree target) {
        if (this.foundPaths.containsKey(target)) {
            return this.foundPaths.get(target);
        }
        TreePath path = new TreePath(root);
        if (path.getLeaf() == target) {
            return path;
        }
        try {
            this.scan(path, target);
        }
        catch (Result result) {
            return result.path;
        }
        return null;
    }

    public void clear() {
        this.foundPaths.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreePath scan(Tree tree, Tree target) {
        TreePath prev = this.path;
        if (tree != null && this.foundPaths.get(tree) == null) {
            TreePath current = new TreePath(this.path, tree);
            this.foundPaths.put(tree, current);
            this.path = current;
        } else {
            this.path = this.foundPaths.get(tree);
        }
        if (tree == target) {
            throw new Result(this.path);
        }
        try {
            TreePath treePath = (TreePath)super.scan(tree, target);
            return treePath;
        }
        finally {
            this.path = prev;
        }
    }

    private static class Result
    extends Error {
        private static final long serialVersionUID = 4948452207518392627L;
        TreePath path;

        Result(TreePath path) {
            this.path = path;
        }
    }
}

