/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.type.visitor.VisitHistory;
import org.checkerframework.framework.util.AtmCombo;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;

public class DefaultRawnessComparer
extends AbstractAtmComboVisitor<Boolean, VisitHistory> {
    private final DefaultTypeHierarchy typeHierarchy;
    private AnnotationMirror currentTop;

    public DefaultRawnessComparer(DefaultTypeHierarchy typeHierarchy) {
        this.typeHierarchy = typeHierarchy;
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return "DefaultRawnessComparer: Unexpected AnnotatedTypeMirror combination.\ntype1 = " + subtype.getClass().getSimpleName() + "( " + subtype + " )\ntype2 = " + supertype.getClass().getSimpleName() + "( " + supertype + " )\nvisitHistory = " + visited;
    }

    public boolean isValid(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        return AtmCombo.accept(subtype, supertype, visited, this);
    }

    public boolean isValidInHierarchy(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, AnnotationMirror top, VisitHistory visited) {
        this.currentTop = top;
        boolean result = AtmCombo.accept(subtype, supertype, visited, this);
        this.currentTop = null;
        return result;
    }

    protected boolean arePrimaryAnnotationsEqual(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
        if (this.currentTop != null) {
            return AnnotationUtils.areSame(subtype.getAnnotationInHierarchy(this.currentTop), supertype.getAnnotationInHierarchy(this.currentTop));
        }
        return AnnotationUtils.areSame(subtype.getAnnotations(), supertype.getAnnotations());
    }

    @Override
    public Boolean visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        if (this.checkOrAdd(subtype, supertype, visited)) {
            return true;
        }
        if (!this.arePrimaryAnnotationsEqual(subtype, supertype)) {
            return false;
        }
        return this.typeHierarchy.visitTypeArgs(subtype, supertype, visited, subtype.wasRaw(), supertype.wasRaw());
    }

    @Override
    public Boolean visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        if (this.checkOrAdd(subtype, supertype, visited)) {
            return true;
        }
        if (supertype.getExtendsBoundField() == null || supertype.getExtendsBoundField().getAnnotations().isEmpty()) {
            return true;
        }
        AnnotatedTypeMirror subtypeUpper = subtype.getExtendsBound();
        AnnotatedTypeMirror supertypeUpper = supertype.getExtendsBound();
        if (supertypeUpper.getKind() == TypeKind.TYPEVAR && InternalUtils.isCaptured((TypeVariable)supertypeUpper.getUnderlyingType())) {
            supertypeUpper = ((AnnotatedTypeMirror.AnnotatedTypeVariable)supertypeUpper).getUpperBound();
        }
        if (this.checkOrAdd(subtypeUpper, supertypeUpper, visited)) {
            return true;
        }
        if (this.currentTop == null) {
            return this.typeHierarchy.isSubtype(subtypeUpper, supertypeUpper);
        }
        return this.typeHierarchy.isSubtype(subtypeUpper, supertypeUpper, this.currentTop);
    }

    @Override
    public Boolean visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, VisitHistory visited) {
        if (!this.arePrimaryAnnotationsEqual(subtype, supertype)) {
            return false;
        }
        return this.isValid(subtype.getComponentType(), supertype.getComponentType(), visited);
    }

    @Override
    public Boolean visitNull_Declared(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        if (this.checkOrAdd(subtype, supertype, visited)) {
            return true;
        }
        if (!this.arePrimaryAnnotationsEqual(subtype, supertype)) {
            return false;
        }
        return !supertype.wasRaw();
    }

    @Override
    public Boolean visitNull_Typevar(AnnotatedTypeMirror.AnnotatedNullType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitTypevarSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitArray_Declared(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.arePrimaryAnnotationsEqual(subtype, supertype);
    }

    @Override
    public Boolean visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType subtype, AnnotatedTypeMirror.AnnotatedPrimitiveType supertype, VisitHistory visited) {
        return this.arePrimaryAnnotationsEqual(subtype, supertype);
    }

    @Override
    public Boolean visitDeclared_Wildcard(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitArray_Wildcard(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Wildcard(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        return this.visitWildcardSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitDeclared_Typevar(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitTypevarSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitArray_Typevar(AnnotatedTypeMirror.AnnotatedArrayType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitTypevarSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Declared(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.visitTypeVarSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Null(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedNullType supertype, VisitHistory visited) {
        return this.visitTypeVarSubtype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitTypevarSupertype(subtype, supertype, visited);
    }

    @Override
    public Boolean visitWildcard_Array(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedArrayType supertype, VisitHistory visited) {
        return this.arePrimaryAnnotationsEqual(subtype.getExtendsBound(), supertype);
    }

    @Override
    public Boolean visitWildcard_Declared(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype, VisitHistory visited) {
        return this.arePrimaryAnnotationsEqual(subtype.getExtendsBound(), supertype);
    }

    @Override
    public Boolean visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        return this.visitTypevarSupertype(subtype, supertype, visited);
    }

    public Boolean visitWildcardSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedWildcardType supertype, VisitHistory visited) {
        if (this.checkOrAdd(subtype, supertype, visited)) {
            return true;
        }
        if (!supertype.getAnnotations().isEmpty() && !supertype.getEffectiveAnnotations().equals(subtype.getEffectiveAnnotations())) {
            return false;
        }
        AnnotatedTypeMirror superExtendsBound = supertype.getExtendsBound();
        if (superExtendsBound == null) {
            return true;
        }
        if (this.checkOrAdd(subtype, superExtendsBound, visited)) {
            return true;
        }
        return (Boolean)this.visit(subtype, superExtendsBound, visited);
    }

    public Boolean visitTypevarSupertype(AnnotatedTypeMirror subtype, AnnotatedTypeMirror.AnnotatedTypeVariable supertype, VisitHistory visited) {
        if (this.checkOrAdd(subtype, supertype, visited)) {
            return true;
        }
        AnnotatedTypeMirror supertypeUb = supertype.getUpperBound();
        if (this.checkOrAdd(subtype, supertypeUb, visited)) {
            return true;
        }
        return (Boolean)this.visit(subtype, supertypeUb, visited);
    }

    public Boolean visitTypeVarSubtype(AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        if (this.checkOrAdd(subtype, supertype, visited)) {
            return true;
        }
        AnnotatedTypeMirror subtypeUb = subtype.getUpperBound();
        if (this.checkOrAdd(subtypeUb, supertype, visited)) {
            return true;
        }
        return (Boolean)this.visit(subtype, subtypeUb, visited);
    }

    private boolean checkOrAdd(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype, VisitHistory visited) {
        if (visited.contains(subtype, supertype)) {
            return true;
        }
        visited.add(subtype, supertype);
        return false;
    }
}

