/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.units.UnitsRelationsTools;
import org.checkerframework.checker.units.qual.Prefix;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.DefaultAnnotatedTypeFormatter;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.framework.util.DefaultAnnotationFormatter;
import org.checkerframework.javacutil.AnnotationUtils;

public class UnitsAnnotatedTypeFormatter
extends DefaultAnnotatedTypeFormatter {
    protected final BaseTypeChecker checker;
    protected final Elements elements;

    public UnitsAnnotatedTypeFormatter(BaseTypeChecker checker) {
        super(new UnitsFormattingVisitor(checker, new UnitsAnnotationFormatter(checker), checker.hasOption("printVerboseGenerics"), true));
        this.checker = checker;
        this.elements = checker.getElementUtils();
    }

    protected static class UnitsAnnotationFormatter
    extends DefaultAnnotationFormatter {
        protected final BaseTypeChecker checker;
        protected final Elements elements;

        public UnitsAnnotationFormatter(BaseTypeChecker checker) {
            this.checker = checker;
            this.elements = checker.getElementUtils();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String formatAnnotationString(Collection<? extends AnnotationMirror> annos, boolean printInvisible) {
            Set<AnnotationMirror> trimmedAnnoSet = AnnotationUtils.createAnnotationSet();
            for (AnnotationMirror annotationMirror : annos) {
                void var5_5;
                if (UnitsRelationsTools.getPrefix(annotationMirror) == Prefix.one) {
                    AnnotationMirror annotationMirror2 = UnitsRelationsTools.removePrefix(this.elements, annotationMirror);
                }
                trimmedAnnoSet.add((AnnotationMirror)var5_5);
            }
            return super.formatAnnotationString(Collections.unmodifiableSet(trimmedAnnoSet), printInvisible);
        }
    }

    protected static class UnitsFormattingVisitor
    extends DefaultAnnotatedTypeFormatter.FormattingVisitor {
        protected final BaseTypeChecker checker;
        protected final Elements elements;

        public UnitsFormattingVisitor(BaseTypeChecker checker, AnnotationFormatter annoFormatter, boolean printVerboseGenerics, boolean defaultInvisiblesSetting) {
            super(annoFormatter, printVerboseGenerics, defaultInvisiblesSetting);
            this.checker = checker;
            this.elements = checker.getElementUtils();
        }
    }
}

