/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.nullness.KeyForAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class KeyForTransfer
extends CFTransfer {
    protected final AnnotationMirror UNKNOWNKEYFOR;
    protected final AnnotationMirror KEYFOR;

    public KeyForTransfer(CFAnalysis analysis) {
        super(analysis);
        this.UNKNOWNKEYFOR = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), UnknownKeyFor.class);
        this.KEYFOR = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), KeyFor.class);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(node, in);
        KeyForAnnotatedTypeFactory factory = (KeyForAnnotatedTypeFactory)this.analysis.getTypeFactory();
        if (factory.isInvocationOfMapMethod(node, "containsKey") || factory.isInvocationOfMapMethod(node, "put")) {
            Node receiver = node.getTarget().getReceiver();
            FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf((AnnotationProvider)factory, receiver);
            String mapName = internalReceiver.toString();
            FlowExpressions.Receiver keyReceiver = FlowExpressions.internalReprOf((AnnotationProvider)factory, node.getArgument(0));
            LinkedHashSet<String> keyForMaps = new LinkedHashSet<String>();
            keyForMaps.add(mapName);
            CFValue previousKeyValue = in.getValueOfSubNode(node.getArgument(0));
            if (previousKeyValue != null) {
                for (AnnotationMirror prevAm : previousKeyValue.getAnnotations()) {
                    if (prevAm == null || !AnnotationUtils.areSameByClass(prevAm, KeyFor.class)) continue;
                    keyForMaps.addAll(this.getKeys(prevAm));
                }
            }
            AnnotationMirror am = factory.createKeyForAnnotationMirrorWithValue(keyForMaps);
            if (factory.getMethodName(node).equals("containsKey")) {
                result.getThenStore().insertValue(keyReceiver, am);
            } else {
                result.getThenStore().insertValue(keyReceiver, am);
                result.getElseStore().insertValue(keyReceiver, am);
            }
        }
        return result;
    }

    private Set<String> getKeys(AnnotationMirror keyFor) {
        if (keyFor.getElementValues().size() == 0) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(AnnotationUtils.getElementValueArray(keyFor, "value", String.class, true));
    }
}

