/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.minlen;

import java.util.Collections;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexRefinementInfo;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.minlen.MinLenAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeMirror;

public class MinLenTransfer
extends IndexAbstractTransfer {
    protected MinLenAnnotatedTypeFactory atypeFactory;

    public MinLenTransfer(CFAnalysis analysis) {
        super(analysis);
        this.atypeFactory = (MinLenAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    @Override
    public TransferResult<CFValue, CFStore> visitArrayAccess(ArrayAccessNode node, TransferInput<CFValue, CFStore> in) {
        TransferResult<CFValue, CFStore> result = super.visitArrayAccess(node, in);
        AnnotatedTypeMirror valueType = this.atypeFactory.valueTypeFromTree(node.getArray().getTree());
        if (valueType.hasAnnotation(ArrayLen.class)) {
            AnnotationMirror arrayLenAnm = valueType.getAnnotation(ArrayLen.class);
            CFStore store = in.getRegularStore();
            int minlen = Collections.min(ValueAnnotatedTypeFactory.getArrayLength(arrayLenAnm));
            FlowExpressions.Receiver rec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getArray());
            store.insertValue(rec, this.atypeFactory.createMinLen(minlen));
        }
        return result;
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> res, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        TransferResult<CFValue, CFStore> result = super.strengthenAnnotationOfEqualTo(res, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result, this.analysis, firstNode, secondNode);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result;
        }
        CFStore equalsStore = notEqualTo ? rfi.elseStore : rfi.thenStore;
        CFStore notEqualsStore = notEqualTo ? rfi.thenStore : rfi.elseStore;
        this.refineGTE(rfi.right, rfi.rightAnno, rfi.left, rfi.leftAnno, equalsStore, null);
        this.refineGTE(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, equalsStore, null);
        this.refineNotEqual(rfi.right, rfi.rightAnno, rfi.left, rfi.leftAnno, notEqualsStore);
        this.refineNotEqual(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, notEqualsStore);
        return rfi.newResult;
    }

    private FlowExpressions.Receiver getReceiverOfFieldAccessNode(Node node) {
        if (node instanceof FieldAccessNode) {
            FlowExpressions.Receiver rec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), ((FieldAccessNode)node).getReceiver());
            return rec;
        }
        return null;
    }

    private void refineNotEqual(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        FlowExpressions.Receiver rec = this.getReceiverOfFieldAccessNode(left);
        Long newMinLen = IndexUtil.getMinValue(right.getTree(), this.atypeFactory.getValueAnnotatedTypeFactory());
        if (newMinLen != null && newMinLen == 0L && rec != null) {
            store.insertValue(rec, this.atypeFactory.createMinLen(1));
        }
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        FlowExpressions.Receiver rec = this.getReceiverOfFieldAccessNode(left);
        Long newMinLen = IndexUtil.getMinValue(right.getTree(), this.atypeFactory.getValueAnnotatedTypeFactory());
        if (rec != null && newMinLen != null) {
            store.insertValue(rec, this.atypeFactory.createMinLen(newMinLen.intValue() + 1));
        }
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        FlowExpressions.Receiver rec = this.getReceiverOfFieldAccessNode(left);
        Long newMinLen = IndexUtil.getMinValue(right.getTree(), this.atypeFactory.getValueAnnotatedTypeFactory());
        if (rec != null && newMinLen != null) {
            store.insertValue(rec, this.atypeFactory.createMinLen(newMinLen.intValue()));
        }
    }
}

