/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.users.callables;

import com.systel.sync.business.common.entities.User;
import com.systel.sync.common.encryption.EncryptionUtils;
import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.users.results.SignInResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class SignInCallable
implements Callable<SignInResult> {
    private static final String LOG_TAG = SignInCallable.class.getSimpleName();
    private Connection connection;
    private User user;

    public SignInCallable(@NotNull Connection connection, @NotNull User user) {
        if (connection == null) {
            SignInCallable.$$$reportNull$$$0(0);
        }
        if (user == null) {
            SignInCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.user = user;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SignInResult call() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement((String)SQLQueries.getInstance().get((Object)SQLQuery.selectUser));){
            preparedStatement.setString(1, this.user.getUsername());
            preparedStatement.setString(2, EncryptionUtils.md5(this.user.getPassword()));
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return new SignInResult(-1);
            User.Builder builder = new User.Builder();
            builder.setId(resultSet.getString("user_id"));
            builder.setUsername(resultSet.getString("username"));
            builder.setPassword(resultSet.getString("password"));
            SignInResult signInResult = new SignInResult(0, builder.build());
            return signInResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
        }
        return new SignInResult(-1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "user";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/users/callables/SignInCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

