/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.users;

import com.systel.sync.business.common.entities.User;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.users.UsersServiceInterface;
import com.systel.sync.services.users.callables.GetAvaiableUsersCallable;
import com.systel.sync.services.users.callables.SignInCallable;
import com.systel.sync.services.users.results.SignInResult;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class UsersService
implements UsersServiceInterface {
    private static final String LOG_TAG = UsersService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;

    public UsersService(ConnectionService connectionService) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void signIn(User user, ServiceCallback<User, Integer> callback) {
        try {
            Future<SignInResult> future = this.executor.submit(new SignInCallable(this.connectionService.getMasterConnection(), user));
            SignInResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getUser());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public TreeSet<User> getAvaiableUsers() {
        try {
            Future<TreeSet<User>> future = this.executor.submit(new GetAvaiableUsersCallable(this.connectionService.getMasterConnection()));
            TreeSet<User> result = future.get();
            return result;
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
        }
        return null;
    }
}

