/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.tools;

import com.systel.sync.business.common.entities.ToolsData;
import com.systel.sync.common.ConfigurationProperties;
import com.systel.sync.common.Language;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.tools.ToolsServiceInterface;

public final class ToolsService
implements ToolsServiceInterface {
    private static final String LOG_TAG = ToolsService.class.getSimpleName();
    private ConfigurationService configurationService;
    private ConnectionService connectionService;

    public ToolsService(ConfigurationService configurationService, ConnectionService connectionService) {
        this.configurationService = configurationService;
        this.connectionService = connectionService;
    }

    @Override
    public void select(ServiceCallback<ToolsData, Integer> callback) {
        try {
            ToolsData ToolsData2 = new ToolsData();
            ToolsData2.setMasterIpAddress(this.configurationService.getMasterDBHost());
            ToolsData2.setLanguage(new Language(this.configurationService.getLocale(), this.configurationService.getLanguage()));
            ToolsData2.setLogLevel(this.configurationService.getLogLevel());
            ToolsData2.getMasterIpAddress().equals(ToolsData2.getMasterIpAddress());
            this.connectionService.resetMasterConnection();
            callback.onSuccess(ToolsData2);
        }
        catch (NullPointerException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
    }

    @Override
    public void update(ToolsData ToolsData2, ServiceCallback<Integer, Integer> callback) {
        try {
            ConfigurationProperties configurationProperties = this.configurationService.getConfigurationProperties();
            configurationProperties.setProperty("masterDBHost", ToolsData2.getMasterIpAddress());
            configurationProperties.setProperty("locale", ToolsData2.getLanguage().getLocale());
            configurationProperties.setProperty("logLevel", ToolsData2.getLogLevel().name());
            this.configurationService.setConfigurationProperties(configurationProperties);
            this.configurationService.save();
            this.connectionService.resetMasterConnection();
            callback.onSuccess(0);
        }
        catch (Exception ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
    }
}

