/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote.callables;

import com.systel.sync.common.sql.SQLInsertUtils;
import com.systel.sync.common.sql.SQLUpdateUtils;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.sync.remote.results.UpdateTableDataResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class UpdateTableDataCallable
implements Callable<UpdateTableDataResult> {
    private static final String LOG_TAG = UpdateTableDataCallable.class.getSimpleName();
    private Connection connection;
    private ServiceNodeConnection nodeConnection;
    private TreeSet<ServiceTable> serviceTables;
    private LinkedHashMap<Integer, ServiceTableData> serviceTablesData;
    private ResourceBundle resourceBundle;

    public UpdateTableDataCallable(@NotNull Connection connection, @NotNull ServiceNodeConnection nodeConnection, @NotNull TreeSet<ServiceTable> serviceTables, @NotNull LinkedHashMap<Integer, ServiceTableData> serviceTablesData, @NotNull ResourceBundle resourceBundle) {
        if (connection == null) {
            UpdateTableDataCallable.$$$reportNull$$$0(0);
        }
        if (nodeConnection == null) {
            UpdateTableDataCallable.$$$reportNull$$$0(1);
        }
        if (serviceTables == null) {
            UpdateTableDataCallable.$$$reportNull$$$0(2);
        }
        if (serviceTablesData == null) {
            UpdateTableDataCallable.$$$reportNull$$$0(3);
        }
        if (resourceBundle == null) {
            UpdateTableDataCallable.$$$reportNull$$$0(4);
        }
        this.connection = connection;
        this.nodeConnection = nodeConnection;
        this.serviceTables = serviceTables;
        this.serviceTablesData = serviceTablesData;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public UpdateTableDataResult call() throws Exception {
        boolean error = false;
        for (ServiceTable serviceTable : this.serviceTables) {
            if (!this.serviceTablesData.containsKey(serviceTable.getId())) continue;
            ServiceTableData serviceTableData = this.serviceTablesData.get(serviceTable.getId());
            int affectedRows = 0;
            for (ServiceTableRow singleRow : serviceTableData.getRows()) {
                Stream<ServiceTableRow> stream = Stream.of(singleRow);
                ArrayList<String> primaryKeys = new ArrayList<String>();
                if (serviceTable.getPrimaryKey().contains(", ")) {
                    for (String primaryKey : serviceTable.getPrimaryKey().split(",")) {
                        primaryKeys.add(primaryKey.trim());
                    }
                } else {
                    primaryKeys.add(serviceTable.getPrimaryKey());
                }
                this.connection.setAutoCommit(true);
                try {
                    Statement statement = this.connection.createStatement();
                    Throwable throwable = null;
                    try {
                        String sql = stream.map(row -> SQLUpdateUtils.makeUpdateStatement(serviceTable.getName(), serviceTableData.getColumnNames(), primaryKeys, row)).reduce("", (st1, st2) -> st1 + st2);
                        int result = statement.executeUpdate(sql);
                        if (result == 0) {
                            stream = Stream.of(singleRow);
                            sql = stream.map(row -> SQLInsertUtils.makeStatement(serviceTable.getName(), serviceTableData.getColumnNames(), row)).reduce("", (st1, st2) -> st1 + st2);
                            result = statement.executeUpdate(sql);
                        }
                        affectedRows += result;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    error = true;
                    ServicesLog.logError(LOG_TAG, this.resourceBundle.getString("update.table.data.exception").replace("#nodeName#", this.nodeConnection.getName() + " " + this.nodeConnection.getNumber()).replace("#tableName#", serviceTable.getName()).replace("#exception#", ex.getMessage()));
                }
            }
            if (affectedRows <= 0) continue;
            ServicesLog.logInfo(LOG_TAG, this.resourceBundle.getString("update.table.data.updated").replace("#nodeName#", this.nodeConnection.getName() + " " + this.nodeConnection.getNumber()).replace("#tableName#", serviceTable.getName()).replace("#updated#", Integer.toString(affectedRows)));
        }
        return new UpdateTableDataResult(0, this.nodeConnection.getId(), error);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeConnection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTablesData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "resourceBundle";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/remote/callables/UpdateTableDataCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

