/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.sync.remote.results.ServiceTableResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.validation.constraints.NotNull;

public final class SelectTableHashCallable
implements Callable<ServiceTableResult> {
    private static final String LOG_TAG = SelectTableHashCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> serviceTables;

    public SelectTableHashCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> serviceTables) {
        this.connection = connection;
        this.serviceTables = serviceTables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServiceTableResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            TreeSet<ServiceTable> serviceTablesHashes = new TreeSet<ServiceTable>();
            for (ServiceTable serviceTable : this.serviceTables) {
                ResultSet resultSet = statement.executeQuery(((String)SQLQueries.getInstance().get((Object)SQLQuery.selectTableHash)).replace("#table#", serviceTable.getName()));
                if (!resultSet.next()) continue;
                ServiceTable serviceTableHash = new ServiceTable(serviceTable);
                serviceTableHash.setMasterHash(resultSet.getString("hash"));
                serviceTablesHashes.add(serviceTableHash);
            }
            ServiceTableResult serviceTableResult = new ServiceTableResult(0, serviceTablesHashes);
            return serviceTableResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new ServiceTableResult(-1);
        }
    }
}

