/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.sync.results.TableDataResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class SelectTableDeletedIdsCallable
implements Callable<TableDataResult> {
    private static final String LOG_TAG = SelectTableDeletedIdsCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> serviceTables;
    private LinkedHashMap<Integer, ServiceTableData> serviceTablesData;

    public SelectTableDeletedIdsCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> serviceTables, @NotNull LinkedHashMap<Integer, ServiceTableData> serviceTablesData) {
        if (connection == null) {
            SelectTableDeletedIdsCallable.$$$reportNull$$$0(0);
        }
        if (serviceTables == null) {
            SelectTableDeletedIdsCallable.$$$reportNull$$$0(1);
        }
        if (serviceTablesData == null) {
            SelectTableDeletedIdsCallable.$$$reportNull$$$0(2);
        }
        this.connection = connection;
        this.serviceTables = serviceTables;
        this.serviceTablesData = serviceTablesData;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableDataResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            LinkedHashMap<Integer, ServiceTableData> records = new LinkedHashMap<Integer, ServiceTableData>();
            for (ServiceTable serviceTable : this.serviceTables) {
                if (!this.serviceTablesData.containsKey(serviceTable.getId())) continue;
                ResultSet resultSet = statement.executeQuery(((String)SQLQueries.getInstance().get((Object)SQLQuery.selectGenericWithColumns)).replace("#columns#", serviceTable.getPrimaryKey()).replace("#table#", serviceTable.getName()));
                ServiceTableData nodeTableData = new ServiceTableData(serviceTable.getId());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int columnCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    nodeTableData.getColumnNames().add(resultSetMetaData.getColumnLabel(i));
                }
                while (resultSet.next()) {
                    ServiceTableRow data = new ServiceTableRow();
                    for (int i = 1; i <= columnCount; ++i) {
                        data.getRow().add(resultSet.getString(i));
                    }
                    nodeTableData.getRows().add(data);
                }
                for (ServiceTableRow masterRow : this.serviceTablesData.get(serviceTable.getId()).getRows()) {
                    boolean found = false;
                    for (ServiceTableRow nodeRow : nodeTableData.getRows()) {
                        if (masterRow.getRow().size() > 1 && nodeRow.getRow().size() > 1) {
                            if (!masterRow.getRow().get(0).equals(nodeRow.getRow().get(0)) || !masterRow.getRow().get(1).equals(nodeRow.getRow().get(1))) continue;
                            found = true;
                            break;
                        }
                        if (!masterRow.getRow().get(0).equals(nodeRow.getRow().get(0))) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ServiceTableRow data = new ServiceTableRow();
                    data.getRow().add(0, masterRow.getRow().get(0));
                    if (masterRow.getRow().size() > 1) {
                        data.getRow().add(1, masterRow.getRow().get(1));
                    }
                    ServiceTableData newTableData = new ServiceTableData(serviceTable.getId());
                    newTableData.getRows().add(data);
                    records.put(newTableData.getTableId(), newTableData);
                }
            }
            TableDataResult tableDataResult = new TableDataResult(0, records);
            return tableDataResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new TableDataResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTablesData";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/remote/callables/SelectTableDeletedIdsCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

