/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote.callables;

import com.systel.sync.common.sql.SQLDeleteUtils;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.results.BaseResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class DeleteNodeTableDataCallable
implements Callable<BaseResult> {
    private static final String LOG_TAG = DeleteNodeTableDataCallable.class.getSimpleName();
    private Connection connection;
    private ServiceNodeConnection nodeConnection;
    private TreeSet<ServiceTable> serviceTables;
    private LinkedHashMap<Integer, ServiceTableData> serviceTablesData;
    private ResourceBundle resourceBundle;

    public DeleteNodeTableDataCallable(@NotNull Connection connection, @NotNull ServiceNodeConnection nodeConnection, @NotNull TreeSet<ServiceTable> serviceTables, @NotNull LinkedHashMap<Integer, ServiceTableData> serviceTablesData, @NotNull ResourceBundle resourceBundle) {
        if (connection == null) {
            DeleteNodeTableDataCallable.$$$reportNull$$$0(0);
        }
        if (nodeConnection == null) {
            DeleteNodeTableDataCallable.$$$reportNull$$$0(1);
        }
        if (serviceTables == null) {
            DeleteNodeTableDataCallable.$$$reportNull$$$0(2);
        }
        if (serviceTablesData == null) {
            DeleteNodeTableDataCallable.$$$reportNull$$$0(3);
        }
        if (resourceBundle == null) {
            DeleteNodeTableDataCallable.$$$reportNull$$$0(4);
        }
        this.connection = connection;
        this.nodeConnection = nodeConnection;
        this.serviceTables = serviceTables;
        this.serviceTablesData = serviceTablesData;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public BaseResult call() throws Exception {
        boolean noError = true;
        for (ServiceTable serviceTable : this.serviceTables) {
            if (!this.serviceTablesData.containsKey(serviceTable.getId())) continue;
            try {
                Statement statement = this.connection.createStatement();
                Throwable throwable = null;
                try {
                    String sql;
                    int result;
                    ServiceTableData serviceTableData = this.serviceTablesData.get(serviceTable.getId());
                    ArrayList<String> primaryKeys = new ArrayList<String>();
                    if (serviceTable.getPrimaryKey().contains(", ")) {
                        for (String primaryKey : serviceTable.getPrimaryKey().split(",")) {
                            primaryKeys.add(primaryKey.trim());
                        }
                    } else {
                        primaryKeys.add(serviceTable.getPrimaryKey());
                    }
                    if ((result = statement.executeUpdate(sql = SQLDeleteUtils.makeDeleteStatement(serviceTable.getName(), primaryKeys, serviceTableData.getRows(), false))) <= 0) continue;
                    ServicesLog.logInfo(LOG_TAG, this.resourceBundle.getString("delete.node.table.data.deleted").replace("#nodeName#", this.nodeConnection.getName() + " " + this.nodeConnection.getNumber()).replace("#tableName#", serviceTable.getName()).replace("#deleted#", Integer.toString(result)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException ex) {
                ServicesLog.logError(LOG_TAG, this.resourceBundle.getString("delete.node.table.data.exception").replace("#nodeName#", this.nodeConnection.getName() + " " + this.nodeConnection.getNumber()).replace("#tableName#", serviceTable.getName()).replace("#exception#", ex.getMessage()));
                noError = false;
            }
        }
        if (noError) {
            return new BaseResult(0);
        }
        return new BaseResult(-1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeConnection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTablesData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "resourceBundle";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/remote/callables/DeleteNodeTableDataCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

