/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.sync.remote.results.SyncNodeResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import javax.validation.constraints.NotNull;

public final class CreateHashFunctionCallable
implements Callable<SyncNodeResult> {
    private static final String LOG_TAG = CreateHashFunctionCallable.class.getSimpleName();
    private Connection connection;
    private long nodeId;

    public CreateHashFunctionCallable(@NotNull Connection connection, long nodeId) {
        this.connection = connection;
        this.nodeId = nodeId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SyncNodeResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            statement.execute((String)SQLQueries.getInstance().get((Object)SQLQuery.createHashFunction));
            SyncNodeResult syncNodeResult = new SyncNodeResult(0, this.nodeId);
            return syncNodeResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new SyncNodeResult(-1, this.nodeId);
        }
    }
}

