/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.sync.remote.results.CompareNodeTablesHashResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class CompareNodeTablesHashCallable
implements Callable<CompareNodeTablesHashResult> {
    private static final String LOG_TAG = CompareNodeTablesHashCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> serviceTables;

    public CompareNodeTablesHashCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> serviceTables) {
        if (connection == null) {
            CompareNodeTablesHashCallable.$$$reportNull$$$0(0);
        }
        if (serviceTables == null) {
            CompareNodeTablesHashCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.serviceTables = serviceTables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompareNodeTablesHashResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            TreeSet<ServiceTable> comparedTables = new TreeSet<ServiceTable>();
            for (ServiceTable serviceTable : this.serviceTables) {
                ResultSet resultSet = statement.executeQuery(((String)SQLQueries.getInstance().get((Object)SQLQuery.selectTableHash)).replace("#table#", serviceTable.getName()));
                if (!resultSet.next() || !(resultSet.getString("hash") != null && serviceTable.getMasterHash() != null && !serviceTable.getMasterHash().equals(resultSet.getString("hash")) || resultSet.getString("hash") == null && serviceTable.getMasterHash() != null) && (resultSet.getString("hash") == null || serviceTable.getMasterHash() != null)) continue;
                comparedTables.add(new ServiceTable(serviceTable));
            }
            CompareNodeTablesHashResult compareNodeTablesHashResult = new CompareNodeTablesHashResult(0, comparedTables);
            return compareNodeTablesHashResult;
        }
        catch (NullPointerException | SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new CompareNodeTablesHashResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTables";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/remote/callables/CompareNodeTablesHashCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

