/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.sync.remote.results.CompareNodeHashResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class CompareNodeHashesCallable
implements Callable<CompareNodeHashResult> {
    private static final String LOG_TAG = CompareNodeHashesCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> nodeTables;
    private ServiceNodeConnection nodeConnection;
    private ResourceBundle resourceBundle;

    public CompareNodeHashesCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> nodeTables, @NotNull ServiceNodeConnection nodeConnection, @NotNull ResourceBundle resourceBundle) {
        if (connection == null) {
            CompareNodeHashesCallable.$$$reportNull$$$0(0);
        }
        if (nodeTables == null) {
            CompareNodeHashesCallable.$$$reportNull$$$0(1);
        }
        if (nodeConnection == null) {
            CompareNodeHashesCallable.$$$reportNull$$$0(2);
        }
        if (resourceBundle == null) {
            CompareNodeHashesCallable.$$$reportNull$$$0(3);
        }
        this.connection = connection;
        this.nodeTables = nodeTables;
        this.nodeConnection = nodeConnection;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public CompareNodeHashResult call() throws Exception {
        boolean equalHashes = false;
        boolean notSynced = false;
        TreeSet<ServiceTable> tablesToSync = new TreeSet<ServiceTable>();
        for (ServiceTable serviceTable : this.nodeTables) {
            try (Statement statement = this.connection.createStatement();){
                equalHashes = true;
                ResultSet resultSet = statement.executeQuery(((String)SQLQueries.getInstance().get((Object)SQLQuery.selectTableHash)).replace("#table#", serviceTable.getName()));
                if (resultSet.next()) {
                    if (resultSet.getString("hash") != null && serviceTable.getMasterHash() != null || resultSet.getString("hash") == null && serviceTable.getMasterHash() == null) {
                        if (resultSet.getString("hash") != null && serviceTable.getMasterHash() != null) {
                            equalHashes = resultSet.getString("hash").equals(serviceTable.getMasterHash());
                        }
                    } else if (resultSet.getString("hash") == null && serviceTable.getMasterHash() != null || resultSet.getString("hash") != null && serviceTable.getMasterHash() == null) {
                        equalHashes = false;
                    }
                }
                if (!equalHashes) {
                    ServicesLog.logInfo(LOG_TAG, this.resourceBundle.getString("compare.node.hashes").replace("#nodeName#", this.nodeConnection.getName() + " " + this.nodeConnection.getNumber()).replace("#tableName#", serviceTable.getName()).replace("#hashes#", (equalHashes ? "EQUAL" : "NOT EQUAL") + " Master Hash: " + serviceTable.getMasterHash() + " Node Hash: " + resultSet.getString("hash")));
                }
            }
            catch (NullPointerException | SQLException ex) {
                ServicesLog.logError(LOG_TAG, this.resourceBundle.getString("compare.node.hashes.not.sync.exception").replace("#nodeName#", this.nodeConnection.getName() + " " + this.nodeConnection.getNumber()).replace("#tableName#", serviceTable.getName()).replace("#exception#", ex.getMessage()));
                equalHashes = false;
            }
            if (equalHashes) continue;
            ServicesLog.logInfo(LOG_TAG, this.resourceBundle.getString("compare.node.hashes.not.sync").replace("#nodeName#", this.nodeConnection.getName() + " " + this.nodeConnection.getNumber()).replace("#tableName#", serviceTable.getName()));
            notSynced = true;
            tablesToSync.add(serviceTable);
        }
        this.connection.close();
        if (notSynced) {
            return new CompareNodeHashResult(0, this.nodeConnection.getId(), true, tablesToSync);
        }
        return new CompareNodeHashResult(0, this.nodeConnection.getId(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeTables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeConnection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "resourceBundle";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/remote/callables/CompareNodeHashesCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

