/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.remote;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceNodeStatus;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.sync.remote.SyncRemoteServiceInterface;
import com.systel.sync.services.sync.remote.callables.CompareNodeHashesCallable;
import com.systel.sync.services.sync.remote.callables.CompareNodeTablesHashCallable;
import com.systel.sync.services.sync.remote.callables.CreateDBLinkFunctionsCallable;
import com.systel.sync.services.sync.remote.callables.CreateHashFunctionCallable;
import com.systel.sync.services.sync.remote.callables.CreateNodeHashFunctionCallable;
import com.systel.sync.services.sync.remote.callables.DeleteNodeTableDataCallable;
import com.systel.sync.services.sync.remote.callables.SelectMasterTableDataCallable;
import com.systel.sync.services.sync.remote.callables.SelectTableDeletedIdsCallable;
import com.systel.sync.services.sync.remote.callables.SelectTableHashCallable;
import com.systel.sync.services.sync.remote.callables.TruncateTablesCallable;
import com.systel.sync.services.sync.remote.callables.UpdateNodeSetupCallable;
import com.systel.sync.services.sync.remote.callables.UpdateTableDataCallable;
import com.systel.sync.services.sync.remote.results.CompareNodeHashResult;
import com.systel.sync.services.sync.remote.results.CompareNodeTablesHashResult;
import com.systel.sync.services.sync.remote.results.ServiceTableResult;
import com.systel.sync.services.sync.remote.results.SyncNodeResult;
import com.systel.sync.services.sync.remote.results.UpdateTableDataResult;
import com.systel.sync.services.sync.results.TableDataResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SyncRemoteService
implements SyncRemoteServiceInterface {
    private static final String LOG_TAG = SyncRemoteService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;
    private ExecutorService parallelExecutor;
    private ResourceBundle resourceBundle;

    public SyncRemoteService(ConnectionService connectionService, ResourceBundle resourceBundle) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
        this.parallelExecutor = Executors.newFixedThreadPool(5);
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void createHashFunctionInMaster(ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getMasterConnection();
            Future<SyncNodeResult> future = this.parallelExecutor.submit(new CreateHashFunctionCallable(connection, 0L));
            SyncNodeResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectMasterTableHashes(TreeSet<ServiceTable> serviceTables, ServiceCallback<TreeSet<ServiceTable>, Integer> callback) {
        try {
            Connection connection = this.connectionService.getMasterConnection();
            Future<ServiceTableResult> future = this.executor.submit(new SelectTableHashCallable(connection, serviceTables));
            ServiceTableResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceTables());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void createHashFunctionInNodes(TreeSet<ServiceNodeConnection> nodeConnections, ServiceCallback<ArrayList<ServiceNodeStatus>, Integer> callback) {
        HashSet<Future<SyncNodeResult>> set = new HashSet<Future<SyncNodeResult>>();
        ArrayList<ServiceNodeStatus> nodesStatus = new ArrayList<ServiceNodeStatus>();
        for (ServiceNodeConnection serviceNodeConnection : nodeConnections) {
            try {
                Connection connection = this.connectionService.getRemoteConnection(serviceNodeConnection);
                nodesStatus.add(new ServiceNodeStatus(serviceNodeConnection.getId(), 0));
                Future<SyncNodeResult> future = this.parallelExecutor.submit(new CreateNodeHashFunctionCallable(connection, serviceNodeConnection.getId()));
                set.add(future);
            }
            catch (ConnectionException ex) {
                nodesStatus.add(new ServiceNodeStatus(serviceNodeConnection.getId(), 4));
            }
        }
        for (Future future : set) {
            try {
                SyncNodeResult result = (SyncNodeResult)future.get();
                ((ServiceNodeStatus)nodesStatus.get(nodesStatus.indexOf(new ServiceNodeStatus(result.getNodeId())))).setStatus(result.getResultCode() != 0 ? 0 : 1);
            }
            catch (InterruptedException | ExecutionException ex) {
                ServicesLog.logError(LOG_TAG, ex.getMessage());
            }
        }
        callback.onSuccess(nodesStatus);
    }

    @Override
    public void compareNodeHashes(TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> serviceTables, ServiceCallback<ArrayList<ServiceNodeStatus>, Integer> callback) {
        HashSet<Future<CompareNodeHashResult>> set = new HashSet<Future<CompareNodeHashResult>>();
        ArrayList<ServiceNodeStatus> nodesStatus = new ArrayList<ServiceNodeStatus>();
        for (ServiceNodeConnection serviceNodeConnection : nodeConnections) {
            try {
                Connection connection = this.connectionService.getRemoteConnection(serviceNodeConnection);
                nodesStatus.add(new ServiceNodeStatus(serviceNodeConnection.getId(), 2));
                Future<CompareNodeHashResult> future = this.parallelExecutor.submit(new CompareNodeHashesCallable(connection, serviceTables, serviceNodeConnection, this.resourceBundle));
                set.add(future);
            }
            catch (ConnectionException ex) {
                nodesStatus.add(new ServiceNodeStatus(serviceNodeConnection.getId(), 4));
            }
        }
        for (Future future : set) {
            try {
                CompareNodeHashResult result = (CompareNodeHashResult)future.get();
                ((ServiceNodeStatus)nodesStatus.get(nodesStatus.indexOf(new ServiceNodeStatus(result.getNodeId())))).setStatus(result.isNotSynced() ? 2 : 3);
                ((ServiceNodeStatus)nodesStatus.get(nodesStatus.indexOf(new ServiceNodeStatus(result.getNodeId())))).setTablesToSync(result.getTablesToSync());
            }
            catch (InterruptedException | ExecutionException ex) {
                ServicesLog.logError(LOG_TAG, ex.getMessage());
            }
        }
        callback.onSuccess(nodesStatus);
    }

    @Override
    public void selectMasterData(TreeSet<ServiceTable> serviceTables, ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer> callback) {
        try {
            Connection connection = this.connectionService.getMasterConnection();
            Future<TableDataResult> future = this.executor.submit(new SelectMasterTableDataCallable(connection, serviceTables));
            TableDataResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getTablesData());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void compareNodeTablesHash(ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> serviceTables, boolean disableTriggers, ServiceCallback<TreeSet<ServiceTable>, Integer> callback) {
        try (Connection connection = this.connectionService.getRemoteConnection(nodeConnection);){
            Future<CompareNodeTablesHashResult> future;
            CompareNodeTablesHashResult result;
            if (disableTriggers) {
                Statement statement = connection.createStatement();
                statement.execute((String)SQLQueries.getInstance().get((Object)SQLQuery.setReplicationRole));
            }
            if ((result = (future = this.parallelExecutor.submit(new CompareNodeTablesHashCallable(connection, serviceTables))).get()).getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceTables());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException | SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void createDBLinkFunctions(ServiceNodeConnection nodeConnection, ServiceCallback<Integer, Integer> callback) {
        try (Connection connection = this.connectionService.getRemoteConnection(nodeConnection);){
            Future<BaseResult> future = this.parallelExecutor.submit(new CreateDBLinkFunctionsCallable(connection, nodeConnection.getId()));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (ConnectionException | SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
        catch (InterruptedException | ExecutionException e) {
            ServicesLog.logError(LOG_TAG, e.getMessage());
            callback.onFailure(-1);
        }
    }

    @Override
    public void deleteNodeRecords(ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> serviceTables, boolean disableTriggers, LinkedHashMap<Integer, ServiceTableData> recordIds, ServiceCallback<Integer, Integer> callback) {
        try (Connection connection = this.connectionService.getRemoteConnection(nodeConnection);){
            Future<BaseResult> future;
            BaseResult result;
            if (disableTriggers) {
                Statement statement = connection.createStatement();
                statement.execute((String)SQLQueries.getInstance().get((Object)SQLQuery.setReplicationRole));
            }
            if ((result = (future = this.parallelExecutor.submit(new DeleteNodeTableDataCallable(connection, nodeConnection, serviceTables, recordIds, this.resourceBundle))).get()).getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException | SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectNodeDeletedRecords(ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> serviceTables, boolean disableTriggers, LinkedHashMap<Integer, ServiceTableData> recordIds, ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer> callback) {
        try (Connection connection = this.connectionService.getRemoteConnection(nodeConnection);){
            Future<TableDataResult> future;
            TableDataResult result;
            if (disableTriggers) {
                Statement statement = connection.createStatement();
                statement.execute((String)SQLQueries.getInstance().get((Object)SQLQuery.setReplicationRole));
            }
            if ((result = (future = this.parallelExecutor.submit(new SelectTableDeletedIdsCallable(connection, serviceTables, recordIds))).get()).getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getTablesData());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException | SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateNodeWithUpdatedData(ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> serviceTables, boolean disableTriggers, LinkedHashMap<Integer, ServiceTableData> tablesData, ServiceCallback<Boolean, Integer> callback) {
        try (Connection connection = this.connectionService.getRemoteConnection(nodeConnection);){
            Future<UpdateTableDataResult> future;
            UpdateTableDataResult result;
            if (disableTriggers) {
                Statement statement = connection.createStatement();
                statement.execute((String)SQLQueries.getInstance().get((Object)SQLQuery.setReplicationRole));
            }
            if ((result = (future = this.executor.submit(new UpdateTableDataCallable(connection, nodeConnection, serviceTables, tablesData, this.resourceBundle))).get()).getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.isPartial());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException | SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void truncateTables(ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> serviceTables, ServiceCallback<Integer, Integer> callback) {
        try (Connection connection = this.connectionService.getRemoteConnection(nodeConnection);){
            Future<BaseResult> future = this.executor.submit(new TruncateTablesCallable(connection, serviceTables));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-1);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException | SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateNodeSetup(ServiceNodeConnection nodeConnection, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getRemoteConnection(nodeConnection);
            Future<BaseResult> future = this.parallelExecutor.submit(new UpdateNodeSetupCallable(connection, nodeConnection, this.connectionService.getMasterConnection()));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(0);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }
}

