/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.local.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.results.BaseResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class TruncateTablesCallable
implements Callable<BaseResult> {
    private static final String LOG_TAG = TruncateTablesCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> tables;

    public TruncateTablesCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> tables) {
        if (connection == null) {
            TruncateTablesCallable.$$$reportNull$$$0(0);
        }
        if (tables == null) {
            TruncateTablesCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.tables = tables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            int i = 0;
            StringBuilder builder = new StringBuilder();
            for (ServiceTable table : this.tables) {
                builder.append(table.getName());
                if (i < this.tables.size() - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            statement.execute(((String)SQLQueries.getInstance().get((Object)SQLQuery.truncateCascade)).replace("#table#", builder.toString()));
            BaseResult baseResult = new BaseResult(0);
            return baseResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new BaseResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tables";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/local/callables/TruncateTablesCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

