/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.local.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.sync.results.TableDataResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class SelectTableUpdatedIdsCallable
implements Callable<TableDataResult> {
    private static final String LOG_TAG = SelectTableUpdatedIdsCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> serviceTables;

    public SelectTableUpdatedIdsCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> serviceTables) {
        if (connection == null) {
            SelectTableUpdatedIdsCallable.$$$reportNull$$$0(0);
        }
        if (serviceTables == null) {
            SelectTableUpdatedIdsCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.serviceTables = serviceTables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableDataResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            LinkedHashMap<Integer, ServiceTableData> tablesData = new LinkedHashMap<Integer, ServiceTableData>();
            Object tableDataResult = this.serviceTables.iterator();
            while (true) {
                ServiceTableData tableData;
                int columnCount;
                ResultSet resultSet;
                if (tableDataResult.hasNext()) {
                    ServiceTable serviceTable = tableDataResult.next();
                    resultSet = statement.executeQuery(((String)SQLQueries.getInstance().get((Object)SQLQuery.selectGenericWithColumns)).replace("#columns#", serviceTable.getPrimaryKey()).replace("#table#", serviceTable.getName()));
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    columnCount = resultSetMetaData.getColumnCount();
                    tableData = new ServiceTableData(serviceTable.getId());
                    for (int i = 1; i <= columnCount; ++i) {
                        tableData.getColumnNames().add(resultSetMetaData.getColumnLabel(i));
                    }
                } else {
                    tableDataResult = new TableDataResult(0, tablesData);
                    return tableDataResult;
                }
                while (resultSet.next()) {
                    ServiceTableRow data = new ServiceTableRow();
                    for (int i = 1; i <= columnCount; ++i) {
                        data.getRow().add(resultSet.getString(i));
                    }
                    tableData.getRows().add(data);
                }
                if (tableData.getRows().size() <= 0) continue;
                tablesData.put(tableData.getTableId(), tableData);
            }
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new TableDataResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTables";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/local/callables/SelectTableUpdatedIdsCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

