/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.local.callables;

import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.sync.results.TableDataResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class SelectTableDataIdsCallable
implements Callable<TableDataResult> {
    private static final String LOG_TAG = SelectTableDataIdsCallable.class.getSimpleName();
    private Connection connection;
    private ServiceNodeConnection nodeConnection;
    private Set<ServiceTable> serviceTables;

    public SelectTableDataIdsCallable(@NotNull Connection connection, ServiceNodeConnection nodeConnection, @NotNull Set<ServiceTable> serviceTables) {
        if (connection == null) {
            SelectTableDataIdsCallable.$$$reportNull$$$0(0);
        }
        if (serviceTables == null) {
            SelectTableDataIdsCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.nodeConnection = nodeConnection;
        this.serviceTables = serviceTables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableDataResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            LinkedHashMap<Integer, ServiceTableData> recordIds = new LinkedHashMap<Integer, ServiceTableData>();
            Object tableDataResult = this.serviceTables.iterator();
            while (true) {
                int columnCount;
                ServiceTableData tableData;
                ResultSet resultSet;
                ServiceTable serviceTable;
                if (tableDataResult.hasNext()) {
                    serviceTable = tableDataResult.next();
                    resultSet = statement.executeQuery(serviceTable.getSqlForNode().replace("#host#", this.nodeConnection.getIpAddress()).replace("#port#", this.nodeConnection.getDbPort()).replace("#dbname#", this.nodeConnection.getDbName()).replace("#user#", this.nodeConnection.getDbUser()).replace("#pass#", this.nodeConnection.getDbPass()));
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    tableData = new ServiceTableData(serviceTable.getId());
                    columnCount = resultSetMetaData.getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        tableData.getColumnNames().add(resultSetMetaData.getColumnLabel(i));
                    }
                } else {
                    tableDataResult = new TableDataResult(0, recordIds);
                    return tableDataResult;
                }
                while (resultSet.next()) {
                    ServiceTableRow data = new ServiceTableRow();
                    for (int i = 1; i <= columnCount; ++i) {
                        data.getRow().add(resultSet.getString(i));
                    }
                    tableData.getRows().add(data);
                }
                if (tableData.getRows().size() <= 0) continue;
                recordIds.put(serviceTable.getId(), tableData);
            }
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new TableDataResult(-1);
        }
        catch (Exception e) {
            ServicesLog.logError(LOG_TAG, e.getMessage());
            return new TableDataResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTables";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/local/callables/SelectTableDataIdsCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

