/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.local.callables;

import com.systel.sync.common.sql.SQLSelectUtils;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.sync.results.TableDataResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class SelectTableDataCallable
implements Callable<TableDataResult> {
    private static final String LOG_TAG = SelectTableDataCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> serviceTables;
    private LinkedHashMap<Integer, ServiceTableData> serviceTablesData;

    public SelectTableDataCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> serviceTables, @NotNull LinkedHashMap<Integer, ServiceTableData> serviceTablesData) {
        if (connection == null) {
            SelectTableDataCallable.$$$reportNull$$$0(0);
        }
        if (serviceTables == null) {
            SelectTableDataCallable.$$$reportNull$$$0(1);
        }
        if (serviceTablesData == null) {
            SelectTableDataCallable.$$$reportNull$$$0(2);
        }
        this.connection = connection;
        this.serviceTables = serviceTables;
        this.serviceTablesData = serviceTablesData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableDataResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            LinkedHashMap<Integer, ServiceTableData> records = new LinkedHashMap<Integer, ServiceTableData>();
            Object tableDataResult = this.serviceTables.iterator();
            while (true) {
                ServiceTableData tableData;
                int columnCount;
                ResultSet resultSet;
                if (tableDataResult.hasNext()) {
                    ServiceTable serviceTable = tableDataResult.next();
                    if (!this.serviceTablesData.containsKey(serviceTable.getId())) continue;
                    ArrayList<String> primaryKeys = new ArrayList<String>();
                    if (serviceTable.getPrimaryKey().contains(", ")) {
                        for (String primaryKey : serviceTable.getPrimaryKey().split(",")) {
                            primaryKeys.add(primaryKey.trim());
                        }
                    } else {
                        primaryKeys.add(serviceTable.getPrimaryKey());
                    }
                    ArrayList<String> resultColumns = new ArrayList<String>();
                    resultColumns.add("*");
                    String sql = SQLSelectUtils.makeSelectStatement(serviceTable.getName(), resultColumns, primaryKeys, this.serviceTablesData.get(serviceTable.getId()).getRows(), false);
                    resultSet = statement.executeQuery(sql);
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    columnCount = resultSetMetaData.getColumnCount();
                    tableData = new ServiceTableData(serviceTable.getId());
                    for (int i = 1; i <= columnCount; ++i) {
                        tableData.getColumnNames().add(resultSetMetaData.getColumnLabel(i));
                    }
                } else {
                    tableDataResult = new TableDataResult(0, records);
                    return tableDataResult;
                }
                while (resultSet.next()) {
                    ServiceTableRow data = new ServiceTableRow();
                    for (int i = 1; i <= columnCount; ++i) {
                        String val = resultSet.getString(i);
                        if (resultSet.wasNull()) {
                            val = "null";
                        }
                        data.getRow().add(val);
                    }
                    tableData.getRows().add(data);
                }
                if (tableData.getRows().size() <= 0) continue;
                records.put(tableData.getTableId(), tableData);
            }
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            if (!ex.getMessage().contains("max_stack_depth")) return new TableDataResult(-1);
            return new TableDataResult(-4);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTablesData";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/local/callables/SelectTableDataCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

