/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.local.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.sync.local.results.ServiceNodeConnectionResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class SelectNodeCallable
implements Callable<ServiceNodeConnectionResult> {
    private static final String LOG_TAG = SelectNodeCallable.class.getSimpleName();
    private Connection connection;
    private Long nodeId;

    public SelectNodeCallable(@NotNull Connection connection, @NotNull Long nodeId) {
        if (connection == null) {
            SelectNodeCallable.$$$reportNull$$$0(0);
        }
        if (nodeId == null) {
            SelectNodeCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.nodeId = nodeId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServiceNodeConnectionResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery(((String)SQLQueries.getInstance().get((Object)SQLQuery.selectNode)).replace("#nodeId#", Long.toString(this.nodeId)));){
            if (!resultSet.next()) return new ServiceNodeConnectionResult(-1);
            ServiceNodeConnection serviceNodeConnection = new ServiceNodeConnection();
            serviceNodeConnection.setId(resultSet.getLong("id"));
            serviceNodeConnection.setName(resultSet.getString("name"));
            serviceNodeConnection.setNumber(resultSet.getString("number"));
            serviceNodeConnection.setStatus(resultSet.getInt("status"));
            serviceNodeConnection.setIpAddress(resultSet.getString("ip_address"));
            serviceNodeConnection.setDbName(resultSet.getString("db_name"));
            serviceNodeConnection.setDbPort(resultSet.getString("db_port"));
            serviceNodeConnection.setDbUser(resultSet.getString("db_user"));
            serviceNodeConnection.setDbPass(resultSet.getString("db_pass"));
            serviceNodeConnection.setVersion(resultSet.getString("lot"));
            serviceNodeConnection.setMaceth(resultSet.getString("maceth"));
            serviceNodeConnection.setMacwifi(resultSet.getString("macwifi"));
            ServiceNodeConnectionResult serviceNodeConnectionResult = new ServiceNodeConnectionResult(0, serviceNodeConnection);
            return serviceNodeConnectionResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
        }
        return new ServiceNodeConnectionResult(-1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeId";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/local/callables/SelectNodeCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

