/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.local.callables;

import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.sync.remote.callables.CompareNodeHashesCallable;
import com.systel.sync.services.sync.remote.results.CompareNodeHashResult;
import java.sql.Connection;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class CompareMasterWithSyncCallable
implements Callable<CompareNodeHashResult> {
    private static final String LOG_TAG = CompareNodeHashesCallable.class.getSimpleName();
    private Connection connection;
    private TreeSet<ServiceTable> nodeTables;
    private ResourceBundle resourceBundle;

    public CompareMasterWithSyncCallable(@NotNull Connection connection, @NotNull TreeSet<ServiceTable> nodeTables, @NotNull ResourceBundle resourceBundle) {
        if (connection == null) {
            CompareMasterWithSyncCallable.$$$reportNull$$$0(0);
        }
        if (nodeTables == null) {
            CompareMasterWithSyncCallable.$$$reportNull$$$0(1);
        }
        if (resourceBundle == null) {
            CompareMasterWithSyncCallable.$$$reportNull$$$0(2);
        }
        this.connection = connection;
        this.nodeTables = nodeTables;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public CompareNodeHashResult call() throws Exception {
        boolean equalHashes = false;
        boolean notSynced = false;
        TreeSet<ServiceTable> tablesToSync = new TreeSet<ServiceTable>();
        for (ServiceTable serviceTable : this.nodeTables) {
            equalHashes = false;
            if (serviceTable.getMasterHash() != null && serviceTable.getSyncHash() != null) {
                equalHashes = serviceTable.getSyncHash().equals(serviceTable.getMasterHash());
            }
            if (equalHashes) continue;
            ServicesLog.logInfo(LOG_TAG, this.resourceBundle.getString("compare.node.hashes").replace("#nodeName#", "Sync with Master").replace("#tableName#", serviceTable.getName()).replace("#hashes#", (equalHashes ? "EQUAL" : "NOT EQUAL") + " Master Hash: " + serviceTable.getMasterHash() + " Sync Hash: " + serviceTable.getSyncHash()));
            tablesToSync.add(serviceTable);
        }
        if (!tablesToSync.isEmpty()) {
            return new CompareNodeHashResult(0, 0L, true, tablesToSync);
        }
        return new CompareNodeHashResult(0, 0L, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeTables";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "resourceBundle";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/sync/local/callables/CompareMasterWithSyncCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

