/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.sync.local;

import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceNodeStatus;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import com.systel.sync.services.sync.local.callables.CompareMasterWithSyncCallable;
import com.systel.sync.services.sync.local.callables.CreateSyncHashFunctionCallable;
import com.systel.sync.services.sync.local.callables.DeleteOldLogsCallable;
import com.systel.sync.services.sync.local.callables.ResetStatusCallable;
import com.systel.sync.services.sync.local.callables.SelectNodeCallable;
import com.systel.sync.services.sync.local.callables.SelectNodesCallable;
import com.systel.sync.services.sync.local.callables.SelectSyncHashCallable;
import com.systel.sync.services.sync.local.callables.SelectTableDataCallable;
import com.systel.sync.services.sync.local.callables.SelectTableDataIdsCallable;
import com.systel.sync.services.sync.local.callables.SelectTableUpdatedIdsCallable;
import com.systel.sync.services.sync.local.callables.SelectTablesCallable;
import com.systel.sync.services.sync.local.callables.TruncateTablesCallable;
import com.systel.sync.services.sync.local.callables.UpdateDatabasesCallable;
import com.systel.sync.services.sync.local.callables.UpdateNodeStatusCallable;
import com.systel.sync.services.sync.local.callables.UpdateNodesStatusCallable;
import com.systel.sync.services.sync.local.callables.UpdateSynchronizationNodeStatusCallable;
import com.systel.sync.services.sync.local.callables.UpdateTableDataCallable;
import com.systel.sync.services.sync.local.callables.UpdateVerificationNodeStatusCallable;
import com.systel.sync.services.sync.local.callables.UpdateVerificationNodesStatusCallable;
import com.systel.sync.services.sync.local.results.ServiceNodeConnectionResult;
import com.systel.sync.services.sync.local.results.ServiceNodeConnectionsResult;
import com.systel.sync.services.sync.local.results.ServiceTablesResult;
import com.systel.sync.services.sync.remote.results.CompareNodeHashResult;
import com.systel.sync.services.sync.remote.results.ServiceTableResult;
import com.systel.sync.services.sync.remote.results.SyncNodeResult;
import com.systel.sync.services.sync.results.TableDataResult;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SyncLocalService
implements SyncLocalServiceInterface {
    private static final String LOG_TAG = SyncLocalService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;
    private ExecutorService parallelExecutor;
    private ResourceBundle resourceBundle;

    public SyncLocalService(ConnectionService connectionService, ResourceBundle resourceBundle) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
        this.parallelExecutor = Executors.newFixedThreadPool(5);
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void resetStatus(int status, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new ResetStatusCallable(connection, status));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateDb(ServiceCallback<Integer, Integer> callback, ArrayList<String> nodeIps, String psqlPath) {
        try {
            Future<BaseResult> future = this.executor.submit(new UpdateDatabasesCallable(nodeIps, psqlPath.toLowerCase()));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
    }

    @Override
    public void deleteOldLogs(ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new DeleteOldLogsCallable(connection));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void executeExternalCommand(ServiceCallback<Integer, Integer> callback) {
        switch (this.connectionService.getConfigurationService().getBeforeSyncType()) {
            case 0: {
                callback.onSuccess(0);
                break;
            }
            case 1: {
                try {
                    Process process = new ProcessBuilder("C:\\SYSTEL\\java\\jre\\bin\\javaw.exe", "-jar", "C:\\SYSTEL\\Importador\\SystelSyncFile.jar", "-i", "-c", "-f").start();
                    process.waitFor();
                    int errorCode = process.exitValue();
                    if (errorCode > 0) {
                        callback.onFailure(errorCode);
                        break;
                    }
                    callback.onSuccess(0);
                }
                catch (IOException e) {
                    callback.onFailure(1);
                }
                catch (InterruptedException e) {
                    callback.onFailure(1);
                }
                break;
            }
            case 2: {
                try {
                    Process process = new ProcessBuilder(this.connectionService.getConfigurationService().getBeforeSyncCommand().split(" ")).start();
                    process.waitFor();
                    int errorCode = process.exitValue();
                    if (errorCode > 0) {
                        callback.onFailure(errorCode);
                        break;
                    }
                    callback.onSuccess(0);
                    break;
                }
                catch (IOException e) {
                    callback.onFailure(1);
                    break;
                }
                catch (InterruptedException e) {
                    callback.onFailure(1);
                }
            }
        }
    }

    @Override
    public void selectNodes(ServiceCallback<TreeSet<ServiceNodeConnection>, Integer> callback, ArrayList<Long> nodeIds) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<ServiceNodeConnectionsResult> future = this.executor.submit(new SelectNodesCallable(connection, nodeIds));
            ServiceNodeConnectionsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-1);
            } else {
                callback.onSuccess(result.getServiceNodeConnections());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectNode(Long nodeId, ServiceCallback<ServiceNodeConnection, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<ServiceNodeConnectionResult> future = this.executor.submit(new SelectNodeCallable(connection, nodeId));
            ServiceNodeConnectionResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-1);
            } else {
                callback.onSuccess(result.getServiceNodeConnection());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void createHashFunctionInSync(ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<SyncNodeResult> future = this.parallelExecutor.submit(new CreateSyncHashFunctionCallable(connection, 0L));
            SyncNodeResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectSyncTableHashes(TreeSet<ServiceTable> serviceTables, ServiceCallback<TreeSet<ServiceTable>, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<ServiceTableResult> future = this.executor.submit(new SelectSyncHashCallable(connection, serviceTables));
            ServiceTableResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceTables());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void compareMasterWithSyncHashes(TreeSet<ServiceTable> serviceTables, ServiceCallback<ServiceNodeStatus, Integer> callback) {
        HashSet set = new HashSet();
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<CompareNodeHashResult> future = this.parallelExecutor.submit(new CompareMasterWithSyncCallable(connection, serviceTables, this.resourceBundle));
            CompareNodeHashResult result = future.get();
            ServiceNodeStatus syncStatusResult = new ServiceNodeStatus(0L);
            syncStatusResult.setStatus(result.isNotSynced() ? 2 : 3);
            syncStatusResult.setTablesToSync(result.getTablesToSync());
            callback.onSuccess(syncStatusResult);
        }
        catch (ConnectionException ex) {
            callback.onSuccess(new ServiceNodeStatus(0L, 4));
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
        }
    }

    @Override
    public void selectTables(String processType, ServiceCallback<TreeSet<ServiceTable>, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<ServiceTablesResult> future = this.executor.submit(new SelectTablesCallable(connection, processType));
            ServiceTablesResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-1);
            } else {
                callback.onSuccess(result.getServiceTables());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateNodesSyncStatus(ArrayList<ServiceNodeStatus> nodesStatus, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new UpdateNodesStatusCallable(connection, nodesStatus));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateVerificationNodesSyncStatus(ArrayList<ServiceNodeStatus> nodesStatus, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new UpdateVerificationNodesStatusCallable(connection, nodesStatus));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void truncateTables(TreeSet<ServiceTable> serviceTables, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new TruncateTablesCallable(connection, serviceTables));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-1);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateLocalWithMasterData(TreeSet<ServiceTable> serviceTables, LinkedHashMap<Integer, ServiceTableData> masterTableData, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new UpdateTableDataCallable(connection, serviceTables, masterTableData, this.resourceBundle));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectRecordIds(TreeSet<ServiceTable> serviceTables, ServiceNodeConnection nodeConnection, ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<TableDataResult> future = this.executor.submit(new SelectTableDataIdsCallable(connection, nodeConnection, serviceTables));
            TableDataResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getTablesData());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectTotalRowsNotSynced(TreeSet<ServiceTable> serviceTables, LinkedHashMap<Integer, ServiceTableData> totalTableRowIdsNotSynced, ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<TableDataResult> future = this.parallelExecutor.submit(new SelectTableDataCallable(connection, serviceTables, totalTableRowIdsNotSynced));
            TableDataResult result = future.get();
            ServicesLog.logError("@@@ selectTotalRowsNotSynced: result.getResultCode():", String.valueOf(result.getResultCode()));
            if (result.getResultCode() != 0) {
                if (result.getResultCode() != -4) {
                    callback.onFailure(-2);
                } else {
                    callback.onFailure(-4);
                }
            } else {
                callback.onSuccess(result.getTablesData());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateNodeSyncStatus(ServiceNodeStatus nodeStatus, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new UpdateNodeStatusCallable(connection, nodeStatus));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(0);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateSynchronizationNodeSyncStatus(ServiceNodeStatus nodeStatus, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new UpdateSynchronizationNodeStatusCallable(connection, nodeStatus));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(0);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateVerificationNodeSyncStatus(ServiceNodeStatus nodeStatus, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<BaseResult> future = this.executor.submit(new UpdateVerificationNodeStatusCallable(connection, nodeStatus));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(0);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectMasterTablesUpdatedIds(TreeSet<ServiceTable> updatedTables, ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<TableDataResult> future = this.executor.submit(new SelectTableUpdatedIdsCallable(connection, updatedTables));
            TableDataResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getTablesData());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }
}

