/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.scheduler;

import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceSchedule;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.scheduler.SchedulerServiceInterface;
import com.systel.sync.services.scheduler.callables.SelectSchedulesCallable;
import com.systel.sync.services.scheduler.callables.UpdateFinishedRunCallable;
import com.systel.sync.services.scheduler.callables.UpdateScheduleCallable;
import com.systel.sync.services.scheduler.results.SelectSchedulesResult;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class SchedulerService
implements SchedulerServiceInterface {
    private static final String LOG_TAG = SchedulerService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;

    public SchedulerService(ConnectionService connectionService) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void selectSchedules(ServiceCallback<ArrayList<ServiceSchedule>, Integer> callback) {
        try {
            Future<SelectSchedulesResult> future = this.executor.submit(new SelectSchedulesCallable(this.connectionService.getLocalConnection()));
            SelectSchedulesResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceSchedules());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateSchedules(ArrayList<ServiceSchedule> serviceSchedules, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<BaseResult> future = this.executor.submit(new UpdateScheduleCallable(this.connectionService.getLocalConnection(), serviceSchedules));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            }
            callback.onSuccess(0);
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateFinishedRun(int scheduler, long currentTimeInMillis, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<BaseResult> future = this.executor.submit(new UpdateFinishedRunCallable(this.connectionService.getLocalConnection(), scheduler, currentTimeInMillis));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }
}

