/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.salesmerge.remote.callables;

import com.systel.sync.common.sql.SQLInsertUtils;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.common.results.AffectedRowsResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class InsertMasterSalesCallable
implements Callable<AffectedRowsResult> {
    private static final String LOG_TAG = InsertMasterSalesCallable.class.getSimpleName();
    private Connection connection;
    private ArrayList<ServiceTableData> serviceTableData;

    public InsertMasterSalesCallable(@NotNull Connection connection, @NotNull ArrayList<ServiceTableData> serviceTableData) {
        if (connection == null) {
            InsertMasterSalesCallable.$$$reportNull$$$0(0);
        }
        if (serviceTableData == null) {
            InsertMasterSalesCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.serviceTableData = serviceTableData;
    }

    @Override
    public AffectedRowsResult call() throws Exception {
        boolean error = false;
        int affectedRows = 0;
        for (ServiceTableData data : this.serviceTableData) {
            for (ServiceTableRow singleRow : data.getRows()) {
                try {
                    Statement statement = this.connection.createStatement();
                    Throwable throwable = null;
                    try {
                        Stream<ServiceTableRow> stream = Stream.of(singleRow);
                        String sql = stream.map(row -> SQLInsertUtils.makeStatement(data.getTableName(), data.getColumnNames(), row)).reduce("", (st1, st2) -> st1 + st2);
                        affectedRows += statement.executeUpdate(sql);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    error = true;
                    ServicesLog.logError(LOG_TAG, ex.getMessage());
                }
            }
        }
        if (error) {
            // empty if block
        }
        return new AffectedRowsResult(0, affectedRows);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTableData";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/salesmerge/remote/callables/InsertMasterSalesCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

