/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.salesmerge.remote;

import com.systel.sync.common.sql.SQLDateTimeUtils;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceNodeTableData;
import com.systel.sync.services.common.entities.ServiceProductData;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.results.AffectedRowsResult;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.salesmerge.remote.SalesMergeRemoteServiceInterface;
import com.systel.sync.services.salesmerge.remote.callables.InsertClosingSales;
import com.systel.sync.services.salesmerge.remote.callables.InsertMasterSalesCallable;
import com.systel.sync.services.salesmerge.remote.callables.SelectMasterProductsCallable;
import com.systel.sync.services.salesmerge.remote.callables.SelectNodeSalesCallable;
import com.systel.sync.services.salesmerge.remote.results.SelectMasterProductsResult;
import com.systel.sync.services.salesmerge.remote.results.SelectNodeSalesResult;
import com.systel.sync.services.sync.remote.callables.TruncateTablesCallable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class SalesMergeRemoteService
implements SalesMergeRemoteServiceInterface {
    private static final String LOG_TAG = SalesMergeRemoteService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;

    public SalesMergeRemoteService(ConnectionService connectionService) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void selectNodeTables(ArrayList<ServiceNodeConnection> nodeConnections, ArrayList<ServiceTable> tables, String endDate, ServiceCallback<ArrayList<ServiceNodeTableData>, Integer> callback) {
        HashSet<Future<SelectNodeSalesResult>> futures = new HashSet<Future<SelectNodeSalesResult>>();
        ArrayList<ServiceNodeTableData> serviceNodeTableDataList = new ArrayList<ServiceNodeTableData>();
        for (ServiceNodeConnection serviceNodeConnection : nodeConnections) {
            String beginDate;
            try {
                beginDate = SQLDateTimeUtils.formatDate(serviceNodeConnection.getLastSalesMerge());
            }
            catch (NullPointerException ex) {
                beginDate = serviceNodeConnection.getLastSalesMerge();
            }
            try {
                Connection connection = this.connectionService.getRemoteConnection(serviceNodeConnection);
                Future<SelectNodeSalesResult> future = this.executor.submit(new SelectNodeSalesCallable(connection, tables, serviceNodeConnection, beginDate, endDate));
                futures.add(future);
            }
            catch (ConnectionException ex) {
                serviceNodeTableDataList.add(new ServiceNodeTableData(serviceNodeConnection));
            }
        }
        for (Future future : futures) {
            try {
                SelectNodeSalesResult result = (SelectNodeSalesResult)future.get();
                serviceNodeTableDataList.add(new ServiceNodeTableData(result.getServiceTablesData(), result.getServiceNodeConnection()));
            }
            catch (InterruptedException | ExecutionException ex) {
                ServicesLog.logError(LOG_TAG, ex.getMessage());
            }
        }
        callback.onSuccess(serviceNodeTableDataList);
    }

    @Override
    public void selectMasterProducts(ServiceCallback<ArrayList<ServiceProductData>, Integer> callback) {
        try {
            Future<SelectMasterProductsResult> future = this.executor.submit(new SelectMasterProductsCallable(this.connectionService.getMasterConnection()));
            SelectMasterProductsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceProductData());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void closingSales(ServiceCallback<Integer, Integer> callback, ArrayList<ServiceNodeConnection> node) {
        try {
            ArrayList<BaseResult> result = new ArrayList<BaseResult>();
            for (ServiceNodeConnection nodes : node) {
                Future<BaseResult> future = this.executor.submit(new InsertClosingSales(this.connectionService.getRemoteConnection(nodes), this.connectionService.getMasterConnection(), node));
                result.add(future.get());
            }
            BaseResult result2 = new BaseResult(0);
            for (int i = 0; i < result.size(); ++i) {
                if (((BaseResult)result.get(i)).getResultCode() != 0) {
                    result2.setResultCode(-2);
                    continue;
                }
                result2.setResultCode(0);
            }
            if (result2.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result2.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void insertMasterSales(ArrayList<ServiceTableData> serviceTableData, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<AffectedRowsResult> future = this.executor.submit(new InsertMasterSalesCallable(this.connectionService.getMasterConnection(), serviceTableData));
            AffectedRowsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getAffectedRows());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void truncateTables(ArrayList<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> serviceTables, ServiceCallback<ServiceNodeConnection, ServiceNodeConnection> callback) {
        for (ServiceNodeConnection nodeConnection : nodeConnections) {
            try {
                Connection connection = this.connectionService.getRemoteConnection(nodeConnection);
                Throwable throwable = null;
                try {
                    Future<BaseResult> future = this.executor.submit(new TruncateTablesCallable(connection, serviceTables));
                    BaseResult result = future.get();
                    if (result.getResultCode() != 0) {
                        callback.onFailure(nodeConnection);
                        continue;
                    }
                    callback.onSuccess(nodeConnection);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                ServicesLog.logError(LOG_TAG, ex.getMessage());
                callback.onFailure(nodeConnection);
            }
            catch (ConnectionException | SQLException ex) {
                ServicesLog.logError(LOG_TAG, ex.getMessage());
                callback.onFailure(nodeConnection);
            }
        }
    }
}

