/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.salesmerge.local.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceProductData;
import com.systel.sync.services.common.results.AffectedRowsResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class UpdateSalesCallable
implements Callable<AffectedRowsResult> {
    private static final String LOG_TAG = UpdateSalesCallable.class.getSimpleName();
    private Connection connection;
    private ArrayList<ServiceProductData> serviceProductData;

    public UpdateSalesCallable(@NotNull Connection connection, @NotNull ArrayList<ServiceProductData> serviceProductData) {
        if (connection == null) {
            UpdateSalesCallable.$$$reportNull$$$0(0);
        }
        if (serviceProductData == null) {
            UpdateSalesCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.serviceProductData = serviceProductData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AffectedRowsResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (ServiceProductData data : this.serviceProductData) {
                builder.append(data.getProductId());
                if (++i >= this.serviceProductData.size()) continue;
                builder.append(", ");
            }
            AffectedRowsResult affectedRowsResult = new AffectedRowsResult(0, statement.executeUpdate(((String)SQLQueries.getInstance().get((Object)SQLQuery.updateUnknownSales)).replace("#unknownProductId#", "-1").replace("#productIds#", builder.toString())));
            return affectedRowsResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new AffectedRowsResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceProductData";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/salesmerge/local/callables/UpdateSalesCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

