/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.salesmerge.local.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.salesmerge.local.results.SelectSalesResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class SelectSalesCallable
implements Callable<SelectSalesResult> {
    private static final String LOG_TAG = SelectSalesCallable.class.getSimpleName();
    private Connection connection;
    private ArrayList<ServiceTable> tables;

    public SelectSalesCallable(@NotNull Connection connection, @NotNull ArrayList<ServiceTable> tables) {
        if (connection == null) {
            SelectSalesCallable.$$$reportNull$$$0(0);
        }
        if (tables == null) {
            SelectSalesCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.tables = tables;
    }

    @Override
    public SelectSalesResult call() throws Exception {
        try {
            ArrayList<ServiceTableData> serviceTableDataList = new ArrayList<ServiceTableData>();
            for (ServiceTable table : this.tables) {
                ServiceTableData serviceTableData = new ServiceTableData(table.getId(), table.getName());
                Statement statement = this.connection.createStatement();
                ResultSet resultSet = statement.executeQuery(((String)SQLQueries.getInstance().get((Object)SQLQuery.selectGeneric)).replace("#table#", table.getName()));
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int columnCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    serviceTableData.getColumnNames().add(resultSetMetaData.getColumnLabel(i));
                }
                while (resultSet.next()) {
                    ServiceTableRow data = new ServiceTableRow();
                    for (int i = 1; i <= columnCount; ++i) {
                        data.getRow().add(resultSet.getString(i));
                    }
                    serviceTableData.getRows().add(data);
                }
                serviceTableDataList.add(serviceTableData);
            }
            return new SelectSalesResult(0, serviceTableDataList);
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new SelectSalesResult(0);
        }
        catch (NullPointerException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new SelectSalesResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tables";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/salesmerge/local/callables/SelectSalesCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

