/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.salesmerge.local.callables;

import com.systel.sync.common.sql.SQLInsertUtils;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.common.results.AffectedRowsResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class InsertSalesCallable
implements Callable<AffectedRowsResult> {
    private static final String LOG_TAG = InsertSalesCallable.class.getSimpleName();
    private Connection connection;
    private ArrayList<ServiceTableData> serviceTableData;

    public InsertSalesCallable(@NotNull Connection connection, @NotNull ArrayList<ServiceTableData> serviceTableData) {
        if (connection == null) {
            InsertSalesCallable.$$$reportNull$$$0(0);
        }
        if (serviceTableData == null) {
            InsertSalesCallable.$$$reportNull$$$0(1);
        }
        this.connection = connection;
        this.serviceTableData = serviceTableData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AffectedRowsResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            this.connection.setAutoCommit(false);
            int affectedRows = 0;
            for (ServiceTableData data : this.serviceTableData) {
                for (ServiceTableRow singleRow : data.getRows()) {
                    Stream<ServiceTableRow> stream = Stream.of(singleRow);
                    String sql = stream.map(row -> SQLInsertUtils.makeStatement(data.getTableName(), data.getColumnNames(), row)).reduce("", (st1, st2) -> st1 + st2);
                    affectedRows += statement.executeUpdate(sql);
                }
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
            AffectedRowsResult affectedRowsResult = new AffectedRowsResult(0, affectedRows);
            return affectedRowsResult;
        }
        catch (SQLException ex) {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new AffectedRowsResult(-1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serviceTableData";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/salesmerge/local/callables/InsertSalesCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

