/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.salesmerge.local;

import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceProductData;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.results.AffectedRowsResult;
import com.systel.sync.services.salesmerge.local.SalesMergeLocalServiceInterface;
import com.systel.sync.services.salesmerge.local.callables.DeleteSalesCallable;
import com.systel.sync.services.salesmerge.local.callables.InsertSalesCallable;
import com.systel.sync.services.salesmerge.local.callables.SelectNodeConnectionCallable;
import com.systel.sync.services.salesmerge.local.callables.SelectSalesCallable;
import com.systel.sync.services.salesmerge.local.callables.SelectTablesCallable;
import com.systel.sync.services.salesmerge.local.callables.UpdateNodesCallable;
import com.systel.sync.services.salesmerge.local.callables.UpdateSalesCallable;
import com.systel.sync.services.salesmerge.local.results.SelectSalesResult;
import com.systel.sync.services.salesmerge.local.results.SelectServiceNodeConnectionResult;
import com.systel.sync.services.salesmerge.local.results.SelectTablesResult;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class SalesMergeLocalService
implements SalesMergeLocalServiceInterface {
    private static final String LOG_TAG = SalesMergeLocalService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;

    public SalesMergeLocalService(ConnectionService connectionService) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void selectTables(ServiceCallback<ArrayList<ServiceTable>, Integer> callback) {
        try {
            Future<SelectTablesResult> future = this.executor.submit(new SelectTablesCallable(this.connectionService.getLocalConnection()));
            SelectTablesResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceTables());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectNodeConnection(ServiceCallback<ArrayList<ServiceNodeConnection>, Integer> callback) {
        try {
            Future<SelectServiceNodeConnectionResult> future = this.executor.submit(new SelectNodeConnectionCallable(this.connectionService.getLocalConnection(), null));
            SelectServiceNodeConnectionResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceNodesConnection());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectNodesConnection(ServiceCallback<ArrayList<ServiceNodeConnection>, Integer> callback, ArrayList<Long> nodeIds) {
        try {
            Future<SelectServiceNodeConnectionResult> future = this.executor.submit(new SelectNodeConnectionCallable(this.connectionService.getLocalConnection(), nodeIds));
            SelectServiceNodeConnectionResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceNodesConnection());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void deleteSales(ArrayList<ServiceTable> tables, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<AffectedRowsResult> future = this.executor.submit(new DeleteSalesCallable(this.connectionService.getLocalConnection(), tables));
            AffectedRowsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getAffectedRows());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void insertSales(ArrayList<ServiceTableData> serviceTableData, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<AffectedRowsResult> future = this.executor.submit(new InsertSalesCallable(this.connectionService.getLocalConnection(), serviceTableData));
            AffectedRowsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getAffectedRows());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateSales(ArrayList<ServiceProductData> serviceProductData, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<AffectedRowsResult> future = this.executor.submit(new UpdateSalesCallable(this.connectionService.getLocalConnection(), serviceProductData));
            AffectedRowsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.affectedRows);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectSales(ArrayList<ServiceTable> tables, ServiceCallback<ArrayList<ServiceTableData>, Integer> callback) {
        try {
            Future<SelectSalesResult> future = this.executor.submit(new SelectSalesCallable(this.connectionService.getLocalConnection(), tables));
            SelectSalesResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getServiceTableData());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateNodes(ArrayList<Long> nodeIds, String endDate, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<AffectedRowsResult> future = this.executor.submit(new UpdateNodesCallable(this.connectionService.getLocalConnection(), nodeIds, endDate));
            AffectedRowsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.affectedRows);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }
}

