/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.preferences;

import com.systel.sync.business.common.entities.PreferencesData;
import com.systel.sync.common.ConfigurationProperties;
import com.systel.sync.common.Language;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.preferences.PreferencesServiceInterface;

public final class PreferencesService
implements PreferencesServiceInterface {
    private static final String LOG_TAG = PreferencesService.class.getSimpleName();
    private ConfigurationService configurationService;
    private ConnectionService connectionService;

    public PreferencesService(ConfigurationService configurationService, ConnectionService connectionService) {
        this.configurationService = configurationService;
        this.connectionService = connectionService;
    }

    @Override
    public void select(ServiceCallback<PreferencesData, Integer> callback) {
        try {
            PreferencesData preferencesData = new PreferencesData();
            preferencesData.setMasterIpAddress(this.configurationService.getMasterDBHost());
            preferencesData.setLanguage(new Language(this.configurationService.getLocale(), this.configurationService.getLanguage()));
            preferencesData.setLogLevel(this.configurationService.getLogLevel());
            preferencesData.getMasterIpAddress().equals(preferencesData.getMasterIpAddress());
            this.connectionService.resetMasterConnection();
            callback.onSuccess(preferencesData);
        }
        catch (NullPointerException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
    }

    @Override
    public void update(PreferencesData preferencesData, ServiceCallback<Integer, Integer> callback) {
        try {
            ConfigurationProperties configurationProperties = this.configurationService.getConfigurationProperties();
            configurationProperties.setProperty("masterDBHost", preferencesData.getMasterIpAddress());
            configurationProperties.setProperty("locale", preferencesData.getLanguage().getLocale());
            configurationProperties.setProperty("logLevel", preferencesData.getLogLevel().name());
            this.configurationService.setConfigurationProperties(configurationProperties);
            this.configurationService.save();
            this.connectionService.resetMasterConnection();
            callback.onSuccess(0);
        }
        catch (Exception ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
    }
}

