/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.nodes.remote;

import com.systel.sync.business.common.entities.Node;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNode;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.nodes.remote.NodesRemoteServiceInterface;
import com.systel.sync.services.nodes.remote.callables.InsertNodesCallable;
import com.systel.sync.services.nodes.remote.callables.UpdateSetupNodesCallable;
import com.systel.sync.services.sync.local.callables.SelectNodeCallable;
import com.systel.sync.services.sync.local.results.ServiceNodeConnectionResult;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class NodesRemoteService
implements NodesRemoteServiceInterface {
    private static final String LOG_TAG = NodesRemoteService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;

    public NodesRemoteService(ConnectionService connectionService) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void uploadNodes(ArrayList<ServiceNode> nodes, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getMasterConnection();
            Future<BaseResult> future = this.executor.submit(new InsertNodesCallable(connection, nodes));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectUpdateNodes(Node node, ServiceCallback<ServiceNodeConnection, Integer> callback) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<ServiceNodeConnectionResult> future = this.executor.submit(new SelectNodeCallable(connection, node.getId()));
            ServiceNodeConnectionResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-1);
            } else {
                callback.onSuccess(result.getServiceNodeConnection());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateNodes(Node node, ServiceNodeConnection nodeConnection, ServiceCallback<Integer, Integer> callback) {
        try {
            Connection connection = this.connectionService.getRemoteConnection(nodeConnection);
            Future<BaseResult> future = this.executor.submit(new UpdateSetupNodesCallable(connection, this.connectionService.getMasterConnection(), nodeConnection, node));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateVariables(String nodeIp, ServiceCallback<Integer, Integer> callback) {
        try {
            String requestMessagePattern = "SET_ALL_VALUES";
            byte[] sendData = requestMessagePattern.getBytes();
            InetAddress address = InetAddress.getByName(nodeIp);
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(2000);
            DatagramPacket requestPacket = new DatagramPacket(sendData, sendData.length, address, 8888);
            datagramSocket.send(requestPacket);
            callback.onSuccess(0);
        }
        catch (SocketException e) {
            callback.onFailure(-2);
            throw new RuntimeException(e);
        }
        catch (UnknownHostException e) {
            callback.onFailure(-2);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            callback.onFailure(-2);
            throw new RuntimeException(e);
        }
    }
}

