/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.nodes.models;

import com.systel.sync.business.common.entities.NodeModel;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.nodes.models.NodeModelsServiceInterface;
import com.systel.sync.services.nodes.models.callables.SelectModelsCallable;
import com.systel.sync.services.nodes.models.results.SelectModelsResult;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class NodeModelsService
implements NodeModelsServiceInterface {
    private static final String LOG_TAG = NodeModelsService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;

    public NodeModelsService(ConnectionService connectionService) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void selectModels(ServiceCallback<ArrayList<NodeModel>, Integer> callback) {
        try {
            Future<SelectModelsResult> future = this.executor.submit(new SelectModelsCallable(this.connectionService.getLocalConnection()));
            SelectModelsResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getModels());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }
}

