/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.nodes.local.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNode;
import com.systel.sync.services.common.results.BaseResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class UpdateNodeCallable
implements Callable<BaseResult> {
    private static final String LOG_TAG = UpdateNodeCallable.class.getSimpleName();
    private Connection connection;
    private ServiceNode node;

    public UpdateNodeCallable(@NotNull Connection connection, @NotNull ServiceNode node) {
        if (connection == null) {
            UpdateNodeCallable.$$$reportNull$$$0(0);
        }
        if (node == null) {
            UpdateNodeCallable.$$$reportNull$$$0(1);
        }
        this.node = node;
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseResult call() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement((String)SQLQueries.getInstance().get((Object)SQLQuery.updateNode));){
            preparedStatement.setString(1, this.node.getIpAddress());
            preparedStatement.setString(2, this.node.getName());
            preparedStatement.setString(3, this.node.getNumber());
            preparedStatement.setString(4, this.node.getDescription());
            preparedStatement.setInt(5, this.node.getModelId());
            preparedStatement.setLong(6, this.node.getId());
            preparedStatement.setString(7, this.node.getVersion());
            preparedStatement.setString(8, this.node.getMaceth());
            preparedStatement.setString(9, this.node.getMacwifi());
            preparedStatement.executeUpdate();
            BaseResult baseResult = new BaseResult(0);
            return baseResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            if (!ex.getSQLState().equals("23505")) return new BaseResult(-1);
            return new BaseResult(-4);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/nodes/local/callables/UpdateNodeCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

