/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.nodes.local.callables;

import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ServiceCallbackWithProgress;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.nodes.local.results.DiscoverNodeResult;
import com.systel.sync.services.nodes.local.results.DiscoverNodesResult;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.Callable;

public final class SetDateTimeNodesCallable
implements Callable<DiscoverNodesResult> {
    private static final String LOG_TAG = SetDateTimeNodesCallable.class.getSimpleName();
    private static String requestMessagePatternDateTime = "";
    private static final String responseMessagePatternDateTime = "DATETIME_SET_OK";
    private static final String errorMessagePattern = "|--|--|--|ERROR DE CONEXION|cuora_neo_cm.jpg";
    private Connection connection;
    private ConfigurationService configurationService;
    private int modelId;
    private ServiceCallbackWithProgress<Integer, Integer, DiscoverNodeResult> callback;

    @Override
    public DiscoverNodesResult call() throws Exception {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            requestMessagePatternDateTime = "SET_DATETIME|" + dateFormat.format(date);
            byte[] sendDataDateTime = requestMessagePatternDateTime.getBytes();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    try {
                        if (interfaceAddress.getAddress().toString().contains(":")) continue;
                        DatagramSocket datagramSocket = new DatagramSocket();
                        datagramSocket.setBroadcast(true);
                        datagramSocket.setSoTimeout(2000);
                        InetAddress broadcast = interfaceAddress.getBroadcast();
                        DatagramPacket requestPacket = new DatagramPacket(sendDataDateTime, sendDataDateTime.length, broadcast, 8888);
                        byte[] responseBuffer = new byte[15000];
                        DatagramPacket responsePacket = new DatagramPacket(responseBuffer, responseBuffer.length);
                        datagramSocket.send(requestPacket);
                        System.out.println(this.getClass().getName() + ">>> Broadcast DateTime SEND: " + requestPacket.getAddress().getHostAddress());
                        try {
                            while (true) {
                                responsePacket.setData(responseBuffer);
                                responsePacket.setLength(responseBuffer.length);
                                datagramSocket.receive(responsePacket);
                                System.out.println(this.getClass().getName() + ">>> Broadcast DateTime response from server: " + responsePacket.getAddress().getHostAddress());
                                String message = new String(responsePacket.getData(), responsePacket.getOffset(), responsePacket.getLength());
                                if (message.contains(responseMessagePatternDateTime)) {
                                    String[] msg = message.split("\\|");
                                    System.out.println("SET DATE TIME OK: " + responsePacket.getAddress().getHostAddress());
                                    continue;
                                }
                                System.out.println("SET DATE TIME ERROR: " + responsePacket.getAddress().getHostAddress());
                            }
                        }
                        catch (SocketTimeoutException ex) {
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (SocketException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            return new DiscoverNodesResult(-3);
        }
        return new DiscoverNodesResult(0);
    }

    private static interface Scale {
        public static final int Number = 1;
        public static final int Capacity = 2;
        public static final int Unit = 3;
        public static final int Name = 4;
        public static final int Icon = 5;
        public static final int Type = 6;
    }
}

