/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.nodes.local.callables;

import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNode;
import com.systel.sync.services.common.results.BaseResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class InsertNodeCallable
implements Callable<BaseResult> {
    private static final String LOG_TAG = InsertNodeCallable.class.getSimpleName();
    private Connection connection;
    private ServiceNode node;

    public InsertNodeCallable(@NotNull Connection connection, @NotNull ServiceNode node) {
        if (connection == null) {
            InsertNodeCallable.$$$reportNull$$$0(0);
        }
        if (node == null) {
            InsertNodeCallable.$$$reportNull$$$0(1);
        }
        this.node = node;
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseResult call() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            int affectedRows = statement.executeUpdate(((String)SQLQueries.getInstance().get((Object)SQLQuery.insertNode)).replace("#ipAddress#", this.node.getIpAddress()).replace("#number#", this.node.getNumber()).replace("#name#", this.node.getName()).replace("#description#", this.node.getDescription() != null ? this.node.getDescription() : "").replace("#status#", Integer.toString(this.node.getStatus())).replace("#modelId#", Integer.toString(this.node.getModelId())).replace("#dbPort#", this.node.getDbPort()).replace("#dbName#", this.node.getDbName()).replace("#dbUser#", this.node.getDbUser()).replace("#dbPass#", this.node.getDbPass()).replace("#lot#", this.node.getVersion() != null ? this.node.getVersion() : "").replace("#maceth#", this.node.getMaceth() != null ? this.node.getMaceth() : "").replace("#macwifi#", this.node.getMacwifi() != null ? this.node.getMacwifi() : ""));
            if (affectedRows <= 0) return new BaseResult(-1);
            BaseResult baseResult = new BaseResult(0);
            return baseResult;
        }
        catch (SQLException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            if (!ex.getSQLState().equals("23505")) return new BaseResult(-1);
            return new BaseResult(-4);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/nodes/local/callables/InsertNodeCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

