/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.nodes.local.callables;

import com.systel.sync.business.common.entities.Node;
import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ServiceCallbackWithProgress;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.nodes.local.results.DiscoverNodeResult;
import com.systel.sync.services.nodes.local.results.DiscoverNodesResult;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import org.jetbrains.annotations.NotNull;

public final class DiscoverNodesCallable
implements Callable<DiscoverNodesResult> {
    private static final String LOG_TAG = DiscoverNodesCallable.class.getSimpleName();
    private static final String requestMessagePattern = "DISCOVER_FUIFSERVER_REQUEST";
    private static String requestMessagePatternDateTime = "";
    private static final String responseMessagePattern = "DISCOVER_FUIFSERVER_RESPONSE";
    private static final String responseMessagePatternDateTime = "DATETIME_SET_OK";
    private static final String errorMessagePattern = "|--|--|--|ERROR DE CONEXION|cuora_neo_cm.jpg";
    private Connection connection;
    private ConfigurationService configurationService;
    private int modelId;
    private ServiceCallbackWithProgress<Integer, Integer, DiscoverNodeResult> callback;
    private ResourceBundle resourceBundle;
    private ArrayList<Node> nodes;
    public boolean aux;

    public DiscoverNodesCallable(@NotNull Connection connection, @NotNull ConfigurationService configurationService, @NotNull ServiceCallbackWithProgress<Integer, Integer, DiscoverNodeResult> callback, int modelId, ResourceBundle resourceBundle, ArrayList<Node> nodes) {
        if (connection == null) {
            DiscoverNodesCallable.$$$reportNull$$$0(0);
        }
        if (configurationService == null) {
            DiscoverNodesCallable.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            DiscoverNodesCallable.$$$reportNull$$$0(2);
        }
        this.nodes = new ArrayList();
        this.aux = false;
        this.connection = connection;
        this.configurationService = configurationService;
        this.callback = callback;
        this.modelId = modelId;
        this.resourceBundle = resourceBundle;
        this.nodes = nodes;
    }

    @Override
    public DiscoverNodesResult call() throws Exception {
        block77: {
            try {
                PreparedStatement preparedStatement;
                Object responseBuffer2;
                Object requestPacket;
                byte[] sendData = requestMessagePattern.getBytes();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                Date date = new Date();
                requestMessagePatternDateTime = "SET_DATETIME|" + dateFormat.format(date);
                byte[] sendDataDateTime = requestMessagePatternDateTime.getBytes();
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                ArrayList<Node> nodesNow = new ArrayList<Node>();
                ArrayList<Node> nodesUpdate = new ArrayList<Node>();
                ArrayList<Node> temporal = new ArrayList<Node>();
                ArrayList nodesRemove = new ArrayList();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                    for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                        try {
                            InetAddress address = interfaceAddress.getAddress();
                            if (address.isLoopbackAddress() || address.getHostAddress().indexOf(58) != -1) continue;
                            DatagramSocket datagramSocket = new DatagramSocket();
                            datagramSocket.setBroadcast(true);
                            datagramSocket.setSoTimeout(2000);
                            InetAddress broadcast = interfaceAddress.getBroadcast();
                            requestPacket = new DatagramPacket(sendData, sendData.length, broadcast, 8888);
                            responseBuffer2 = new byte[15000];
                            DatagramPacket responsePacket = new DatagramPacket((byte[])responseBuffer2, ((byte[])responseBuffer2).length);
                            int maxAttempts = 3;
                            boolean flag = !this.nodes.isEmpty();
                            for (int i = 0; i < maxAttempts; ++i) {
                                datagramSocket.send((DatagramPacket)requestPacket);
                                try {
                                    while (true) {
                                        DiscoverNodeResult discoverResult;
                                        if ((discoverResult = this.discoverAny(datagramSocket, responsePacket)).getResultCode() != 0) {
                                            continue;
                                        }
                                        temporal.add(discoverResult.getNode());
                                        if (!flag) {
                                            this.nodes.add(discoverResult.getNode());
                                            nodesNow.add(discoverResult.getNode());
                                            continue;
                                        }
                                        boolean nodeExists = false;
                                        boolean numberChanged = false;
                                        boolean nameChanged = false;
                                        for (int j = 0; j < this.nodes.size(); ++j) {
                                            Node node = this.nodes.get(j);
                                            if (!node.getIpAddress().equalsIgnoreCase(discoverResult.getNode().getIpAddress())) continue;
                                            if (node.getNumber().equalsIgnoreCase(discoverResult.getNode().getNumber()) && node.getName().equalsIgnoreCase(discoverResult.getNode().getName())) {
                                                nodeExists = true;
                                                break;
                                            }
                                            if (!node.getNumber().equalsIgnoreCase(discoverResult.getNode().getNumber())) {
                                                discoverResult.getNode().setId(node.getId());
                                                nodesUpdate.add(discoverResult.getNode());
                                                numberChanged = true;
                                                break;
                                            }
                                            if (node.getName().equalsIgnoreCase(discoverResult.getNode().getName())) continue;
                                            discoverResult.getNode().setId(node.getId());
                                            nodesUpdate.add(discoverResult.getNode());
                                            nameChanged = true;
                                            break;
                                        }
                                        if (nodeExists || numberChanged || nameChanged) continue;
                                        nodesNow.add(discoverResult.getNode());
                                    }
                                }
                                catch (SocketTimeoutException ex) {
                                    flag = true;
                                    continue;
                                }
                            }
                            if (interfaceAddress.getAddress().toString().contains(":")) continue;
                            requestPacket = new DatagramPacket(sendDataDateTime, sendDataDateTime.length, broadcast, 8888);
                            datagramSocket.send((DatagramPacket)requestPacket);
                            System.out.println(this.getClass().getName() + ">>> Broadcast DateTime SEND: " + ((DatagramPacket)requestPacket).getAddress().getHostAddress());
                            try {
                                while (true) {
                                    responsePacket.setData((byte[])responseBuffer2);
                                    responsePacket.setLength(((Object)responseBuffer2).length);
                                    datagramSocket.receive(responsePacket);
                                    System.out.println(this.getClass().getName() + ">>> Broadcast DateTime response from server: " + responsePacket.getAddress().getHostAddress());
                                    String message = new String(responsePacket.getData(), responsePacket.getOffset(), responsePacket.getLength());
                                    if (message.contains(responseMessagePatternDateTime)) {
                                        String[] msg = message.split("\\|");
                                        System.out.println("SET DATE TIME OK: " + responsePacket.getAddress().getHostAddress());
                                        continue;
                                    }
                                    System.out.println("SET DATE TIME ERROR: " + responsePacket.getAddress().getHostAddress());
                                }
                            }
                            catch (SocketTimeoutException ex) {
                            }
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
                LinkedHashSet setTemporal = new LinkedHashSet(temporal);
                temporal.clear();
                temporal.addAll(setTemporal);
                Iterator<Node> iterator = this.nodes.iterator();
                while (iterator.hasNext()) {
                    Node element = iterator.next();
                    if (temporal.contains(element)) continue;
                    iterator.remove();
                }
                LinkedHashSet setNodesNow = new LinkedHashSet(nodesNow);
                nodesNow.clear();
                nodesNow.addAll(setNodesNow);
                if (!nodesNow.isEmpty()) {
                    for (Node node : nodesNow) {
                        try {
                            Statement statement = this.connection.createStatement();
                            requestPacket = null;
                            try {
                                statement.executeUpdate(((String)SQLQueries.getInstance().get((Object)SQLQuery.insertNode)).replace("#ipAddress#", node.getIpAddress()).replace("#number#", node.getNumber()).replace("#name#", node.getName()).replace("#description#", node.getDescription() != null ? node.getDescription() : "").replace("#status#", Integer.toString(node.getStatus())).replace("#modelId#", Integer.toString(node.getModelId())).replace("#dbPort#", this.configurationService.getDefaultDBPort()).replace("#dbName#", this.configurationService.getDefaultDBName()).replace("#dbUser#", this.configurationService.getDefaultDBUser()).replace("#dbPass#", this.configurationService.getDefaultDBPassword()).replace("#lot#", node.getVersion() != null ? node.getVersion() : "").replace("#maceth#", node.getMACEth() != null ? node.getMACEth() : "").replace("#macwifi#", node.getMACWiFi() != null ? node.getMACWiFi() : ""));
                                this.callback.onProgress(new DiscoverNodeResult(3000, node));
                            }
                            catch (Throwable responseBuffer2) {
                                requestPacket = responseBuffer2;
                                throw responseBuffer2;
                            }
                            finally {
                                if (statement == null) continue;
                                if (requestPacket != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable responseBuffer2) {
                                        ((Throwable)requestPacket).addSuppressed(responseBuffer2);
                                    }
                                    continue;
                                }
                                statement.close();
                            }
                        }
                        catch (SQLException ex) {
                            ServicesLog.logError(LOG_TAG, ex.getMessage());
                            this.callback.onProgress(new DiscoverNodeResult(3004, node));
                            this.aux = true;
                        }
                    }
                }
                LinkedHashSet setNodesUpdate = new LinkedHashSet(nodesUpdate);
                nodesUpdate.clear();
                nodesUpdate.addAll(setNodesUpdate);
                if (!nodesUpdate.isEmpty()) {
                    for (Node node : nodesUpdate) {
                        try {
                            preparedStatement = this.connection.prepareStatement((String)SQLQueries.getInstance().get((Object)SQLQuery.updateNode));
                            responseBuffer2 = null;
                            try {
                                preparedStatement.setString(1, node.getIpAddress());
                                preparedStatement.setString(2, node.getName());
                                preparedStatement.setString(3, node.getNumber());
                                preparedStatement.setString(4, node.getDescription());
                                preparedStatement.setInt(5, node.getModelId());
                                preparedStatement.setLong(6, node.getId());
                                preparedStatement.setString(7, node.getVersion());
                                preparedStatement.setString(8, node.getMACEth());
                                preparedStatement.setString(9, node.getMACWiFi());
                                preparedStatement.executeUpdate();
                                this.callback.onProgress(new DiscoverNodeResult(3002, node));
                            }
                            catch (Throwable throwable) {
                                responseBuffer2 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                if (responseBuffer2 != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)responseBuffer2).addSuppressed(throwable);
                                    }
                                    continue;
                                }
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException ex) {
                            ServicesLog.logError(LOG_TAG, ex.getMessage());
                            this.callback.onProgress(new DiscoverNodeResult(3004, node));
                            try (PreparedStatement preparedStatement2 = this.connection.prepareStatement((String)SQLQueries.getInstance().get((Object)SQLQuery.deleteNode));){
                                preparedStatement2.setLong(1, node.getId());
                                preparedStatement2.executeUpdate();
                            }
                            catch (SQLException e) {
                                ServicesLog.logError(LOG_TAG, e.getMessage());
                            }
                            this.aux = true;
                        }
                    }
                }
                if (nodesRemove.isEmpty()) break block77;
                for (Node node : nodesRemove) {
                    try {
                        preparedStatement = this.connection.prepareStatement((String)SQLQueries.getInstance().get((Object)SQLQuery.deleteNode));
                        Throwable throwable = null;
                        try {
                            preparedStatement.setLong(1, node.getId());
                            preparedStatement.executeUpdate();
                            this.callback.onProgress(new DiscoverNodeResult(3005, node));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            preparedStatement.close();
                        }
                    }
                    catch (SQLException ex) {
                        ServicesLog.logError(LOG_TAG, ex.getMessage());
                    }
                }
            }
            catch (SocketException ex) {
                ServicesLog.logError(LOG_TAG, ex.getMessage());
                return new DiscoverNodesResult(-3);
            }
        }
        if (this.aux) {
            Platform.runLater(() -> {
                try {
                    Alert alert = new Alert(Alert.AlertType.WARNING);
                    alert.setTitle(this.resourceBundle.getString("nodes.discovery.id.repeat"));
                    alert.setHeaderText(this.resourceBundle.getString("nodes.discovery.id.repeat.alert.message"));
                    alert.initModality(Modality.APPLICATION_MODAL);
                    alert.showAndWait().ifPresent(rs -> {
                        if (rs == ButtonType.OK) {
                            alert.close();
                        }
                    });
                }
                catch (Exception e) {
                    ServicesLog.logError("@@@ WARNING ERROR:", e.getMessage());
                }
            });
        }
        return new DiscoverNodesResult(0);
    }

    public DiscoverNodeResult discoverAny(DatagramSocket datagramSocket, DatagramPacket responsePacket) throws IOException, SocketTimeoutException {
        byte[] responseBuffer = new byte[15000];
        responsePacket.setData(responseBuffer);
        responsePacket.setLength(responseBuffer.length);
        datagramSocket.receive(responsePacket);
        String message = "";
        message = new String(responsePacket.getData()).trim();
        if (message.contains(responseMessagePattern)) {
            String[] messageSplit = message.split("\\|");
            if (messageSplit[6].toUpperCase().contains("SELFSERVICE")) {
                return new DiscoverNodeResult(-1);
            }
            if (messageSplit[6].toUpperCase().contains("MODULAR")) {
                return new DiscoverNodeResult(-1);
            }
            Node.Builder nodeBuilder = new Node.Builder();
            nodeBuilder.setIpAddress(responsePacket.getAddress().getHostAddress());
            nodeBuilder.setName(messageSplit[4]);
            nodeBuilder.setNumber(messageSplit[1]);
            if (messageSplit[6].toUpperCase().contains("NEO")) {
                nodeBuilder.setModelId(1);
            } else if (messageSplit[6].toUpperCase().contains("VICL")) {
                nodeBuilder.setModelId(4);
            } else if (messageSplit[6].toUpperCase().contains("SELFSERVICE")) {
                nodeBuilder.setModelId(5);
            } else if (messageSplit[6].toUpperCase().contains("MODULAR")) {
                nodeBuilder.setModelId(6);
            } else {
                nodeBuilder.setModelId(1);
            }
            try {
                nodeBuilder.setVersion(messageSplit[7].toUpperCase().trim());
            }
            catch (Exception e) {
                nodeBuilder.setVersion("");
            }
            try {
                nodeBuilder.setMACEth(messageSplit[8].toUpperCase().trim());
            }
            catch (Exception e) {
                nodeBuilder.setMACEth("");
            }
            try {
                nodeBuilder.setMACWiFi(messageSplit[9].toUpperCase().trim());
            }
            catch (Exception e) {
                nodeBuilder.setMACWiFi("");
            }
            return new DiscoverNodeResult(0, nodeBuilder.build());
        }
        return new DiscoverNodeResult(-1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configurationService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/systel/sync/services/nodes/local/callables/DiscoverNodesCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface Scale {
        public static final int Number = 1;
        public static final int Capacity = 2;
        public static final int Unit = 3;
        public static final int Name = 4;
        public static final int Icon = 6;
        public static final int Type = 6;
        public static final int Version = 7;
        public static final int MACEth = 8;
        public static final int MACWiFi = 9;
    }
}

