/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.nodes.local;

import com.systel.sync.business.common.entities.Node;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServiceCallbackWithProgress;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNode;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.nodes.local.NodesLocalServiceInterface;
import com.systel.sync.services.nodes.local.callables.DeleteNodeCallable;
import com.systel.sync.services.nodes.local.callables.DeleteNodesCallable;
import com.systel.sync.services.nodes.local.callables.DiscoverNodesCallable;
import com.systel.sync.services.nodes.local.callables.InsertNodeCallable;
import com.systel.sync.services.nodes.local.callables.SelectDefaultModelCallable;
import com.systel.sync.services.nodes.local.callables.SelectNodesCallable;
import com.systel.sync.services.nodes.local.callables.UpdateNodeCallable;
import com.systel.sync.services.nodes.local.results.DiscoverNodeResult;
import com.systel.sync.services.nodes.local.results.DiscoverNodesResult;
import com.systel.sync.services.nodes.local.results.SelectDefaultModelResult;
import com.systel.sync.services.nodes.local.results.SelectNodesResult;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class NodesLocalService
implements NodesLocalServiceInterface {
    private static final String LOG_TAG = NodesLocalService.class.getSimpleName();
    private ConfigurationService configurationService;
    private ConnectionService connectionService;
    private ExecutorService executor;
    private ResourceBundle resourceBundle;

    public NodesLocalService(ConfigurationService configurationService, ConnectionService connectionService, ResourceBundle resourceBundle) {
        this.configurationService = configurationService;
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void discoverNodes(ServiceCallbackWithProgress<Integer, Integer, DiscoverNodeResult> callback, ArrayList<Node> nodes) {
        try {
            Connection connection = this.connectionService.getLocalConnection();
            Future<SelectDefaultModelResult> future = this.executor.submit(new SelectDefaultModelCallable(connection));
            SelectDefaultModelResult modelResult = future.get();
            if (modelResult.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                Future<DiscoverNodesResult> discoverFuture = this.executor.submit(new DiscoverNodesCallable(connection, this.configurationService, callback, modelResult.getModelId(), this.resourceBundle, nodes));
                DiscoverNodesResult discoverNodesResult = discoverFuture.get();
                if (discoverNodesResult.getResultCode() != 0) {
                    callback.onFailure(-2);
                } else {
                    callback.onSuccess(discoverNodesResult.getResultCode());
                }
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void selectNodes(ServiceCallback<ArrayList<Node>, Integer> callback) {
        try {
            Future<SelectNodesResult> future = this.executor.submit(new SelectNodesCallable(this.connectionService.getLocalConnection()));
            SelectNodesResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getNodes());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void insertNodeRow(Node node, ServiceCallback<Integer, Integer> callback) {
        try {
            ServiceNode serviceNode = new ServiceNode();
            serviceNode.setIpAddress(node.getIpAddress());
            serviceNode.setName(node.getName());
            serviceNode.setNumber(node.getNumber());
            serviceNode.setDescription(node.getDescription());
            serviceNode.setStatus(node.getStatus());
            serviceNode.setModelId(node.getModelId());
            serviceNode.setDbName(this.configurationService.getDefaultDBName());
            serviceNode.setDbPort(this.configurationService.getDefaultDBPort());
            serviceNode.setDbUser(this.configurationService.getDefaultDBUser());
            serviceNode.setDbPass(this.configurationService.getDefaultDBPassword());
            serviceNode.setVersion(this.configurationService.getDefaultVersion());
            Future<BaseResult> future = this.executor.submit(new InsertNodeCallable(this.connectionService.getLocalConnection(), serviceNode));
            BaseResult result = future.get();
            if (result.getResultCode() == -4) {
                callback.onFailure(result.getResultCode());
            } else if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void updateNodeRow(Node node, ServiceCallback<Integer, Integer> callback) {
        try {
            ServiceNode serviceNode = new ServiceNode();
            serviceNode.setId(node.getId());
            serviceNode.setIpAddress(node.getIpAddress());
            serviceNode.setName(node.getName());
            serviceNode.setNumber(node.getNumber());
            serviceNode.setModelId(node.getModelId());
            serviceNode.setDescription(node.getDescription());
            serviceNode.setDbName(this.configurationService.getDefaultDBName());
            serviceNode.setDbPort(this.configurationService.getDefaultDBPort());
            serviceNode.setDbUser(this.configurationService.getDefaultDBUser());
            serviceNode.setDbPass(this.configurationService.getDefaultDBPassword());
            Future<BaseResult> future = this.executor.submit(new UpdateNodeCallable(this.connectionService.getLocalConnection(), serviceNode));
            BaseResult result = future.get();
            if (result.getResultCode() == -4) {
                callback.onFailure(result.getResultCode());
            } else if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void deleteNodeRow(long nodeId, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<BaseResult> future = this.executor.submit(new DeleteNodeCallable(this.connectionService.getLocalConnection(), nodeId));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void deleteNodes(ArrayList<Long> nodeIds, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<BaseResult> future = this.executor.submit(new DeleteNodesCallable(this.connectionService.getLocalConnection(), nodeIds));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }
}

