/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.log;

import com.systel.sync.log.LogLevel;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.log.LogServiceInterface;
import com.systel.sync.services.log.callables.ExportLogTableCallable;
import com.systel.sync.services.log.callables.TruncateLogTableCallable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class LogService
implements LogServiceInterface {
    private static final String LOG_TAG = LogService.class.getSimpleName();
    private ConnectionService connectionService;
    private ExecutorService executor;

    public LogService(ConnectionService connectionService) {
        this.connectionService = connectionService;
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void getLogLevels(ServiceCallback<List<LogLevel>, Integer> callback) {
        ArrayList<LogLevel> logLevels = new ArrayList<LogLevel>();
        logLevels.add(LogLevel.NoLog);
        logLevels.add(LogLevel.Info);
        logLevels.add(LogLevel.Debug);
        logLevels.add(LogLevel.Warning);
        logLevels.add(LogLevel.Error);
        callback.onSuccess(logLevels);
    }

    @Override
    public void clear(ServiceCallback<Integer, Integer> callback) {
        try {
            Future<BaseResult> future = this.executor.submit(new TruncateLogTableCallable(this.connectionService.getLocalConnection()));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }

    @Override
    public void export(String filePath, ServiceCallback<Integer, Integer> callback) {
        try {
            Future<BaseResult> future = this.executor.submit(new ExportLogTableCallable(this.connectionService.getLocalConnection(), filePath));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
        catch (ConnectionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-3);
        }
    }
}

