/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.install;

import com.systel.sync.business.common.entities.InstallData;
import com.systel.sync.common.ConfigurationProperties;
import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.common.sql.SQLQuery;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.install.InstallServiceInterface;
import com.systel.sync.services.sync.local.callables.UpdateDatabasesCallable;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class InstallService
implements InstallServiceInterface {
    private static final String LOG_TAG = InstallService.class.getSimpleName();
    private ConfigurationService configurationService;
    private ConnectionService connectionService;
    private ExecutorService executor;

    public InstallService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.connectionService = new ConnectionService(configurationService);
        this.executor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void testInstall(ServiceCallback<Integer, Integer> callback) {
        try {
            this.connectionService.getLocalConnection();
        }
        catch (Exception ex) {
            callback.onFailure(-1000);
            return;
        }
        try {
            this.connectionService.getMasterConnection();
        }
        catch (Exception ex) {
            callback.onFailure(-1001);
            return;
        }
        callback.onSuccess(0);
    }

    @Override
    public void install(InstallData installData, ServiceCallback<Integer, Integer> callback) {
        Throwable throwable;
        Statement statement;
        Connection connection;
        ConfigurationProperties configurationProperties = this.configurationService.getConfigurationProperties();
        configurationProperties.setProperty("syncDBHost", installData.getSyncIpAddress());
        configurationProperties.setProperty("masterDBHost", installData.getMasterIpAddress());
        configurationProperties.setProperty("locale", installData.getLanguage().getLocale());
        configurationProperties.setProperty("logLevel", installData.getLogLevel().name());
        this.configurationService.setConfigurationProperties(configurationProperties);
        this.configurationService.save();
        this.connectionService.setConfigurationService(this.configurationService);
        try {
            connection = this.connectionService.getInstallConnection();
            try {
                statement = connection.createStatement();
                throwable = null;
                try {
                    statement.execute(((String)SQLQueries.getInstance().get((Object)SQLQuery.dropDatabase)).replace("#syncDB#", this.configurationService.getSyncDBName()));
                    statement.execute(((String)SQLQueries.getInstance().get((Object)SQLQuery.createDatabase)).replace("#syncDB#", this.configurationService.getSyncDBName()));
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                callback.onFailure(-1003);
                return;
            }
        }
        catch (Exception ex) {
            callback.onFailure(-1002);
            return;
        }
        try {
            this.connectionService.resetLocalConnection();
            connection = this.connectionService.getLocalConnection();
            try {
                statement = connection.createStatement();
                throwable = null;
                try {
                    statement.execute((String)SQLQueries.getInstance().get((Object)SQLQuery.createLocalTables));
                    statement.execute((String)SQLQueries.getInstance().get((Object)SQLQuery.createHashFunction));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                callback.onFailure(-1004);
                return;
            }
        }
        catch (Exception ex) {
            callback.onFailure(-1000);
            return;
        }
        try {
            this.connectionService.resetMasterConnection();
            this.connectionService.getMasterConnection();
        }
        catch (Exception ex) {
            callback.onFailure(-1001);
            return;
        }
        callback.onSuccess(0);
    }

    @Override
    public void setMasterIp(String masterIpAddress, ServiceCallback<Integer, Integer> callback) {
        ConfigurationProperties configurationProperties = this.configurationService.getConfigurationProperties();
        configurationProperties.setProperty("masterDBHost", masterIpAddress);
        this.configurationService.setConfigurationProperties(configurationProperties);
        this.configurationService.save();
        this.connectionService.setConfigurationService(this.configurationService);
        try {
            this.connectionService.resetMasterConnection();
            this.connectionService.getMasterConnection();
        }
        catch (Exception ex) {
            callback.onFailure(-1001);
            return;
        }
        callback.onSuccess(0);
    }

    @Override
    public void updateDb(ServiceCallback<Integer, Integer> callback, ArrayList<String> nodeIps, String psqlPath) {
        try {
            Future<BaseResult> future = this.executor.submit(new UpdateDatabasesCallable(nodeIps, psqlPath.toLowerCase()));
            BaseResult result = future.get();
            if (result.getResultCode() != 0) {
                callback.onFailure(-2);
            } else {
                callback.onSuccess(result.getResultCode());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            ServicesLog.logError(LOG_TAG, ex.getMessage());
            callback.onFailure(-1);
        }
    }
}

