/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.common;

import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import javax.annotation.Nullable;

public class ConnectionService {
    private static final int DBLoginTimeout = 10;
    private ConfigurationService configurationService;
    private Connection syncConnection;
    private Connection masterConnection;

    public ConnectionService() {
    }

    public ConnectionService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public Connection getLocalConnection() throws ConnectionException {
        try {
            this.syncConnection.equals(this.syncConnection);
        }
        catch (NullPointerException ex) {
            try {
                Class.forName("org.postgresql.Driver");
                DriverManager.setLoginTimeout(10);
                StringBuilder builder = new StringBuilder();
                builder.append("jdbc:postgresql://");
                builder.append(this.configurationService.getSyncDBHost());
                builder.append(":");
                builder.append(this.configurationService.getSyncDBPort());
                builder.append("/");
                builder.append(this.configurationService.getSyncDBName());
                Properties prop = new Properties();
                prop.put("charSet", "UTF8");
                prop.put("characterEncoding", "UTF8");
                prop.put("collate", "C");
                prop.put("charType", "C");
                prop.put("user", this.configurationService.getSyncDBUser());
                prop.put("password", this.configurationService.getSyncDBPassword());
                this.syncConnection = DriverManager.getConnection(builder.toString(), prop);
            }
            catch (Exception e) {
                throw new ConnectionException();
            }
        }
        return this.syncConnection;
    }

    public void resetLocalConnection() {
        this.syncConnection = null;
    }

    public Connection getMasterConnection() throws ConnectionException {
        try {
            this.masterConnection.equals(this.masterConnection);
        }
        catch (NullPointerException ex) {
            try {
                Class.forName("org.postgresql.Driver");
                DriverManager.setLoginTimeout(10);
                StringBuilder builder = new StringBuilder();
                builder.append("jdbc:postgresql://");
                builder.append(this.configurationService.getMasterDBHost());
                builder.append(":");
                builder.append(this.configurationService.getMasterDBPort());
                builder.append("/");
                builder.append(this.configurationService.getMasterDBName());
                Properties prop = new Properties();
                prop.put("charSet", "UTF8");
                prop.put("characterEncoding", "UTF8");
                prop.put("collate", "C");
                prop.put("charType", "C");
                prop.put("user", this.configurationService.getMasterDBUser());
                prop.put("password", this.configurationService.getMasterDBPassword());
                this.masterConnection = DriverManager.getConnection(builder.toString(), prop);
            }
            catch (Exception e) {
                throw new ConnectionException();
            }
        }
        return this.masterConnection;
    }

    public void resetMasterConnection() {
        this.masterConnection = null;
    }

    @Nullable
    public Connection getRemoteConnection(ServiceNodeConnection nodeConnection) throws ConnectionException {
        try {
            Class.forName("org.postgresql.Driver");
            DriverManager.setLoginTimeout(10);
            StringBuilder builder = new StringBuilder();
            builder.append("jdbc:postgresql://");
            builder.append(nodeConnection.getIpAddress());
            builder.append(":");
            builder.append(nodeConnection.getDbPort());
            builder.append("/");
            builder.append(nodeConnection.getDbName());
            Properties prop = new Properties();
            prop.put("charSet", "UTF8");
            prop.put("characterEncoding", "UTF8");
            prop.put("collate", "C");
            prop.put("charType", "C");
            prop.put("user", nodeConnection.getDbUser());
            prop.put("password", nodeConnection.getDbPass());
            return DriverManager.getConnection(builder.toString(), prop);
        }
        catch (Exception ex) {
            throw new ConnectionException();
        }
    }

    public Connection getInstallConnection() throws ConnectionException {
        Connection installConnection;
        try {
            Class.forName("org.postgresql.Driver");
            DriverManager.setLoginTimeout(10);
            StringBuilder builder = new StringBuilder();
            builder.append("jdbc:postgresql://");
            builder.append(this.configurationService.getSyncDBHost());
            builder.append(":");
            builder.append(this.configurationService.getSyncDBPort());
            builder.append("/postgres");
            Properties prop = new Properties();
            prop.put("charSet", "UTF8");
            prop.put("characterEncoding", "UTF8");
            prop.put("collate", "C");
            prop.put("charType", "C");
            prop.put("user", this.configurationService.getRootDBUser());
            prop.put("password", this.configurationService.getRootDBPassword());
            installConnection = DriverManager.getConnection(builder.toString(), prop);
        }
        catch (Exception ex) {
            throw new ConnectionException();
        }
        return installConnection;
    }
}

