/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services.common;

import com.systel.sync.common.ConfigurationProperties;
import com.systel.sync.log.LogLevel;
import java.io.IOException;
import java.util.ArrayList;

public class ConfigurationService {
    protected ConfigurationProperties configurationProperties;
    protected String language;
    protected String country;
    protected boolean encrypted;

    public ConfigurationService(ConfigurationProperties configurationProperties) {
        this(configurationProperties, false);
    }

    public ConfigurationService(ConfigurationProperties configurationProperties, boolean encrypted) {
        this.configurationProperties = configurationProperties;
        this.encrypted = encrypted;
        this.load();
    }

    public void load() {
        try {
            if (this.encrypted) {
                this.configurationProperties.loadEncrypted();
            } else {
                this.configurationProperties.load();
            }
        }
        catch (IOException ex) {
            this.configurationProperties.setProperty("locale", "es_AR");
            this.configurationProperties.setProperty("validLocales", "en_US@es_AR@pt_BR");
            this.configurationProperties.setProperty("logLevel", "Error");
            this.configurationProperties.setProperty("defaultLocale", "en_US");
            this.configurationProperties.setProperty("defaultDBName", "cuora");
            this.configurationProperties.setProperty("defaultDBPort", "5432");
            this.configurationProperties.setProperty("defaultDBUser", "sync");
            this.configurationProperties.setProperty("defaultDBPassword", "7a952bbdaf931189260ffd6e061cbce9");
            this.configurationProperties.setProperty("defaultVersion", "0");
            this.configurationProperties.setProperty("rootDBUser", "sync");
            this.configurationProperties.setProperty("rootDBPassword", "7a952bbdaf931189260ffd6e061cbce9");
            this.configurationProperties.setProperty("syncDBName", "systel_sync");
            this.configurationProperties.setProperty("syncDBPort", "5432");
            this.configurationProperties.setProperty("syncDBUser", "sync");
            this.configurationProperties.setProperty("syncDBPassword", "7a952bbdaf931189260ffd6e061cbce9");
            this.configurationProperties.setProperty("masterDBName", "cuora");
            this.configurationProperties.setProperty("masterDBPort", "5432");
            this.configurationProperties.setProperty("masterDBUser", "sync");
            this.configurationProperties.setProperty("masterDBPassword", "7a952bbdaf931189260ffd6e061cbce9");
            this.configurationProperties.setProperty("beforeSyncType", "0");
            this.configurationProperties.setProperty("beforeSyncCommand", "nocommand");
            this.save();
        }
        this.checkLocale();
    }

    public void save() {
        try {
            if (this.encrypted) {
                this.configurationProperties.saveEncrypted();
            } else {
                this.configurationProperties.save();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkLocale();
    }

    public String[] getValidLocales() {
        return this.configurationProperties.getProperty("validLocales").split("@");
    }

    public String getLocale() {
        return this.configurationProperties.getProperty("locale");
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getRootDBUser() {
        return this.configurationProperties.getProperty("rootDBUser");
    }

    public String getRootDBPassword() {
        return this.configurationProperties.getProperty("rootDBPassword");
    }

    public String getSyncDBHost() {
        return this.configurationProperties.getProperty("syncDBHost");
    }

    public String getSyncDBName() {
        return this.configurationProperties.getProperty("syncDBName");
    }

    public String getSyncDBPort() {
        return this.configurationProperties.getProperty("syncDBPort");
    }

    public String getSyncDBUser() {
        return this.configurationProperties.getProperty("syncDBUser");
    }

    public String getSyncDBPassword() {
        return this.configurationProperties.getProperty("syncDBPassword");
    }

    public String getMasterDBHost() {
        return this.configurationProperties.getProperty("masterDBHost");
    }

    public String getMasterDBName() {
        return this.configurationProperties.getProperty("masterDBName");
    }

    public String getMasterDBPort() {
        return this.configurationProperties.getProperty("masterDBPort");
    }

    public String getMasterDBUser() {
        return this.configurationProperties.getProperty("masterDBUser");
    }

    public String getMasterDBPassword() {
        return this.configurationProperties.getProperty("masterDBPassword");
    }

    public String getDefaultDBName() {
        return this.configurationProperties.getProperty("defaultDBName");
    }

    public String getDefaultDBPort() {
        return this.configurationProperties.getProperty("defaultDBPort");
    }

    public String getDefaultDBUser() {
        return this.configurationProperties.getProperty("defaultDBUser");
    }

    public String getDefaultDBPassword() {
        return this.configurationProperties.getProperty("defaultDBPassword");
    }

    public String getDefaultVersion() {
        return this.configurationProperties.getProperty("defaultVersion");
    }

    public LogLevel getLogLevel() {
        return LogLevel.valueOf(this.configurationProperties.getProperty("logLevel"));
    }

    public int getBeforeSyncType() {
        try {
            return Integer.parseInt(this.configurationProperties.getProperty("beforeSyncType"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getBeforeSyncCommand() {
        try {
            if (this.configurationProperties.getProperty("beforeSyncCommand").compareTo("nocommand") != 0) {
                return this.configurationProperties.getProperty("beforeSyncCommand");
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public void setBeforeSyncType(int type) {
        this.configurationProperties.setProperty("beforeSyncType", Integer.toString(type));
        this.save();
    }

    public void setBeforeSyncCommand(String command) {
        if (command.compareTo("") != 0) {
            this.configurationProperties.setProperty("beforeSyncCommand", command);
        } else {
            this.configurationProperties.setProperty("beforeSyncCommand", "nocommand");
        }
        this.save();
    }

    private void checkLocale() {
        try {
            ArrayList<String> validLanguages = new ArrayList<String>();
            for (String l : this.getValidLocales()) {
                validLanguages.add(l);
            }
            String locale = this.getLocale();
            if (!validLanguages.contains(locale)) {
                this.configurationProperties.setProperty("locale", this.configurationProperties.getProperty("defaultLocale"));
            }
        }
        catch (NullPointerException ex) {
            this.configurationProperties.setProperty("locale", this.configurationProperties.getProperty("defaultLocale"));
        }
        String[] localeSplit = this.configurationProperties.getProperty("locale").split("_");
        this.language = localeSplit[0];
        this.country = localeSplit[1];
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(ConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }
}

